// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28410 = arguments.length;
var i__4865__auto___28411 = (0);
while(true){
if((i__4865__auto___28411 < len__4864__auto___28410)){
args__4870__auto__.push((arguments[i__4865__auto___28411]));

var G__28412 = (i__4865__auto___28411 + (1));
i__4865__auto___28411 = G__28412;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__28358){
var map__28359 = p__28358;
var map__28359__$1 = cljs.core.__destructure_map(map__28359);
var options = map__28359__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28359__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28359__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28390){
var state_val_28391 = (state_28390[(1)]);
if((state_val_28391 === (7))){
var inst_28376 = (state_28390[(2)]);
var state_28390__$1 = state_28390;
if(cljs.core.truth_(inst_28376)){
var statearr_28392_28413 = state_28390__$1;
(statearr_28392_28413[(1)] = (8));

} else {
var statearr_28393_28414 = state_28390__$1;
(statearr_28393_28414[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (1))){
var inst_28360 = milia.utils.retry.initial_polling_interval;
var inst_28361 = inst_28360;
var inst_28362 = (0);
var state_28390__$1 = (function (){var statearr_28394 = state_28390;
(statearr_28394[(7)] = inst_28361);

(statearr_28394[(8)] = inst_28362);

return statearr_28394;
})();
var statearr_28395_28415 = state_28390__$1;
(statearr_28395_28415[(2)] = null);

(statearr_28395_28415[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (4))){
var inst_28371 = (state_28390[(9)]);
var inst_28369 = (state_28390[(10)]);
var inst_28368 = (state_28390[(2)]);
var inst_28369__$1 = cljs.core.__destructure_map(inst_28368);
var inst_28370 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28369__$1,cljs.core.cst$kw$status);
var inst_28371__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_28370);
var state_28390__$1 = (function (){var statearr_28396 = state_28390;
(statearr_28396[(9)] = inst_28371__$1);

(statearr_28396[(10)] = inst_28369__$1);

return statearr_28396;
})();
if(inst_28371__$1){
var statearr_28397_28416 = state_28390__$1;
(statearr_28397_28416[(1)] = (5));

} else {
var statearr_28398_28417 = state_28390__$1;
(statearr_28398_28417[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (6))){
var inst_28371 = (state_28390[(9)]);
var state_28390__$1 = state_28390;
var statearr_28399_28418 = state_28390__$1;
(statearr_28399_28418[(2)] = inst_28371);

(statearr_28399_28418[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (3))){
var inst_28388 = (state_28390[(2)]);
var state_28390__$1 = state_28390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28390__$1,inst_28388);
} else {
if((state_val_28391 === (2))){
var inst_28365 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_28366 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([method,url,inst_28365], 0));
var state_28390__$1 = state_28390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28390__$1,(4),inst_28366);
} else {
if((state_val_28391 === (11))){
var inst_28361 = (state_28390[(7)]);
var inst_28362 = (state_28390[(8)]);
var inst_28380 = (state_28390[(2)]);
var inst_28381 = (inst_28361 * (2));
var inst_28382 = (inst_28362 + (1));
var inst_28361__$1 = inst_28381;
var inst_28362__$1 = inst_28382;
var state_28390__$1 = (function (){var statearr_28400 = state_28390;
(statearr_28400[(7)] = inst_28361__$1);

(statearr_28400[(11)] = inst_28380);

(statearr_28400[(8)] = inst_28362__$1);

return statearr_28400;
})();
var statearr_28401_28419 = state_28390__$1;
(statearr_28401_28419[(2)] = null);

(statearr_28401_28419[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (9))){
var inst_28369 = (state_28390[(10)]);
var state_28390__$1 = state_28390;
var statearr_28402_28420 = state_28390__$1;
(statearr_28402_28420[(2)] = inst_28369);

(statearr_28402_28420[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (5))){
var inst_28362 = (state_28390[(8)]);
var inst_28373 = (inst_28362 < max_retries);
var state_28390__$1 = state_28390;
var statearr_28403_28421 = state_28390__$1;
(statearr_28403_28421[(2)] = inst_28373);

(statearr_28403_28421[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (10))){
var inst_28386 = (state_28390[(2)]);
var state_28390__$1 = state_28390;
var statearr_28404_28422 = state_28390__$1;
(statearr_28404_28422[(2)] = inst_28386);

(statearr_28404_28422[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28391 === (8))){
var inst_28361 = (state_28390[(7)]);
var inst_28378 = cljs.core.async.timeout(inst_28361);
var state_28390__$1 = state_28390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28390__$1,(11),inst_28378);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var milia$utils$retry$state_machine__24176__auto__ = null;
var milia$utils$retry$state_machine__24176__auto____0 = (function (){
var statearr_28405 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28405[(0)] = milia$utils$retry$state_machine__24176__auto__);

(statearr_28405[(1)] = (1));

return statearr_28405;
});
var milia$utils$retry$state_machine__24176__auto____1 = (function (state_28390){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28390);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28406){var ex__24179__auto__ = e28406;
var statearr_28407_28423 = state_28390;
(statearr_28407_28423[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28390[(4)]))){
var statearr_28408_28424 = state_28390;
(statearr_28408_28424[(1)] = cljs.core.first((state_28390[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28425 = state_28390;
state_28390 = G__28425;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$utils$retry$state_machine__24176__auto__ = function(state_28390){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__24176__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__24176__auto____1.call(this,state_28390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__24176__auto____0;
milia$utils$retry$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__24176__auto____1;
return milia$utils$retry$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28409 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28409[(6)] = c__24250__auto__);

return statearr_28409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
}));

(milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq28355){
var G__28356 = cljs.core.first(seq28355);
var seq28355__$1 = cljs.core.next(seq28355);
var G__28357 = cljs.core.first(seq28355__$1);
var seq28355__$2 = cljs.core.next(seq28355__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28356,G__28357,seq28355__$2);
}));

