// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.user');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.js_interop');
goog.require('clojure.string');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.user.patch = (function milia$api$user$patch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28970 = arguments.length;
var i__4865__auto___28971 = (0);
while(true){
if((i__4865__auto___28971 < len__4864__auto___28970)){
args__4870__auto__.push((arguments[i__4865__auto___28971]));

var G__28972 = (i__4865__auto___28971 + (1));
i__4865__auto___28971 = G__28972;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic = (function (username,params,p__28968){
var map__28969 = p__28968;
var map__28969__$1 = cljs.core.__destructure_map(map__28969);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28969__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
}));

(milia.api.user.patch.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.user.patch.cljs$lang$applyTo = (function (seq28965){
var G__28966 = cljs.core.first(seq28965);
var seq28965__$1 = cljs.core.next(seq28965);
var G__28967 = cljs.core.first(seq28965__$1);
var seq28965__$2 = cljs.core.next(seq28965__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28966,G__28967,seq28965__$2);
}));

/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.profile = (function milia$api$user$profile(username){
if(cljs.core.truth_(username)){
} else {
throw (new Error("Assert failed: username"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
var response = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$max_DASH_retries,(4)], 0));
var temp__5751__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__5751__auto__)){
var error = temp__5751__auto__;
return null;
} else {
return response;
}
});
milia.api.user.verify_email = (function milia$api$user$verify_email(verification_key){
if(cljs.core.truth_(verification_key)){
} else {
throw (new Error("Assert failed: verification-key"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",["verify_email.json?verification_key=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(verification_key)].join('')], 0));
var response = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$max_DASH_retries,(2)], 0));
var temp__5751__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__5751__auto__)){
var error = temp__5751__auto__;
return null;
} else {
return response;
}
});
milia.api.user.send_verification_email = (function milia$api$user$send_verification_email(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28980 = arguments.length;
var i__4865__auto___28981 = (0);
while(true){
if((i__4865__auto___28981 < len__4864__auto___28980)){
args__4870__auto__.push((arguments[i__4865__auto___28981]));

var G__28982 = (i__4865__auto___28981 + (1));
i__4865__auto___28981 = G__28982;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__28975){
var vec__28976 = p__28975;
var redirect_url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28976,(0),null);
if(cljs.core.truth_(username)){
} else {
throw (new Error("Assert failed: username"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles","send_verification_email.json"], 0));
var form_params = (function (){var G__28979 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(redirect_url) : chimera.core.not_nil_QMARK_.call(null,redirect_url)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28979,cljs.core.cst$kw$redirect_url,redirect_url);
} else {
return G__28979;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.user.send_verification_email.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.user.send_verification_email.cljs$lang$applyTo = (function (seq28973){
var G__28974 = cljs.core.first(seq28973);
var seq28973__$1 = cljs.core.next(seq28973);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28974,seq28973__$1);
}));

/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.get_profiles_for_list_of_users = (function milia$api$user$get_profiles_for_list_of_users(users){
if(cljs.core.seq(users)){
} else {
throw (new Error("Assert failed: (seq users)"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["profiles.json?users=",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",users)].join('')], 0));
var response = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
var temp__5751__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__5751__auto__)){
var error = temp__5751__auto__;
return error;
} else {
return response;
}
});
/**
 * Return the user profile with authentication details.
 */
milia.api.user.user = (function milia$api$user$user(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28988 = arguments.length;
var i__4865__auto___28989 = (0);
while(true){
if((i__4865__auto___28989 < len__4864__auto___28988)){
args__4870__auto__.push((arguments[i__4865__auto___28989]));

var G__28990 = (i__4865__auto___28989 + (1));
i__4865__auto___28989 = G__28990;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic = (function (p__28984){
var vec__28985 = p__28984;
var suppress_4xx_exceptions_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28985,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
}));

(milia.api.user.user.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.user.user.cljs$lang$applyTo = (function (seq28983){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28983));
}));

milia.api.user.get_subscription = (function milia$api$user$get_subscription(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing","subscriptions",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.update_subscription = (function milia$api$user$update_subscription(username,contactpersons){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing","subscriptions",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$contactpersons,contactpersons], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.get_subscription_payment = (function milia$api$user$get_subscription_payment(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing","payments",username], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.user.get_invoices = (function milia$api$user$get_invoices(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing",["invoices?username=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Create a new user.
 */
milia.api.user.create = (function milia$api$user$create(params){
var profile = cljs.core.select_keys(params,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$first_name,cljs.core.cst$kw$last_name,cljs.core.cst$kw$username,cljs.core.cst$kw$email,cljs.core.cst$kw$password], null));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,profile], null)], 0));
});
/**
 * return all users
 */
milia.api.user.all = (function milia$api$user$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * update user profile
 */
milia.api.user.update = (function milia$api$user$update(username,params){
if(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$city,cljs.core.cst$kw$country,cljs.core.cst$kw$email,cljs.core.cst$kw$gravatar,cljs.core.cst$kw$last_name,cljs.core.cst$kw$first_name,cljs.core.cst$kw$is_org,cljs.core.cst$kw$owner,cljs.core.cst$kw$require_auth,cljs.core.cst$kw$twitter,cljs.core.cst$kw$url,cljs.core.cst$kw$user,cljs.core.cst$kw$username,cljs.core.cst$kw$website,cljs.core.cst$kw$organization], null))){
} else {
throw (new Error("Assert failed: (has-keys? params [:city :country :email :gravatar :last_name :first_name :is_org :owner :require_auth :twitter :url :user :username :website :organization])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Change user password
 */
milia.api.user.change_password = (function milia$api$user$change_password(username,current_password,new_password){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",username,"change_password.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current_password,current_password,cljs.core.cst$kw$new_password,new_password], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.user.retrieve_metadata = (function milia$api$user$retrieve_metadata(username){
return cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.user.profile(username));
});
milia.api.user.update_user_metadata = (function milia$api$user$update_user_metadata(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28996 = arguments.length;
var i__4865__auto___28997 = (0);
while(true){
if((i__4865__auto___28997 < len__4864__auto___28996)){
args__4870__auto__.push((arguments[i__4865__auto___28997]));

var G__28998 = (i__4865__auto___28997 + (1));
i__4865__auto___28997 = G__28998;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic = (function (username,metadata,p__28994){
var map__28995 = p__28994;
var map__28995__$1 = cljs.core.__destructure_map(map__28995);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28995__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,null);
var current_metadata = milia.api.user.retrieve_metadata(username);
var updated_metadata = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([current_metadata,metadata], 0));
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$metadata,updated_metadata], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
}));

(milia.api.user.update_user_metadata.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.user.update_user_metadata.cljs$lang$applyTo = (function (seq28991){
var G__28992 = cljs.core.first(seq28991);
var seq28991__$1 = cljs.core.next(seq28991);
var G__28993 = cljs.core.first(seq28991__$1);
var seq28991__$2 = cljs.core.next(seq28991__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28992,G__28993,seq28991__$2);
}));

/**
 * Return the user for this username
 */
milia.api.user.get = (function milia$api$user$get(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return the users that match this email address
 */
milia.api.user.get_by_email = (function milia$api$user$get_by_email(email){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$search,email], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.generate_odk_token = (function milia$api$user$generate_odk_token(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","odk_token.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$post,url);
});
/**
 * Trigger a password reset email to the given email and given return URL.
 * Also takes an optional subject for the email message.
 */
milia.api.user.trigger_password_reset_email = (function milia$api$user$trigger_password_reset_email(var_args){
var G__29000 = arguments.length;
switch (G__29000) {
case 2:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2 = (function (email,reset_url){
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3(email,reset_url,null);
}));

(milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3 = (function (email,reset_url,reset_subject){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","reset.json"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$email,email,cljs.core.cst$kw$reset_url,reset_url], null),(cljs.core.truth_(reset_subject)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$email_subject,reset_subject], null):null)], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.user.trigger_password_reset_email.cljs$lang$maxFixedArity = 3);

milia.api.user.reset_password = (function milia$api$user$reset_password(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29008 = arguments.length;
var i__4865__auto___29009 = (0);
while(true){
if((i__4865__auto___29009 < len__4864__auto___29008)){
args__4870__auto__.push((arguments[i__4865__auto___29009]));

var G__29010 = (i__4865__auto___29009 + (1));
i__4865__auto___29009 = G__29010;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return milia.api.user.reset_password.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(milia.api.user.reset_password.cljs$core$IFn$_invoke$arity$variadic = (function (new_password,token,uid,p__29006){
var map__29007 = p__29006;
var map__29007__$1 = cljs.core.__destructure_map(map__29007);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29007__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","reset.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_,cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$new_password,new_password,cljs.core.cst$kw$token,token,cljs.core.cst$kw$uid,uid], null)], null)], 0));
}));

(milia.api.user.reset_password.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.user.reset_password.cljs$lang$applyTo = (function (seq29002){
var G__29003 = cljs.core.first(seq29002);
var seq29002__$1 = cljs.core.next(seq29002);
var G__29004 = cljs.core.first(seq29002__$1);
var seq29002__$2 = cljs.core.next(seq29002__$1);
var G__29005 = cljs.core.first(seq29002__$2);
var seq29002__$3 = cljs.core.next(seq29002__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29003,G__29004,G__29005,seq29002__$3);
}));

/**
 * Change the user's email address. This requires a password so that the API
 * can successful update the authentication digest and email can be used to
 * login.
 */
milia.api.user.change_email_address = (function milia$api$user$change_email_address(username,email_address,password){
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$email,email_address,cljs.core.cst$kw$password,password], null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Expire the user's temporary token.
 */
milia.api.user.expire_temp_token = (function milia$api$user$expire_temp_token(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","expire.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Send a code to authorize a user to use google sheets
 */
milia.api.user.google_sheet_authorization = (function milia$api$user$google_sheet_authorization(code,redirect_uri){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["google",chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("google_auth.json?code=%s&redirect_uri=%s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([code,redirect_uri], 0))], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
