// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28559 = arguments.length;
var i__4865__auto___28560 = (0);
while(true){
if((i__4865__auto___28560 < len__4864__auto___28559)){
args__4870__auto__.push((arguments[i__4865__auto___28560]));

var G__28561 = (i__4865__auto___28560 + (1));
i__4865__auto___28560 = G__28561;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__28555){
var vec__28556 = p__28555;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28556,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
}));

(milia.api.rest_services.create.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.rest_services.create.cljs$lang$applyTo = (function (seq28551){
var G__28552 = cljs.core.first(seq28551);
var seq28551__$1 = cljs.core.next(seq28551);
var G__28553 = cljs.core.first(seq28551__$1);
var seq28551__$2 = cljs.core.next(seq28551__$1);
var G__28554 = cljs.core.first(seq28551__$2);
var seq28551__$3 = cljs.core.next(seq28551__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28552,G__28553,G__28554,seq28551__$3);
}));

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28571 = arguments.length;
var i__4865__auto___28572 = (0);
while(true){
if((i__4865__auto___28572 < len__4864__auto___28571)){
args__4870__auto__.push((arguments[i__4865__auto___28572]));

var G__28573 = (i__4865__auto___28572 + (1));
i__4865__auto___28572 = G__28573;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((4) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4871__auto__);
});

(milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__28567){
var vec__28568 = p__28567;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28568,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
}));

(milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq28562){
var G__28563 = cljs.core.first(seq28562);
var seq28562__$1 = cljs.core.next(seq28562);
var G__28564 = cljs.core.first(seq28562__$1);
var seq28562__$2 = cljs.core.next(seq28562__$1);
var G__28565 = cljs.core.first(seq28562__$2);
var seq28562__$3 = cljs.core.next(seq28562__$2);
var G__28566 = cljs.core.first(seq28562__$3);
var seq28562__$4 = cljs.core.next(seq28562__$3);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28563,G__28564,G__28565,G__28566,seq28562__$4);
}));

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices.json"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28578 = arguments.length;
var i__4865__auto___28579 = (0);
while(true){
if((i__4865__auto___28579 < len__4864__auto___28578)){
args__4870__auto__.push((arguments[i__4865__auto___28579]));

var G__28580 = (i__4865__auto___28579 + (1));
i__4865__auto___28579 = G__28580;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__28576){
var map__28577 = p__28576;
var map__28577__$1 = cljs.core.__destructure_map(map__28577);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28577__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["restservices",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq28574){
var G__28575 = cljs.core.first(seq28574);
var seq28574__$1 = cljs.core.next(seq28574);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28575,seq28574__$1);
}));

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28585 = arguments.length;
var i__4865__auto___28586 = (0);
while(true){
if((i__4865__auto___28586 < len__4864__auto___28585)){
args__4870__auto__.push((arguments[i__4865__auto___28586]));

var G__28587 = (i__4865__auto___28586 + (1));
i__4865__auto___28586 = G__28587;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__28583){
var map__28584 = p__28583;
var map__28584__$1 = cljs.core.__destructure_map(map__28584);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28584__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["restservices.json?xform=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(formid)].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq28581){
var G__28582 = cljs.core.first(seq28581);
var seq28581__$1 = cljs.core.next(seq28581);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28582,seq28581__$1);
}));

