// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('chimera.urls');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$temp_DASH_token,null,cljs.core.cst$kw$token,null,cljs.core.cst$kw$username,null,cljs.core.cst$kw$password,null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
milia.utils.remote.images_url = ["images.",cljs.core.str.cljs$core$IFn$_invoke$arity$1((window["location"]["hostname"]))].join('');
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$client,"zebra.ona.io",cljs.core.cst$kw$data,"stage-api.ona.io",cljs.core.cst$kw$j2x,"j2x.ona.io",cljs.core.cst$kw$request_DASH_protocol,"https",cljs.core.cst$kw$images,milia.utils.remote.images_url], null));
/**
 * Store customizable timeouts to use in the http libraries. In milliseconds.
 */
milia.utils.remote.timeouts = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$conn_DASH_timeout,(60000),cljs.core.cst$kw$socket_DASH_timeout,(60000)], null));
/**
 * Swap values into hosts atom, requires data-host, other args are option but
 * must be provided in order. If an option arg is nil it is ignored, and not
 * swapped into hosts.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_hosts = (function milia$utils$remote$set_hosts(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28164 = arguments.length;
var i__4865__auto___28165 = (0);
while(true){
if((i__4865__auto___28165 < len__4864__auto___28164)){
args__4870__auto__.push((arguments[i__4865__auto___28165]));

var G__28166 = (i__4865__auto___28165 + (1));
i__4865__auto___28165 = G__28166;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});
goog.exportSymbol('milia.utils.remote.set_hosts', milia.utils.remote.set_hosts);

(milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic = (function (data_host,p__28159){
var vec__28160 = p__28159;
var client_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28160,(0),null);
var j2x_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28160,(1),null);
var request_protocol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28160,(2),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(milia.utils.remote.hosts,cljs.core.merge,(function (){var G__28163 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,data_host], null);
var G__28163__$1 = (((!((client_host == null))))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28163,cljs.core.cst$kw$client,client_host):G__28163);
var G__28163__$2 = (((!((j2x_host == null))))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28163__$1,cljs.core.cst$kw$j2x,j2x_host):G__28163__$1);
if((!((request_protocol == null)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28163__$2,cljs.core.cst$kw$request_DASH_protocol,request_protocol);
} else {
return G__28163__$2;
}
})());
}));

(milia.utils.remote.set_hosts.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.utils.remote.set_hosts.cljs$lang$applyTo = (function (seq28157){
var G__28158 = cljs.core.first(seq28157);
var seq28157__$1 = cljs.core.next(seq28157);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28158,seq28157__$1);
}));

/**
 * Set the dynamic credentials to include the username and optionally
 * any other arguments that are passed. If an argument is nil or not passed
 * it will be set to nil in the credentials.
 * 
 * Calling this from Clojure will break if not done from within a previous
 * binding of the *credentials* variable.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_credentials = (function milia$utils$remote$set_credentials(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28173 = arguments.length;
var i__4865__auto___28174 = (0);
while(true){
if((i__4865__auto___28174 < len__4864__auto___28173)){
args__4870__auto__.push((arguments[i__4865__auto___28174]));

var G__28175 = (i__4865__auto___28174 + (1));
i__4865__auto___28174 = G__28175;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});
goog.exportSymbol('milia.utils.remote.set_credentials', milia.utils.remote.set_credentials);

(milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__28169){
var vec__28170 = p__28169;
var password = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28170,(0),null);
var temp_token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28170,(1),null);
var token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28170,(2),null);
return (milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$password,password,cljs.core.cst$kw$temp_DASH_token,temp_token,cljs.core.cst$kw$token,token], null));
}));

(milia.utils.remote.set_credentials.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.utils.remote.set_credentials.cljs$lang$applyTo = (function (seq28167){
var G__28168 = cljs.core.first(seq28167);
var seq28167__$1 = cljs.core.next(seq28167);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28168,seq28167__$1);
}));

/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(milia.utils.remote.hosts)),"://",resources], null)));
});
milia.utils.remote.thumbor_server = milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$images.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(milia.utils.remote.hosts)));
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.urls.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28177 = arguments.length;
var i__4865__auto___28178 = (0);
while(true){
if((i__4865__auto___28178 < len__4864__auto___28177)){
args__4870__auto__.push((arguments[i__4865__auto___28178]));

var G__28179 = (i__4865__auto___28178 + (1));
i__4865__auto___28178 = G__28179;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(milia.utils.remote.hosts))),"/api/v1"].join(''),postfix);
}));

(milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq28176){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28176));
}));

/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28181 = arguments.length;
var i__4865__auto___28182 = (0);
while(true){
if((i__4865__auto___28182 < len__4864__auto___28181)){
args__4870__auto__.push((arguments[i__4865__auto___28182]));

var G__28183 = (i__4865__auto___28182 + (1));
i__4865__auto___28182 = G__28183;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
}));

(milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq28180){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28180));
}));

/**
 * Like make-url, but ensures an ending in .json
 */
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28185 = arguments.length;
var i__4865__auto___28186 = (0);
while(true){
if((i__4865__auto___28186 < len__4864__auto___28185)){
args__4870__auto__.push((arguments[i__4865__auto___28186]));

var G__28187 = (i__4865__auto___28186 + (1));
i__4865__auto___28186 = G__28187;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),".json"].join('');
}));

(milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq28184){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28184));
}));

/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28189 = arguments.length;
var i__4865__auto___28190 = (0);
while(true){
if((i__4865__auto___28190 < len__4864__auto___28189)){
args__4870__auto__.push((arguments[i__4865__auto___28190]));

var G__28191 = (i__4865__auto___28190 + (1));
i__4865__auto___28190 = G__28191;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$j2x.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(milia.utils.remote.hosts))),postfix);
}));

(milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq28188){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28188));
}));

