// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.widgets');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * The Ona API expects clients to submit a URL as the value of the object bound
 * to a widget. This is basically asking clients to be aware of internal API
 * implementation details since this is a Django REST framework peculiarity.
 * This function provides an abstraction that allows Clojure based clients to
 * be ignorant of the quirk.
 * `content-type` can be either :form or :dataview
 * `content-id` is an integer identifying the object
 */
milia.api.widgets.generate_content_object_url = (function milia$api$widgets$generate_content_object_url(content_type,content_id){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var G__28306 = content_type;
var G__28306__$1 = (((G__28306 instanceof cljs.core.Keyword))?G__28306.fqn:null);
switch (G__28306__$1) {
case "form":
return "forms";

break;
case "dataview":
return "dataviews";

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28306__$1)].join('')));

}
})(),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(content_id),".json"].join('')], 0));
});
/**
 * Create a new widget.
 * `widget-definition` is a map containing the following keys:
 *  `:title` is a string
 *  `:content_type` is one of either :form of :dataview
 *  `:content_id` is an intger identifying the content object
 *  `:description` is a string.
 *  `:widget_type` is a string, determined by the client e.g. chart
 *  `:view_type` is a string, determined by the client e.g. bar-chart
 *  `:column` is the  data column to be stored based on the form field.
 *  `:order` this is the position of the widget in relation to others
 *           within the set associated with a form or dataview. Optional.
 *  `:group_by` the data column for the data to be grouped by. Optional
 *  `:aggregation` is the aggregation used while grouping data. Optional.
 *  `:metadata` is a map containing arbitrary key-value pairs.
 */
milia.api.widgets.create = (function milia$api$widgets$create(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28314 = arguments.length;
var i__4865__auto___28315 = (0);
while(true){
if((i__4865__auto___28315 < len__4864__auto___28314)){
args__4870__auto__.push((arguments[i__4865__auto___28315]));

var G__28316 = (i__4865__auto___28315 + (1));
i__4865__auto___28315 = G__28316;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic = (function (p__28310,p__28311){
var map__28312 = p__28310;
var map__28312__$1 = cljs.core.__destructure_map(map__28312);
var widget_definition = map__28312__$1;
var content_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28312__$1,cljs.core.cst$kw$content_type);
var content_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28312__$1,cljs.core.cst$kw$content_id);
var map__28313 = p__28311;
var map__28313__$1 = cljs.core.__destructure_map(map__28313);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28313__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["widgets.json",(cljs.core.truth_(with_data_QMARK_)?"?data=true":null)].join('')], 0));
var processed_widget_definition = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(widget_definition,cljs.core.cst$kw$content_object,milia.api.widgets.generate_content_object_url(content_type,content_id));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,processed_widget_definition], null)], 0));
}));

(milia.api.widgets.create.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.widgets.create.cljs$lang$applyTo = (function (seq28308){
var G__28309 = cljs.core.first(seq28308);
var seq28308__$1 = cljs.core.next(seq28308);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28309,seq28308__$1);
}));

/**
 * Updates a widget, given the widget ID, and a map of properties to replace
 * existing values for the associated keys
 */
milia.api.widgets.update = (function milia$api$widgets$update(widget_id,patch_map){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["widgets",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(widget_id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,patch_map], null)], 0));
});
/**
 * List widgets belonging to a particular user
 * Can optionally be filtered by supplying either a dataview ID or an XForm ID
 * Note that the filters are mutually exclusive
 */
milia.api.widgets.list = (function milia$api$widgets$list(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28320 = arguments.length;
var i__4865__auto___28321 = (0);
while(true){
if((i__4865__auto___28321 < len__4864__auto___28320)){
args__4870__auto__.push((arguments[i__4865__auto___28321]));

var G__28322 = (i__4865__auto___28321 + (1));
i__4865__auto___28321 = G__28322;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__28318){
var map__28319 = p__28318;
var map__28319__$1 = cljs.core.__destructure_map(map__28319);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28319__$1,cljs.core.cst$kw$dataview_DASH_id);
var xform_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28319__$1,cljs.core.cst$kw$xform_DASH_id);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28319__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(dataview_id)?["widgets.json?dataview=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataview_id),(cljs.core.truth_(with_data_QMARK_)?"&data=true":null)].join(''):(cljs.core.truth_(xform_id)?["widgets.json?xform=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(xform_id),(cljs.core.truth_(with_data_QMARK_)?"&data=true":null)].join(''):["widgets.json",(cljs.core.truth_(with_data_QMARK_)?"?data=true":null)].join('')
))], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
}));

(milia.api.widgets.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.widgets.list.cljs$lang$applyTo = (function (seq28317){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28317));
}));

/**
 * Deletes a widget, given a widget id.
 */
milia.api.widgets.delete$ = (function milia$api$widgets$delete(widget_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["widgets",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(widget_id),".json"].join('')], 0)));
});
/**
 * Returns specific widget, given the ID
 */
milia.api.widgets.get = (function milia$api$widgets$get(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28327 = arguments.length;
var i__4865__auto___28328 = (0);
while(true){
if((i__4865__auto___28328 < len__4864__auto___28327)){
args__4870__auto__.push((arguments[i__4865__auto___28328]));

var G__28329 = (i__4865__auto___28328 + (1));
i__4865__auto___28328 = G__28329;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic = (function (widget_id,p__28325){
var map__28326 = p__28325;
var map__28326__$1 = cljs.core.__destructure_map(map__28326);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28326__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["widgets",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(widget_id),".json",(cljs.core.truth_(with_data_QMARK_)?"?data=true":null)].join('')], 0)));
}));

(milia.api.widgets.get.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.widgets.get.cljs$lang$applyTo = (function (seq28323){
var G__28324 = cljs.core.first(seq28323);
var seq28323__$1 = cljs.core.next(seq28323);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28324,seq28323__$1);
}));

