// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.notes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Returns all notes. Returns notes for a specific submission if
 *   optional instance ID is proviced
 */
milia.api.notes.list = (function milia$api$notes$list(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28464 = arguments.length;
var i__4865__auto___28465 = (0);
while(true){
if((i__4865__auto___28465 < len__4864__auto___28464)){
args__4870__auto__.push((arguments[i__4865__auto___28465]));

var G__28466 = (i__4865__auto___28465 + (1));
i__4865__auto___28465 = G__28466;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__28462){
var map__28463 = p__28462;
var map__28463__$1 = cljs.core.__destructure_map(map__28463);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28463__$1,cljs.core.cst$kw$instance_DASH_id);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28463__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["notes.json",(cljs.core.truth_(instance_id)?["?instance=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_id)].join(''):null)].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.notes.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.notes.list.cljs$lang$applyTo = (function (seq28461){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28461));
}));

/**
 * Creates a note for a submission instance given the note and instance-id.
 * Takes an options instance-field argument if note added for specific field.
 */
milia.api.notes.create = (function milia$api$notes$create(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28474 = arguments.length;
var i__4865__auto___28475 = (0);
while(true){
if((i__4865__auto___28475 < len__4864__auto___28474)){
args__4870__auto__.push((arguments[i__4865__auto___28475]));

var G__28476 = (i__4865__auto___28475 + (1));
i__4865__auto___28475 = G__28476;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic = (function (note,instance_id,p__28470){
var vec__28471 = p__28470;
var instance_field = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28471,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notes.json"], 0));
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$instance,instance_id], null);
var form_params = (cljs.core.truth_(instance_field)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(params,cljs.core.cst$kw$instance_field,instance_field):params);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.notes.create.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.notes.create.cljs$lang$applyTo = (function (seq28467){
var G__28468 = cljs.core.first(seq28467);
var seq28467__$1 = cljs.core.next(seq28467);
var G__28469 = cljs.core.first(seq28467__$1);
var seq28467__$2 = cljs.core.next(seq28467__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28468,G__28469,seq28467__$2);
}));

/**
 * Returns a note object given a note ID.
 */
milia.api.notes.get = (function milia$api$notes$get(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notes",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(note_id),".json"].join('')], 0)));
});
/**
 * Deletes a note given a note ID.
 */
milia.api.notes.delete$ = (function milia$api$notes$delete(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["notes",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(note_id),".json"].join('')], 0)));
});
