// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.charts');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.charts.format = goog.string.format;
milia.api.charts.suffix = (function milia$api$charts$suffix(var_args){
var G__28602 = arguments.length;
switch (G__28602) {
case 1:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('');
}));

(milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var field_s = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_name,"all"))?"fields":"field_name");
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json?",field_s,"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(field_name)].join('');
}));

(milia.api.charts.suffix.cljs$lang$maxFixedArity = 2);

/**
 * Get list of chart fields for a specific dataset
 */
milia.api.charts.fields = (function milia$api$charts$fields(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1(dataset_id)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get chart for a specific field in a dataset
 */
milia.api.charts.chart = (function milia$api$charts$chart(var_args){
var G__28605 = arguments.length;
switch (G__28605) {
case 1:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2(dataset_id,"all");
}));

(milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2(dataset_id,field_name)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.charts.chart.cljs$lang$maxFixedArity = 2);

/**
 * Given a field name, return chart data associated with a dataset or dataview
 */
milia.api.charts.get = (function milia$api$charts$get(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28611 = arguments.length;
var i__4865__auto___28612 = (0);
while(true){
if((i__4865__auto___28612 < len__4864__auto___28611)){
args__4870__auto__.push((arguments[i__4865__auto___28612]));

var G__28613 = (i__4865__auto___28612 + (1));
i__4865__auto___28612 = G__28613;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic = (function (field_name,p__28609){
var map__28610 = p__28609;
var map__28610__$1 = cljs.core.__destructure_map(map__28610);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28610__$1,cljs.core.cst$kw$dataview_DASH_id);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28610__$1,cljs.core.cst$kw$dataset_DASH_id);
var group_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28610__$1,cljs.core.cst$kw$group_DASH_by);
var id = (function (){var or__4253__auto__ = dataview_id;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return dataset_id;
}
})();
var base_url_template = (cljs.core.truth_(dataview_id)?"dataviews/%s/charts.json?field_name=%s":"charts/%s.json?field_name=%s");
var url_template = [base_url_template,(cljs.core.truth_(group_by)?"&group_by=%s":null)].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(milia.api.charts.format.cljs$core$IFn$_invoke$arity$4 ? milia.api.charts.format.cljs$core$IFn$_invoke$arity$4(url_template,id,field_name,group_by) : milia.api.charts.format.call(null,url_template,id,field_name,group_by))], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.charts.get.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.charts.get.cljs$lang$applyTo = (function (seq28607){
var G__28608 = cljs.core.first(seq28607);
var seq28607__$1 = cljs.core.next(seq28607);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28608,seq28607__$1);
}));

