// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
/**
 * Return true if string value is true else false
 */
chimera.string.str_is_true_QMARK_ = (function chimera$string$str_is_true_QMARK_(value){
var and__4251__auto__ = value;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(value),"true");
} else {
return and__4251__auto__;
}
});
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set("aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)," (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(suffix),")"].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count(s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count(s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),chimera.string.ellipsis_start),"...",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,end_start)].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(s)));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first(s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first(s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix(prefix,cljs.core.count(collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count(s) - cljs.core.count(suffix));
return (((offset >= (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suffix,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,offset))));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",(function (){var iter__4652__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__28015(s__28016){
return (new cljs.core.LazySeq(null,(function (){
var s__28016__$1 = s__28016;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__28016__$1);
if(temp__5753__auto__){
var s__28016__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28016__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__28016__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__28018 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__28017 = (0);
while(true){
if((i__28017 < size__4651__auto__)){
var vec__28019 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__28017);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28019,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28019,(1),null);
cljs.core.chunk_append(b__28018,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null));

var G__28025 = (i__28017 + (1));
i__28017 = G__28025;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28018),chimera$string$map__GT_js_string_map_$_iter__28015(cljs.core.chunk_rest(s__28016__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28018),null);
}
} else {
var vec__28022 = cljs.core.first(s__28016__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28022,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28022,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__28015(cljs.core.rest(s__28016__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
var G__28026 = cljs.core.first(clojure.string.lower_case(cljs.core.first(s)));
return (chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1(G__28026) : chimera.string.vowel_QMARK_.call(null,G__28026));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var and__4251__auto__ = typeof s === 'string';
if(and__4251__auto__){
return clojure.string.lower_case(s);
} else {
return and__4251__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("<br/>",(function (){var iter__4652__auto__ = (function chimera$string$error_json__GT_str_$_iter__28027(s__28028){
return (new cljs.core.LazySeq(null,(function (){
var s__28028__$1 = s__28028;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__28028__$1);
if(temp__5753__auto__){
var s__28028__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28028__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__28028__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__28030 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__28029 = (0);
while(true){
if((i__28029 < size__4651__auto__)){
var vec__28031 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__28029);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28031,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28031,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__28034 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__28034);
} else {
return G__28034;
}
})();
cljs.core.chunk_append(b__28030,[key,": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));

var G__28039 = (i__28029 + (1));
i__28029 = G__28039;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28030),chimera$string$error_json__GT_str_$_iter__28027(cljs.core.chunk_rest(s__28028__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28030),null);
}
} else {
var vec__28035 = cljs.core.first(s__28028__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28035,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28035,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__28038 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__28038);
} else {
return G__28038;
}
})();
return cljs.core.cons([key,": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''),chimera$string$error_json__GT_str_$_iter__28027(cljs.core.rest(s__28028__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__28040){
var vec__28041 = p__28040;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28041,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28041,(1),null);
return clojure.string.replace(r,cljs.core.re_pattern(v),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
/**
 * Checks if a variable is null or nil
 */
chimera.string.is_null_or_nil_QMARK_ = (function chimera$string$is_null_or_nil_QMARK_(s){
return ((chimera.string.is_null_QMARK_(s)) || ((s == null)));
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28050 = arguments.length;
var i__4865__auto___28051 = (0);
while(true){
if((i__4865__auto___28051 < len__4864__auto___28050)){
args__4870__auto__.push((arguments[i__4865__auto___28051]));

var G__28052 = (i__4865__auto___28051 + (1));
i__4865__auto___28051 = G__28052;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__28047){
var map__28048 = p__28047;
var map__28048__$1 = cljs.core.__destructure_map(map__28048);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28048__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(((cljs.core.empty_QMARK_(s)) || (chimera.string.is_null_QMARK_(s)))){
return false;
} else {
var G__28049 = cljs.core.re_find(cljs.core.re_pattern([(cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(substring)].join('')),s);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__28049) : chimera.core.not_nil_QMARK_.call(null,G__28049));
}
}));

(chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq28044){
var G__28045 = cljs.core.first(seq28044);
var seq28044__$1 = cljs.core.next(seq28044);
var G__28046 = cljs.core.first(seq28044__$1);
var seq28044__$2 = cljs.core.next(seq28044__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28045,G__28046,seq28044__$2);
}));

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape(x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
chimera.string.get_query_params_str = (function chimera$string$get_query_params_str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28060 = arguments.length;
var i__4865__auto___28061 = (0);
while(true){
if((i__4865__auto___28061 < len__4864__auto___28060)){
args__4870__auto__.push((arguments[i__4865__auto___28061]));

var G__28062 = (i__4865__auto___28061 + (1));
i__4865__auto___28061 = G__28062;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic = (function (query_params_map,p__28055){
var vec__28056 = p__28055;
var query_param_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28056,(0),null);

var query_param_str__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_param_str);
var query_param_str_blank_QMARK_ = clojure.string.blank_QMARK_(query_param_str__$1);
var key = cljs.core.first(cljs.core.keys(query_params_map));
var query_param_key = cljs.core.name((function (){var or__4253__auto__ = key;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "";
}
})());
var query_param_val = (function (){var and__4251__auto__ = key;
if(cljs.core.truth_(and__4251__auto__)){
return (key.cljs$core$IFn$_invoke$arity$1 ? key.cljs$core$IFn$_invoke$arity$1(query_params_map) : key.call(null,query_params_map));
} else {
return and__4251__auto__;
}
})();
var G__28059 = cljs.core.count(query_params_map);
switch (G__28059) {
case (0):
return null;

break;
case (1):
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?",query_param_key,"=",query_param_val], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_param_str__$1,"&",query_param_key,"=",query_param_val], null)));

break;
default:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.string.get_query_params_str,((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_params_map,"?"], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.rest(query_params_map)),[query_param_str__$1,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query_param_str__$1,"?"))?null:"&"),query_param_key,"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_param_val)].join('')], null)));

}
}));

(chimera.string.get_query_params_str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chimera.string.get_query_params_str.cljs$lang$applyTo = (function (seq28053){
var G__28054 = cljs.core.first(seq28053);
var seq28053__$1 = cljs.core.next(seq28053);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28054,seq28053__$1);
}));

