// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e28291){if((e28291 instanceof Error)){
var _ = e28291;
return string;
} else {
throw e28291;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28294 = arguments.length;
var i__4865__auto___28295 = (0);
while(true){
if((i__4865__auto___28295 < len__4864__auto___28294)){
args__4870__auto__.push((arguments[i__4865__auto___28295]));

var G__28296 = (i__4865__auto___28295 + (1));
i__4865__auto___28295 = G__28296;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
}));

(chimera.js_interop.format.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chimera.js_interop.format.cljs$lang$applyTo = (function (seq28292){
var G__28293 = cljs.core.first(seq28292);
var seq28292__$1 = cljs.core.next(seq28292);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28293,seq28292__$1);
}));

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28301 = arguments.length;
var i__4865__auto___28302 = (0);
while(true){
if((i__4865__auto___28302 < len__4864__auto___28301)){
args__4870__auto__.push((arguments[i__4865__auto___28302]));

var G__28303 = (i__4865__auto___28302 + (1));
i__4865__auto___28302 = G__28303;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__28299){
var map__28300 = p__28299;
var map__28300__$1 = cljs.core.__destructure_map(map__28300);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28300__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([(cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null),goog.string.regExpEscape(query_string)].join(''));
}));

(chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq28297){
var G__28298 = cljs.core.first(seq28297);
var seq28297__$1 = cljs.core.next(seq28297);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28298,seq28297__$1);
}));

