// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.apps');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.apps.rapidpro_hosts = new cljs.core.PersistentArrayMap(null, 2, ["rapidpro-ona","rapidpro.ona.io","textit","textit.in"], null);
/**
 * Returns host URL
 */
milia.api.apps.get_textit_host = (function milia$api$apps$get_textit_host(server){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(milia.api.apps.rapidpro_hosts,server);
if(cljs.core.truth_(temp__5751__auto__)){
var host_url = temp__5751__auto__;
return ["https://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(host_url)].join('');
} else {
return server;
}
})());
});
/**
 * Returns host url appended with API path
 */
milia.api.apps.get_textit_api_url = (function milia$api$apps$get_textit_api_url(server){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server),"/api/v2"].join('');
});
/**
 * Build a texit server API url.
 */
milia.api.apps.make_textit_url = (function milia$api$apps$make_textit_url(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28334 = arguments.length;
var i__4865__auto___28335 = (0);
while(true){
if((i__4865__auto___28335 < len__4864__auto___28334)){
args__4870__auto__.push((arguments[i__4865__auto___28335]));

var G__28336 = (i__4865__auto___28335 + (1));
i__4865__auto___28335 = G__28336;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic = (function (server,postfix){
return milia.utils.remote.url_join(milia.api.apps.get_textit_api_url(server),postfix);
}));

(milia.api.apps.make_textit_url.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.apps.make_textit_url.cljs$lang$applyTo = (function (seq28332){
var G__28333 = cljs.core.first(seq28332);
var seq28332__$1 = cljs.core.next(seq28332);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28333,seq28332__$1);
}));

milia.api.apps.make_textit_service_url = (function milia$api$apps$make_textit_service_url(server){
return milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic(server,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["flow_starts.json"], 0));
});
/**
 * Get data from textit server given server URL, endpoint & API Key.
 */
milia.api.apps.get_textit_data = (function milia$api$apps$get_textit_data(api_token,endpoint,server){
var url = milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic(server,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(endpoint),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$auth_DASH_token,api_token,cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$raw_DASH_response_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
