// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5753__auto__ = (function (){var fexpr__26205 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__26205.cljs$core$IFn$_invoke$arity$1 ? fexpr__26205.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__26205.call(null,channel));
})();
if(cljs.core.truth_(temp__5753__auto__)){
var req = temp__5753__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__26206){
var vec__26207 = p__26206;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26207,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26207,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__26210 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__26210)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__26210)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__26210)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__26210)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__26210)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__26210)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26210)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__26211){
var map__26212 = p__26211;
var map__26212__$1 = cljs.core.__destructure_map(map__26212);
var request = map__26212__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26212__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26212__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26212__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__4253__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__26213 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__26213,default_headers);

cljs_http.core.apply_response_type_BANG_(G__26213,response_type);

G__26213.setTimeoutInterval(timeout);

G__26213.setWithCredentials(send_credentials);

return G__26213;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__26214){
var map__26215 = p__26214;
var map__26215__$1 = cljs.core.__destructure_map(map__26215);
var request = map__26215__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26215__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26215__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26215__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26215__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26215__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26215__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4253__auto__ = request_method;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__26216 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__26216) : cljs_http.core.error_kw.call(null,G__26216));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_26240 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});
var G__26217_26241 = xhr;
G__26217_26241.setProgressEventsEnabled(true);

G__26217_26241.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_26240,cljs.core.cst$kw$upload));

G__26217_26241.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_26240,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__24250__auto___26242 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_26228){
var state_val_26229 = (state_26228[(1)]);
if((state_val_26229 === (1))){
var state_26228__$1 = state_26228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26228__$1,(2),cancel);
} else {
if((state_val_26229 === (2))){
var inst_26219 = (state_26228[(2)]);
var inst_26220 = xhr.isComplete();
var inst_26221 = cljs.core.not(inst_26220);
var state_26228__$1 = (function (){var statearr_26230 = state_26228;
(statearr_26230[(7)] = inst_26219);

return statearr_26230;
})();
if(inst_26221){
var statearr_26231_26243 = state_26228__$1;
(statearr_26231_26243[(1)] = (3));

} else {
var statearr_26232_26244 = state_26228__$1;
(statearr_26232_26244[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26229 === (3))){
var inst_26223 = xhr.abort();
var state_26228__$1 = state_26228;
var statearr_26233_26245 = state_26228__$1;
(statearr_26233_26245[(2)] = inst_26223);

(statearr_26233_26245[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26229 === (4))){
var state_26228__$1 = state_26228;
var statearr_26234_26246 = state_26228__$1;
(statearr_26234_26246[(2)] = null);

(statearr_26234_26246[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26229 === (5))){
var inst_26226 = (state_26228[(2)]);
var state_26228__$1 = state_26228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26228__$1,inst_26226);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__24176__auto__ = null;
var cljs_http$core$xhr_$_state_machine__24176__auto____0 = (function (){
var statearr_26235 = [null,null,null,null,null,null,null,null];
(statearr_26235[(0)] = cljs_http$core$xhr_$_state_machine__24176__auto__);

(statearr_26235[(1)] = (1));

return statearr_26235;
});
var cljs_http$core$xhr_$_state_machine__24176__auto____1 = (function (state_26228){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_26228);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e26236){var ex__24179__auto__ = e26236;
var statearr_26237_26247 = state_26228;
(statearr_26237_26247[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_26228[(4)]))){
var statearr_26238_26248 = state_26228;
(statearr_26238_26248[(1)] = cljs.core.first((state_26228[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__26249 = state_26228;
state_26228 = G__26249;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__24176__auto__ = function(state_26228){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__24176__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__24176__auto____1.call(this,state_26228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__24176__auto____0;
cljs_http$core$xhr_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__24176__auto____1;
return cljs_http$core$xhr_$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_26239 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_26239[(6)] = c__24250__auto___26242);

return statearr_26239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__26250){
var map__26251 = p__26250;
var map__26251__$1 = cljs.core.__destructure_map(map__26251);
var request = map__26251__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26251__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26251__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26251__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26251__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_26264 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_26264], null));

if(cljs.core.truth_(cancel)){
var c__24250__auto___26265 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_26256){
var state_val_26257 = (state_26256[(1)]);
if((state_val_26257 === (1))){
var state_26256__$1 = state_26256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26256__$1,(2),cancel);
} else {
if((state_val_26257 === (2))){
var inst_26253 = (state_26256[(2)]);
var inst_26254 = jsonp.cancel(req_26264);
var state_26256__$1 = (function (){var statearr_26258 = state_26256;
(statearr_26258[(7)] = inst_26253);

return statearr_26258;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_26256__$1,inst_26254);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__24176__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__24176__auto____0 = (function (){
var statearr_26259 = [null,null,null,null,null,null,null,null];
(statearr_26259[(0)] = cljs_http$core$jsonp_$_state_machine__24176__auto__);

(statearr_26259[(1)] = (1));

return statearr_26259;
});
var cljs_http$core$jsonp_$_state_machine__24176__auto____1 = (function (state_26256){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_26256);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e26260){var ex__24179__auto__ = e26260;
var statearr_26261_26266 = state_26256;
(statearr_26261_26266[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_26256[(4)]))){
var statearr_26262_26267 = state_26256;
(statearr_26262_26267[(1)] = cljs.core.first((state_26256[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__26268 = state_26256;
state_26256 = G__26268;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__24176__auto__ = function(state_26256){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__24176__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__24176__auto____1.call(this,state_26256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__24176__auto____0;
cljs_http$core$jsonp_$_state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__24176__auto____1;
return cljs_http$core$jsonp_$_state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_26263 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_26263[(6)] = c__24250__auto___26265);

return statearr_26263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__26269){
var map__26270 = p__26269;
var map__26270__$1 = cljs.core.__destructure_map(map__26270);
var request = map__26270__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26270__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
