// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__37549 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__37549,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__37550 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__37550) : cljs_hash.md5.md5.call(null,G__37550));
})());
} else {
return G__37549;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37555 = arguments.length;
var i__7652__auto___37556 = (0);
while(true){
if((i__7652__auto___37556 < len__7651__auto___37555)){
args__7658__auto__.push((arguments[i__7652__auto___37556]));

var G__37557 = (i__7652__auto___37556 + (1));
i__7652__auto___37556 = G__37557;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__37552){
var map__37553 = p__37552;
var map__37553__$1 = ((((!((map__37553 == null)))?((((map__37553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37553.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37553):map__37553);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37553__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37553__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37553__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37553__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq37551){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37551));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37567 = arguments.length;
var i__7652__auto___37568 = (0);
while(true){
if((i__7652__auto___37568 < len__7651__auto___37567)){
args__7658__auto__.push((arguments[i__7652__auto___37568]));

var G__37569 = (i__7652__auto___37568 + (1));
i__7652__auto___37568 = G__37569;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__37560){
var vec__37561 = p__37560;
var map__37564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37561,(0),null);
var map__37564__$1 = ((((!((map__37564 == null)))?((((map__37564.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37564.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37564):map__37564);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37564__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e37566){if((e37566 instanceof Error)){
var _ = e37566;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e37566;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq37558){
var G__37559 = cljs.core.first(seq37558);
var seq37558__$1 = cljs.core.next(seq37558);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__37559,seq37558__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__37576_37582 = io_obj;
var G__37577_37583 = goog.net.EventType.SUCCESS;
var G__37578_37584 = ((function (G__37576_37582,G__37577_37583,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__37576_37582,G__37577_37583,io_obj))
;
goog.events.listen(G__37576_37582,G__37577_37583,G__37578_37584);

var G__37579_37585 = io_obj;
var G__37580_37586 = goog.net.EventType.ERROR;
var G__37581_37587 = ((function (G__37579_37585,G__37580_37586,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__37579_37585,G__37580_37586,io_obj))
;
goog.events.listen(G__37579_37585,G__37580_37586,G__37581_37587);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://developers.google.com/closure/library/docs/xhrio
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37607 = arguments.length;
var i__7652__auto___37608 = (0);
while(true){
if((i__7652__auto___37608 < len__7651__auto___37607)){
args__7658__auto__.push((arguments[i__7652__auto___37608]));

var G__37609 = (i__7652__auto___37608 + (1));
i__7652__auto___37608 = G__37609;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__37592){
var map__37593 = p__37592;
var map__37593__$1 = ((((!((map__37593 == null)))?((((map__37593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37593.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37593):map__37593);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37593__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37593__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37593__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__37595_37610 = io_obj;
var G__37596_37611 = goog.net.EventType.COMPLETE;
var G__37597_37612 = ((function (G__37595_37610,G__37596_37611,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0))));
});})(G__37595_37610,G__37596_37611,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37595_37610,G__37596_37611,G__37597_37612);

var G__37598_37613 = io_obj;
var G__37599_37614 = goog.net.EventType.SUCCESS;
var G__37600_37615 = ((function (G__37598_37613,G__37599_37614,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__37598_37613,G__37599_37614,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37598_37613,G__37599_37614,G__37600_37615);

var G__37601_37616 = io_obj;
var G__37602_37617 = goog.net.EventType.ERROR;
var G__37603_37618 = ((function (G__37601_37616,G__37602_37617,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__37601_37616,G__37602_37617,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37601_37616,G__37602_37617,G__37603_37618);

var G__37604_37619 = io_obj;
var G__37605_37620 = goog.net.EventType.PROGRESS;
var G__37606_37621 = ((function (G__37604_37619,G__37605_37620,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_){
return (function (p1__37588_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__37588_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__37588_SHARP_.loaded,cljs.core.cst$kw$total,p1__37588_SHARP_.total], null)));
});})(G__37604_37619,G__37605_37620,io_obj,data,url,map__37593,map__37593__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37604_37619,G__37605_37620,G__37606_37621);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq37589){
var G__37590 = cljs.core.first(seq37589);
var seq37589__$1 = cljs.core.next(seq37589);
var G__37591 = cljs.core.first(seq37589__$1);
var seq37589__$2 = cljs.core.next(seq37589__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__37590,G__37591,seq37589__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37686 = arguments.length;
var i__7652__auto___37687 = (0);
while(true){
if((i__7652__auto___37687 < len__7651__auto___37686)){
args__7658__auto__.push((arguments[i__7652__auto___37687]));

var G__37688 = (i__7652__auto___37687 + (1));
i__7652__auto___37687 = G__37688;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19252__auto___37689 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___37689,response_channel){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___37689,response_channel){
return (function (state_37659){
var state_val_37660 = (state_37659[(1)]);
if((state_val_37660 === (7))){
var state_37659__$1 = state_37659;
var statearr_37661_37690 = state_37659__$1;
(statearr_37661_37690[(2)] = false);

(statearr_37661_37690[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (1))){
var inst_37625 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_37659__$1 = state_37659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37659__$1,(2),inst_37625);
} else {
if((state_val_37660 === (4))){
var state_37659__$1 = state_37659;
var statearr_37662_37691 = state_37659__$1;
(statearr_37662_37691[(2)] = false);

(statearr_37662_37691[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (13))){
var inst_37648 = (state_37659[(7)]);
var inst_37655 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_37648);
var state_37659__$1 = state_37659;
var statearr_37663_37692 = state_37659__$1;
(statearr_37663_37692[(2)] = inst_37655);

(statearr_37663_37692[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (6))){
var state_37659__$1 = state_37659;
var statearr_37664_37693 = state_37659__$1;
(statearr_37664_37693[(2)] = true);

(statearr_37664_37693[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (3))){
var inst_37627 = (state_37659[(8)]);
var inst_37632 = inst_37627.cljs$lang$protocol_mask$partition0$;
var inst_37633 = (inst_37632 & (64));
var inst_37634 = inst_37627.cljs$core$ISeq$;
var inst_37635 = (cljs.core.PROTOCOL_SENTINEL === inst_37634);
var inst_37636 = (inst_37633) || (inst_37635);
var state_37659__$1 = state_37659;
if(cljs.core.truth_(inst_37636)){
var statearr_37665_37694 = state_37659__$1;
(statearr_37665_37694[(1)] = (6));

} else {
var statearr_37666_37695 = state_37659__$1;
(statearr_37666_37695[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (12))){
var inst_37652 = window.location.href();
var inst_37653 = window.location = inst_37652;
var state_37659__$1 = state_37659;
var statearr_37667_37696 = state_37659__$1;
(statearr_37667_37696[(2)] = inst_37653);

(statearr_37667_37696[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (2))){
var inst_37627 = (state_37659[(8)]);
var inst_37627__$1 = (state_37659[(2)]);
var inst_37629 = (inst_37627__$1 == null);
var inst_37630 = cljs.core.not(inst_37629);
var state_37659__$1 = (function (){var statearr_37668 = state_37659;
(statearr_37668[(8)] = inst_37627__$1);

return statearr_37668;
})();
if(inst_37630){
var statearr_37669_37697 = state_37659__$1;
(statearr_37669_37697[(1)] = (3));

} else {
var statearr_37670_37698 = state_37659__$1;
(statearr_37670_37698[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (11))){
var inst_37648 = (state_37659[(7)]);
var inst_37648__$1 = (state_37659[(2)]);
var inst_37649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37648__$1,cljs.core.cst$kw$status);
var inst_37650 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37649,(401));
var state_37659__$1 = (function (){var statearr_37671 = state_37659;
(statearr_37671[(7)] = inst_37648__$1);

return statearr_37671;
})();
if(inst_37650){
var statearr_37672_37699 = state_37659__$1;
(statearr_37672_37699[(1)] = (12));

} else {
var statearr_37673_37700 = state_37659__$1;
(statearr_37673_37700[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (9))){
var inst_37627 = (state_37659[(8)]);
var inst_37645 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37627);
var state_37659__$1 = state_37659;
var statearr_37674_37701 = state_37659__$1;
(statearr_37674_37701[(2)] = inst_37645);

(statearr_37674_37701[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (5))){
var inst_37643 = (state_37659[(2)]);
var state_37659__$1 = state_37659;
if(cljs.core.truth_(inst_37643)){
var statearr_37675_37702 = state_37659__$1;
(statearr_37675_37702[(1)] = (9));

} else {
var statearr_37676_37703 = state_37659__$1;
(statearr_37676_37703[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (14))){
var inst_37657 = (state_37659[(2)]);
var state_37659__$1 = state_37659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37659__$1,inst_37657);
} else {
if((state_val_37660 === (10))){
var inst_37627 = (state_37659[(8)]);
var state_37659__$1 = state_37659;
var statearr_37677_37704 = state_37659__$1;
(statearr_37677_37704[(2)] = inst_37627);

(statearr_37677_37704[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37660 === (8))){
var inst_37640 = (state_37659[(2)]);
var state_37659__$1 = state_37659;
var statearr_37678_37705 = state_37659__$1;
(statearr_37678_37705[(2)] = inst_37640);

(statearr_37678_37705[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___37689,response_channel))
;
return ((function (switch__19140__auto__,c__19252__auto___37689,response_channel){
return (function() {
var milia$api$io$state_machine__19141__auto__ = null;
var milia$api$io$state_machine__19141__auto____0 = (function (){
var statearr_37682 = [null,null,null,null,null,null,null,null,null];
(statearr_37682[(0)] = milia$api$io$state_machine__19141__auto__);

(statearr_37682[(1)] = (1));

return statearr_37682;
});
var milia$api$io$state_machine__19141__auto____1 = (function (state_37659){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_37659);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e37683){if((e37683 instanceof Object)){
var ex__19144__auto__ = e37683;
var statearr_37684_37706 = state_37659;
(statearr_37684_37706[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37659);

return cljs.core.cst$kw$recur;
} else {
throw e37683;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__37707 = state_37659;
state_37659 = G__37707;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$io$state_machine__19141__auto__ = function(state_37659){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19141__auto____1.call(this,state_37659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19141__auto____0;
milia$api$io$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19141__auto____1;
return milia$api$io$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___37689,response_channel))
})();
var state__19254__auto__ = (function (){var statearr_37685 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_37685[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___37689);

return statearr_37685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___37689,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq37622){
var G__37623 = cljs.core.first(seq37622);
var seq37622__$1 = cljs.core.next(seq37622);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__37623,seq37622__$1);
});

