// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38270 = arguments.length;
var i__7652__auto___38271 = (0);
while(true){
if((i__7652__auto___38271 < len__7651__auto___38270)){
args__7658__auto__.push((arguments[i__7652__auto___38271]));

var G__38272 = (i__7652__auto___38271 + (1));
i__7652__auto___38271 = G__38272;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq38269){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38269));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__38273,p__38274){
var map__38283 = p__38273;
var map__38283__$1 = ((((!((map__38283 == null)))?((((map__38283.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38283.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38283):map__38283);
var response = map__38283__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38283__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38283__$1,cljs.core.cst$kw$body);
var map__38284 = p__38274;
var map__38284__$1 = ((((!((map__38284 == null)))?((((map__38284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38284.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38284):map__38284);
var callbacks = map__38284__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38284__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38284__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38284__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38284__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__38287 = body;
var map__38287__$1 = ((((!((map__38287 == null)))?((((map__38287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38287.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38287):map__38287);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38287__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38287__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38287__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__38287,map__38287__$1,export_url,job_status,job_id,map__38283,map__38283__$1,response,status,body,map__38284,map__38284__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__38287,map__38287__$1,export_url,job_status,job_id,map__38283,map__38283__$1,response,status,body,map__38284,map__38284__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__38289_38291 = error_detail;
var G__38290_38292 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__38289_38291,G__38290_38292) : on_error.call(null,G__38289_38291,G__38290_38292));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38343 = arguments.length;
var i__7652__auto___38344 = (0);
while(true){
if((i__7652__auto___38344 < len__7651__auto___38343)){
args__7658__auto__.push((arguments[i__7652__auto___38344]));

var G__38345 = (i__7652__auto___38344 + (1));
i__7652__auto___38344 = G__38345;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__38296){
var map__38297 = p__38296;
var map__38297__$1 = ((((!((map__38297 == null)))?((((map__38297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38297.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38297):map__38297);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38297__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38297__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38297__$1,cljs.core.cst$kw$data_DASH_type);
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type){
return (function (state_38325){
var state_val_38326 = (state_38325[(1)]);
if((state_val_38326 === (1))){
var inst_38299 = milia.api.async_export.initial_polling_interval;
var state_38325__$1 = (function (){var statearr_38327 = state_38325;
(statearr_38327[(7)] = inst_38299);

return statearr_38327;
})();
var statearr_38328_38346 = state_38325__$1;
(statearr_38328_38346[(2)] = null);

(statearr_38328_38346[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38326 === (2))){
var inst_38303 = (state_38325[(8)]);
var inst_38301 = (state_38325[(9)]);
var inst_38301__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_38302 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_38303__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_38302,dataset_id,inst_38301__$1], 0));
var inst_38304 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_38303__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_38325__$1 = (function (){var statearr_38329 = state_38325;
(statearr_38329[(8)] = inst_38303__$1);

(statearr_38329[(9)] = inst_38301__$1);

return statearr_38329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38325__$1,(4),inst_38304);
} else {
if((state_val_38326 === (3))){
var inst_38323 = (state_38325[(2)]);
var state_38325__$1 = state_38325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38325__$1,inst_38323);
} else {
if((state_val_38326 === (4))){
var inst_38299 = (state_38325[(7)]);
var inst_38303 = (state_38325[(8)]);
var inst_38301 = (state_38325[(9)]);
var inst_38306 = (state_38325[(2)]);
var inst_38307 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_38308 = (function (){var polling_interval = inst_38299;
var job_suffix = inst_38301;
var job_url = inst_38303;
var response = inst_38306;
return ((function (polling_interval,job_suffix,job_url,response,inst_38299,inst_38303,inst_38301,inst_38306,inst_38307,state_val_38326,c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_38299,inst_38303,inst_38301,inst_38306,inst_38307,state_val_38326,c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type))
})();
var inst_38309 = [inst_38308,on_error,on_export_url];
var inst_38310 = cljs.core.PersistentHashMap.fromArrays(inst_38307,inst_38309);
var inst_38311 = milia.api.async_export.handle_response(inst_38306,inst_38310);
var inst_38312 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_38311,cljs.core.cst$kw$stop);
var state_38325__$1 = state_38325;
if(inst_38312){
var statearr_38330_38347 = state_38325__$1;
(statearr_38330_38347[(1)] = (5));

} else {
var statearr_38331_38348 = state_38325__$1;
(statearr_38331_38348[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38326 === (5))){
var inst_38299 = (state_38325[(7)]);
var inst_38314 = cljs.core.async.timeout(inst_38299);
var state_38325__$1 = state_38325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38325__$1,(8),inst_38314);
} else {
if((state_val_38326 === (6))){
var state_38325__$1 = state_38325;
var statearr_38332_38349 = state_38325__$1;
(statearr_38332_38349[(2)] = null);

(statearr_38332_38349[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38326 === (7))){
var inst_38321 = (state_38325[(2)]);
var state_38325__$1 = state_38325;
var statearr_38333_38350 = state_38325__$1;
(statearr_38333_38350[(2)] = inst_38321);

(statearr_38333_38350[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38326 === (8))){
var inst_38299 = (state_38325[(7)]);
var inst_38316 = (state_38325[(2)]);
var inst_38317 = (inst_38299 * (2));
var inst_38299__$1 = inst_38317;
var state_38325__$1 = (function (){var statearr_38334 = state_38325;
(statearr_38334[(7)] = inst_38299__$1);

(statearr_38334[(10)] = inst_38316);

return statearr_38334;
})();
var statearr_38335_38351 = state_38325__$1;
(statearr_38335_38351[(2)] = null);

(statearr_38335_38351[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19140__auto__,c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19141__auto__ = null;
var milia$api$async_export$state_machine__19141__auto____0 = (function (){
var statearr_38339 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38339[(0)] = milia$api$async_export$state_machine__19141__auto__);

(statearr_38339[(1)] = (1));

return statearr_38339;
});
var milia$api$async_export$state_machine__19141__auto____1 = (function (state_38325){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_38325);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e38340){if((e38340 instanceof Object)){
var ex__19144__auto__ = e38340;
var statearr_38341_38352 = state_38325;
(statearr_38341_38352[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38325);

return cljs.core.cst$kw$recur;
} else {
throw e38340;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__38353 = state_38325;
state_38325 = G__38353;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19141__auto__ = function(state_38325){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19141__auto____1.call(this,state_38325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19141__auto____0;
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19141__auto____1;
return milia$api$async_export$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type))
})();
var state__19254__auto__ = (function (){var statearr_38342 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_38342[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_38342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,map__38297,map__38297__$1,on_error,on_export_url,data_type))
);

return c__19252__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq38293){
var G__38294 = cljs.core.first(seq38293);
var seq38293__$1 = cljs.core.next(seq38293);
var G__38295 = cljs.core.first(seq38293__$1);
var seq38293__$2 = cljs.core.next(seq38293__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38294,G__38295,seq38293__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_38483){
var state_val_38484 = (state_38483[(1)]);
if((state_val_38484 === (7))){
var inst_38458 = (state_38483[(2)]);
var state_38483__$1 = state_38483;
if(cljs.core.truth_(inst_38458)){
var statearr_38485_38515 = state_38483__$1;
(statearr_38485_38515[(1)] = (11));

} else {
var statearr_38486_38516 = state_38483__$1;
(statearr_38486_38516[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (1))){
var inst_38435 = milia.api.async_export.initial_polling_interval;
var state_38483__$1 = (function (){var statearr_38487 = state_38483;
(statearr_38487[(7)] = inst_38435);

return statearr_38487;
})();
var statearr_38488_38517 = state_38483__$1;
(statearr_38488_38517[(2)] = null);

(statearr_38488_38517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (4))){
var inst_38442 = (state_38483[(8)]);
var inst_38442__$1 = (state_38483[(2)]);
var inst_38444 = (inst_38442__$1 == null);
var inst_38445 = cljs.core.not(inst_38444);
var state_38483__$1 = (function (){var statearr_38489 = state_38483;
(statearr_38489[(8)] = inst_38442__$1);

return statearr_38489;
})();
if(inst_38445){
var statearr_38490_38518 = state_38483__$1;
(statearr_38490_38518[(1)] = (5));

} else {
var statearr_38491_38519 = state_38483__$1;
(statearr_38491_38519[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (15))){
var inst_38435 = (state_38483[(7)]);
var inst_38473 = cljs.core.async.timeout(inst_38435);
var state_38483__$1 = state_38483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38483__$1,(17),inst_38473);
} else {
if((state_val_38484 === (13))){
var inst_38465 = (state_38483[(9)]);
var inst_38439 = (state_38483[(10)]);
var inst_38435 = (state_38483[(7)]);
var inst_38463 = (state_38483[(2)]);
var inst_38464 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38463,cljs.core.cst$kw$status);
var inst_38465__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38463,cljs.core.cst$kw$body);
var inst_38466 = (function (){var polling_interval = inst_38435;
var export_url = inst_38439;
var map__38437 = inst_38463;
var status = inst_38464;
var body = inst_38465__$1;
return ((function (polling_interval,export_url,map__38437,status,body,inst_38465,inst_38439,inst_38435,inst_38463,inst_38464,inst_38465__$1,state_val_38484,c__19252__auto__){
return (function (p1__38354_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__38354_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__38437,status,body,inst_38465,inst_38439,inst_38435,inst_38463,inst_38464,inst_38465__$1,state_val_38484,c__19252__auto__))
})();
var inst_38467 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_38466,inst_38465__$1);
var inst_38468 = cljs.core.vec(inst_38467);
var inst_38469 = cljs.core.empty_QMARK_(inst_38468);
var state_38483__$1 = (function (){var statearr_38492 = state_38483;
(statearr_38492[(9)] = inst_38465__$1);

return statearr_38492;
})();
if(inst_38469){
var statearr_38493_38520 = state_38483__$1;
(statearr_38493_38520[(1)] = (14));

} else {
var statearr_38494_38521 = state_38483__$1;
(statearr_38494_38521[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (6))){
var state_38483__$1 = state_38483;
var statearr_38495_38522 = state_38483__$1;
(statearr_38495_38522[(2)] = false);

(statearr_38495_38522[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (17))){
var inst_38435 = (state_38483[(7)]);
var inst_38475 = (state_38483[(2)]);
var inst_38476 = (inst_38435 * (2));
var inst_38435__$1 = inst_38476;
var state_38483__$1 = (function (){var statearr_38496 = state_38483;
(statearr_38496[(11)] = inst_38475);

(statearr_38496[(7)] = inst_38435__$1);

return statearr_38496;
})();
var statearr_38497_38523 = state_38483__$1;
(statearr_38497_38523[(2)] = null);

(statearr_38497_38523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (3))){
var inst_38481 = (state_38483[(2)]);
var state_38483__$1 = state_38483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38483__$1,inst_38481);
} else {
if((state_val_38484 === (12))){
var inst_38442 = (state_38483[(8)]);
var state_38483__$1 = state_38483;
var statearr_38498_38524 = state_38483__$1;
(statearr_38498_38524[(2)] = inst_38442);

(statearr_38498_38524[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (2))){
var inst_38439 = (state_38483[(10)]);
var inst_38438 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export.json?xform=",dataset_id,"&"], 0));
var inst_38439__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_38438], 0));
var inst_38440 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_38439__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_38483__$1 = (function (){var statearr_38499 = state_38483;
(statearr_38499[(10)] = inst_38439__$1);

return statearr_38499;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38483__$1,(4),inst_38440);
} else {
if((state_val_38484 === (11))){
var inst_38442 = (state_38483[(8)]);
var inst_38460 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38442);
var state_38483__$1 = state_38483;
var statearr_38500_38525 = state_38483__$1;
(statearr_38500_38525[(2)] = inst_38460);

(statearr_38500_38525[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (9))){
var state_38483__$1 = state_38483;
var statearr_38501_38526 = state_38483__$1;
(statearr_38501_38526[(2)] = false);

(statearr_38501_38526[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (5))){
var inst_38442 = (state_38483[(8)]);
var inst_38447 = inst_38442.cljs$lang$protocol_mask$partition0$;
var inst_38448 = (inst_38447 & (64));
var inst_38449 = inst_38442.cljs$core$ISeq$;
var inst_38450 = (cljs.core.PROTOCOL_SENTINEL === inst_38449);
var inst_38451 = (inst_38448) || (inst_38450);
var state_38483__$1 = state_38483;
if(cljs.core.truth_(inst_38451)){
var statearr_38502_38527 = state_38483__$1;
(statearr_38502_38527[(1)] = (8));

} else {
var statearr_38503_38528 = state_38483__$1;
(statearr_38503_38528[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (14))){
var inst_38465 = (state_38483[(9)]);
var inst_38471 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_38465) : callback.call(null,inst_38465));
var state_38483__$1 = state_38483;
var statearr_38504_38529 = state_38483__$1;
(statearr_38504_38529[(2)] = inst_38471);

(statearr_38504_38529[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (16))){
var inst_38479 = (state_38483[(2)]);
var state_38483__$1 = state_38483;
var statearr_38505_38530 = state_38483__$1;
(statearr_38505_38530[(2)] = inst_38479);

(statearr_38505_38530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (10))){
var inst_38455 = (state_38483[(2)]);
var state_38483__$1 = state_38483;
var statearr_38506_38531 = state_38483__$1;
(statearr_38506_38531[(2)] = inst_38455);

(statearr_38506_38531[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38484 === (8))){
var state_38483__$1 = state_38483;
var statearr_38507_38532 = state_38483__$1;
(statearr_38507_38532[(2)] = true);

(statearr_38507_38532[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____0 = (function (){
var statearr_38511 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38511[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__);

(statearr_38511[(1)] = (1));

return statearr_38511;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____1 = (function (state_38483){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_38483);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e38512){if((e38512 instanceof Object)){
var ex__19144__auto__ = e38512;
var statearr_38513_38533 = state_38483;
(statearr_38513_38533[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38483);

return cljs.core.cst$kw$recur;
} else {
throw e38512;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__38534 = state_38483;
state_38483 = G__38534;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__ = function(state_38483){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____1.call(this,state_38483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_38514 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_38514[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_38514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels","include_reviews"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_,cljs.core.cst$kw$include_DASH_reviews_QMARK_], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38542 = arguments.length;
var i__7652__auto___38543 = (0);
while(true){
if((i__7652__auto___38543 < len__7651__auto___38542)){
args__7658__auto__.push((arguments[i__7652__auto___38543]));

var G__38544 = (i__7652__auto___38543 + (1));
i__7652__auto___38543 = G__38544;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__38538){
var vec__38539 = p__38538;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38539,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq38535){
var G__38536 = cljs.core.first(seq38535);
var seq38535__$1 = cljs.core.next(seq38535);
var G__38537 = cljs.core.first(seq38535__$1);
var seq38535__$2 = cljs.core.next(seq38535__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__38536,G__38537,seq38535__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38594 = arguments.length;
var i__7652__auto___38595 = (0);
while(true){
if((i__7652__auto___38595 < len__7651__auto___38594)){
args__7658__auto__.push((arguments[i__7652__auto___38595]));

var G__38596 = (i__7652__auto___38595 + (1));
i__7652__auto___38595 = G__38596;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__38547){
var vec__38548 = p__38547;
var map__38551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38548,(0),null);
var map__38551__$1 = ((((!((map__38551 == null)))?((((map__38551.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38551.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38551):map__38551);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38551__$1,cljs.core.cst$kw$on_DASH_done);
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_38574){
var state_val_38575 = (state_38574[(1)]);
if((state_val_38575 === (1))){
var inst_38553 = (state_38574[(7)]);
var inst_38555 = (state_38574[(8)]);
var inst_38553__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_38554 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_38555__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_38554,dataset_id,inst_38553__$1], 0));
var inst_38556 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_38555__$1);
var state_38574__$1 = (function (){var statearr_38576 = state_38574;
(statearr_38576[(7)] = inst_38553__$1);

(statearr_38576[(8)] = inst_38555__$1);

return statearr_38576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38574__$1,(2),inst_38556);
} else {
if((state_val_38575 === (2))){
var inst_38553 = (state_38574[(7)]);
var inst_38555 = (state_38574[(8)]);
var inst_38558 = (state_38574[(9)]);
var inst_38558__$1 = (state_38574[(2)]);
var inst_38559 = (function (){var export_suffix = inst_38553;
var export_url = inst_38555;
var response = inst_38558__$1;
return ((function (export_suffix,export_url,response,inst_38553,inst_38555,inst_38558,inst_38558__$1,state_val_38575,c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_38553,inst_38555,inst_38558,inst_38558__$1,state_val_38575,c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_38574__$1 = (function (){var statearr_38577 = state_38574;
(statearr_38577[(9)] = inst_38558__$1);

(statearr_38577[(10)] = inst_38559);

return statearr_38577;
})();
if(cljs.core.truth_(on_done)){
var statearr_38578_38597 = state_38574__$1;
(statearr_38578_38597[(1)] = (3));

} else {
var statearr_38579_38598 = state_38574__$1;
(statearr_38579_38598[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (3))){
var inst_38558 = (state_38574[(9)]);
var inst_38561 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_38558) : on_done.call(null,inst_38558));
var state_38574__$1 = state_38574;
var statearr_38580_38599 = state_38574__$1;
(statearr_38580_38599[(2)] = inst_38561);

(statearr_38580_38599[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (4))){
var state_38574__$1 = state_38574;
var statearr_38581_38600 = state_38574__$1;
(statearr_38581_38600[(2)] = null);

(statearr_38581_38600[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (5))){
var inst_38564 = (state_38574[(2)]);
var inst_38565 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_38574__$1 = (function (){var statearr_38582 = state_38574;
(statearr_38582[(11)] = inst_38564);

(statearr_38582[(12)] = inst_38565);

return statearr_38582;
})();
if(cljs.core.truth_(on_done)){
var statearr_38583_38601 = state_38574__$1;
(statearr_38583_38601[(1)] = (6));

} else {
var statearr_38584_38602 = state_38574__$1;
(statearr_38584_38602[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (6))){
var state_38574__$1 = state_38574;
var statearr_38585_38603 = state_38574__$1;
(statearr_38585_38603[(2)] = on_job_id);

(statearr_38585_38603[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (7))){
var inst_38559 = (state_38574[(10)]);
var state_38574__$1 = state_38574;
var statearr_38586_38604 = state_38574__$1;
(statearr_38586_38604[(2)] = inst_38559);

(statearr_38586_38604[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (8))){
var inst_38558 = (state_38574[(9)]);
var inst_38565 = (state_38574[(12)]);
var inst_38569 = (state_38574[(2)]);
var inst_38570 = [on_error,inst_38569,on_export_url];
var inst_38571 = cljs.core.PersistentHashMap.fromArrays(inst_38565,inst_38570);
var inst_38572 = milia.api.async_export.handle_response(inst_38558,inst_38571);
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38574__$1,inst_38572);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19140__auto__,c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19141__auto__ = null;
var milia$api$async_export$state_machine__19141__auto____0 = (function (){
var statearr_38590 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38590[(0)] = milia$api$async_export$state_machine__19141__auto__);

(statearr_38590[(1)] = (1));

return statearr_38590;
});
var milia$api$async_export$state_machine__19141__auto____1 = (function (state_38574){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_38574);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e38591){if((e38591 instanceof Object)){
var ex__19144__auto__ = e38591;
var statearr_38592_38605 = state_38574;
(statearr_38592_38605[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38574);

return cljs.core.cst$kw$recur;
} else {
throw e38591;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__38606 = state_38574;
state_38574 = G__38606;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19141__auto__ = function(state_38574){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19141__auto____1.call(this,state_38574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19141__auto____0;
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19141__auto____1;
return milia$api$async_export$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19254__auto__ = (function (){var statearr_38593 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_38593[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_38593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,vec__38548,map__38551,map__38551__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19252__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq38545){
var G__38546 = cljs.core.first(seq38545);
var seq38545__$1 = cljs.core.next(seq38545);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38546,seq38545__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__38607_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__38607_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38632 = arguments.length;
var i__7652__auto___38633 = (0);
while(true){
if((i__7652__auto___38633 < len__7651__auto___38632)){
args__7658__auto__.push((arguments[i__7652__auto___38633]));

var G__38634 = (i__7652__auto___38633 + (1));
i__7652__auto___38633 = G__38634;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_38623){
var state_val_38624 = (state_38623[(1)]);
if((state_val_38624 === (1))){
var inst_38612 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_38623__$1 = state_38623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38623__$1,(2),inst_38612);
} else {
if((state_val_38624 === (2))){
var inst_38614 = (state_38623[(2)]);
var inst_38615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38616 = [http_method,inst_38614];
var inst_38617 = (new cljs.core.PersistentVector(null,2,(5),inst_38615,inst_38616,null));
var inst_38618 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38617,args);
var inst_38619 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_38618);
var state_38623__$1 = state_38623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38623__$1,(3),inst_38619);
} else {
if((state_val_38624 === (3))){
var inst_38621 = (state_38623[(2)]);
var state_38623__$1 = state_38623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38623__$1,inst_38621);
} else {
return null;
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var milia$api$async_export$state_machine__19141__auto__ = null;
var milia$api$async_export$state_machine__19141__auto____0 = (function (){
var statearr_38628 = [null,null,null,null,null,null,null];
(statearr_38628[(0)] = milia$api$async_export$state_machine__19141__auto__);

(statearr_38628[(1)] = (1));

return statearr_38628;
});
var milia$api$async_export$state_machine__19141__auto____1 = (function (state_38623){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_38623);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e38629){if((e38629 instanceof Object)){
var ex__19144__auto__ = e38629;
var statearr_38630_38635 = state_38623;
(statearr_38630_38635[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38623);

return cljs.core.cst$kw$recur;
} else {
throw e38629;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__38636 = state_38623;
state_38623 = G__38636;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19141__auto__ = function(state_38623){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19141__auto____1.call(this,state_38623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19141__auto____0;
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19141__auto____1;
return milia$api$async_export$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_38631 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_38631[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_38631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq38608){
var G__38609 = cljs.core.first(seq38608);
var seq38608__$1 = cljs.core.next(seq38608);
var G__38610 = cljs.core.first(seq38608__$1);
var seq38608__$2 = cljs.core.next(seq38608__$1);
var G__38611 = cljs.core.first(seq38608__$2);
var seq38608__$3 = cljs.core.next(seq38608__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__38609,G__38610,G__38611,seq38608__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export.json?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
