// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32651 = arguments.length;
var i__7652__auto___32652 = (0);
while(true){
if((i__7652__auto___32652 < len__7651__auto___32651)){
args__7658__auto__.push((arguments[i__7652__auto___32652]));

var G__32653 = (i__7652__auto___32652 + (1));
i__7652__auto___32652 = G__32653;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__32564){
var map__32565 = p__32564;
var map__32565__$1 = ((((!((map__32565 == null)))?((((map__32565.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32565.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32565):map__32565);
var options = map__32565__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32565__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32565__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,map__32565,map__32565__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,map__32565,map__32565__$1,options,max_retries,retry_for_statuses){
return (function (state_32616){
var state_val_32617 = (state_32616[(1)]);
if((state_val_32617 === (7))){
var inst_32590 = (state_32616[(2)]);
var state_32616__$1 = state_32616;
if(cljs.core.truth_(inst_32590)){
var statearr_32618_32654 = state_32616__$1;
(statearr_32618_32654[(1)] = (11));

} else {
var statearr_32619_32655 = state_32616__$1;
(statearr_32619_32655[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (20))){
var inst_32568 = (state_32616[(7)]);
var inst_32567 = (state_32616[(8)]);
var inst_32606 = (state_32616[(2)]);
var inst_32607 = (inst_32567 * (2));
var inst_32608 = (inst_32568 + (1));
var inst_32567__$1 = inst_32607;
var inst_32568__$1 = inst_32608;
var state_32616__$1 = (function (){var statearr_32620 = state_32616;
(statearr_32620[(7)] = inst_32568__$1);

(statearr_32620[(9)] = inst_32606);

(statearr_32620[(8)] = inst_32567__$1);

return statearr_32620;
})();
var statearr_32621_32656 = state_32616__$1;
(statearr_32621_32656[(2)] = null);

(statearr_32621_32656[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (1))){
var inst_32567 = milia.utils.retry.initial_polling_interval;
var inst_32568 = (0);
var state_32616__$1 = (function (){var statearr_32622 = state_32616;
(statearr_32622[(7)] = inst_32568);

(statearr_32622[(8)] = inst_32567);

return statearr_32622;
})();
var statearr_32623_32657 = state_32616__$1;
(statearr_32623_32657[(2)] = null);

(statearr_32623_32657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (4))){
var inst_32574 = (state_32616[(10)]);
var inst_32574__$1 = (state_32616[(2)]);
var inst_32576 = (inst_32574__$1 == null);
var inst_32577 = cljs.core.not(inst_32576);
var state_32616__$1 = (function (){var statearr_32624 = state_32616;
(statearr_32624[(10)] = inst_32574__$1);

return statearr_32624;
})();
if(inst_32577){
var statearr_32625_32658 = state_32616__$1;
(statearr_32625_32658[(1)] = (5));

} else {
var statearr_32626_32659 = state_32616__$1;
(statearr_32626_32659[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (15))){
var inst_32597 = (state_32616[(11)]);
var state_32616__$1 = state_32616;
var statearr_32627_32660 = state_32616__$1;
(statearr_32627_32660[(2)] = inst_32597);

(statearr_32627_32660[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (13))){
var inst_32597 = (state_32616[(11)]);
var inst_32595 = (state_32616[(12)]);
var inst_32595__$1 = (state_32616[(2)]);
var inst_32596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32595__$1,cljs.core.cst$kw$status);
var inst_32597__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_32596);
var state_32616__$1 = (function (){var statearr_32628 = state_32616;
(statearr_32628[(11)] = inst_32597__$1);

(statearr_32628[(12)] = inst_32595__$1);

return statearr_32628;
})();
if(cljs.core.truth_(inst_32597__$1)){
var statearr_32629_32661 = state_32616__$1;
(statearr_32629_32661[(1)] = (14));

} else {
var statearr_32630_32662 = state_32616__$1;
(statearr_32630_32662[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (6))){
var state_32616__$1 = state_32616;
var statearr_32631_32663 = state_32616__$1;
(statearr_32631_32663[(2)] = false);

(statearr_32631_32663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (17))){
var inst_32567 = (state_32616[(8)]);
var inst_32604 = cljs.core.async.timeout(inst_32567);
var state_32616__$1 = state_32616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32616__$1,(20),inst_32604);
} else {
if((state_val_32617 === (3))){
var inst_32614 = (state_32616[(2)]);
var state_32616__$1 = state_32616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32616__$1,inst_32614);
} else {
if((state_val_32617 === (12))){
var inst_32574 = (state_32616[(10)]);
var state_32616__$1 = state_32616;
var statearr_32632_32664 = state_32616__$1;
(statearr_32632_32664[(2)] = inst_32574);

(statearr_32632_32664[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (2))){
var inst_32571 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_32572 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_32571], 0));
var state_32616__$1 = state_32616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32616__$1,(4),inst_32572);
} else {
if((state_val_32617 === (19))){
var inst_32612 = (state_32616[(2)]);
var state_32616__$1 = state_32616;
var statearr_32633_32665 = state_32616__$1;
(statearr_32633_32665[(2)] = inst_32612);

(statearr_32633_32665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (11))){
var inst_32574 = (state_32616[(10)]);
var inst_32592 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32574);
var state_32616__$1 = state_32616;
var statearr_32634_32666 = state_32616__$1;
(statearr_32634_32666[(2)] = inst_32592);

(statearr_32634_32666[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (9))){
var state_32616__$1 = state_32616;
var statearr_32635_32667 = state_32616__$1;
(statearr_32635_32667[(2)] = false);

(statearr_32635_32667[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (5))){
var inst_32574 = (state_32616[(10)]);
var inst_32579 = inst_32574.cljs$lang$protocol_mask$partition0$;
var inst_32580 = (inst_32579 & (64));
var inst_32581 = inst_32574.cljs$core$ISeq$;
var inst_32582 = (cljs.core.PROTOCOL_SENTINEL === inst_32581);
var inst_32583 = (inst_32580) || (inst_32582);
var state_32616__$1 = state_32616;
if(cljs.core.truth_(inst_32583)){
var statearr_32636_32668 = state_32616__$1;
(statearr_32636_32668[(1)] = (8));

} else {
var statearr_32637_32669 = state_32616__$1;
(statearr_32637_32669[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (14))){
var inst_32568 = (state_32616[(7)]);
var inst_32599 = (inst_32568 < max_retries);
var state_32616__$1 = state_32616;
var statearr_32638_32670 = state_32616__$1;
(statearr_32638_32670[(2)] = inst_32599);

(statearr_32638_32670[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (16))){
var inst_32602 = (state_32616[(2)]);
var state_32616__$1 = state_32616;
if(cljs.core.truth_(inst_32602)){
var statearr_32639_32671 = state_32616__$1;
(statearr_32639_32671[(1)] = (17));

} else {
var statearr_32640_32672 = state_32616__$1;
(statearr_32640_32672[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (10))){
var inst_32587 = (state_32616[(2)]);
var state_32616__$1 = state_32616;
var statearr_32641_32673 = state_32616__$1;
(statearr_32641_32673[(2)] = inst_32587);

(statearr_32641_32673[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (18))){
var inst_32595 = (state_32616[(12)]);
var state_32616__$1 = state_32616;
var statearr_32642_32674 = state_32616__$1;
(statearr_32642_32674[(2)] = inst_32595);

(statearr_32642_32674[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32617 === (8))){
var state_32616__$1 = state_32616;
var statearr_32643_32675 = state_32616__$1;
(statearr_32643_32675[(2)] = true);

(statearr_32643_32675[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__,map__32565,map__32565__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19140__auto__,c__19252__auto__,map__32565,map__32565__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19141__auto__ = null;
var milia$utils$retry$state_machine__19141__auto____0 = (function (){
var statearr_32647 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32647[(0)] = milia$utils$retry$state_machine__19141__auto__);

(statearr_32647[(1)] = (1));

return statearr_32647;
});
var milia$utils$retry$state_machine__19141__auto____1 = (function (state_32616){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_32616);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e32648){if((e32648 instanceof Object)){
var ex__19144__auto__ = e32648;
var statearr_32649_32676 = state_32616;
(statearr_32649_32676[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32616);

return cljs.core.cst$kw$recur;
} else {
throw e32648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__32677 = state_32616;
state_32616 = G__32677;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19141__auto__ = function(state_32616){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19141__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19141__auto____1.call(this,state_32616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19141__auto____0;
milia$utils$retry$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19141__auto____1;
return milia$utils$retry$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,map__32565,map__32565__$1,options,max_retries,retry_for_statuses))
})();
var state__19254__auto__ = (function (){var statearr_32650 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_32650[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_32650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,map__32565,map__32565__$1,options,max_retries,retry_for_statuses))
);

return c__19252__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq32561){
var G__32562 = cljs.core.first(seq32561);
var seq32561__$1 = cljs.core.next(seq32561);
var G__32563 = cljs.core.first(seq32561__$1);
var seq32561__$2 = cljs.core.next(seq32561__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__32562,G__32563,seq32561__$2);
});

