// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32824 = arguments.length;
var i__7652__auto___32825 = (0);
while(true){
if((i__7652__auto___32825 < len__7651__auto___32824)){
args__7658__auto__.push((arguments[i__7652__auto___32825]));

var G__32826 = (i__7652__auto___32825 + (1));
i__7652__auto___32825 = G__32826;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__32820){
var vec__32821 = p__32820;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32821,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices.json"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq32816){
var G__32817 = cljs.core.first(seq32816);
var seq32816__$1 = cljs.core.next(seq32816);
var G__32818 = cljs.core.first(seq32816__$1);
var seq32816__$2 = cljs.core.next(seq32816__$1);
var G__32819 = cljs.core.first(seq32816__$2);
var seq32816__$3 = cljs.core.next(seq32816__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__32817,G__32818,G__32819,seq32816__$3);
});

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32836 = arguments.length;
var i__7652__auto___32837 = (0);
while(true){
if((i__7652__auto___32837 < len__7651__auto___32836)){
args__7658__auto__.push((arguments[i__7652__auto___32837]));

var G__32838 = (i__7652__auto___32837 + (1));
i__7652__auto___32837 = G__32838;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((4) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7659__auto__);
});

milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__32832){
var vec__32833 = p__32832;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32833,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",[cljs.core.str(id),cljs.core.str(".json")].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4);

milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq32827){
var G__32828 = cljs.core.first(seq32827);
var seq32827__$1 = cljs.core.next(seq32827);
var G__32829 = cljs.core.first(seq32827__$1);
var seq32827__$2 = cljs.core.next(seq32827__$1);
var G__32830 = cljs.core.first(seq32827__$2);
var seq32827__$3 = cljs.core.next(seq32827__$2);
var G__32831 = cljs.core.first(seq32827__$3);
var seq32827__$4 = cljs.core.next(seq32827__$3);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic(G__32828,G__32829,G__32830,G__32831,seq32827__$4);
});

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",[cljs.core.str(id),cljs.core.str(".json")].join('')], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices.json"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32844 = arguments.length;
var i__7652__auto___32845 = (0);
while(true){
if((i__7652__auto___32845 < len__7651__auto___32844)){
args__7658__auto__.push((arguments[i__7652__auto___32845]));

var G__32846 = (i__7652__auto___32845 + (1));
i__7652__auto___32845 = G__32846;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__32841){
var map__32842 = p__32841;
var map__32842__$1 = ((((!((map__32842 == null)))?((((map__32842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32842.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32842):map__32842);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32842__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",[cljs.core.str(id),cljs.core.str(".json")].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq32839){
var G__32840 = cljs.core.first(seq32839);
var seq32839__$1 = cljs.core.next(seq32839);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic(G__32840,seq32839__$1);
});

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32852 = arguments.length;
var i__7652__auto___32853 = (0);
while(true){
if((i__7652__auto___32853 < len__7651__auto___32852)){
args__7658__auto__.push((arguments[i__7652__auto___32853]));

var G__32854 = (i__7652__auto___32853 + (1));
i__7652__auto___32853 = G__32854;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__32849){
var map__32850 = p__32849;
var map__32850__$1 = ((((!((map__32850 == null)))?((((map__32850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32850.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32850):map__32850);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32850__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("restservices.json?xform="),cljs.core.str(formid)].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq32847){
var G__32848 = cljs.core.first(seq32847);
var seq32847__$1 = cljs.core.next(seq32847);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic(G__32848,seq32847__$1);
});

