// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.open_data');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create an open-data object.
 * `object-id` is the numeric id of the object which can be an xform or a
 * dataview.
 * `name` is the name of the open-data object. It's advisable to use either
 * the id_string or title for an xform or title for a dataview.
 * `data-type` is class name in onadata and should either be
 * 'xform' or 'dataview'.
 */
milia.api.open_data.create = (function milia$api$open_data$create(object_id,name,data_type){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["open-data.json"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$object_id,object_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$data_type,data_type], null)], null)], 0));
});
/**
 * Updates an open-data object.
 */
milia.api.open_data.update = (function milia$api$open_data$update(object_id,data_type,uuid){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["open-data",[cljs.core.str(uuid),cljs.core.str(".json")].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$object_id,object_id,cljs.core.cst$kw$data_type,data_type], null)], null)], 0));
});
/**
 * Delete an open-data object
 */
milia.api.open_data.delete$ = (function milia$api$open_data$delete(uuid){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["open-data",[cljs.core.str(uuid),cljs.core.str(".json")].join('')], 0)));
});
/**
 * Get uuid of an open-data object.
 */
milia.api.open_data.get_open_data_uuid = (function milia$api$open_data$get_open_data_uuid(object_id,data_type){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("open-data/uuid.json?object_id="),cljs.core.str(object_id),cljs.core.str("&data_type="),cljs.core.str(data_type)].join('')], 0)));
});
