// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__32306 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__32306,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__32307 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32307) : cljs_hash.md5.md5.call(null,G__32307));
})());
} else {
return G__32306;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32312 = arguments.length;
var i__7652__auto___32313 = (0);
while(true){
if((i__7652__auto___32313 < len__7651__auto___32312)){
args__7658__auto__.push((arguments[i__7652__auto___32313]));

var G__32314 = (i__7652__auto___32313 + (1));
i__7652__auto___32313 = G__32314;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__32309){
var map__32310 = p__32309;
var map__32310__$1 = ((((!((map__32310 == null)))?((((map__32310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32310.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32310):map__32310);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32310__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32310__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32310__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32310__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq32308){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32308));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32324 = arguments.length;
var i__7652__auto___32325 = (0);
while(true){
if((i__7652__auto___32325 < len__7651__auto___32324)){
args__7658__auto__.push((arguments[i__7652__auto___32325]));

var G__32326 = (i__7652__auto___32325 + (1));
i__7652__auto___32325 = G__32326;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__32317){
var vec__32318 = p__32317;
var map__32321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32318,(0),null);
var map__32321__$1 = ((((!((map__32321 == null)))?((((map__32321.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32321.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32321):map__32321);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32321__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e32323){if((e32323 instanceof Error)){
var _ = e32323;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e32323;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq32315){
var G__32316 = cljs.core.first(seq32315);
var seq32315__$1 = cljs.core.next(seq32315);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__32316,seq32315__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__32333_32339 = io_obj;
var G__32334_32340 = goog.net.EventType.SUCCESS;
var G__32335_32341 = ((function (G__32333_32339,G__32334_32340,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__32333_32339,G__32334_32340,io_obj))
;
goog.events.listen(G__32333_32339,G__32334_32340,G__32335_32341);

var G__32336_32342 = io_obj;
var G__32337_32343 = goog.net.EventType.ERROR;
var G__32338_32344 = ((function (G__32336_32342,G__32337_32343,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__32336_32342,G__32337_32343,io_obj))
;
goog.events.listen(G__32336_32342,G__32337_32343,G__32338_32344);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://developers.google.com/closure/library/docs/xhrio
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32364 = arguments.length;
var i__7652__auto___32365 = (0);
while(true){
if((i__7652__auto___32365 < len__7651__auto___32364)){
args__7658__auto__.push((arguments[i__7652__auto___32365]));

var G__32366 = (i__7652__auto___32365 + (1));
i__7652__auto___32365 = G__32366;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__32349){
var map__32350 = p__32349;
var map__32350__$1 = ((((!((map__32350 == null)))?((((map__32350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32350.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32350):map__32350);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32350__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32350__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32350__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__32352_32367 = io_obj;
var G__32353_32368 = goog.net.EventType.COMPLETE;
var G__32354_32369 = ((function (G__32352_32367,G__32353_32368,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0))));
});})(G__32352_32367,G__32353_32368,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__32352_32367,G__32353_32368,G__32354_32369);

var G__32355_32370 = io_obj;
var G__32356_32371 = goog.net.EventType.SUCCESS;
var G__32357_32372 = ((function (G__32355_32370,G__32356_32371,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__32355_32370,G__32356_32371,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__32355_32370,G__32356_32371,G__32357_32372);

var G__32358_32373 = io_obj;
var G__32359_32374 = goog.net.EventType.ERROR;
var G__32360_32375 = ((function (G__32358_32373,G__32359_32374,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__32358_32373,G__32359_32374,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__32358_32373,G__32359_32374,G__32360_32375);

var G__32361_32376 = io_obj;
var G__32362_32377 = goog.net.EventType.PROGRESS;
var G__32363_32378 = ((function (G__32361_32376,G__32362_32377,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_){
return (function (p1__32345_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__32345_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__32345_SHARP_.loaded,cljs.core.cst$kw$total,p1__32345_SHARP_.total], null)));
});})(G__32361_32376,G__32362_32377,io_obj,data,url,map__32350,map__32350__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__32361_32376,G__32362_32377,G__32363_32378);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq32346){
var G__32347 = cljs.core.first(seq32346);
var seq32346__$1 = cljs.core.next(seq32346);
var G__32348 = cljs.core.first(seq32346__$1);
var seq32346__$2 = cljs.core.next(seq32346__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__32347,G__32348,seq32346__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32443 = arguments.length;
var i__7652__auto___32444 = (0);
while(true){
if((i__7652__auto___32444 < len__7651__auto___32443)){
args__7658__auto__.push((arguments[i__7652__auto___32444]));

var G__32445 = (i__7652__auto___32444 + (1));
i__7652__auto___32444 = G__32445;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19252__auto___32446 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___32446,response_channel){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___32446,response_channel){
return (function (state_32416){
var state_val_32417 = (state_32416[(1)]);
if((state_val_32417 === (7))){
var state_32416__$1 = state_32416;
var statearr_32418_32447 = state_32416__$1;
(statearr_32418_32447[(2)] = false);

(statearr_32418_32447[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (1))){
var inst_32382 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_32416__$1 = state_32416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32416__$1,(2),inst_32382);
} else {
if((state_val_32417 === (4))){
var state_32416__$1 = state_32416;
var statearr_32419_32448 = state_32416__$1;
(statearr_32419_32448[(2)] = false);

(statearr_32419_32448[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (13))){
var inst_32405 = (state_32416[(7)]);
var inst_32412 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_32405);
var state_32416__$1 = state_32416;
var statearr_32420_32449 = state_32416__$1;
(statearr_32420_32449[(2)] = inst_32412);

(statearr_32420_32449[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (6))){
var state_32416__$1 = state_32416;
var statearr_32421_32450 = state_32416__$1;
(statearr_32421_32450[(2)] = true);

(statearr_32421_32450[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (3))){
var inst_32384 = (state_32416[(8)]);
var inst_32389 = inst_32384.cljs$lang$protocol_mask$partition0$;
var inst_32390 = (inst_32389 & (64));
var inst_32391 = inst_32384.cljs$core$ISeq$;
var inst_32392 = (cljs.core.PROTOCOL_SENTINEL === inst_32391);
var inst_32393 = (inst_32390) || (inst_32392);
var state_32416__$1 = state_32416;
if(cljs.core.truth_(inst_32393)){
var statearr_32422_32451 = state_32416__$1;
(statearr_32422_32451[(1)] = (6));

} else {
var statearr_32423_32452 = state_32416__$1;
(statearr_32423_32452[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (12))){
var inst_32409 = window.location.href();
var inst_32410 = window.location = inst_32409;
var state_32416__$1 = state_32416;
var statearr_32424_32453 = state_32416__$1;
(statearr_32424_32453[(2)] = inst_32410);

(statearr_32424_32453[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (2))){
var inst_32384 = (state_32416[(8)]);
var inst_32384__$1 = (state_32416[(2)]);
var inst_32386 = (inst_32384__$1 == null);
var inst_32387 = cljs.core.not(inst_32386);
var state_32416__$1 = (function (){var statearr_32425 = state_32416;
(statearr_32425[(8)] = inst_32384__$1);

return statearr_32425;
})();
if(inst_32387){
var statearr_32426_32454 = state_32416__$1;
(statearr_32426_32454[(1)] = (3));

} else {
var statearr_32427_32455 = state_32416__$1;
(statearr_32427_32455[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (11))){
var inst_32405 = (state_32416[(7)]);
var inst_32405__$1 = (state_32416[(2)]);
var inst_32406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32405__$1,cljs.core.cst$kw$status);
var inst_32407 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32406,(401));
var state_32416__$1 = (function (){var statearr_32428 = state_32416;
(statearr_32428[(7)] = inst_32405__$1);

return statearr_32428;
})();
if(inst_32407){
var statearr_32429_32456 = state_32416__$1;
(statearr_32429_32456[(1)] = (12));

} else {
var statearr_32430_32457 = state_32416__$1;
(statearr_32430_32457[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (9))){
var inst_32384 = (state_32416[(8)]);
var inst_32402 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32384);
var state_32416__$1 = state_32416;
var statearr_32431_32458 = state_32416__$1;
(statearr_32431_32458[(2)] = inst_32402);

(statearr_32431_32458[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (5))){
var inst_32400 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
if(cljs.core.truth_(inst_32400)){
var statearr_32432_32459 = state_32416__$1;
(statearr_32432_32459[(1)] = (9));

} else {
var statearr_32433_32460 = state_32416__$1;
(statearr_32433_32460[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (14))){
var inst_32414 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32416__$1,inst_32414);
} else {
if((state_val_32417 === (10))){
var inst_32384 = (state_32416[(8)]);
var state_32416__$1 = state_32416;
var statearr_32434_32461 = state_32416__$1;
(statearr_32434_32461[(2)] = inst_32384);

(statearr_32434_32461[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (8))){
var inst_32397 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32435_32462 = state_32416__$1;
(statearr_32435_32462[(2)] = inst_32397);

(statearr_32435_32462[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto___32446,response_channel))
;
return ((function (switch__19140__auto__,c__19252__auto___32446,response_channel){
return (function() {
var milia$api$io$state_machine__19141__auto__ = null;
var milia$api$io$state_machine__19141__auto____0 = (function (){
var statearr_32439 = [null,null,null,null,null,null,null,null,null];
(statearr_32439[(0)] = milia$api$io$state_machine__19141__auto__);

(statearr_32439[(1)] = (1));

return statearr_32439;
});
var milia$api$io$state_machine__19141__auto____1 = (function (state_32416){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_32416);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e32440){if((e32440 instanceof Object)){
var ex__19144__auto__ = e32440;
var statearr_32441_32463 = state_32416;
(statearr_32441_32463[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32416);

return cljs.core.cst$kw$recur;
} else {
throw e32440;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__32464 = state_32416;
state_32416 = G__32464;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$io$state_machine__19141__auto__ = function(state_32416){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19141__auto____1.call(this,state_32416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19141__auto____0;
milia$api$io$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19141__auto____1;
return milia$api$io$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___32446,response_channel))
})();
var state__19254__auto__ = (function (){var statearr_32442 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_32442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___32446);

return statearr_32442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___32446,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq32379){
var G__32380 = cljs.core.first(seq32379);
var seq32379__$1 = cljs.core.next(seq32379);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__32380,seq32379__$1);
});

