// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33017 = arguments.length;
var i__7652__auto___33018 = (0);
while(true){
if((i__7652__auto___33018 < len__7651__auto___33017)){
args__7658__auto__.push((arguments[i__7652__auto___33018]));

var G__33019 = (i__7652__auto___33018 + (1));
i__7652__auto___33018 = G__33019;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq33016){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33016));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__33020,p__33021){
var map__33030 = p__33020;
var map__33030__$1 = ((((!((map__33030 == null)))?((((map__33030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33030.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33030):map__33030);
var response = map__33030__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33030__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33030__$1,cljs.core.cst$kw$body);
var map__33031 = p__33021;
var map__33031__$1 = ((((!((map__33031 == null)))?((((map__33031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33031.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33031):map__33031);
var callbacks = map__33031__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33031__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33031__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33031__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33031__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__33034 = body;
var map__33034__$1 = ((((!((map__33034 == null)))?((((map__33034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33034.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33034):map__33034);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33034__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33034__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33034__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__33034,map__33034__$1,export_url,job_status,job_id,map__33030,map__33030__$1,response,status,body,map__33031,map__33031__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__33034,map__33034__$1,export_url,job_status,job_id,map__33030,map__33030__$1,response,status,body,map__33031,map__33031__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__33036_33038 = error_detail;
var G__33037_33039 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__33036_33038,G__33037_33039) : on_error.call(null,G__33036_33038,G__33037_33039));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33090 = arguments.length;
var i__7652__auto___33091 = (0);
while(true){
if((i__7652__auto___33091 < len__7651__auto___33090)){
args__7658__auto__.push((arguments[i__7652__auto___33091]));

var G__33092 = (i__7652__auto___33091 + (1));
i__7652__auto___33091 = G__33092;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__33043){
var map__33044 = p__33043;
var map__33044__$1 = ((((!((map__33044 == null)))?((((map__33044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33044.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33044):map__33044);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33044__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33044__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33044__$1,cljs.core.cst$kw$data_DASH_type);
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type){
return (function (state_33072){
var state_val_33073 = (state_33072[(1)]);
if((state_val_33073 === (1))){
var inst_33046 = milia.api.async_export.initial_polling_interval;
var state_33072__$1 = (function (){var statearr_33074 = state_33072;
(statearr_33074[(7)] = inst_33046);

return statearr_33074;
})();
var statearr_33075_33093 = state_33072__$1;
(statearr_33075_33093[(2)] = null);

(statearr_33075_33093[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33073 === (2))){
var inst_33050 = (state_33072[(8)]);
var inst_33048 = (state_33072[(9)]);
var inst_33048__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_33049 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_33050__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_33049,dataset_id,inst_33048__$1], 0));
var inst_33051 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_33050__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_33072__$1 = (function (){var statearr_33076 = state_33072;
(statearr_33076[(8)] = inst_33050__$1);

(statearr_33076[(9)] = inst_33048__$1);

return statearr_33076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33072__$1,(4),inst_33051);
} else {
if((state_val_33073 === (3))){
var inst_33070 = (state_33072[(2)]);
var state_33072__$1 = state_33072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33072__$1,inst_33070);
} else {
if((state_val_33073 === (4))){
var inst_33050 = (state_33072[(8)]);
var inst_33046 = (state_33072[(7)]);
var inst_33048 = (state_33072[(9)]);
var inst_33053 = (state_33072[(2)]);
var inst_33054 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_33055 = (function (){var polling_interval = inst_33046;
var job_suffix = inst_33048;
var job_url = inst_33050;
var response = inst_33053;
return ((function (polling_interval,job_suffix,job_url,response,inst_33050,inst_33046,inst_33048,inst_33053,inst_33054,state_val_33073,c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_33050,inst_33046,inst_33048,inst_33053,inst_33054,state_val_33073,c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type))
})();
var inst_33056 = [inst_33055,on_error,on_export_url];
var inst_33057 = cljs.core.PersistentHashMap.fromArrays(inst_33054,inst_33056);
var inst_33058 = milia.api.async_export.handle_response(inst_33053,inst_33057);
var inst_33059 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_33058,cljs.core.cst$kw$stop);
var state_33072__$1 = state_33072;
if(inst_33059){
var statearr_33077_33094 = state_33072__$1;
(statearr_33077_33094[(1)] = (5));

} else {
var statearr_33078_33095 = state_33072__$1;
(statearr_33078_33095[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33073 === (5))){
var inst_33046 = (state_33072[(7)]);
var inst_33061 = cljs.core.async.timeout(inst_33046);
var state_33072__$1 = state_33072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33072__$1,(8),inst_33061);
} else {
if((state_val_33073 === (6))){
var state_33072__$1 = state_33072;
var statearr_33079_33096 = state_33072__$1;
(statearr_33079_33096[(2)] = null);

(statearr_33079_33096[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33073 === (7))){
var inst_33068 = (state_33072[(2)]);
var state_33072__$1 = state_33072;
var statearr_33080_33097 = state_33072__$1;
(statearr_33080_33097[(2)] = inst_33068);

(statearr_33080_33097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33073 === (8))){
var inst_33046 = (state_33072[(7)]);
var inst_33063 = (state_33072[(2)]);
var inst_33064 = (inst_33046 * (2));
var inst_33046__$1 = inst_33064;
var state_33072__$1 = (function (){var statearr_33081 = state_33072;
(statearr_33081[(7)] = inst_33046__$1);

(statearr_33081[(10)] = inst_33063);

return statearr_33081;
})();
var statearr_33082_33098 = state_33072__$1;
(statearr_33082_33098[(2)] = null);

(statearr_33082_33098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19140__auto__,c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19141__auto__ = null;
var milia$api$async_export$state_machine__19141__auto____0 = (function (){
var statearr_33086 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33086[(0)] = milia$api$async_export$state_machine__19141__auto__);

(statearr_33086[(1)] = (1));

return statearr_33086;
});
var milia$api$async_export$state_machine__19141__auto____1 = (function (state_33072){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_33072);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e33087){if((e33087 instanceof Object)){
var ex__19144__auto__ = e33087;
var statearr_33088_33099 = state_33072;
(statearr_33088_33099[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33072);

return cljs.core.cst$kw$recur;
} else {
throw e33087;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__33100 = state_33072;
state_33072 = G__33100;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19141__auto__ = function(state_33072){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19141__auto____1.call(this,state_33072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19141__auto____0;
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19141__auto____1;
return milia$api$async_export$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type))
})();
var state__19254__auto__ = (function (){var statearr_33089 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_33089[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_33089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,map__33044,map__33044__$1,on_error,on_export_url,data_type))
);

return c__19252__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq33040){
var G__33041 = cljs.core.first(seq33040);
var seq33040__$1 = cljs.core.next(seq33040);
var G__33042 = cljs.core.first(seq33040__$1);
var seq33040__$2 = cljs.core.next(seq33040__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33041,G__33042,seq33040__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_33230){
var state_val_33231 = (state_33230[(1)]);
if((state_val_33231 === (7))){
var inst_33205 = (state_33230[(2)]);
var state_33230__$1 = state_33230;
if(cljs.core.truth_(inst_33205)){
var statearr_33232_33262 = state_33230__$1;
(statearr_33232_33262[(1)] = (11));

} else {
var statearr_33233_33263 = state_33230__$1;
(statearr_33233_33263[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (1))){
var inst_33182 = milia.api.async_export.initial_polling_interval;
var state_33230__$1 = (function (){var statearr_33234 = state_33230;
(statearr_33234[(7)] = inst_33182);

return statearr_33234;
})();
var statearr_33235_33264 = state_33230__$1;
(statearr_33235_33264[(2)] = null);

(statearr_33235_33264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (4))){
var inst_33189 = (state_33230[(8)]);
var inst_33189__$1 = (state_33230[(2)]);
var inst_33191 = (inst_33189__$1 == null);
var inst_33192 = cljs.core.not(inst_33191);
var state_33230__$1 = (function (){var statearr_33236 = state_33230;
(statearr_33236[(8)] = inst_33189__$1);

return statearr_33236;
})();
if(inst_33192){
var statearr_33237_33265 = state_33230__$1;
(statearr_33237_33265[(1)] = (5));

} else {
var statearr_33238_33266 = state_33230__$1;
(statearr_33238_33266[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (15))){
var inst_33182 = (state_33230[(7)]);
var inst_33220 = cljs.core.async.timeout(inst_33182);
var state_33230__$1 = state_33230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33230__$1,(17),inst_33220);
} else {
if((state_val_33231 === (13))){
var inst_33186 = (state_33230[(9)]);
var inst_33212 = (state_33230[(10)]);
var inst_33182 = (state_33230[(7)]);
var inst_33210 = (state_33230[(2)]);
var inst_33211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33210,cljs.core.cst$kw$status);
var inst_33212__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33210,cljs.core.cst$kw$body);
var inst_33213 = (function (){var polling_interval = inst_33182;
var export_url = inst_33186;
var map__33184 = inst_33210;
var status = inst_33211;
var body = inst_33212__$1;
return ((function (polling_interval,export_url,map__33184,status,body,inst_33186,inst_33212,inst_33182,inst_33210,inst_33211,inst_33212__$1,state_val_33231,c__19252__auto__){
return (function (p1__33101_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__33101_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__33184,status,body,inst_33186,inst_33212,inst_33182,inst_33210,inst_33211,inst_33212__$1,state_val_33231,c__19252__auto__))
})();
var inst_33214 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_33213,inst_33212__$1);
var inst_33215 = cljs.core.vec(inst_33214);
var inst_33216 = cljs.core.empty_QMARK_(inst_33215);
var state_33230__$1 = (function (){var statearr_33239 = state_33230;
(statearr_33239[(10)] = inst_33212__$1);

return statearr_33239;
})();
if(inst_33216){
var statearr_33240_33267 = state_33230__$1;
(statearr_33240_33267[(1)] = (14));

} else {
var statearr_33241_33268 = state_33230__$1;
(statearr_33241_33268[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (6))){
var state_33230__$1 = state_33230;
var statearr_33242_33269 = state_33230__$1;
(statearr_33242_33269[(2)] = false);

(statearr_33242_33269[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (17))){
var inst_33182 = (state_33230[(7)]);
var inst_33222 = (state_33230[(2)]);
var inst_33223 = (inst_33182 * (2));
var inst_33182__$1 = inst_33223;
var state_33230__$1 = (function (){var statearr_33243 = state_33230;
(statearr_33243[(11)] = inst_33222);

(statearr_33243[(7)] = inst_33182__$1);

return statearr_33243;
})();
var statearr_33244_33270 = state_33230__$1;
(statearr_33244_33270[(2)] = null);

(statearr_33244_33270[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (3))){
var inst_33228 = (state_33230[(2)]);
var state_33230__$1 = state_33230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33230__$1,inst_33228);
} else {
if((state_val_33231 === (12))){
var inst_33189 = (state_33230[(8)]);
var state_33230__$1 = state_33230;
var statearr_33245_33271 = state_33230__$1;
(statearr_33245_33271[(2)] = inst_33189);

(statearr_33245_33271[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (2))){
var inst_33186 = (state_33230[(9)]);
var inst_33185 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export.json?xform=",dataset_id,"&"], 0));
var inst_33186__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_33185], 0));
var inst_33187 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_33186__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_33230__$1 = (function (){var statearr_33246 = state_33230;
(statearr_33246[(9)] = inst_33186__$1);

return statearr_33246;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33230__$1,(4),inst_33187);
} else {
if((state_val_33231 === (11))){
var inst_33189 = (state_33230[(8)]);
var inst_33207 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33189);
var state_33230__$1 = state_33230;
var statearr_33247_33272 = state_33230__$1;
(statearr_33247_33272[(2)] = inst_33207);

(statearr_33247_33272[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (9))){
var state_33230__$1 = state_33230;
var statearr_33248_33273 = state_33230__$1;
(statearr_33248_33273[(2)] = false);

(statearr_33248_33273[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (5))){
var inst_33189 = (state_33230[(8)]);
var inst_33194 = inst_33189.cljs$lang$protocol_mask$partition0$;
var inst_33195 = (inst_33194 & (64));
var inst_33196 = inst_33189.cljs$core$ISeq$;
var inst_33197 = (cljs.core.PROTOCOL_SENTINEL === inst_33196);
var inst_33198 = (inst_33195) || (inst_33197);
var state_33230__$1 = state_33230;
if(cljs.core.truth_(inst_33198)){
var statearr_33249_33274 = state_33230__$1;
(statearr_33249_33274[(1)] = (8));

} else {
var statearr_33250_33275 = state_33230__$1;
(statearr_33250_33275[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (14))){
var inst_33212 = (state_33230[(10)]);
var inst_33218 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_33212) : callback.call(null,inst_33212));
var state_33230__$1 = state_33230;
var statearr_33251_33276 = state_33230__$1;
(statearr_33251_33276[(2)] = inst_33218);

(statearr_33251_33276[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (16))){
var inst_33226 = (state_33230[(2)]);
var state_33230__$1 = state_33230;
var statearr_33252_33277 = state_33230__$1;
(statearr_33252_33277[(2)] = inst_33226);

(statearr_33252_33277[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (10))){
var inst_33202 = (state_33230[(2)]);
var state_33230__$1 = state_33230;
var statearr_33253_33278 = state_33230__$1;
(statearr_33253_33278[(2)] = inst_33202);

(statearr_33253_33278[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33231 === (8))){
var state_33230__$1 = state_33230;
var statearr_33254_33279 = state_33230__$1;
(statearr_33254_33279[(2)] = true);

(statearr_33254_33279[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____0 = (function (){
var statearr_33258 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33258[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__);

(statearr_33258[(1)] = (1));

return statearr_33258;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____1 = (function (state_33230){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_33230);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e33259){if((e33259 instanceof Object)){
var ex__19144__auto__ = e33259;
var statearr_33260_33280 = state_33230;
(statearr_33260_33280[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33230);

return cljs.core.cst$kw$recur;
} else {
throw e33259;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__33281 = state_33230;
state_33230 = G__33281;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__ = function(state_33230){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____1.call(this,state_33230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_33261 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_33261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_33261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels","include_reviews"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_,cljs.core.cst$kw$include_DASH_reviews_QMARK_], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33289 = arguments.length;
var i__7652__auto___33290 = (0);
while(true){
if((i__7652__auto___33290 < len__7651__auto___33289)){
args__7658__auto__.push((arguments[i__7652__auto___33290]));

var G__33291 = (i__7652__auto___33290 + (1));
i__7652__auto___33290 = G__33291;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__33285){
var vec__33286 = p__33285;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33286,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq33282){
var G__33283 = cljs.core.first(seq33282);
var seq33282__$1 = cljs.core.next(seq33282);
var G__33284 = cljs.core.first(seq33282__$1);
var seq33282__$2 = cljs.core.next(seq33282__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__33283,G__33284,seq33282__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33341 = arguments.length;
var i__7652__auto___33342 = (0);
while(true){
if((i__7652__auto___33342 < len__7651__auto___33341)){
args__7658__auto__.push((arguments[i__7652__auto___33342]));

var G__33343 = (i__7652__auto___33342 + (1));
i__7652__auto___33342 = G__33343;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__33294){
var vec__33295 = p__33294;
var map__33298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33295,(0),null);
var map__33298__$1 = ((((!((map__33298 == null)))?((((map__33298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33298.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33298):map__33298);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33298__$1,cljs.core.cst$kw$on_DASH_done);
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_33321){
var state_val_33322 = (state_33321[(1)]);
if((state_val_33322 === (1))){
var inst_33302 = (state_33321[(7)]);
var inst_33300 = (state_33321[(8)]);
var inst_33300__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_33301 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_33302__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_33301,dataset_id,inst_33300__$1], 0));
var inst_33303 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_33302__$1);
var state_33321__$1 = (function (){var statearr_33323 = state_33321;
(statearr_33323[(7)] = inst_33302__$1);

(statearr_33323[(8)] = inst_33300__$1);

return statearr_33323;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(2),inst_33303);
} else {
if((state_val_33322 === (2))){
var inst_33302 = (state_33321[(7)]);
var inst_33305 = (state_33321[(9)]);
var inst_33300 = (state_33321[(8)]);
var inst_33305__$1 = (state_33321[(2)]);
var inst_33306 = (function (){var export_suffix = inst_33300;
var export_url = inst_33302;
var response = inst_33305__$1;
return ((function (export_suffix,export_url,response,inst_33302,inst_33305,inst_33300,inst_33305__$1,state_val_33322,c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_33302,inst_33305,inst_33300,inst_33305__$1,state_val_33322,c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_33321__$1 = (function (){var statearr_33324 = state_33321;
(statearr_33324[(10)] = inst_33306);

(statearr_33324[(9)] = inst_33305__$1);

return statearr_33324;
})();
if(cljs.core.truth_(on_done)){
var statearr_33325_33344 = state_33321__$1;
(statearr_33325_33344[(1)] = (3));

} else {
var statearr_33326_33345 = state_33321__$1;
(statearr_33326_33345[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (3))){
var inst_33305 = (state_33321[(9)]);
var inst_33308 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_33305) : on_done.call(null,inst_33305));
var state_33321__$1 = state_33321;
var statearr_33327_33346 = state_33321__$1;
(statearr_33327_33346[(2)] = inst_33308);

(statearr_33327_33346[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (4))){
var state_33321__$1 = state_33321;
var statearr_33328_33347 = state_33321__$1;
(statearr_33328_33347[(2)] = null);

(statearr_33328_33347[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (5))){
var inst_33311 = (state_33321[(2)]);
var inst_33312 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_33321__$1 = (function (){var statearr_33329 = state_33321;
(statearr_33329[(11)] = inst_33312);

(statearr_33329[(12)] = inst_33311);

return statearr_33329;
})();
if(cljs.core.truth_(on_done)){
var statearr_33330_33348 = state_33321__$1;
(statearr_33330_33348[(1)] = (6));

} else {
var statearr_33331_33349 = state_33321__$1;
(statearr_33331_33349[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (6))){
var state_33321__$1 = state_33321;
var statearr_33332_33350 = state_33321__$1;
(statearr_33332_33350[(2)] = on_job_id);

(statearr_33332_33350[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (7))){
var inst_33306 = (state_33321[(10)]);
var state_33321__$1 = state_33321;
var statearr_33333_33351 = state_33321__$1;
(statearr_33333_33351[(2)] = inst_33306);

(statearr_33333_33351[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (8))){
var inst_33312 = (state_33321[(11)]);
var inst_33305 = (state_33321[(9)]);
var inst_33316 = (state_33321[(2)]);
var inst_33317 = [on_error,inst_33316,on_export_url];
var inst_33318 = cljs.core.PersistentHashMap.fromArrays(inst_33312,inst_33317);
var inst_33319 = milia.api.async_export.handle_response(inst_33305,inst_33318);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33321__$1,inst_33319);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19140__auto__,c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19141__auto__ = null;
var milia$api$async_export$state_machine__19141__auto____0 = (function (){
var statearr_33337 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33337[(0)] = milia$api$async_export$state_machine__19141__auto__);

(statearr_33337[(1)] = (1));

return statearr_33337;
});
var milia$api$async_export$state_machine__19141__auto____1 = (function (state_33321){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_33321);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e33338){if((e33338 instanceof Object)){
var ex__19144__auto__ = e33338;
var statearr_33339_33352 = state_33321;
(statearr_33339_33352[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33321);

return cljs.core.cst$kw$recur;
} else {
throw e33338;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__33353 = state_33321;
state_33321 = G__33353;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19141__auto__ = function(state_33321){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19141__auto____1.call(this,state_33321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19141__auto____0;
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19141__auto____1;
return milia$api$async_export$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19254__auto__ = (function (){var statearr_33340 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_33340[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_33340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__,vec__33295,map__33298,map__33298__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19252__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq33292){
var G__33293 = cljs.core.first(seq33292);
var seq33292__$1 = cljs.core.next(seq33292);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33293,seq33292__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__33354_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__33354_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33379 = arguments.length;
var i__7652__auto___33380 = (0);
while(true){
if((i__7652__auto___33380 < len__7651__auto___33379)){
args__7658__auto__.push((arguments[i__7652__auto___33380]));

var G__33381 = (i__7652__auto___33380 + (1));
i__7652__auto___33380 = G__33381;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19252__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto__){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto__){
return (function (state_33370){
var state_val_33371 = (state_33370[(1)]);
if((state_val_33371 === (1))){
var inst_33359 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_33370__$1 = state_33370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33370__$1,(2),inst_33359);
} else {
if((state_val_33371 === (2))){
var inst_33361 = (state_33370[(2)]);
var inst_33362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33363 = [http_method,inst_33361];
var inst_33364 = (new cljs.core.PersistentVector(null,2,(5),inst_33362,inst_33363,null));
var inst_33365 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_33364,args);
var inst_33366 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_33365);
var state_33370__$1 = state_33370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33370__$1,(3),inst_33366);
} else {
if((state_val_33371 === (3))){
var inst_33368 = (state_33370[(2)]);
var state_33370__$1 = state_33370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33370__$1,inst_33368);
} else {
return null;
}
}
}
});})(c__19252__auto__))
;
return ((function (switch__19140__auto__,c__19252__auto__){
return (function() {
var milia$api$async_export$state_machine__19141__auto__ = null;
var milia$api$async_export$state_machine__19141__auto____0 = (function (){
var statearr_33375 = [null,null,null,null,null,null,null];
(statearr_33375[(0)] = milia$api$async_export$state_machine__19141__auto__);

(statearr_33375[(1)] = (1));

return statearr_33375;
});
var milia$api$async_export$state_machine__19141__auto____1 = (function (state_33370){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_33370);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e33376){if((e33376 instanceof Object)){
var ex__19144__auto__ = e33376;
var statearr_33377_33382 = state_33370;
(statearr_33377_33382[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33370);

return cljs.core.cst$kw$recur;
} else {
throw e33376;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__33383 = state_33370;
state_33370 = G__33383;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19141__auto__ = function(state_33370){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19141__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19141__auto____1.call(this,state_33370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19141__auto____0;
milia$api$async_export$state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19141__auto____1;
return milia$api$async_export$state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto__))
})();
var state__19254__auto__ = (function (){var statearr_33378 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_33378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto__);

return statearr_33378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto__))
);

return c__19252__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq33355){
var G__33356 = cljs.core.first(seq33355);
var seq33355__$1 = cljs.core.next(seq33355);
var G__33357 = cljs.core.first(seq33355__$1);
var seq33355__$2 = cljs.core.next(seq33355__$1);
var G__33358 = cljs.core.first(seq33355__$2);
var seq33355__$3 = cljs.core.next(seq33355__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__33356,G__33357,G__33358,seq33355__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export.json?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
