// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.user');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('clojure.string');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.user.patch = (function milia$api$user$patch(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33395 = arguments.length;
var i__7652__auto___33396 = (0);
while(true){
if((i__7652__auto___33396 < len__7651__auto___33395)){
args__7658__auto__.push((arguments[i__7652__auto___33396]));

var G__33397 = (i__7652__auto___33396 + (1));
i__7652__auto___33396 = G__33397;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic = (function (username,params,p__33392){
var map__33393 = p__33392;
var map__33393__$1 = ((((!((map__33393 == null)))?((((map__33393.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33393.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33393):map__33393);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33393__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",[cljs.core.str(username),cljs.core.str(".json")].join('')], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
});

milia.api.user.patch.cljs$lang$maxFixedArity = (2);

milia.api.user.patch.cljs$lang$applyTo = (function (seq33389){
var G__33390 = cljs.core.first(seq33389);
var seq33389__$1 = cljs.core.next(seq33389);
var G__33391 = cljs.core.first(seq33389__$1);
var seq33389__$2 = cljs.core.next(seq33389__$1);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(G__33390,G__33391,seq33389__$2);
});

/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.profile = (function milia$api$user$profile(username){
if(cljs.core.truth_(username)){
} else {
throw (new Error("Assert failed: username"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",[cljs.core.str(username),cljs.core.str(".json")].join('')], 0));
var response = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$max_DASH_retries,(2)], 0));
var temp__4655__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__4655__auto__)){
var error = temp__4655__auto__;
return null;
} else {
return response;
}
});
milia.api.user.verify_email = (function milia$api$user$verify_email(verification_key){
if(cljs.core.truth_(verification_key)){
} else {
throw (new Error("Assert failed: verification-key"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",[cljs.core.str("verify_email.json?verification_key="),cljs.core.str(verification_key)].join('')], 0));
var response = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$max_DASH_retries,(2)], 0));
var temp__4655__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__4655__auto__)){
var error = temp__4655__auto__;
return null;
} else {
return response;
}
});
milia.api.user.send_verification_email = (function milia$api$user$send_verification_email(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33405 = arguments.length;
var i__7652__auto___33406 = (0);
while(true){
if((i__7652__auto___33406 < len__7651__auto___33405)){
args__7658__auto__.push((arguments[i__7652__auto___33406]));

var G__33407 = (i__7652__auto___33406 + (1));
i__7652__auto___33406 = G__33407;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__33400){
var vec__33401 = p__33400;
var redirect_url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33401,(0),null);
if(cljs.core.truth_(username)){
} else {
throw (new Error("Assert failed: username"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles","send_verification_email.json"], 0));
var form_params = (function (){var G__33404 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(redirect_url) : chimera.core.not_nil_QMARK_.call(null,redirect_url)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33404,cljs.core.cst$kw$redirect_url,redirect_url);
} else {
return G__33404;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.user.send_verification_email.cljs$lang$maxFixedArity = (1);

milia.api.user.send_verification_email.cljs$lang$applyTo = (function (seq33398){
var G__33399 = cljs.core.first(seq33398);
var seq33398__$1 = cljs.core.next(seq33398);
return milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic(G__33399,seq33398__$1);
});

/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.get_profiles_for_list_of_users = (function milia$api$user$get_profiles_for_list_of_users(users){
if(cljs.core.seq(users)){
} else {
throw (new Error("Assert failed: (seq users)"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("profiles.json?users="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",users))].join('')], 0));
var response = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
var temp__4655__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__4655__auto__)){
var error = temp__4655__auto__;
return error;
} else {
return response;
}
});
/**
 * Return the user profile with authentication details.
 */
milia.api.user.user = (function milia$api$user$user(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33413 = arguments.length;
var i__7652__auto___33414 = (0);
while(true){
if((i__7652__auto___33414 < len__7651__auto___33413)){
args__7658__auto__.push((arguments[i__7652__auto___33414]));

var G__33415 = (i__7652__auto___33414 + (1));
i__7652__auto___33414 = G__33415;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic = (function (p__33409){
var vec__33410 = p__33409;
var suppress_4xx_exceptions_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33410,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
});

milia.api.user.user.cljs$lang$maxFixedArity = (0);

milia.api.user.user.cljs$lang$applyTo = (function (seq33408){
return milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33408));
});

milia.api.user.get_subscription = (function milia$api$user$get_subscription(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["pricing","subscriptions",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.update_subscription = (function milia$api$user$update_subscription(username,contactpersons){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["pricing","subscriptions",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$contactpersons,contactpersons], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.get_subscription_payment = (function milia$api$user$get_subscription_payment(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["pricing","payments",username], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.user.get_invoices = (function milia$api$user$get_invoices(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["pricing",[cljs.core.str("invoices?username="),cljs.core.str(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Create a new user.
 */
milia.api.user.create = (function milia$api$user$create(params){
var profile = cljs.core.select_keys(params,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$first_name,cljs.core.cst$kw$last_name,cljs.core.cst$kw$username,cljs.core.cst$kw$email,cljs.core.cst$kw$password], null));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,profile], null)], 0));
});
/**
 * return all users
 */
milia.api.user.all = (function milia$api$user$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * update user profile
 */
milia.api.user.update = (function milia$api$user$update(username,params){
if(cljs.core.truth_(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$city,cljs.core.cst$kw$country,cljs.core.cst$kw$email,cljs.core.cst$kw$gravatar,cljs.core.cst$kw$last_name,cljs.core.cst$kw$first_name,cljs.core.cst$kw$is_org,cljs.core.cst$kw$owner,cljs.core.cst$kw$require_auth,cljs.core.cst$kw$twitter,cljs.core.cst$kw$url,cljs.core.cst$kw$user,cljs.core.cst$kw$username,cljs.core.cst$kw$website,cljs.core.cst$kw$organization], null)))){
} else {
throw (new Error("Assert failed: (has-keys? params [:city :country :email :gravatar :last_name :first_name :is_org :owner :require_auth :twitter :url :user :username :website :organization])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",[cljs.core.str(username),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Change user password
 */
milia.api.user.change_password = (function milia$api$user$change_password(username,current_password,new_password){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["profiles",username,"change_password.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current_password,current_password,cljs.core.cst$kw$new_password,new_password], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.user.retrieve_metadata = (function milia$api$user$retrieve_metadata(username){
return cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.user.profile(username));
});
milia.api.user.update_user_metadata = (function milia$api$user$update_user_metadata(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33422 = arguments.length;
var i__7652__auto___33423 = (0);
while(true){
if((i__7652__auto___33423 < len__7651__auto___33422)){
args__7658__auto__.push((arguments[i__7652__auto___33423]));

var G__33424 = (i__7652__auto___33423 + (1));
i__7652__auto___33423 = G__33424;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic = (function (username,metadata,p__33419){
var map__33420 = p__33419;
var map__33420__$1 = ((((!((map__33420 == null)))?((((map__33420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33420.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33420):map__33420);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33420__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,null);
var current_metadata = milia.api.user.retrieve_metadata(username);
var updated_metadata = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([current_metadata,metadata], 0));
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$metadata,updated_metadata], null),cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
});

milia.api.user.update_user_metadata.cljs$lang$maxFixedArity = (2);

milia.api.user.update_user_metadata.cljs$lang$applyTo = (function (seq33416){
var G__33417 = cljs.core.first(seq33416);
var seq33416__$1 = cljs.core.next(seq33416);
var G__33418 = cljs.core.first(seq33416__$1);
var seq33416__$2 = cljs.core.next(seq33416__$1);
return milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic(G__33417,G__33418,seq33416__$2);
});

/**
 * Return the user for this username
 */
milia.api.user.get = (function milia$api$user$get(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",[cljs.core.str(username),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return the users that match this email address
 */
milia.api.user.get_by_email = (function milia$api$user$get_by_email(email){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$search,email], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Trigger a password reset email to the given email and given return URL.
 * Also takes an optional subject for the email message.
 */
milia.api.user.trigger_password_reset_email = (function milia$api$user$trigger_password_reset_email(var_args){
var args33425 = [];
var len__7651__auto___33428 = arguments.length;
var i__7652__auto___33429 = (0);
while(true){
if((i__7652__auto___33429 < len__7651__auto___33428)){
args33425.push((arguments[i__7652__auto___33429]));

var G__33430 = (i__7652__auto___33429 + (1));
i__7652__auto___33429 = G__33430;
continue;
} else {
}
break;
}

var G__33427 = args33425.length;
switch (G__33427) {
case 2:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33425.length)].join('')));

}
});

milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2 = (function (email,reset_url){
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3(email,reset_url,null);
});

milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3 = (function (email,reset_url,reset_subject){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user","reset.json"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$email,email,cljs.core.cst$kw$reset_url,reset_url], null),(cljs.core.truth_(reset_subject)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$email_subject,reset_subject], null):null)], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.user.trigger_password_reset_email.cljs$lang$maxFixedArity = 3;

milia.api.user.reset_password = (function milia$api$user$reset_password(new_password,token,uid){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user","reset.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$new_password,new_password,cljs.core.cst$kw$token,token,cljs.core.cst$kw$uid,uid], null)], null)], 0));
});
/**
 * Change the user's email address. This requires a password so that the API
 * can successful update the authentication digest and email can be used to
 * login.
 */
milia.api.user.change_email_address = (function milia$api$user$change_email_address(username,email_address,password){
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$email,email_address,cljs.core.cst$kw$password,password], null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,params,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Expire the user's temporary token.
 */
milia.api.user.expire_temp_token = (function milia$api$user$expire_temp_token(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user","expire.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Send a code to authorize a user to use google sheets
 */
milia.api.user.google_sheet_authorization = (function milia$api$user$google_sheet_authorization(code,redirect_uri){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["google",chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("google_auth.json?code=%s&redirect_uri=%s",cljs.core.array_seq([code,redirect_uri], 0))], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
