// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__28672 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28672) : cljs.core.atom.call(null,G__28672));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4425__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4425__auto__)){
var req = temp__4425__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.constant$keyword$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.constant$keyword$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var seq__28685 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)));
var chunk__28690 = null;
var count__28691 = (0);
var i__28692 = (0);
while(true){
if((i__28692 < count__28691)){
var h_name = chunk__28690.cljs$core$IIndexed$_nth$arity$2(null,i__28692);
var seq__28693_28697 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28694_28698 = null;
var count__28695_28699 = (0);
var i__28696_28700 = (0);
while(true){
if((i__28696_28700 < count__28695_28699)){
var h_val_28701 = chunk__28694_28698.cljs$core$IIndexed$_nth$arity$2(null,i__28696_28700);
xhr.headers.set(h_name,h_val_28701);

var G__28702 = seq__28693_28697;
var G__28703 = chunk__28694_28698;
var G__28704 = count__28695_28699;
var G__28705 = (i__28696_28700 + (1));
seq__28693_28697 = G__28702;
chunk__28694_28698 = G__28703;
count__28695_28699 = G__28704;
i__28696_28700 = G__28705;
continue;
} else {
var temp__4425__auto___28706 = cljs.core.seq(seq__28693_28697);
if(temp__4425__auto___28706){
var seq__28693_28707__$1 = temp__4425__auto___28706;
if(cljs.core.chunked_seq_QMARK_(seq__28693_28707__$1)){
var c__8721__auto___28708 = cljs.core.chunk_first(seq__28693_28707__$1);
var G__28709 = cljs.core.chunk_rest(seq__28693_28707__$1);
var G__28710 = c__8721__auto___28708;
var G__28711 = cljs.core.count(c__8721__auto___28708);
var G__28712 = (0);
seq__28693_28697 = G__28709;
chunk__28694_28698 = G__28710;
count__28695_28699 = G__28711;
i__28696_28700 = G__28712;
continue;
} else {
var h_val_28713 = cljs.core.first(seq__28693_28707__$1);
xhr.headers.set(h_name,h_val_28713);

var G__28714 = cljs.core.next(seq__28693_28707__$1);
var G__28715 = null;
var G__28716 = (0);
var G__28717 = (0);
seq__28693_28697 = G__28714;
chunk__28694_28698 = G__28715;
count__28695_28699 = G__28716;
i__28696_28700 = G__28717;
continue;
}
} else {
}
}
break;
}

var G__28718 = seq__28685;
var G__28719 = chunk__28690;
var G__28720 = count__28691;
var G__28721 = (i__28692 + (1));
seq__28685 = G__28718;
chunk__28690 = G__28719;
count__28691 = G__28720;
i__28692 = G__28721;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__28685);
if(temp__4425__auto__){
var seq__28685__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28685__$1)){
var c__8721__auto__ = cljs.core.chunk_first(seq__28685__$1);
var G__28722 = cljs.core.chunk_rest(seq__28685__$1);
var G__28723 = c__8721__auto__;
var G__28724 = cljs.core.count(c__8721__auto__);
var G__28725 = (0);
seq__28685 = G__28722;
chunk__28690 = G__28723;
count__28691 = G__28724;
i__28692 = G__28725;
continue;
} else {
var h_name = cljs.core.first(seq__28685__$1);
var seq__28686_28726 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28687_28727 = null;
var count__28688_28728 = (0);
var i__28689_28729 = (0);
while(true){
if((i__28689_28729 < count__28688_28728)){
var h_val_28730 = chunk__28687_28727.cljs$core$IIndexed$_nth$arity$2(null,i__28689_28729);
xhr.headers.set(h_name,h_val_28730);

var G__28731 = seq__28686_28726;
var G__28732 = chunk__28687_28727;
var G__28733 = count__28688_28728;
var G__28734 = (i__28689_28729 + (1));
seq__28686_28726 = G__28731;
chunk__28687_28727 = G__28732;
count__28688_28728 = G__28733;
i__28689_28729 = G__28734;
continue;
} else {
var temp__4425__auto___28735__$1 = cljs.core.seq(seq__28686_28726);
if(temp__4425__auto___28735__$1){
var seq__28686_28736__$1 = temp__4425__auto___28735__$1;
if(cljs.core.chunked_seq_QMARK_(seq__28686_28736__$1)){
var c__8721__auto___28737 = cljs.core.chunk_first(seq__28686_28736__$1);
var G__28738 = cljs.core.chunk_rest(seq__28686_28736__$1);
var G__28739 = c__8721__auto___28737;
var G__28740 = cljs.core.count(c__8721__auto___28737);
var G__28741 = (0);
seq__28686_28726 = G__28738;
chunk__28687_28727 = G__28739;
count__28688_28728 = G__28740;
i__28689_28729 = G__28741;
continue;
} else {
var h_val_28742 = cljs.core.first(seq__28686_28736__$1);
xhr.headers.set(h_name,h_val_28742);

var G__28743 = cljs.core.next(seq__28686_28736__$1);
var G__28744 = null;
var G__28745 = (0);
var G__28746 = (0);
seq__28686_28726 = G__28743;
chunk__28687_28727 = G__28744;
count__28688_28728 = G__28745;
i__28689_28729 = G__28746;
continue;
}
} else {
}
}
break;
}

var G__28747 = cljs.core.next(seq__28685__$1);
var G__28748 = null;
var G__28749 = (0);
var G__28750 = (0);
seq__28685 = G__28747;
chunk__28690 = G__28748;
count__28691 = G__28749;
i__28692 = G__28750;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__28752 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$array_DASH_buffer,G__28752)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$blob,G__28752)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$document,G__28752)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$text,G__28752)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$default,G__28752)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__28752)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__28753){
var map__28757 = p__28753;
var map__28757__$1 = ((((!((map__28757 == null)))?((((map__28757.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28757.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28757):map__28757);
var request = map__28757__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28757__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28757__$1,cljs.core.constant$keyword$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28757__$1,cljs.core.constant$keyword$response_DASH_type);
var timeout = (function (){var or__7937__auto__ = cljs.core.constant$keyword$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__28759 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__28759,default_headers);

cljs_http.core.apply_response_type_BANG_(G__28759,response_type);

G__28759.setTimeoutInterval(timeout);

G__28759.setWithCredentials(send_credentials);

return G__28759;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.constant$keyword$no_DASH_error,cljs.core.constant$keyword$abort,cljs.core.constant$keyword$access_DASH_denied,cljs.core.constant$keyword$custom_DASH_error,cljs.core.constant$keyword$http_DASH_error,cljs.core.constant$keyword$ff_DASH_silent_DASH_error,cljs.core.constant$keyword$file_DASH_not_DASH_found,cljs.core.constant$keyword$offline,cljs.core.constant$keyword$exception,cljs.core.constant$keyword$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__28760){
var map__28788 = p__28760;
var map__28788__$1 = ((((!((map__28788 == null)))?((((map__28788.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28788.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28788):map__28788);
var request = map__28788__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28788__$1,cljs.core.constant$keyword$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28788__$1,cljs.core.constant$keyword$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28788__$1,cljs.core.constant$keyword$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28788__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28788__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__7937__auto__ = request_method;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return cljs.core.constant$keyword$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$status,target.getStatus(),cljs.core.constant$keyword$success,target.isSuccess(),cljs.core.constant$keyword$body,target.getResponse(),cljs.core.constant$keyword$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.constant$keyword$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.constant$keyword$error_DASH_code,(function (){var G__28790 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__28790) : cljs_http.core.error_kw.call(null,G__28790));
})(),cljs.core.constant$keyword$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__11626__auto___28815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___28815,channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___28815,channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_28801){
var state_val_28802 = (state_28801[(1)]);
if((state_val_28802 === (1))){
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28801__$1,(2),cancel);
} else {
if((state_val_28802 === (2))){
var inst_28792 = (state_28801[(2)]);
var inst_28793 = xhr__$1.isComplete();
var inst_28794 = cljs.core.not(inst_28793);
var state_28801__$1 = (function (){var statearr_28803 = state_28801;
(statearr_28803[(7)] = inst_28792);

return statearr_28803;
})();
if(inst_28794){
var statearr_28804_28816 = state_28801__$1;
(statearr_28804_28816[(1)] = (3));

} else {
var statearr_28805_28817 = state_28801__$1;
(statearr_28805_28817[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28802 === (3))){
var inst_28796 = xhr__$1.abort();
var state_28801__$1 = state_28801;
var statearr_28806_28818 = state_28801__$1;
(statearr_28806_28818[(2)] = inst_28796);

(statearr_28806_28818[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28802 === (4))){
var state_28801__$1 = state_28801;
var statearr_28807_28819 = state_28801__$1;
(statearr_28807_28819[(2)] = null);

(statearr_28807_28819[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28802 === (5))){
var inst_28799 = (state_28801[(2)]);
var state_28801__$1 = state_28801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28801__$1,inst_28799);
} else {
return null;
}
}
}
}
}
});})(c__11626__auto___28815,channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__11561__auto__,c__11626__auto___28815,channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__11562__auto__ = null;
var cljs_http$core$xhr_$_state_machine__11562__auto____0 = (function (){
var statearr_28811 = [null,null,null,null,null,null,null,null];
(statearr_28811[(0)] = cljs_http$core$xhr_$_state_machine__11562__auto__);

(statearr_28811[(1)] = (1));

return statearr_28811;
});
var cljs_http$core$xhr_$_state_machine__11562__auto____1 = (function (state_28801){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_28801);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e28812){if((e28812 instanceof Object)){
var ex__11565__auto__ = e28812;
var statearr_28813_28820 = state_28801;
(statearr_28813_28820[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28801);

return cljs.core.constant$keyword$recur;
} else {
throw e28812;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__28821 = state_28801;
state_28801 = G__28821;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__11562__auto__ = function(state_28801){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__11562__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__11562__auto____1.call(this,state_28801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__11562__auto____0;
cljs_http$core$xhr_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__11562__auto____1;
return cljs_http$core$xhr_$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___28815,channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__11628__auto__ = (function (){var statearr_28814 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_28814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___28815);

return statearr_28814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___28815,channel,request_url,method,headers__$1,xhr__$1,map__28788,map__28788__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__28822){
var map__28839 = p__28822;
var map__28839__$1 = ((((!((map__28839 == null)))?((((map__28839.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28839.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28839):map__28839);
var request = map__28839__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28839__$1,cljs.core.constant$keyword$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28839__$1,cljs.core.constant$keyword$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28839__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_28855 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$status,(200),cljs.core.constant$keyword$success,true,cljs.core.constant$keyword$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel))
,((function (channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$jsonp,jsonp__$1,cljs.core.constant$keyword$request,req_28855], null));

if(cljs.core.truth_(cancel)){
var c__11626__auto___28856 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___28856,req_28855,channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___28856,req_28855,channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel){
return (function (state_28845){
var state_val_28846 = (state_28845[(1)]);
if((state_val_28846 === (1))){
var state_28845__$1 = state_28845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28845__$1,(2),cancel);
} else {
if((state_val_28846 === (2))){
var inst_28842 = (state_28845[(2)]);
var inst_28843 = jsonp__$1.cancel(req_28855);
var state_28845__$1 = (function (){var statearr_28847 = state_28845;
(statearr_28847[(7)] = inst_28842);

return statearr_28847;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28845__$1,inst_28843);
} else {
return null;
}
}
});})(c__11626__auto___28856,req_28855,channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel))
;
return ((function (switch__11561__auto__,c__11626__auto___28856,req_28855,channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel){
return (function() {
var cljs_http$core$jsonp_$_state_machine__11562__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__11562__auto____0 = (function (){
var statearr_28851 = [null,null,null,null,null,null,null,null];
(statearr_28851[(0)] = cljs_http$core$jsonp_$_state_machine__11562__auto__);

(statearr_28851[(1)] = (1));

return statearr_28851;
});
var cljs_http$core$jsonp_$_state_machine__11562__auto____1 = (function (state_28845){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_28845);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e28852){if((e28852 instanceof Object)){
var ex__11565__auto__ = e28852;
var statearr_28853_28857 = state_28845;
(statearr_28853_28857[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28845);

return cljs.core.constant$keyword$recur;
} else {
throw e28852;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__28858 = state_28845;
state_28845 = G__28858;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__11562__auto__ = function(state_28845){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__11562__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__11562__auto____1.call(this,state_28845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__11562__auto____0;
cljs_http$core$jsonp_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__11562__auto____1;
return cljs_http$core$jsonp_$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___28856,req_28855,channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel))
})();
var state__11628__auto__ = (function (){var statearr_28854 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_28854[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___28856);

return statearr_28854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___28856,req_28855,channel,jsonp__$1,map__28839,map__28839__$1,request,timeout,callback_name,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__28859){
var map__28862 = p__28859;
var map__28862__$1 = ((((!((map__28862 == null)))?((((map__28862.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28862.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28862):map__28862);
var request__$1 = map__28862__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28862__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.constant$keyword$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
