// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
if(cljs.core.truth_((function (){var and__6141__auto__ = cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__6141__auto__)){
return stateful_method_QMARK_;
} else {
return and__6141__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$xhr], null),true);
if(cljs.core.truth_((function (){var and__6141__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__6141__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__20562 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__20562) : cljs_hash.md5.md5.call(null,G__20562));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20567 = arguments.length;
var i__7212__auto___20568 = (0);
while(true){
if((i__7212__auto___20568 < len__7211__auto___20567)){
args__7218__auto__.push((arguments[i__7212__auto___20568]));

var G__20569 = (i__7212__auto___20568 + (1));
i__7212__auto___20568 = G__20569;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__20564){
var map__20565 = p__20564;
var map__20565__$1 = ((((!((map__20565 == null)))?((((map__20565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20565):map__20565);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20565__$1,cljs.core.cst$kw$accept_DASH_header);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__6141__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6141__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6141__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6141__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6141__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6141__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6153__auto__ = accept_header;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq20563){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20563));
});
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(io_obj){
try{return io_obj.getResponseJson();
}catch (e20571){if((e20571 instanceof Error)){
var _ = e20571;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e20571;

}
}});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20587 = arguments.length;
var i__7212__auto___20588 = (0);
while(true){
if((i__7212__auto___20588 < len__7211__auto___20587)){
args__7218__auto__.push((arguments[i__7212__auto___20588]));

var G__20589 = (i__7212__auto___20588 + (1));
i__7212__auto___20588 = G__20589;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__20576){
var vec__20577 = p__20576;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20577,(0),null);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
var G__20578_20590 = io_obj;
var G__20579_20591 = goog.net.EventType.SUCCESS;
var G__20580_20592 = ((function (G__20578_20590,G__20579_20591,io_obj,data,url,vec__20577,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__20578_20590,G__20579_20591,io_obj,data,url,vec__20577,id))
;
goog.events.listen(G__20578_20590,G__20579_20591,G__20580_20592);

var G__20581_20593 = io_obj;
var G__20582_20594 = goog.net.EventType.ERROR;
var G__20583_20595 = ((function (G__20581_20593,G__20582_20594,io_obj,data,url,vec__20577,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__20581_20593,G__20582_20594,io_obj,data,url,vec__20577,id))
;
goog.events.listen(G__20581_20593,G__20582_20594,G__20583_20595);

var G__20584_20596 = io_obj;
var G__20585_20597 = goog.net.EventType.PROGRESS;
var G__20586_20598 = ((function (G__20584_20596,G__20585_20597,io_obj,data,url,vec__20577,id){
return (function (p1__20572_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__20572_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__20572_SHARP_.loaded,cljs.core.cst$kw$total,p1__20572_SHARP_.total], null)));
});})(G__20584_20596,G__20585_20597,io_obj,data,url,vec__20577,id))
;
goog.events.listen(G__20584_20596,G__20585_20597,G__20586_20598);

io_obj.send(url,"POST",form);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq20573){
var G__20574 = cljs.core.first(seq20573);
var seq20573__$1 = cljs.core.next(seq20573);
var G__20575 = cljs.core.first(seq20573__$1);
var seq20573__$2 = cljs.core.next(seq20573__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__20574,G__20575,seq20573__$2);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7218__auto__ = [];
var len__7211__auto___20661 = arguments.length;
var i__7212__auto___20662 = (0);
while(true){
if((i__7212__auto___20662 < len__7211__auto___20661)){
args__7218__auto__.push((arguments[i__7212__auto___20662]));

var G__20663 = (i__7212__auto___20662 + (1));
i__7212__auto___20662 = G__20663;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__17341__auto___20664 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___20664,response_channel){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___20664,response_channel){
return (function (state_20634){
var state_val_20635 = (state_20634[(1)]);
if((state_val_20635 === (7))){
var state_20634__$1 = state_20634;
var statearr_20636_20665 = state_20634__$1;
(statearr_20636_20665[(2)] = false);

(statearr_20636_20665[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (1))){
var inst_20602 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_20634__$1 = state_20634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20634__$1,(2),inst_20602);
} else {
if((state_val_20635 === (4))){
var state_20634__$1 = state_20634;
var statearr_20637_20666 = state_20634__$1;
(statearr_20637_20666[(2)] = false);

(statearr_20637_20666[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (13))){
var inst_20624 = (state_20634[(7)]);
var inst_20630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_20624);
var state_20634__$1 = state_20634;
var statearr_20638_20667 = state_20634__$1;
(statearr_20638_20667[(2)] = inst_20630);

(statearr_20638_20667[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (6))){
var state_20634__$1 = state_20634;
var statearr_20639_20668 = state_20634__$1;
(statearr_20639_20668[(2)] = true);

(statearr_20639_20668[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (3))){
var inst_20604 = (state_20634[(8)]);
var inst_20609 = inst_20604.cljs$lang$protocol_mask$partition0$;
var inst_20610 = (inst_20609 & (64));
var inst_20611 = inst_20604.cljs$core$ISeq$;
var inst_20612 = (inst_20610) || (inst_20611);
var state_20634__$1 = state_20634;
if(cljs.core.truth_(inst_20612)){
var statearr_20640_20669 = state_20634__$1;
(statearr_20640_20669[(1)] = (6));

} else {
var statearr_20641_20670 = state_20634__$1;
(statearr_20641_20670[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (12))){
var inst_20628 = window.location = window.location;
var state_20634__$1 = state_20634;
var statearr_20642_20671 = state_20634__$1;
(statearr_20642_20671[(2)] = inst_20628);

(statearr_20642_20671[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (2))){
var inst_20604 = (state_20634[(8)]);
var inst_20604__$1 = (state_20634[(2)]);
var inst_20606 = (inst_20604__$1 == null);
var inst_20607 = cljs.core.not(inst_20606);
var state_20634__$1 = (function (){var statearr_20643 = state_20634;
(statearr_20643[(8)] = inst_20604__$1);

return statearr_20643;
})();
if(inst_20607){
var statearr_20644_20672 = state_20634__$1;
(statearr_20644_20672[(1)] = (3));

} else {
var statearr_20645_20673 = state_20634__$1;
(statearr_20645_20673[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (11))){
var inst_20624 = (state_20634[(7)]);
var inst_20624__$1 = (state_20634[(2)]);
var inst_20625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20624__$1,cljs.core.cst$kw$status);
var inst_20626 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20625,(401));
var state_20634__$1 = (function (){var statearr_20646 = state_20634;
(statearr_20646[(7)] = inst_20624__$1);

return statearr_20646;
})();
if(inst_20626){
var statearr_20647_20674 = state_20634__$1;
(statearr_20647_20674[(1)] = (12));

} else {
var statearr_20648_20675 = state_20634__$1;
(statearr_20648_20675[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (9))){
var inst_20604 = (state_20634[(8)]);
var inst_20621 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20604);
var state_20634__$1 = state_20634;
var statearr_20649_20676 = state_20634__$1;
(statearr_20649_20676[(2)] = inst_20621);

(statearr_20649_20676[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (5))){
var inst_20619 = (state_20634[(2)]);
var state_20634__$1 = state_20634;
if(cljs.core.truth_(inst_20619)){
var statearr_20650_20677 = state_20634__$1;
(statearr_20650_20677[(1)] = (9));

} else {
var statearr_20651_20678 = state_20634__$1;
(statearr_20651_20678[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (14))){
var inst_20632 = (state_20634[(2)]);
var state_20634__$1 = state_20634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20634__$1,inst_20632);
} else {
if((state_val_20635 === (10))){
var inst_20604 = (state_20634[(8)]);
var state_20634__$1 = state_20634;
var statearr_20652_20679 = state_20634__$1;
(statearr_20652_20679[(2)] = inst_20604);

(statearr_20652_20679[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20635 === (8))){
var inst_20616 = (state_20634[(2)]);
var state_20634__$1 = state_20634;
var statearr_20653_20680 = state_20634__$1;
(statearr_20653_20680[(2)] = inst_20616);

(statearr_20653_20680[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17341__auto___20664,response_channel))
;
return ((function (switch__17227__auto__,c__17341__auto___20664,response_channel){
return (function() {
var milia$api$io$state_machine__17228__auto__ = null;
var milia$api$io$state_machine__17228__auto____0 = (function (){
var statearr_20657 = [null,null,null,null,null,null,null,null,null];
(statearr_20657[(0)] = milia$api$io$state_machine__17228__auto__);

(statearr_20657[(1)] = (1));

return statearr_20657;
});
var milia$api$io$state_machine__17228__auto____1 = (function (state_20634){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20634);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20658){if((e20658 instanceof Object)){
var ex__17231__auto__ = e20658;
var statearr_20659_20681 = state_20634;
(statearr_20659_20681[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20634);

return cljs.core.cst$kw$recur;
} else {
throw e20658;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20682 = state_20634;
state_20634 = G__20682;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
milia$api$io$state_machine__17228__auto__ = function(state_20634){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__17228__auto____0.call(this);
case 1:
return milia$api$io$state_machine__17228__auto____1.call(this,state_20634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__17228__auto____0;
milia$api$io$state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__17228__auto____1;
return milia$api$io$state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___20664,response_channel))
})();
var state__17343__auto__ = (function (){var statearr_20660 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20660[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___20664);

return statearr_20660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___20664,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq20599){
var G__20600 = cljs.core.first(seq20599);
var seq20599__$1 = cljs.core.next(seq20599);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__20600,seq20599__$1);
});
