// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__20142 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__20142) : cljs.core.atom.call(null,G__20142));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__20145){
var vec__20146 = p__20145;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20146,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20146,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__20148 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__20148)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__20148)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__20148)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__20148)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__20148)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__20148)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__20149){
var map__20153 = p__20149;
var map__20153__$1 = ((((!((map__20153 == null)))?((((map__20153.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20153.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20153):map__20153);
var request = map__20153__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20153__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20153__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20153__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6153__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__20155 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__20155,default_headers);

cljs_http.core.apply_response_type_BANG_(G__20155,response_type);

G__20155.setTimeoutInterval(timeout);

G__20155.setWithCredentials(send_credentials);

return G__20155;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__20156){
var map__20184 = p__20156;
var map__20184__$1 = ((((!((map__20184 == null)))?((((map__20184.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20184.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20184):map__20184);
var request = map__20184__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20184__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20184__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20184__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20184__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20184__$1,cljs.core.cst$kw$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6153__auto__ = request_method;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__20186 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__20186) : cljs_http.core.error_kw.call(null,G__20186));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__17341__auto___20211 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___20211,channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___20211,channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_20197){
var state_val_20198 = (state_20197[(1)]);
if((state_val_20198 === (1))){
var state_20197__$1 = state_20197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20197__$1,(2),cancel);
} else {
if((state_val_20198 === (2))){
var inst_20188 = (state_20197[(2)]);
var inst_20189 = xhr__$1.isComplete();
var inst_20190 = cljs.core.not(inst_20189);
var state_20197__$1 = (function (){var statearr_20199 = state_20197;
(statearr_20199[(7)] = inst_20188);

return statearr_20199;
})();
if(inst_20190){
var statearr_20200_20212 = state_20197__$1;
(statearr_20200_20212[(1)] = (3));

} else {
var statearr_20201_20213 = state_20197__$1;
(statearr_20201_20213[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20198 === (3))){
var inst_20192 = xhr__$1.abort();
var state_20197__$1 = state_20197;
var statearr_20202_20214 = state_20197__$1;
(statearr_20202_20214[(2)] = inst_20192);

(statearr_20202_20214[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20198 === (4))){
var state_20197__$1 = state_20197;
var statearr_20203_20215 = state_20197__$1;
(statearr_20203_20215[(2)] = null);

(statearr_20203_20215[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20198 === (5))){
var inst_20195 = (state_20197[(2)]);
var state_20197__$1 = state_20197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20197__$1,inst_20195);
} else {
return null;
}
}
}
}
}
});})(c__17341__auto___20211,channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__17227__auto__,c__17341__auto___20211,channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__17228__auto__ = null;
var cljs_http$core$xhr_$_state_machine__17228__auto____0 = (function (){
var statearr_20207 = [null,null,null,null,null,null,null,null];
(statearr_20207[(0)] = cljs_http$core$xhr_$_state_machine__17228__auto__);

(statearr_20207[(1)] = (1));

return statearr_20207;
});
var cljs_http$core$xhr_$_state_machine__17228__auto____1 = (function (state_20197){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20197);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20208){if((e20208 instanceof Object)){
var ex__17231__auto__ = e20208;
var statearr_20209_20216 = state_20197;
(statearr_20209_20216[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20197);

return cljs.core.cst$kw$recur;
} else {
throw e20208;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20217 = state_20197;
state_20197 = G__20217;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__17228__auto__ = function(state_20197){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__17228__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__17228__auto____1.call(this,state_20197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__17228__auto____0;
cljs_http$core$xhr_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__17228__auto____1;
return cljs_http$core$xhr_$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___20211,channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__17343__auto__ = (function (){var statearr_20210 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20210[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___20211);

return statearr_20210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___20211,channel,request_url,method,headers__$1,xhr__$1,map__20184,map__20184__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__20218){
var map__20235 = p__20218;
var map__20235__$1 = ((((!((map__20235 == null)))?((((map__20235.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20235.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20235):map__20235);
var request = map__20235__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20235__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20235__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20235__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20235__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_20251 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp__$1,cljs.core.cst$kw$request,req_20251], null));

if(cljs.core.truth_(cancel)){
var c__17341__auto___20252 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17341__auto___20252,req_20251,channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__17342__auto__ = (function (){var switch__17227__auto__ = ((function (c__17341__auto___20252,req_20251,channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_20241){
var state_val_20242 = (state_20241[(1)]);
if((state_val_20242 === (1))){
var state_20241__$1 = state_20241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20241__$1,(2),cancel);
} else {
if((state_val_20242 === (2))){
var inst_20238 = (state_20241[(2)]);
var inst_20239 = jsonp__$1.cancel(req_20251);
var state_20241__$1 = (function (){var statearr_20243 = state_20241;
(statearr_20243[(7)] = inst_20238);

return statearr_20243;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20241__$1,inst_20239);
} else {
return null;
}
}
});})(c__17341__auto___20252,req_20251,channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__17227__auto__,c__17341__auto___20252,req_20251,channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__17228__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__17228__auto____0 = (function (){
var statearr_20247 = [null,null,null,null,null,null,null,null];
(statearr_20247[(0)] = cljs_http$core$jsonp_$_state_machine__17228__auto__);

(statearr_20247[(1)] = (1));

return statearr_20247;
});
var cljs_http$core$jsonp_$_state_machine__17228__auto____1 = (function (state_20241){
while(true){
var ret_value__17229__auto__ = (function (){try{while(true){
var result__17230__auto__ = switch__17227__auto__(state_20241);
if(cljs.core.keyword_identical_QMARK_(result__17230__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17230__auto__;
}
break;
}
}catch (e20248){if((e20248 instanceof Object)){
var ex__17231__auto__ = e20248;
var statearr_20249_20253 = state_20241;
(statearr_20249_20253[(5)] = ex__17231__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20241);

return cljs.core.cst$kw$recur;
} else {
throw e20248;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17229__auto__,cljs.core.cst$kw$recur)){
var G__20254 = state_20241;
state_20241 = G__20254;
continue;
} else {
return ret_value__17229__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__17228__auto__ = function(state_20241){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__17228__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__17228__auto____1.call(this,state_20241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__17228__auto____0;
cljs_http$core$jsonp_$_state_machine__17228__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__17228__auto____1;
return cljs_http$core$jsonp_$_state_machine__17228__auto__;
})()
;})(switch__17227__auto__,c__17341__auto___20252,req_20251,channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__17343__auto__ = (function (){var statearr_20250 = (f__17342__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17342__auto__.cljs$core$IFn$_invoke$arity$0() : f__17342__auto__.call(null));
(statearr_20250[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17341__auto___20252);

return statearr_20250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17343__auto__);
});})(c__17341__auto___20252,req_20251,channel,jsonp__$1,map__20235,map__20235__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__20255){
var map__20258 = p__20255;
var map__20258__$1 = ((((!((map__20258 == null)))?((((map__20258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20258):map__20258);
var request__$1 = map__20258__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20258__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
