// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args32120 = [];
var len__7651__auto___32126 = arguments.length;
var i__7652__auto___32127 = (0);
while(true){
if((i__7652__auto___32127 < len__7651__auto___32126)){
args32120.push((arguments[i__7652__auto___32127]));

var G__32128 = (i__7652__auto___32127 + (1));
i__7652__auto___32127 = G__32128;
continue;
} else {
}
break;
}

var G__32122 = args32120.length;
switch (G__32122) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32120.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async32123 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32123 = (function (f,blockable,meta32124){
this.f = f;
this.blockable = blockable;
this.meta32124 = meta32124;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32123.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32125,meta32124__$1){
var self__ = this;
var _32125__$1 = this;
return (new cljs.core.async.t_cljs$core$async32123(self__.f,self__.blockable,meta32124__$1));
});

cljs.core.async.t_cljs$core$async32123.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32125){
var self__ = this;
var _32125__$1 = this;
return self__.meta32124;
});

cljs.core.async.t_cljs$core$async32123.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32123.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32123.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async32123.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async32123.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta32124], null);
});

cljs.core.async.t_cljs$core$async32123.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32123.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32123";

cljs.core.async.t_cljs$core$async32123.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32123");
});

cljs.core.async.__GT_t_cljs$core$async32123 = (function cljs$core$async$__GT_t_cljs$core$async32123(f__$1,blockable__$1,meta32124){
return (new cljs.core.async.t_cljs$core$async32123(f__$1,blockable__$1,meta32124));
});

}

return (new cljs.core.async.t_cljs$core$async32123(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args32132 = [];
var len__7651__auto___32135 = arguments.length;
var i__7652__auto___32136 = (0);
while(true){
if((i__7652__auto___32136 < len__7651__auto___32135)){
args32132.push((arguments[i__7652__auto___32136]));

var G__32137 = (i__7652__auto___32136 + (1));
i__7652__auto___32136 = G__32137;
continue;
} else {
}
break;
}

var G__32134 = args32132.length;
switch (G__32134) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32132.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args32139 = [];
var len__7651__auto___32142 = arguments.length;
var i__7652__auto___32143 = (0);
while(true){
if((i__7652__auto___32143 < len__7651__auto___32142)){
args32139.push((arguments[i__7652__auto___32143]));

var G__32144 = (i__7652__auto___32143 + (1));
i__7652__auto___32143 = G__32144;
continue;
} else {
}
break;
}

var G__32141 = args32139.length;
switch (G__32141) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32139.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args32146 = [];
var len__7651__auto___32149 = arguments.length;
var i__7652__auto___32150 = (0);
while(true){
if((i__7652__auto___32150 < len__7651__auto___32149)){
args32146.push((arguments[i__7652__auto___32150]));

var G__32151 = (i__7652__auto___32150 + (1));
i__7652__auto___32150 = G__32151;
continue;
} else {
}
break;
}

var G__32148 = args32146.length;
switch (G__32148) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32146.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32153 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32153) : fn1.call(null,val_32153));
} else {
cljs.core.async.impl.dispatch.run(((function (val_32153,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32153) : fn1.call(null,val_32153));
});})(val_32153,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args32154 = [];
var len__7651__auto___32157 = arguments.length;
var i__7652__auto___32158 = (0);
while(true){
if((i__7652__auto___32158 < len__7651__auto___32157)){
args32154.push((arguments[i__7652__auto___32158]));

var G__32159 = (i__7652__auto___32158 + (1));
i__7652__auto___32158 = G__32159;
continue;
} else {
}
break;
}

var G__32156 = args32154.length;
switch (G__32156) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32154.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___32161 = n;
var x_32162 = (0);
while(true){
if((x_32162 < n__7461__auto___32161)){
(a[x_32162] = (0));

var G__32163 = (x_32162 + (1));
x_32162 = G__32163;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__32164 = (i + (1));
i = G__32164;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async32168 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32168 = (function (flag,meta32169){
this.flag = flag;
this.meta32169 = meta32169;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32168.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_32170,meta32169__$1){
var self__ = this;
var _32170__$1 = this;
return (new cljs.core.async.t_cljs$core$async32168(self__.flag,meta32169__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async32168.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_32170){
var self__ = this;
var _32170__$1 = this;
return self__.meta32169;
});})(flag))
;

cljs.core.async.t_cljs$core$async32168.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32168.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async32168.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32168.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32168.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta32169], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async32168.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32168.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32168";

cljs.core.async.t_cljs$core$async32168.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32168");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async32168 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async32168(flag__$1,meta32169){
return (new cljs.core.async.t_cljs$core$async32168(flag__$1,meta32169));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async32168(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async32174 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32174 = (function (flag,cb,meta32175){
this.flag = flag;
this.cb = cb;
this.meta32175 = meta32175;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32174.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32176,meta32175__$1){
var self__ = this;
var _32176__$1 = this;
return (new cljs.core.async.t_cljs$core$async32174(self__.flag,self__.cb,meta32175__$1));
});

cljs.core.async.t_cljs$core$async32174.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32176){
var self__ = this;
var _32176__$1 = this;
return self__.meta32175;
});

cljs.core.async.t_cljs$core$async32174.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32174.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async32174.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32174.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async32174.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta32175], null);
});

cljs.core.async.t_cljs$core$async32174.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32174.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32174";

cljs.core.async.t_cljs$core$async32174.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32174");
});

cljs.core.async.__GT_t_cljs$core$async32174 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async32174(flag__$1,cb__$1,meta32175){
return (new cljs.core.async.t_cljs$core$async32174(flag__$1,cb__$1,meta32175));
});

}

return (new cljs.core.async.t_cljs$core$async32174(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32177_SHARP_){
var G__32181 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32177_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__32181) : fret.call(null,G__32181));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32178_SHARP_){
var G__32182 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32178_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__32182) : fret.call(null,G__32182));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32183 = (i + (1));
i = G__32183;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32189 = arguments.length;
var i__7652__auto___32190 = (0);
while(true){
if((i__7652__auto___32190 < len__7651__auto___32189)){
args__7658__auto__.push((arguments[i__7652__auto___32190]));

var G__32191 = (i__7652__auto___32190 + (1));
i__7652__auto___32190 = G__32191;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__32186){
var map__32187 = p__32186;
var map__32187__$1 = ((((!((map__32187 == null)))?((((map__32187.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32187.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32187):map__32187);
var opts = map__32187__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq32184){
var G__32185 = cljs.core.first(seq32184);
var seq32184__$1 = cljs.core.next(seq32184);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32185,seq32184__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args32192 = [];
var len__7651__auto___32242 = arguments.length;
var i__7652__auto___32243 = (0);
while(true){
if((i__7652__auto___32243 < len__7651__auto___32242)){
args32192.push((arguments[i__7652__auto___32243]));

var G__32244 = (i__7652__auto___32243 + (1));
i__7652__auto___32243 = G__32244;
continue;
} else {
}
break;
}

var G__32194 = args32192.length;
switch (G__32194) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32192.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19296__auto___32246 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___32246){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___32246){
return (function (state_32218){
var state_val_32219 = (state_32218[(1)]);
if((state_val_32219 === (7))){
var inst_32214 = (state_32218[(2)]);
var state_32218__$1 = state_32218;
var statearr_32220_32247 = state_32218__$1;
(statearr_32220_32247[(2)] = inst_32214);

(statearr_32220_32247[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (1))){
var state_32218__$1 = state_32218;
var statearr_32221_32248 = state_32218__$1;
(statearr_32221_32248[(2)] = null);

(statearr_32221_32248[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (4))){
var inst_32197 = (state_32218[(7)]);
var inst_32197__$1 = (state_32218[(2)]);
var inst_32198 = (inst_32197__$1 == null);
var state_32218__$1 = (function (){var statearr_32222 = state_32218;
(statearr_32222[(7)] = inst_32197__$1);

return statearr_32222;
})();
if(cljs.core.truth_(inst_32198)){
var statearr_32223_32249 = state_32218__$1;
(statearr_32223_32249[(1)] = (5));

} else {
var statearr_32224_32250 = state_32218__$1;
(statearr_32224_32250[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (13))){
var state_32218__$1 = state_32218;
var statearr_32225_32251 = state_32218__$1;
(statearr_32225_32251[(2)] = null);

(statearr_32225_32251[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (6))){
var inst_32197 = (state_32218[(7)]);
var state_32218__$1 = state_32218;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32218__$1,(11),to,inst_32197);
} else {
if((state_val_32219 === (3))){
var inst_32216 = (state_32218[(2)]);
var state_32218__$1 = state_32218;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32218__$1,inst_32216);
} else {
if((state_val_32219 === (12))){
var state_32218__$1 = state_32218;
var statearr_32226_32252 = state_32218__$1;
(statearr_32226_32252[(2)] = null);

(statearr_32226_32252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (2))){
var state_32218__$1 = state_32218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32218__$1,(4),from);
} else {
if((state_val_32219 === (11))){
var inst_32207 = (state_32218[(2)]);
var state_32218__$1 = state_32218;
if(cljs.core.truth_(inst_32207)){
var statearr_32227_32253 = state_32218__$1;
(statearr_32227_32253[(1)] = (12));

} else {
var statearr_32228_32254 = state_32218__$1;
(statearr_32228_32254[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (9))){
var state_32218__$1 = state_32218;
var statearr_32229_32255 = state_32218__$1;
(statearr_32229_32255[(2)] = null);

(statearr_32229_32255[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (5))){
var state_32218__$1 = state_32218;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32230_32256 = state_32218__$1;
(statearr_32230_32256[(1)] = (8));

} else {
var statearr_32231_32257 = state_32218__$1;
(statearr_32231_32257[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (14))){
var inst_32212 = (state_32218[(2)]);
var state_32218__$1 = state_32218;
var statearr_32232_32258 = state_32218__$1;
(statearr_32232_32258[(2)] = inst_32212);

(statearr_32232_32258[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (10))){
var inst_32204 = (state_32218[(2)]);
var state_32218__$1 = state_32218;
var statearr_32233_32259 = state_32218__$1;
(statearr_32233_32259[(2)] = inst_32204);

(statearr_32233_32259[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32219 === (8))){
var inst_32201 = cljs.core.async.close_BANG_(to);
var state_32218__$1 = state_32218;
var statearr_32234_32260 = state_32218__$1;
(statearr_32234_32260[(2)] = inst_32201);

(statearr_32234_32260[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___32246))
;
return ((function (switch__19184__auto__,c__19296__auto___32246){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_32238 = [null,null,null,null,null,null,null,null];
(statearr_32238[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_32238[(1)] = (1));

return statearr_32238;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_32218){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32218);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32239){if((e32239 instanceof Object)){
var ex__19188__auto__ = e32239;
var statearr_32240_32261 = state_32218;
(statearr_32240_32261[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32218);

return cljs.core.cst$kw$recur;
} else {
throw e32239;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32262 = state_32218;
state_32218 = G__32262;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_32218){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_32218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___32246))
})();
var state__19298__auto__ = (function (){var statearr_32241 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32241[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___32246);

return statearr_32241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___32246))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__32450){
var vec__32451 = p__32450;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32451,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32451,(1),null);
var job = vec__32451;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__19296__auto___32637 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___32637,res,vec__32451,v,p,job,jobs,results){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___32637,res,vec__32451,v,p,job,jobs,results){
return (function (state_32458){
var state_val_32459 = (state_32458[(1)]);
if((state_val_32459 === (1))){
var state_32458__$1 = state_32458;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32458__$1,(2),res,v);
} else {
if((state_val_32459 === (2))){
var inst_32455 = (state_32458[(2)]);
var inst_32456 = cljs.core.async.close_BANG_(res);
var state_32458__$1 = (function (){var statearr_32460 = state_32458;
(statearr_32460[(7)] = inst_32455);

return statearr_32460;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32458__$1,inst_32456);
} else {
return null;
}
}
});})(c__19296__auto___32637,res,vec__32451,v,p,job,jobs,results))
;
return ((function (switch__19184__auto__,c__19296__auto___32637,res,vec__32451,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0 = (function (){
var statearr_32464 = [null,null,null,null,null,null,null,null];
(statearr_32464[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__);

(statearr_32464[(1)] = (1));

return statearr_32464;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1 = (function (state_32458){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32458);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32465){if((e32465 instanceof Object)){
var ex__19188__auto__ = e32465;
var statearr_32466_32638 = state_32458;
(statearr_32466_32638[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32458);

return cljs.core.cst$kw$recur;
} else {
throw e32465;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32639 = state_32458;
state_32458 = G__32639;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = function(state_32458){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1.call(this,state_32458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___32637,res,vec__32451,v,p,job,jobs,results))
})();
var state__19298__auto__ = (function (){var statearr_32467 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32467[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___32637);

return statearr_32467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___32637,res,vec__32451,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__32468){
var vec__32469 = p__32468;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32469,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32469,(1),null);
var job = vec__32469;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___32640 = n;
var __32641 = (0);
while(true){
if((__32641 < n__7461__auto___32640)){
var G__32472_32642 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__32472_32642) {
case "compute":
var c__19296__auto___32644 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32641,c__19296__auto___32644,G__32472_32642,n__7461__auto___32640,jobs,results,process,async){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (__32641,c__19296__auto___32644,G__32472_32642,n__7461__auto___32640,jobs,results,process,async){
return (function (state_32485){
var state_val_32486 = (state_32485[(1)]);
if((state_val_32486 === (1))){
var state_32485__$1 = state_32485;
var statearr_32487_32645 = state_32485__$1;
(statearr_32487_32645[(2)] = null);

(statearr_32487_32645[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32486 === (2))){
var state_32485__$1 = state_32485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32485__$1,(4),jobs);
} else {
if((state_val_32486 === (3))){
var inst_32483 = (state_32485[(2)]);
var state_32485__$1 = state_32485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32485__$1,inst_32483);
} else {
if((state_val_32486 === (4))){
var inst_32475 = (state_32485[(2)]);
var inst_32476 = process(inst_32475);
var state_32485__$1 = state_32485;
if(cljs.core.truth_(inst_32476)){
var statearr_32488_32646 = state_32485__$1;
(statearr_32488_32646[(1)] = (5));

} else {
var statearr_32489_32647 = state_32485__$1;
(statearr_32489_32647[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32486 === (5))){
var state_32485__$1 = state_32485;
var statearr_32490_32648 = state_32485__$1;
(statearr_32490_32648[(2)] = null);

(statearr_32490_32648[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32486 === (6))){
var state_32485__$1 = state_32485;
var statearr_32491_32649 = state_32485__$1;
(statearr_32491_32649[(2)] = null);

(statearr_32491_32649[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32486 === (7))){
var inst_32481 = (state_32485[(2)]);
var state_32485__$1 = state_32485;
var statearr_32492_32650 = state_32485__$1;
(statearr_32492_32650[(2)] = inst_32481);

(statearr_32492_32650[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32641,c__19296__auto___32644,G__32472_32642,n__7461__auto___32640,jobs,results,process,async))
;
return ((function (__32641,switch__19184__auto__,c__19296__auto___32644,G__32472_32642,n__7461__auto___32640,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0 = (function (){
var statearr_32496 = [null,null,null,null,null,null,null];
(statearr_32496[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__);

(statearr_32496[(1)] = (1));

return statearr_32496;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1 = (function (state_32485){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32485);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32497){if((e32497 instanceof Object)){
var ex__19188__auto__ = e32497;
var statearr_32498_32651 = state_32485;
(statearr_32498_32651[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32485);

return cljs.core.cst$kw$recur;
} else {
throw e32497;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32652 = state_32485;
state_32485 = G__32652;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = function(state_32485){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1.call(this,state_32485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__;
})()
;})(__32641,switch__19184__auto__,c__19296__auto___32644,G__32472_32642,n__7461__auto___32640,jobs,results,process,async))
})();
var state__19298__auto__ = (function (){var statearr_32499 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32499[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___32644);

return statearr_32499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(__32641,c__19296__auto___32644,G__32472_32642,n__7461__auto___32640,jobs,results,process,async))
);


break;
case "async":
var c__19296__auto___32653 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32641,c__19296__auto___32653,G__32472_32642,n__7461__auto___32640,jobs,results,process,async){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (__32641,c__19296__auto___32653,G__32472_32642,n__7461__auto___32640,jobs,results,process,async){
return (function (state_32512){
var state_val_32513 = (state_32512[(1)]);
if((state_val_32513 === (1))){
var state_32512__$1 = state_32512;
var statearr_32514_32654 = state_32512__$1;
(statearr_32514_32654[(2)] = null);

(statearr_32514_32654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32513 === (2))){
var state_32512__$1 = state_32512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32512__$1,(4),jobs);
} else {
if((state_val_32513 === (3))){
var inst_32510 = (state_32512[(2)]);
var state_32512__$1 = state_32512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32512__$1,inst_32510);
} else {
if((state_val_32513 === (4))){
var inst_32502 = (state_32512[(2)]);
var inst_32503 = async(inst_32502);
var state_32512__$1 = state_32512;
if(cljs.core.truth_(inst_32503)){
var statearr_32515_32655 = state_32512__$1;
(statearr_32515_32655[(1)] = (5));

} else {
var statearr_32516_32656 = state_32512__$1;
(statearr_32516_32656[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32513 === (5))){
var state_32512__$1 = state_32512;
var statearr_32517_32657 = state_32512__$1;
(statearr_32517_32657[(2)] = null);

(statearr_32517_32657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32513 === (6))){
var state_32512__$1 = state_32512;
var statearr_32518_32658 = state_32512__$1;
(statearr_32518_32658[(2)] = null);

(statearr_32518_32658[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32513 === (7))){
var inst_32508 = (state_32512[(2)]);
var state_32512__$1 = state_32512;
var statearr_32519_32659 = state_32512__$1;
(statearr_32519_32659[(2)] = inst_32508);

(statearr_32519_32659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32641,c__19296__auto___32653,G__32472_32642,n__7461__auto___32640,jobs,results,process,async))
;
return ((function (__32641,switch__19184__auto__,c__19296__auto___32653,G__32472_32642,n__7461__auto___32640,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0 = (function (){
var statearr_32523 = [null,null,null,null,null,null,null];
(statearr_32523[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__);

(statearr_32523[(1)] = (1));

return statearr_32523;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1 = (function (state_32512){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32512);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32524){if((e32524 instanceof Object)){
var ex__19188__auto__ = e32524;
var statearr_32525_32660 = state_32512;
(statearr_32525_32660[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32512);

return cljs.core.cst$kw$recur;
} else {
throw e32524;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32661 = state_32512;
state_32512 = G__32661;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = function(state_32512){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1.call(this,state_32512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__;
})()
;})(__32641,switch__19184__auto__,c__19296__auto___32653,G__32472_32642,n__7461__auto___32640,jobs,results,process,async))
})();
var state__19298__auto__ = (function (){var statearr_32526 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32526[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___32653);

return statearr_32526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(__32641,c__19296__auto___32653,G__32472_32642,n__7461__auto___32640,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__32662 = (__32641 + (1));
__32641 = G__32662;
continue;
} else {
}
break;
}

var c__19296__auto___32663 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___32663,jobs,results,process,async){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___32663,jobs,results,process,async){
return (function (state_32548){
var state_val_32549 = (state_32548[(1)]);
if((state_val_32549 === (1))){
var state_32548__$1 = state_32548;
var statearr_32550_32664 = state_32548__$1;
(statearr_32550_32664[(2)] = null);

(statearr_32550_32664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32549 === (2))){
var state_32548__$1 = state_32548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32548__$1,(4),from);
} else {
if((state_val_32549 === (3))){
var inst_32546 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32548__$1,inst_32546);
} else {
if((state_val_32549 === (4))){
var inst_32529 = (state_32548[(7)]);
var inst_32529__$1 = (state_32548[(2)]);
var inst_32530 = (inst_32529__$1 == null);
var state_32548__$1 = (function (){var statearr_32551 = state_32548;
(statearr_32551[(7)] = inst_32529__$1);

return statearr_32551;
})();
if(cljs.core.truth_(inst_32530)){
var statearr_32552_32665 = state_32548__$1;
(statearr_32552_32665[(1)] = (5));

} else {
var statearr_32553_32666 = state_32548__$1;
(statearr_32553_32666[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32549 === (5))){
var inst_32532 = cljs.core.async.close_BANG_(jobs);
var state_32548__$1 = state_32548;
var statearr_32554_32667 = state_32548__$1;
(statearr_32554_32667[(2)] = inst_32532);

(statearr_32554_32667[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32549 === (6))){
var inst_32534 = (state_32548[(8)]);
var inst_32529 = (state_32548[(7)]);
var inst_32534__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_32535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32536 = [inst_32529,inst_32534__$1];
var inst_32537 = (new cljs.core.PersistentVector(null,2,(5),inst_32535,inst_32536,null));
var state_32548__$1 = (function (){var statearr_32555 = state_32548;
(statearr_32555[(8)] = inst_32534__$1);

return statearr_32555;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32548__$1,(8),jobs,inst_32537);
} else {
if((state_val_32549 === (7))){
var inst_32544 = (state_32548[(2)]);
var state_32548__$1 = state_32548;
var statearr_32556_32668 = state_32548__$1;
(statearr_32556_32668[(2)] = inst_32544);

(statearr_32556_32668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32549 === (8))){
var inst_32534 = (state_32548[(8)]);
var inst_32539 = (state_32548[(2)]);
var state_32548__$1 = (function (){var statearr_32557 = state_32548;
(statearr_32557[(9)] = inst_32539);

return statearr_32557;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32548__$1,(9),results,inst_32534);
} else {
if((state_val_32549 === (9))){
var inst_32541 = (state_32548[(2)]);
var state_32548__$1 = (function (){var statearr_32558 = state_32548;
(statearr_32558[(10)] = inst_32541);

return statearr_32558;
})();
var statearr_32559_32669 = state_32548__$1;
(statearr_32559_32669[(2)] = null);

(statearr_32559_32669[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___32663,jobs,results,process,async))
;
return ((function (switch__19184__auto__,c__19296__auto___32663,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0 = (function (){
var statearr_32563 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32563[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__);

(statearr_32563[(1)] = (1));

return statearr_32563;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1 = (function (state_32548){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32548);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32564){if((e32564 instanceof Object)){
var ex__19188__auto__ = e32564;
var statearr_32565_32670 = state_32548;
(statearr_32565_32670[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32548);

return cljs.core.cst$kw$recur;
} else {
throw e32564;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32671 = state_32548;
state_32548 = G__32671;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = function(state_32548){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1.call(this,state_32548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___32663,jobs,results,process,async))
})();
var state__19298__auto__ = (function (){var statearr_32566 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32566[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___32663);

return statearr_32566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___32663,jobs,results,process,async))
);


var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__,jobs,results,process,async){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__,jobs,results,process,async){
return (function (state_32604){
var state_val_32605 = (state_32604[(1)]);
if((state_val_32605 === (7))){
var inst_32600 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32606_32672 = state_32604__$1;
(statearr_32606_32672[(2)] = inst_32600);

(statearr_32606_32672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (20))){
var state_32604__$1 = state_32604;
var statearr_32607_32673 = state_32604__$1;
(statearr_32607_32673[(2)] = null);

(statearr_32607_32673[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (1))){
var state_32604__$1 = state_32604;
var statearr_32608_32674 = state_32604__$1;
(statearr_32608_32674[(2)] = null);

(statearr_32608_32674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (4))){
var inst_32569 = (state_32604[(7)]);
var inst_32569__$1 = (state_32604[(2)]);
var inst_32570 = (inst_32569__$1 == null);
var state_32604__$1 = (function (){var statearr_32609 = state_32604;
(statearr_32609[(7)] = inst_32569__$1);

return statearr_32609;
})();
if(cljs.core.truth_(inst_32570)){
var statearr_32610_32675 = state_32604__$1;
(statearr_32610_32675[(1)] = (5));

} else {
var statearr_32611_32676 = state_32604__$1;
(statearr_32611_32676[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (15))){
var inst_32582 = (state_32604[(8)]);
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32604__$1,(18),to,inst_32582);
} else {
if((state_val_32605 === (21))){
var inst_32595 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32612_32677 = state_32604__$1;
(statearr_32612_32677[(2)] = inst_32595);

(statearr_32612_32677[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (13))){
var inst_32597 = (state_32604[(2)]);
var state_32604__$1 = (function (){var statearr_32613 = state_32604;
(statearr_32613[(9)] = inst_32597);

return statearr_32613;
})();
var statearr_32614_32678 = state_32604__$1;
(statearr_32614_32678[(2)] = null);

(statearr_32614_32678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (6))){
var inst_32569 = (state_32604[(7)]);
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32604__$1,(11),inst_32569);
} else {
if((state_val_32605 === (17))){
var inst_32590 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
if(cljs.core.truth_(inst_32590)){
var statearr_32615_32679 = state_32604__$1;
(statearr_32615_32679[(1)] = (19));

} else {
var statearr_32616_32680 = state_32604__$1;
(statearr_32616_32680[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (3))){
var inst_32602 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32604__$1,inst_32602);
} else {
if((state_val_32605 === (12))){
var inst_32579 = (state_32604[(10)]);
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32604__$1,(14),inst_32579);
} else {
if((state_val_32605 === (2))){
var state_32604__$1 = state_32604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32604__$1,(4),results);
} else {
if((state_val_32605 === (19))){
var state_32604__$1 = state_32604;
var statearr_32617_32681 = state_32604__$1;
(statearr_32617_32681[(2)] = null);

(statearr_32617_32681[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (11))){
var inst_32579 = (state_32604[(2)]);
var state_32604__$1 = (function (){var statearr_32618 = state_32604;
(statearr_32618[(10)] = inst_32579);

return statearr_32618;
})();
var statearr_32619_32682 = state_32604__$1;
(statearr_32619_32682[(2)] = null);

(statearr_32619_32682[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (9))){
var state_32604__$1 = state_32604;
var statearr_32620_32683 = state_32604__$1;
(statearr_32620_32683[(2)] = null);

(statearr_32620_32683[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (5))){
var state_32604__$1 = state_32604;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32621_32684 = state_32604__$1;
(statearr_32621_32684[(1)] = (8));

} else {
var statearr_32622_32685 = state_32604__$1;
(statearr_32622_32685[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (14))){
var inst_32584 = (state_32604[(11)]);
var inst_32582 = (state_32604[(8)]);
var inst_32582__$1 = (state_32604[(2)]);
var inst_32583 = (inst_32582__$1 == null);
var inst_32584__$1 = cljs.core.not(inst_32583);
var state_32604__$1 = (function (){var statearr_32623 = state_32604;
(statearr_32623[(11)] = inst_32584__$1);

(statearr_32623[(8)] = inst_32582__$1);

return statearr_32623;
})();
if(inst_32584__$1){
var statearr_32624_32686 = state_32604__$1;
(statearr_32624_32686[(1)] = (15));

} else {
var statearr_32625_32687 = state_32604__$1;
(statearr_32625_32687[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (16))){
var inst_32584 = (state_32604[(11)]);
var state_32604__$1 = state_32604;
var statearr_32626_32688 = state_32604__$1;
(statearr_32626_32688[(2)] = inst_32584);

(statearr_32626_32688[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (10))){
var inst_32576 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32627_32689 = state_32604__$1;
(statearr_32627_32689[(2)] = inst_32576);

(statearr_32627_32689[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (18))){
var inst_32587 = (state_32604[(2)]);
var state_32604__$1 = state_32604;
var statearr_32628_32690 = state_32604__$1;
(statearr_32628_32690[(2)] = inst_32587);

(statearr_32628_32690[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32605 === (8))){
var inst_32573 = cljs.core.async.close_BANG_(to);
var state_32604__$1 = state_32604;
var statearr_32629_32691 = state_32604__$1;
(statearr_32629_32691[(2)] = inst_32573);

(statearr_32629_32691[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto__,jobs,results,process,async))
;
return ((function (switch__19184__auto__,c__19296__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0 = (function (){
var statearr_32633 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32633[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__);

(statearr_32633[(1)] = (1));

return statearr_32633;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1 = (function (state_32604){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32604);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32634){if((e32634 instanceof Object)){
var ex__19188__auto__ = e32634;
var statearr_32635_32692 = state_32604;
(statearr_32635_32692[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32604);

return cljs.core.cst$kw$recur;
} else {
throw e32634;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32693 = state_32604;
state_32604 = G__32693;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__ = function(state_32604){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1.call(this,state_32604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19185__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__,jobs,results,process,async))
})();
var state__19298__auto__ = (function (){var statearr_32636 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_32636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__,jobs,results,process,async))
);

return c__19296__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args32694 = [];
var len__7651__auto___32697 = arguments.length;
var i__7652__auto___32698 = (0);
while(true){
if((i__7652__auto___32698 < len__7651__auto___32697)){
args32694.push((arguments[i__7652__auto___32698]));

var G__32699 = (i__7652__auto___32698 + (1));
i__7652__auto___32698 = G__32699;
continue;
} else {
}
break;
}

var G__32696 = args32694.length;
switch (G__32696) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32694.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args32701 = [];
var len__7651__auto___32704 = arguments.length;
var i__7652__auto___32705 = (0);
while(true){
if((i__7652__auto___32705 < len__7651__auto___32704)){
args32701.push((arguments[i__7652__auto___32705]));

var G__32706 = (i__7652__auto___32705 + (1));
i__7652__auto___32705 = G__32706;
continue;
} else {
}
break;
}

var G__32703 = args32701.length;
switch (G__32703) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32701.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args32708 = [];
var len__7651__auto___32761 = arguments.length;
var i__7652__auto___32762 = (0);
while(true){
if((i__7652__auto___32762 < len__7651__auto___32761)){
args32708.push((arguments[i__7652__auto___32762]));

var G__32763 = (i__7652__auto___32762 + (1));
i__7652__auto___32762 = G__32763;
continue;
} else {
}
break;
}

var G__32710 = args32708.length;
switch (G__32710) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32708.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__19296__auto___32765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___32765,tc,fc){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___32765,tc,fc){
return (function (state_32736){
var state_val_32737 = (state_32736[(1)]);
if((state_val_32737 === (7))){
var inst_32732 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
var statearr_32738_32766 = state_32736__$1;
(statearr_32738_32766[(2)] = inst_32732);

(statearr_32738_32766[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (1))){
var state_32736__$1 = state_32736;
var statearr_32739_32767 = state_32736__$1;
(statearr_32739_32767[(2)] = null);

(statearr_32739_32767[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (4))){
var inst_32713 = (state_32736[(7)]);
var inst_32713__$1 = (state_32736[(2)]);
var inst_32714 = (inst_32713__$1 == null);
var state_32736__$1 = (function (){var statearr_32740 = state_32736;
(statearr_32740[(7)] = inst_32713__$1);

return statearr_32740;
})();
if(cljs.core.truth_(inst_32714)){
var statearr_32741_32768 = state_32736__$1;
(statearr_32741_32768[(1)] = (5));

} else {
var statearr_32742_32769 = state_32736__$1;
(statearr_32742_32769[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (13))){
var state_32736__$1 = state_32736;
var statearr_32743_32770 = state_32736__$1;
(statearr_32743_32770[(2)] = null);

(statearr_32743_32770[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (6))){
var inst_32713 = (state_32736[(7)]);
var inst_32719 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32713) : p.call(null,inst_32713));
var state_32736__$1 = state_32736;
if(cljs.core.truth_(inst_32719)){
var statearr_32744_32771 = state_32736__$1;
(statearr_32744_32771[(1)] = (9));

} else {
var statearr_32745_32772 = state_32736__$1;
(statearr_32745_32772[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (3))){
var inst_32734 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32736__$1,inst_32734);
} else {
if((state_val_32737 === (12))){
var state_32736__$1 = state_32736;
var statearr_32746_32773 = state_32736__$1;
(statearr_32746_32773[(2)] = null);

(statearr_32746_32773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (2))){
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32736__$1,(4),ch);
} else {
if((state_val_32737 === (11))){
var inst_32713 = (state_32736[(7)]);
var inst_32723 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32736__$1,(8),inst_32723,inst_32713);
} else {
if((state_val_32737 === (9))){
var state_32736__$1 = state_32736;
var statearr_32747_32774 = state_32736__$1;
(statearr_32747_32774[(2)] = tc);

(statearr_32747_32774[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (5))){
var inst_32716 = cljs.core.async.close_BANG_(tc);
var inst_32717 = cljs.core.async.close_BANG_(fc);
var state_32736__$1 = (function (){var statearr_32748 = state_32736;
(statearr_32748[(8)] = inst_32716);

return statearr_32748;
})();
var statearr_32749_32775 = state_32736__$1;
(statearr_32749_32775[(2)] = inst_32717);

(statearr_32749_32775[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (14))){
var inst_32730 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
var statearr_32750_32776 = state_32736__$1;
(statearr_32750_32776[(2)] = inst_32730);

(statearr_32750_32776[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (10))){
var state_32736__$1 = state_32736;
var statearr_32751_32777 = state_32736__$1;
(statearr_32751_32777[(2)] = fc);

(statearr_32751_32777[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32737 === (8))){
var inst_32725 = (state_32736[(2)]);
var state_32736__$1 = state_32736;
if(cljs.core.truth_(inst_32725)){
var statearr_32752_32778 = state_32736__$1;
(statearr_32752_32778[(1)] = (12));

} else {
var statearr_32753_32779 = state_32736__$1;
(statearr_32753_32779[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___32765,tc,fc))
;
return ((function (switch__19184__auto__,c__19296__auto___32765,tc,fc){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_32757 = [null,null,null,null,null,null,null,null,null];
(statearr_32757[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_32757[(1)] = (1));

return statearr_32757;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_32736){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32736);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32758){if((e32758 instanceof Object)){
var ex__19188__auto__ = e32758;
var statearr_32759_32780 = state_32736;
(statearr_32759_32780[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32736);

return cljs.core.cst$kw$recur;
} else {
throw e32758;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32781 = state_32736;
state_32736 = G__32781;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_32736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_32736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___32765,tc,fc))
})();
var state__19298__auto__ = (function (){var statearr_32760 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___32765);

return statearr_32760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___32765,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__){
return (function (state_32845){
var state_val_32846 = (state_32845[(1)]);
if((state_val_32846 === (7))){
var inst_32841 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32847_32868 = state_32845__$1;
(statearr_32847_32868[(2)] = inst_32841);

(statearr_32847_32868[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (1))){
var inst_32825 = init;
var state_32845__$1 = (function (){var statearr_32848 = state_32845;
(statearr_32848[(7)] = inst_32825);

return statearr_32848;
})();
var statearr_32849_32869 = state_32845__$1;
(statearr_32849_32869[(2)] = null);

(statearr_32849_32869[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (4))){
var inst_32828 = (state_32845[(8)]);
var inst_32828__$1 = (state_32845[(2)]);
var inst_32829 = (inst_32828__$1 == null);
var state_32845__$1 = (function (){var statearr_32850 = state_32845;
(statearr_32850[(8)] = inst_32828__$1);

return statearr_32850;
})();
if(cljs.core.truth_(inst_32829)){
var statearr_32851_32870 = state_32845__$1;
(statearr_32851_32870[(1)] = (5));

} else {
var statearr_32852_32871 = state_32845__$1;
(statearr_32852_32871[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (6))){
var inst_32832 = (state_32845[(9)]);
var inst_32825 = (state_32845[(7)]);
var inst_32828 = (state_32845[(8)]);
var inst_32832__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32825,inst_32828) : f.call(null,inst_32825,inst_32828));
var inst_32833 = cljs.core.reduced_QMARK_(inst_32832__$1);
var state_32845__$1 = (function (){var statearr_32853 = state_32845;
(statearr_32853[(9)] = inst_32832__$1);

return statearr_32853;
})();
if(inst_32833){
var statearr_32854_32872 = state_32845__$1;
(statearr_32854_32872[(1)] = (8));

} else {
var statearr_32855_32873 = state_32845__$1;
(statearr_32855_32873[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (3))){
var inst_32843 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32845__$1,inst_32843);
} else {
if((state_val_32846 === (2))){
var state_32845__$1 = state_32845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32845__$1,(4),ch);
} else {
if((state_val_32846 === (9))){
var inst_32832 = (state_32845[(9)]);
var inst_32825 = inst_32832;
var state_32845__$1 = (function (){var statearr_32856 = state_32845;
(statearr_32856[(7)] = inst_32825);

return statearr_32856;
})();
var statearr_32857_32874 = state_32845__$1;
(statearr_32857_32874[(2)] = null);

(statearr_32857_32874[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (5))){
var inst_32825 = (state_32845[(7)]);
var state_32845__$1 = state_32845;
var statearr_32858_32875 = state_32845__$1;
(statearr_32858_32875[(2)] = inst_32825);

(statearr_32858_32875[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (10))){
var inst_32839 = (state_32845[(2)]);
var state_32845__$1 = state_32845;
var statearr_32859_32876 = state_32845__$1;
(statearr_32859_32876[(2)] = inst_32839);

(statearr_32859_32876[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32846 === (8))){
var inst_32832 = (state_32845[(9)]);
var inst_32835 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_32832) : cljs.core.deref.call(null,inst_32832));
var state_32845__$1 = state_32845;
var statearr_32860_32877 = state_32845__$1;
(statearr_32860_32877[(2)] = inst_32835);

(statearr_32860_32877[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto__))
;
return ((function (switch__19184__auto__,c__19296__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__19185__auto__ = null;
var cljs$core$async$reduce_$_state_machine__19185__auto____0 = (function (){
var statearr_32864 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32864[(0)] = cljs$core$async$reduce_$_state_machine__19185__auto__);

(statearr_32864[(1)] = (1));

return statearr_32864;
});
var cljs$core$async$reduce_$_state_machine__19185__auto____1 = (function (state_32845){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32845);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32865){if((e32865 instanceof Object)){
var ex__19188__auto__ = e32865;
var statearr_32866_32878 = state_32845;
(statearr_32866_32878[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32845);

return cljs.core.cst$kw$recur;
} else {
throw e32865;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32879 = state_32845;
state_32845 = G__32879;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__19185__auto__ = function(state_32845){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__19185__auto____1.call(this,state_32845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__19185__auto____0;
cljs$core$async$reduce_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__19185__auto____1;
return cljs$core$async$reduce_$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__))
})();
var state__19298__auto__ = (function (){var statearr_32867 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32867[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_32867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__))
);

return c__19296__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__,f__$1){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__,f__$1){
return (function (state_32899){
var state_val_32900 = (state_32899[(1)]);
if((state_val_32900 === (1))){
var inst_32894 = cljs.core.async.reduce(f__$1,init,ch);
var state_32899__$1 = state_32899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32899__$1,(2),inst_32894);
} else {
if((state_val_32900 === (2))){
var inst_32896 = (state_32899[(2)]);
var inst_32897 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32896) : f__$1.call(null,inst_32896));
var state_32899__$1 = state_32899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32899__$1,inst_32897);
} else {
return null;
}
}
});})(c__19296__auto__,f__$1))
;
return ((function (switch__19184__auto__,c__19296__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__19185__auto__ = null;
var cljs$core$async$transduce_$_state_machine__19185__auto____0 = (function (){
var statearr_32904 = [null,null,null,null,null,null,null];
(statearr_32904[(0)] = cljs$core$async$transduce_$_state_machine__19185__auto__);

(statearr_32904[(1)] = (1));

return statearr_32904;
});
var cljs$core$async$transduce_$_state_machine__19185__auto____1 = (function (state_32899){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32899);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32905){if((e32905 instanceof Object)){
var ex__19188__auto__ = e32905;
var statearr_32906_32908 = state_32899;
(statearr_32906_32908[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32899);

return cljs.core.cst$kw$recur;
} else {
throw e32905;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32909 = state_32899;
state_32899 = G__32909;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__19185__auto__ = function(state_32899){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__19185__auto____1.call(this,state_32899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__19185__auto____0;
cljs$core$async$transduce_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__19185__auto____1;
return cljs$core$async$transduce_$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__,f__$1))
})();
var state__19298__auto__ = (function (){var statearr_32907 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32907[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_32907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__,f__$1))
);

return c__19296__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32910 = [];
var len__7651__auto___32962 = arguments.length;
var i__7652__auto___32963 = (0);
while(true){
if((i__7652__auto___32963 < len__7651__auto___32962)){
args32910.push((arguments[i__7652__auto___32963]));

var G__32964 = (i__7652__auto___32963 + (1));
i__7652__auto___32963 = G__32964;
continue;
} else {
}
break;
}

var G__32912 = args32910.length;
switch (G__32912) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32910.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__){
return (function (state_32937){
var state_val_32938 = (state_32937[(1)]);
if((state_val_32938 === (7))){
var inst_32919 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
var statearr_32939_32966 = state_32937__$1;
(statearr_32939_32966[(2)] = inst_32919);

(statearr_32939_32966[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (1))){
var inst_32913 = cljs.core.seq(coll);
var inst_32914 = inst_32913;
var state_32937__$1 = (function (){var statearr_32940 = state_32937;
(statearr_32940[(7)] = inst_32914);

return statearr_32940;
})();
var statearr_32941_32967 = state_32937__$1;
(statearr_32941_32967[(2)] = null);

(statearr_32941_32967[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (4))){
var inst_32914 = (state_32937[(7)]);
var inst_32917 = cljs.core.first(inst_32914);
var state_32937__$1 = state_32937;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32937__$1,(7),ch,inst_32917);
} else {
if((state_val_32938 === (13))){
var inst_32931 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
var statearr_32942_32968 = state_32937__$1;
(statearr_32942_32968[(2)] = inst_32931);

(statearr_32942_32968[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (6))){
var inst_32922 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
if(cljs.core.truth_(inst_32922)){
var statearr_32943_32969 = state_32937__$1;
(statearr_32943_32969[(1)] = (8));

} else {
var statearr_32944_32970 = state_32937__$1;
(statearr_32944_32970[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (3))){
var inst_32935 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32937__$1,inst_32935);
} else {
if((state_val_32938 === (12))){
var state_32937__$1 = state_32937;
var statearr_32945_32971 = state_32937__$1;
(statearr_32945_32971[(2)] = null);

(statearr_32945_32971[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (2))){
var inst_32914 = (state_32937[(7)]);
var state_32937__$1 = state_32937;
if(cljs.core.truth_(inst_32914)){
var statearr_32946_32972 = state_32937__$1;
(statearr_32946_32972[(1)] = (4));

} else {
var statearr_32947_32973 = state_32937__$1;
(statearr_32947_32973[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (11))){
var inst_32928 = cljs.core.async.close_BANG_(ch);
var state_32937__$1 = state_32937;
var statearr_32948_32974 = state_32937__$1;
(statearr_32948_32974[(2)] = inst_32928);

(statearr_32948_32974[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (9))){
var state_32937__$1 = state_32937;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32949_32975 = state_32937__$1;
(statearr_32949_32975[(1)] = (11));

} else {
var statearr_32950_32976 = state_32937__$1;
(statearr_32950_32976[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (5))){
var inst_32914 = (state_32937[(7)]);
var state_32937__$1 = state_32937;
var statearr_32951_32977 = state_32937__$1;
(statearr_32951_32977[(2)] = inst_32914);

(statearr_32951_32977[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (10))){
var inst_32933 = (state_32937[(2)]);
var state_32937__$1 = state_32937;
var statearr_32952_32978 = state_32937__$1;
(statearr_32952_32978[(2)] = inst_32933);

(statearr_32952_32978[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32938 === (8))){
var inst_32914 = (state_32937[(7)]);
var inst_32924 = cljs.core.next(inst_32914);
var inst_32914__$1 = inst_32924;
var state_32937__$1 = (function (){var statearr_32953 = state_32937;
(statearr_32953[(7)] = inst_32914__$1);

return statearr_32953;
})();
var statearr_32954_32979 = state_32937__$1;
(statearr_32954_32979[(2)] = null);

(statearr_32954_32979[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto__))
;
return ((function (switch__19184__auto__,c__19296__auto__){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_32958 = [null,null,null,null,null,null,null,null];
(statearr_32958[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_32958[(1)] = (1));

return statearr_32958;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_32937){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_32937);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e32959){if((e32959 instanceof Object)){
var ex__19188__auto__ = e32959;
var statearr_32960_32980 = state_32937;
(statearr_32960_32980[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32937);

return cljs.core.cst$kw$recur;
} else {
throw e32959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__32981 = state_32937;
state_32937 = G__32981;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_32937){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_32937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__))
})();
var state__19298__auto__ = (function (){var statearr_32961 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_32961[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_32961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__))
);

return c__19296__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto__.call(null,_));
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__33210 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33210) : cljs.core.atom.call(null,G__33210));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33211 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33211 = (function (ch,cs,meta33212){
this.ch = ch;
this.cs = cs;
this.meta33212 = meta33212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_33213,meta33212__$1){
var self__ = this;
var _33213__$1 = this;
return (new cljs.core.async.t_cljs$core$async33211(self__.ch,self__.cs,meta33212__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_33213){
var self__ = this;
var _33213__$1 = this;
return self__.meta33212;
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33214_33438 = self__.cs;
var G__33215_33439 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33214_33438,G__33215_33439) : cljs.core.reset_BANG_.call(null,G__33214_33438,G__33215_33439));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta33212], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async33211.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33211";

cljs.core.async.t_cljs$core$async33211.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33211");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async33211 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async33211(ch__$1,cs__$1,meta33212){
return (new cljs.core.async.t_cljs$core$async33211(ch__$1,cs__$1,meta33212));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async33211(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19296__auto___33440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___33440,cs,m,dchan,dctr,done){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___33440,cs,m,dchan,dctr,done){
return (function (state_33350){
var state_val_33351 = (state_33350[(1)]);
if((state_val_33351 === (7))){
var inst_33346 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33352_33441 = state_33350__$1;
(statearr_33352_33441[(2)] = inst_33346);

(statearr_33352_33441[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (20))){
var inst_33249 = (state_33350[(7)]);
var inst_33261 = cljs.core.first(inst_33249);
var inst_33262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33261,(0),null);
var inst_33263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33261,(1),null);
var state_33350__$1 = (function (){var statearr_33353 = state_33350;
(statearr_33353[(8)] = inst_33262);

return statearr_33353;
})();
if(cljs.core.truth_(inst_33263)){
var statearr_33354_33442 = state_33350__$1;
(statearr_33354_33442[(1)] = (22));

} else {
var statearr_33355_33443 = state_33350__$1;
(statearr_33355_33443[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (27))){
var inst_33298 = (state_33350[(9)]);
var inst_33291 = (state_33350[(10)]);
var inst_33218 = (state_33350[(11)]);
var inst_33293 = (state_33350[(12)]);
var inst_33298__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33291,inst_33293);
var inst_33299 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33298__$1,inst_33218,done);
var state_33350__$1 = (function (){var statearr_33356 = state_33350;
(statearr_33356[(9)] = inst_33298__$1);

return statearr_33356;
})();
if(cljs.core.truth_(inst_33299)){
var statearr_33357_33444 = state_33350__$1;
(statearr_33357_33444[(1)] = (30));

} else {
var statearr_33358_33445 = state_33350__$1;
(statearr_33358_33445[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (1))){
var state_33350__$1 = state_33350;
var statearr_33359_33446 = state_33350__$1;
(statearr_33359_33446[(2)] = null);

(statearr_33359_33446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (24))){
var inst_33249 = (state_33350[(7)]);
var inst_33268 = (state_33350[(2)]);
var inst_33269 = cljs.core.next(inst_33249);
var inst_33227 = inst_33269;
var inst_33228 = null;
var inst_33229 = (0);
var inst_33230 = (0);
var state_33350__$1 = (function (){var statearr_33360 = state_33350;
(statearr_33360[(13)] = inst_33229);

(statearr_33360[(14)] = inst_33227);

(statearr_33360[(15)] = inst_33230);

(statearr_33360[(16)] = inst_33228);

(statearr_33360[(17)] = inst_33268);

return statearr_33360;
})();
var statearr_33361_33447 = state_33350__$1;
(statearr_33361_33447[(2)] = null);

(statearr_33361_33447[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (39))){
var state_33350__$1 = state_33350;
var statearr_33365_33448 = state_33350__$1;
(statearr_33365_33448[(2)] = null);

(statearr_33365_33448[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (4))){
var inst_33218 = (state_33350[(11)]);
var inst_33218__$1 = (state_33350[(2)]);
var inst_33219 = (inst_33218__$1 == null);
var state_33350__$1 = (function (){var statearr_33366 = state_33350;
(statearr_33366[(11)] = inst_33218__$1);

return statearr_33366;
})();
if(cljs.core.truth_(inst_33219)){
var statearr_33367_33449 = state_33350__$1;
(statearr_33367_33449[(1)] = (5));

} else {
var statearr_33368_33450 = state_33350__$1;
(statearr_33368_33450[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (15))){
var inst_33229 = (state_33350[(13)]);
var inst_33227 = (state_33350[(14)]);
var inst_33230 = (state_33350[(15)]);
var inst_33228 = (state_33350[(16)]);
var inst_33245 = (state_33350[(2)]);
var inst_33246 = (inst_33230 + (1));
var tmp33362 = inst_33229;
var tmp33363 = inst_33227;
var tmp33364 = inst_33228;
var inst_33227__$1 = tmp33363;
var inst_33228__$1 = tmp33364;
var inst_33229__$1 = tmp33362;
var inst_33230__$1 = inst_33246;
var state_33350__$1 = (function (){var statearr_33369 = state_33350;
(statearr_33369[(13)] = inst_33229__$1);

(statearr_33369[(14)] = inst_33227__$1);

(statearr_33369[(15)] = inst_33230__$1);

(statearr_33369[(16)] = inst_33228__$1);

(statearr_33369[(18)] = inst_33245);

return statearr_33369;
})();
var statearr_33370_33451 = state_33350__$1;
(statearr_33370_33451[(2)] = null);

(statearr_33370_33451[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (21))){
var inst_33272 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33374_33452 = state_33350__$1;
(statearr_33374_33452[(2)] = inst_33272);

(statearr_33374_33452[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (31))){
var inst_33298 = (state_33350[(9)]);
var inst_33302 = done(null);
var inst_33303 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_33298);
var state_33350__$1 = (function (){var statearr_33375 = state_33350;
(statearr_33375[(19)] = inst_33302);

return statearr_33375;
})();
var statearr_33376_33453 = state_33350__$1;
(statearr_33376_33453[(2)] = inst_33303);

(statearr_33376_33453[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (32))){
var inst_33292 = (state_33350[(20)]);
var inst_33291 = (state_33350[(10)]);
var inst_33290 = (state_33350[(21)]);
var inst_33293 = (state_33350[(12)]);
var inst_33305 = (state_33350[(2)]);
var inst_33306 = (inst_33293 + (1));
var tmp33371 = inst_33292;
var tmp33372 = inst_33291;
var tmp33373 = inst_33290;
var inst_33290__$1 = tmp33373;
var inst_33291__$1 = tmp33372;
var inst_33292__$1 = tmp33371;
var inst_33293__$1 = inst_33306;
var state_33350__$1 = (function (){var statearr_33377 = state_33350;
(statearr_33377[(20)] = inst_33292__$1);

(statearr_33377[(10)] = inst_33291__$1);

(statearr_33377[(21)] = inst_33290__$1);

(statearr_33377[(22)] = inst_33305);

(statearr_33377[(12)] = inst_33293__$1);

return statearr_33377;
})();
var statearr_33378_33454 = state_33350__$1;
(statearr_33378_33454[(2)] = null);

(statearr_33378_33454[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (40))){
var inst_33318 = (state_33350[(23)]);
var inst_33322 = done(null);
var inst_33323 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_33318);
var state_33350__$1 = (function (){var statearr_33379 = state_33350;
(statearr_33379[(24)] = inst_33322);

return statearr_33379;
})();
var statearr_33380_33455 = state_33350__$1;
(statearr_33380_33455[(2)] = inst_33323);

(statearr_33380_33455[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (33))){
var inst_33309 = (state_33350[(25)]);
var inst_33311 = cljs.core.chunked_seq_QMARK_(inst_33309);
var state_33350__$1 = state_33350;
if(inst_33311){
var statearr_33381_33456 = state_33350__$1;
(statearr_33381_33456[(1)] = (36));

} else {
var statearr_33382_33457 = state_33350__$1;
(statearr_33382_33457[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (13))){
var inst_33239 = (state_33350[(26)]);
var inst_33242 = cljs.core.async.close_BANG_(inst_33239);
var state_33350__$1 = state_33350;
var statearr_33383_33458 = state_33350__$1;
(statearr_33383_33458[(2)] = inst_33242);

(statearr_33383_33458[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (22))){
var inst_33262 = (state_33350[(8)]);
var inst_33265 = cljs.core.async.close_BANG_(inst_33262);
var state_33350__$1 = state_33350;
var statearr_33384_33459 = state_33350__$1;
(statearr_33384_33459[(2)] = inst_33265);

(statearr_33384_33459[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (36))){
var inst_33309 = (state_33350[(25)]);
var inst_33313 = cljs.core.chunk_first(inst_33309);
var inst_33314 = cljs.core.chunk_rest(inst_33309);
var inst_33315 = cljs.core.count(inst_33313);
var inst_33290 = inst_33314;
var inst_33291 = inst_33313;
var inst_33292 = inst_33315;
var inst_33293 = (0);
var state_33350__$1 = (function (){var statearr_33385 = state_33350;
(statearr_33385[(20)] = inst_33292);

(statearr_33385[(10)] = inst_33291);

(statearr_33385[(21)] = inst_33290);

(statearr_33385[(12)] = inst_33293);

return statearr_33385;
})();
var statearr_33386_33460 = state_33350__$1;
(statearr_33386_33460[(2)] = null);

(statearr_33386_33460[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (41))){
var inst_33309 = (state_33350[(25)]);
var inst_33325 = (state_33350[(2)]);
var inst_33326 = cljs.core.next(inst_33309);
var inst_33290 = inst_33326;
var inst_33291 = null;
var inst_33292 = (0);
var inst_33293 = (0);
var state_33350__$1 = (function (){var statearr_33387 = state_33350;
(statearr_33387[(20)] = inst_33292);

(statearr_33387[(10)] = inst_33291);

(statearr_33387[(21)] = inst_33290);

(statearr_33387[(27)] = inst_33325);

(statearr_33387[(12)] = inst_33293);

return statearr_33387;
})();
var statearr_33388_33461 = state_33350__$1;
(statearr_33388_33461[(2)] = null);

(statearr_33388_33461[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (43))){
var state_33350__$1 = state_33350;
var statearr_33389_33462 = state_33350__$1;
(statearr_33389_33462[(2)] = null);

(statearr_33389_33462[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (29))){
var inst_33334 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33390_33463 = state_33350__$1;
(statearr_33390_33463[(2)] = inst_33334);

(statearr_33390_33463[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (44))){
var inst_33343 = (state_33350[(2)]);
var state_33350__$1 = (function (){var statearr_33391 = state_33350;
(statearr_33391[(28)] = inst_33343);

return statearr_33391;
})();
var statearr_33392_33464 = state_33350__$1;
(statearr_33392_33464[(2)] = null);

(statearr_33392_33464[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (6))){
var inst_33282 = (state_33350[(29)]);
var inst_33281 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_33282__$1 = cljs.core.keys(inst_33281);
var inst_33283 = cljs.core.count(inst_33282__$1);
var inst_33284 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_33283) : cljs.core.reset_BANG_.call(null,dctr,inst_33283));
var inst_33289 = cljs.core.seq(inst_33282__$1);
var inst_33290 = inst_33289;
var inst_33291 = null;
var inst_33292 = (0);
var inst_33293 = (0);
var state_33350__$1 = (function (){var statearr_33393 = state_33350;
(statearr_33393[(20)] = inst_33292);

(statearr_33393[(29)] = inst_33282__$1);

(statearr_33393[(10)] = inst_33291);

(statearr_33393[(21)] = inst_33290);

(statearr_33393[(12)] = inst_33293);

(statearr_33393[(30)] = inst_33284);

return statearr_33393;
})();
var statearr_33394_33465 = state_33350__$1;
(statearr_33394_33465[(2)] = null);

(statearr_33394_33465[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (28))){
var inst_33309 = (state_33350[(25)]);
var inst_33290 = (state_33350[(21)]);
var inst_33309__$1 = cljs.core.seq(inst_33290);
var state_33350__$1 = (function (){var statearr_33395 = state_33350;
(statearr_33395[(25)] = inst_33309__$1);

return statearr_33395;
})();
if(inst_33309__$1){
var statearr_33396_33466 = state_33350__$1;
(statearr_33396_33466[(1)] = (33));

} else {
var statearr_33397_33467 = state_33350__$1;
(statearr_33397_33467[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (25))){
var inst_33292 = (state_33350[(20)]);
var inst_33293 = (state_33350[(12)]);
var inst_33295 = (inst_33293 < inst_33292);
var inst_33296 = inst_33295;
var state_33350__$1 = state_33350;
if(cljs.core.truth_(inst_33296)){
var statearr_33398_33468 = state_33350__$1;
(statearr_33398_33468[(1)] = (27));

} else {
var statearr_33399_33469 = state_33350__$1;
(statearr_33399_33469[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (34))){
var state_33350__$1 = state_33350;
var statearr_33400_33470 = state_33350__$1;
(statearr_33400_33470[(2)] = null);

(statearr_33400_33470[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (17))){
var state_33350__$1 = state_33350;
var statearr_33401_33471 = state_33350__$1;
(statearr_33401_33471[(2)] = null);

(statearr_33401_33471[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (3))){
var inst_33348 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33350__$1,inst_33348);
} else {
if((state_val_33351 === (12))){
var inst_33277 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33402_33472 = state_33350__$1;
(statearr_33402_33472[(2)] = inst_33277);

(statearr_33402_33472[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (2))){
var state_33350__$1 = state_33350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33350__$1,(4),ch);
} else {
if((state_val_33351 === (23))){
var state_33350__$1 = state_33350;
var statearr_33403_33473 = state_33350__$1;
(statearr_33403_33473[(2)] = null);

(statearr_33403_33473[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (35))){
var inst_33332 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33404_33474 = state_33350__$1;
(statearr_33404_33474[(2)] = inst_33332);

(statearr_33404_33474[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (19))){
var inst_33249 = (state_33350[(7)]);
var inst_33253 = cljs.core.chunk_first(inst_33249);
var inst_33254 = cljs.core.chunk_rest(inst_33249);
var inst_33255 = cljs.core.count(inst_33253);
var inst_33227 = inst_33254;
var inst_33228 = inst_33253;
var inst_33229 = inst_33255;
var inst_33230 = (0);
var state_33350__$1 = (function (){var statearr_33405 = state_33350;
(statearr_33405[(13)] = inst_33229);

(statearr_33405[(14)] = inst_33227);

(statearr_33405[(15)] = inst_33230);

(statearr_33405[(16)] = inst_33228);

return statearr_33405;
})();
var statearr_33406_33475 = state_33350__$1;
(statearr_33406_33475[(2)] = null);

(statearr_33406_33475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (11))){
var inst_33249 = (state_33350[(7)]);
var inst_33227 = (state_33350[(14)]);
var inst_33249__$1 = cljs.core.seq(inst_33227);
var state_33350__$1 = (function (){var statearr_33407 = state_33350;
(statearr_33407[(7)] = inst_33249__$1);

return statearr_33407;
})();
if(inst_33249__$1){
var statearr_33408_33476 = state_33350__$1;
(statearr_33408_33476[(1)] = (16));

} else {
var statearr_33409_33477 = state_33350__$1;
(statearr_33409_33477[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (9))){
var inst_33279 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33410_33478 = state_33350__$1;
(statearr_33410_33478[(2)] = inst_33279);

(statearr_33410_33478[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (5))){
var inst_33225 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_33226 = cljs.core.seq(inst_33225);
var inst_33227 = inst_33226;
var inst_33228 = null;
var inst_33229 = (0);
var inst_33230 = (0);
var state_33350__$1 = (function (){var statearr_33411 = state_33350;
(statearr_33411[(13)] = inst_33229);

(statearr_33411[(14)] = inst_33227);

(statearr_33411[(15)] = inst_33230);

(statearr_33411[(16)] = inst_33228);

return statearr_33411;
})();
var statearr_33412_33479 = state_33350__$1;
(statearr_33412_33479[(2)] = null);

(statearr_33412_33479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (14))){
var state_33350__$1 = state_33350;
var statearr_33413_33480 = state_33350__$1;
(statearr_33413_33480[(2)] = null);

(statearr_33413_33480[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (45))){
var inst_33340 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33414_33481 = state_33350__$1;
(statearr_33414_33481[(2)] = inst_33340);

(statearr_33414_33481[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (26))){
var inst_33282 = (state_33350[(29)]);
var inst_33336 = (state_33350[(2)]);
var inst_33337 = cljs.core.seq(inst_33282);
var state_33350__$1 = (function (){var statearr_33415 = state_33350;
(statearr_33415[(31)] = inst_33336);

return statearr_33415;
})();
if(inst_33337){
var statearr_33416_33482 = state_33350__$1;
(statearr_33416_33482[(1)] = (42));

} else {
var statearr_33417_33483 = state_33350__$1;
(statearr_33417_33483[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (16))){
var inst_33249 = (state_33350[(7)]);
var inst_33251 = cljs.core.chunked_seq_QMARK_(inst_33249);
var state_33350__$1 = state_33350;
if(inst_33251){
var statearr_33418_33484 = state_33350__$1;
(statearr_33418_33484[(1)] = (19));

} else {
var statearr_33419_33485 = state_33350__$1;
(statearr_33419_33485[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (38))){
var inst_33329 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33420_33486 = state_33350__$1;
(statearr_33420_33486[(2)] = inst_33329);

(statearr_33420_33486[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (30))){
var state_33350__$1 = state_33350;
var statearr_33421_33487 = state_33350__$1;
(statearr_33421_33487[(2)] = null);

(statearr_33421_33487[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (10))){
var inst_33230 = (state_33350[(15)]);
var inst_33228 = (state_33350[(16)]);
var inst_33238 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33228,inst_33230);
var inst_33239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33238,(0),null);
var inst_33240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33238,(1),null);
var state_33350__$1 = (function (){var statearr_33422 = state_33350;
(statearr_33422[(26)] = inst_33239);

return statearr_33422;
})();
if(cljs.core.truth_(inst_33240)){
var statearr_33423_33488 = state_33350__$1;
(statearr_33423_33488[(1)] = (13));

} else {
var statearr_33424_33489 = state_33350__$1;
(statearr_33424_33489[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (18))){
var inst_33275 = (state_33350[(2)]);
var state_33350__$1 = state_33350;
var statearr_33425_33490 = state_33350__$1;
(statearr_33425_33490[(2)] = inst_33275);

(statearr_33425_33490[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (42))){
var state_33350__$1 = state_33350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33350__$1,(45),dchan);
} else {
if((state_val_33351 === (37))){
var inst_33309 = (state_33350[(25)]);
var inst_33318 = (state_33350[(23)]);
var inst_33218 = (state_33350[(11)]);
var inst_33318__$1 = cljs.core.first(inst_33309);
var inst_33319 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33318__$1,inst_33218,done);
var state_33350__$1 = (function (){var statearr_33426 = state_33350;
(statearr_33426[(23)] = inst_33318__$1);

return statearr_33426;
})();
if(cljs.core.truth_(inst_33319)){
var statearr_33427_33491 = state_33350__$1;
(statearr_33427_33491[(1)] = (39));

} else {
var statearr_33428_33492 = state_33350__$1;
(statearr_33428_33492[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33351 === (8))){
var inst_33229 = (state_33350[(13)]);
var inst_33230 = (state_33350[(15)]);
var inst_33232 = (inst_33230 < inst_33229);
var inst_33233 = inst_33232;
var state_33350__$1 = state_33350;
if(cljs.core.truth_(inst_33233)){
var statearr_33429_33493 = state_33350__$1;
(statearr_33429_33493[(1)] = (10));

} else {
var statearr_33430_33494 = state_33350__$1;
(statearr_33430_33494[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___33440,cs,m,dchan,dctr,done))
;
return ((function (switch__19184__auto__,c__19296__auto___33440,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__19185__auto__ = null;
var cljs$core$async$mult_$_state_machine__19185__auto____0 = (function (){
var statearr_33434 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33434[(0)] = cljs$core$async$mult_$_state_machine__19185__auto__);

(statearr_33434[(1)] = (1));

return statearr_33434;
});
var cljs$core$async$mult_$_state_machine__19185__auto____1 = (function (state_33350){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_33350);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e33435){if((e33435 instanceof Object)){
var ex__19188__auto__ = e33435;
var statearr_33436_33495 = state_33350;
(statearr_33436_33495[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33350);

return cljs.core.cst$kw$recur;
} else {
throw e33435;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__33496 = state_33350;
state_33350 = G__33496;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__19185__auto__ = function(state_33350){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__19185__auto____1.call(this,state_33350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__19185__auto____0;
cljs$core$async$mult_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__19185__auto____1;
return cljs$core$async$mult_$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___33440,cs,m,dchan,dctr,done))
})();
var state__19298__auto__ = (function (){var statearr_33437 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_33437[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___33440);

return statearr_33437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___33440,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args33497 = [];
var len__7651__auto___33500 = arguments.length;
var i__7652__auto___33501 = (0);
while(true){
if((i__7652__auto___33501 < len__7651__auto___33500)){
args33497.push((arguments[i__7652__auto___33501]));

var G__33502 = (i__7652__auto___33501 + (1));
i__7652__auto___33501 = G__33502;
continue;
} else {
}
break;
}

var G__33499 = args33497.length;
switch (G__33499) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33497.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto__.call(null,m,state_map));
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto__.call(null,m,mode));
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33514 = arguments.length;
var i__7652__auto___33515 = (0);
while(true){
if((i__7652__auto___33515 < len__7651__auto___33514)){
args__7658__auto__.push((arguments[i__7652__auto___33515]));

var G__33516 = (i__7652__auto___33515 + (1));
i__7652__auto___33515 = G__33516;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33508){
var map__33509 = p__33508;
var map__33509__$1 = ((((!((map__33509 == null)))?((((map__33509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33509.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33509):map__33509);
var opts = map__33509__$1;
var statearr_33511_33517 = state;
(statearr_33511_33517[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__33509,map__33509__$1,opts){
return (function (val){
var statearr_33512_33518 = state;
(statearr_33512_33518[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__33509,map__33509__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_33513_33519 = state;
(statearr_33513_33519[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33504){
var G__33505 = cljs.core.first(seq33504);
var seq33504__$1 = cljs.core.next(seq33504);
var G__33506 = cljs.core.first(seq33504__$1);
var seq33504__$2 = cljs.core.next(seq33504__$1);
var G__33507 = cljs.core.first(seq33504__$2);
var seq33504__$3 = cljs.core.next(seq33504__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33505,G__33506,G__33507,seq33504__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__33691 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33691) : cljs.core.atom.call(null,G__33691));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__33692 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33692) : cljs.core.atom.call(null,G__33692));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33693 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33693 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33694){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33694 = meta33694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33695,meta33694__$1){
var self__ = this;
var _33695__$1 = this;
return (new cljs.core.async.t_cljs$core$async33693(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33694__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33695){
var self__ = this;
var _33695__$1 = this;
return self__.meta33694;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33696_33862 = self__.cs;
var G__33697_33863 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33696_33862,G__33697_33863) : cljs.core.reset_BANG_.call(null,G__33696_33862,G__33697_33863));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta33694], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33693.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33693.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33693";

cljs.core.async.t_cljs$core$async33693.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33693");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async33693 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33693(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33694){
return (new cljs.core.async.t_cljs$core$async33693(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33694));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33693(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19296__auto___33864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___33864,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___33864,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33799){
var state_val_33800 = (state_33799[(1)]);
if((state_val_33800 === (7))){
var inst_33714 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
var statearr_33801_33865 = state_33799__$1;
(statearr_33801_33865[(2)] = inst_33714);

(statearr_33801_33865[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (20))){
var inst_33726 = (state_33799[(7)]);
var state_33799__$1 = state_33799;
var statearr_33802_33866 = state_33799__$1;
(statearr_33802_33866[(2)] = inst_33726);

(statearr_33802_33866[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (27))){
var state_33799__$1 = state_33799;
var statearr_33803_33867 = state_33799__$1;
(statearr_33803_33867[(2)] = null);

(statearr_33803_33867[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (1))){
var inst_33701 = (state_33799[(8)]);
var inst_33701__$1 = calc_state();
var inst_33703 = (inst_33701__$1 == null);
var inst_33704 = cljs.core.not(inst_33703);
var state_33799__$1 = (function (){var statearr_33804 = state_33799;
(statearr_33804[(8)] = inst_33701__$1);

return statearr_33804;
})();
if(inst_33704){
var statearr_33805_33868 = state_33799__$1;
(statearr_33805_33868[(1)] = (2));

} else {
var statearr_33806_33869 = state_33799__$1;
(statearr_33806_33869[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (24))){
var inst_33773 = (state_33799[(9)]);
var inst_33750 = (state_33799[(10)]);
var inst_33759 = (state_33799[(11)]);
var inst_33773__$1 = (inst_33750.cljs$core$IFn$_invoke$arity$1 ? inst_33750.cljs$core$IFn$_invoke$arity$1(inst_33759) : inst_33750.call(null,inst_33759));
var state_33799__$1 = (function (){var statearr_33807 = state_33799;
(statearr_33807[(9)] = inst_33773__$1);

return statearr_33807;
})();
if(cljs.core.truth_(inst_33773__$1)){
var statearr_33808_33870 = state_33799__$1;
(statearr_33808_33870[(1)] = (29));

} else {
var statearr_33809_33871 = state_33799__$1;
(statearr_33809_33871[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (4))){
var inst_33717 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33717)){
var statearr_33810_33872 = state_33799__$1;
(statearr_33810_33872[(1)] = (8));

} else {
var statearr_33811_33873 = state_33799__$1;
(statearr_33811_33873[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (15))){
var inst_33744 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33744)){
var statearr_33812_33874 = state_33799__$1;
(statearr_33812_33874[(1)] = (19));

} else {
var statearr_33813_33875 = state_33799__$1;
(statearr_33813_33875[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (21))){
var inst_33749 = (state_33799[(12)]);
var inst_33749__$1 = (state_33799[(2)]);
var inst_33750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33749__$1,cljs.core.cst$kw$solos);
var inst_33751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33749__$1,cljs.core.cst$kw$mutes);
var inst_33752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33749__$1,cljs.core.cst$kw$reads);
var state_33799__$1 = (function (){var statearr_33814 = state_33799;
(statearr_33814[(13)] = inst_33751);

(statearr_33814[(12)] = inst_33749__$1);

(statearr_33814[(10)] = inst_33750);

return statearr_33814;
})();
return cljs.core.async.ioc_alts_BANG_(state_33799__$1,(22),inst_33752);
} else {
if((state_val_33800 === (31))){
var inst_33781 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33781)){
var statearr_33815_33876 = state_33799__$1;
(statearr_33815_33876[(1)] = (32));

} else {
var statearr_33816_33877 = state_33799__$1;
(statearr_33816_33877[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (32))){
var inst_33758 = (state_33799[(14)]);
var state_33799__$1 = state_33799;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33799__$1,(35),out,inst_33758);
} else {
if((state_val_33800 === (33))){
var inst_33749 = (state_33799[(12)]);
var inst_33726 = inst_33749;
var state_33799__$1 = (function (){var statearr_33817 = state_33799;
(statearr_33817[(7)] = inst_33726);

return statearr_33817;
})();
var statearr_33818_33878 = state_33799__$1;
(statearr_33818_33878[(2)] = null);

(statearr_33818_33878[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (13))){
var inst_33726 = (state_33799[(7)]);
var inst_33733 = inst_33726.cljs$lang$protocol_mask$partition0$;
var inst_33734 = (inst_33733 & (64));
var inst_33735 = inst_33726.cljs$core$ISeq$;
var inst_33736 = (cljs.core.PROTOCOL_SENTINEL === inst_33735);
var inst_33737 = (inst_33734) || (inst_33736);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33737)){
var statearr_33819_33879 = state_33799__$1;
(statearr_33819_33879[(1)] = (16));

} else {
var statearr_33820_33880 = state_33799__$1;
(statearr_33820_33880[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (22))){
var inst_33758 = (state_33799[(14)]);
var inst_33759 = (state_33799[(11)]);
var inst_33757 = (state_33799[(2)]);
var inst_33758__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33757,(0),null);
var inst_33759__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33757,(1),null);
var inst_33760 = (inst_33758__$1 == null);
var inst_33761 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33759__$1,change);
var inst_33762 = (inst_33760) || (inst_33761);
var state_33799__$1 = (function (){var statearr_33821 = state_33799;
(statearr_33821[(14)] = inst_33758__$1);

(statearr_33821[(11)] = inst_33759__$1);

return statearr_33821;
})();
if(cljs.core.truth_(inst_33762)){
var statearr_33822_33881 = state_33799__$1;
(statearr_33822_33881[(1)] = (23));

} else {
var statearr_33823_33882 = state_33799__$1;
(statearr_33823_33882[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (36))){
var inst_33749 = (state_33799[(12)]);
var inst_33726 = inst_33749;
var state_33799__$1 = (function (){var statearr_33824 = state_33799;
(statearr_33824[(7)] = inst_33726);

return statearr_33824;
})();
var statearr_33825_33883 = state_33799__$1;
(statearr_33825_33883[(2)] = null);

(statearr_33825_33883[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (29))){
var inst_33773 = (state_33799[(9)]);
var state_33799__$1 = state_33799;
var statearr_33826_33884 = state_33799__$1;
(statearr_33826_33884[(2)] = inst_33773);

(statearr_33826_33884[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (6))){
var state_33799__$1 = state_33799;
var statearr_33827_33885 = state_33799__$1;
(statearr_33827_33885[(2)] = false);

(statearr_33827_33885[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (28))){
var inst_33769 = (state_33799[(2)]);
var inst_33770 = calc_state();
var inst_33726 = inst_33770;
var state_33799__$1 = (function (){var statearr_33828 = state_33799;
(statearr_33828[(15)] = inst_33769);

(statearr_33828[(7)] = inst_33726);

return statearr_33828;
})();
var statearr_33829_33886 = state_33799__$1;
(statearr_33829_33886[(2)] = null);

(statearr_33829_33886[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (25))){
var inst_33795 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
var statearr_33830_33887 = state_33799__$1;
(statearr_33830_33887[(2)] = inst_33795);

(statearr_33830_33887[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (34))){
var inst_33793 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
var statearr_33831_33888 = state_33799__$1;
(statearr_33831_33888[(2)] = inst_33793);

(statearr_33831_33888[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (17))){
var state_33799__$1 = state_33799;
var statearr_33832_33889 = state_33799__$1;
(statearr_33832_33889[(2)] = false);

(statearr_33832_33889[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (3))){
var state_33799__$1 = state_33799;
var statearr_33833_33890 = state_33799__$1;
(statearr_33833_33890[(2)] = false);

(statearr_33833_33890[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (12))){
var inst_33797 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33799__$1,inst_33797);
} else {
if((state_val_33800 === (2))){
var inst_33701 = (state_33799[(8)]);
var inst_33706 = inst_33701.cljs$lang$protocol_mask$partition0$;
var inst_33707 = (inst_33706 & (64));
var inst_33708 = inst_33701.cljs$core$ISeq$;
var inst_33709 = (cljs.core.PROTOCOL_SENTINEL === inst_33708);
var inst_33710 = (inst_33707) || (inst_33709);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33710)){
var statearr_33834_33891 = state_33799__$1;
(statearr_33834_33891[(1)] = (5));

} else {
var statearr_33835_33892 = state_33799__$1;
(statearr_33835_33892[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (23))){
var inst_33758 = (state_33799[(14)]);
var inst_33764 = (inst_33758 == null);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33764)){
var statearr_33836_33893 = state_33799__$1;
(statearr_33836_33893[(1)] = (26));

} else {
var statearr_33837_33894 = state_33799__$1;
(statearr_33837_33894[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (35))){
var inst_33784 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
if(cljs.core.truth_(inst_33784)){
var statearr_33838_33895 = state_33799__$1;
(statearr_33838_33895[(1)] = (36));

} else {
var statearr_33839_33896 = state_33799__$1;
(statearr_33839_33896[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (19))){
var inst_33726 = (state_33799[(7)]);
var inst_33746 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33726);
var state_33799__$1 = state_33799;
var statearr_33840_33897 = state_33799__$1;
(statearr_33840_33897[(2)] = inst_33746);

(statearr_33840_33897[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (11))){
var inst_33726 = (state_33799[(7)]);
var inst_33730 = (inst_33726 == null);
var inst_33731 = cljs.core.not(inst_33730);
var state_33799__$1 = state_33799;
if(inst_33731){
var statearr_33841_33898 = state_33799__$1;
(statearr_33841_33898[(1)] = (13));

} else {
var statearr_33842_33899 = state_33799__$1;
(statearr_33842_33899[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (9))){
var inst_33701 = (state_33799[(8)]);
var state_33799__$1 = state_33799;
var statearr_33843_33900 = state_33799__$1;
(statearr_33843_33900[(2)] = inst_33701);

(statearr_33843_33900[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (5))){
var state_33799__$1 = state_33799;
var statearr_33844_33901 = state_33799__$1;
(statearr_33844_33901[(2)] = true);

(statearr_33844_33901[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (14))){
var state_33799__$1 = state_33799;
var statearr_33845_33902 = state_33799__$1;
(statearr_33845_33902[(2)] = false);

(statearr_33845_33902[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (26))){
var inst_33759 = (state_33799[(11)]);
var inst_33766 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_33759);
var state_33799__$1 = state_33799;
var statearr_33846_33903 = state_33799__$1;
(statearr_33846_33903[(2)] = inst_33766);

(statearr_33846_33903[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (16))){
var state_33799__$1 = state_33799;
var statearr_33847_33904 = state_33799__$1;
(statearr_33847_33904[(2)] = true);

(statearr_33847_33904[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (38))){
var inst_33789 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
var statearr_33848_33905 = state_33799__$1;
(statearr_33848_33905[(2)] = inst_33789);

(statearr_33848_33905[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (30))){
var inst_33751 = (state_33799[(13)]);
var inst_33750 = (state_33799[(10)]);
var inst_33759 = (state_33799[(11)]);
var inst_33776 = cljs.core.empty_QMARK_(inst_33750);
var inst_33777 = (inst_33751.cljs$core$IFn$_invoke$arity$1 ? inst_33751.cljs$core$IFn$_invoke$arity$1(inst_33759) : inst_33751.call(null,inst_33759));
var inst_33778 = cljs.core.not(inst_33777);
var inst_33779 = (inst_33776) && (inst_33778);
var state_33799__$1 = state_33799;
var statearr_33849_33906 = state_33799__$1;
(statearr_33849_33906[(2)] = inst_33779);

(statearr_33849_33906[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (10))){
var inst_33701 = (state_33799[(8)]);
var inst_33722 = (state_33799[(2)]);
var inst_33723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33722,cljs.core.cst$kw$solos);
var inst_33724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33722,cljs.core.cst$kw$mutes);
var inst_33725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33722,cljs.core.cst$kw$reads);
var inst_33726 = inst_33701;
var state_33799__$1 = (function (){var statearr_33850 = state_33799;
(statearr_33850[(16)] = inst_33723);

(statearr_33850[(17)] = inst_33725);

(statearr_33850[(7)] = inst_33726);

(statearr_33850[(18)] = inst_33724);

return statearr_33850;
})();
var statearr_33851_33907 = state_33799__$1;
(statearr_33851_33907[(2)] = null);

(statearr_33851_33907[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (18))){
var inst_33741 = (state_33799[(2)]);
var state_33799__$1 = state_33799;
var statearr_33852_33908 = state_33799__$1;
(statearr_33852_33908[(2)] = inst_33741);

(statearr_33852_33908[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (37))){
var state_33799__$1 = state_33799;
var statearr_33853_33909 = state_33799__$1;
(statearr_33853_33909[(2)] = null);

(statearr_33853_33909[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33800 === (8))){
var inst_33701 = (state_33799[(8)]);
var inst_33719 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33701);
var state_33799__$1 = state_33799;
var statearr_33854_33910 = state_33799__$1;
(statearr_33854_33910[(2)] = inst_33719);

(statearr_33854_33910[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___33864,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__19184__auto__,c__19296__auto___33864,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__19185__auto__ = null;
var cljs$core$async$mix_$_state_machine__19185__auto____0 = (function (){
var statearr_33858 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33858[(0)] = cljs$core$async$mix_$_state_machine__19185__auto__);

(statearr_33858[(1)] = (1));

return statearr_33858;
});
var cljs$core$async$mix_$_state_machine__19185__auto____1 = (function (state_33799){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_33799);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e33859){if((e33859 instanceof Object)){
var ex__19188__auto__ = e33859;
var statearr_33860_33911 = state_33799;
(statearr_33860_33911[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33799);

return cljs.core.cst$kw$recur;
} else {
throw e33859;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__33912 = state_33799;
state_33799 = G__33912;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__19185__auto__ = function(state_33799){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__19185__auto____1.call(this,state_33799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__19185__auto____0;
cljs$core$async$mix_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__19185__auto____1;
return cljs$core$async$mix_$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___33864,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19298__auto__ = (function (){var statearr_33861 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_33861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___33864);

return statearr_33861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___33864,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto__.call(null,p,v,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33913 = [];
var len__7651__auto___33916 = arguments.length;
var i__7652__auto___33917 = (0);
while(true){
if((i__7652__auto___33917 < len__7651__auto___33916)){
args33913.push((arguments[i__7652__auto___33917]));

var G__33918 = (i__7652__auto___33917 + (1));
i__7652__auto___33917 = G__33918;
continue;
} else {
}
break;
}

var G__33915 = args33913.length;
switch (G__33915) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33913.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto__.call(null,p));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto__.call(null,p,v));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33921 = [];
var len__7651__auto___34049 = arguments.length;
var i__7652__auto___34050 = (0);
while(true){
if((i__7652__auto___34050 < len__7651__auto___34049)){
args33921.push((arguments[i__7652__auto___34050]));

var G__34051 = (i__7652__auto___34050 + (1));
i__7652__auto___34050 = G__34051;
continue;
} else {
}
break;
}

var G__33923 = args33921.length;
switch (G__33923) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33921.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__33924 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33924) : cljs.core.atom.call(null,G__33924));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6543__auto__,mults){
return (function (p1__33920_SHARP_){
if(cljs.core.truth_((p1__33920_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33920_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33920_SHARP_.call(null,topic)))){
return p1__33920_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33920_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33925 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33925 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33926){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33926 = meta33926;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33927,meta33926__$1){
var self__ = this;
var _33927__$1 = this;
return (new cljs.core.async.t_cljs$core$async33925(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33926__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33927){
var self__ = this;
var _33927__$1 = this;
return self__.meta33926;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33928 = self__.mults;
var G__33929 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33928,G__33929) : cljs.core.reset_BANG_.call(null,G__33928,G__33929));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta33926], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33925.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33925.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33925";

cljs.core.async.t_cljs$core$async33925.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33925");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33925 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33925(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33926){
return (new cljs.core.async.t_cljs$core$async33925(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33926));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33925(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19296__auto___34053 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34053,mults,ensure_mult,p){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34053,mults,ensure_mult,p){
return (function (state_34001){
var state_val_34002 = (state_34001[(1)]);
if((state_val_34002 === (7))){
var inst_33997 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
var statearr_34003_34054 = state_34001__$1;
(statearr_34003_34054[(2)] = inst_33997);

(statearr_34003_34054[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (20))){
var state_34001__$1 = state_34001;
var statearr_34004_34055 = state_34001__$1;
(statearr_34004_34055[(2)] = null);

(statearr_34004_34055[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (1))){
var state_34001__$1 = state_34001;
var statearr_34005_34056 = state_34001__$1;
(statearr_34005_34056[(2)] = null);

(statearr_34005_34056[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (24))){
var inst_33980 = (state_34001[(7)]);
var inst_33989 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33980);
var state_34001__$1 = state_34001;
var statearr_34006_34057 = state_34001__$1;
(statearr_34006_34057[(2)] = inst_33989);

(statearr_34006_34057[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (4))){
var inst_33932 = (state_34001[(8)]);
var inst_33932__$1 = (state_34001[(2)]);
var inst_33933 = (inst_33932__$1 == null);
var state_34001__$1 = (function (){var statearr_34007 = state_34001;
(statearr_34007[(8)] = inst_33932__$1);

return statearr_34007;
})();
if(cljs.core.truth_(inst_33933)){
var statearr_34008_34058 = state_34001__$1;
(statearr_34008_34058[(1)] = (5));

} else {
var statearr_34009_34059 = state_34001__$1;
(statearr_34009_34059[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (15))){
var inst_33974 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
var statearr_34010_34060 = state_34001__$1;
(statearr_34010_34060[(2)] = inst_33974);

(statearr_34010_34060[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (21))){
var inst_33994 = (state_34001[(2)]);
var state_34001__$1 = (function (){var statearr_34011 = state_34001;
(statearr_34011[(9)] = inst_33994);

return statearr_34011;
})();
var statearr_34012_34061 = state_34001__$1;
(statearr_34012_34061[(2)] = null);

(statearr_34012_34061[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (13))){
var inst_33956 = (state_34001[(10)]);
var inst_33958 = cljs.core.chunked_seq_QMARK_(inst_33956);
var state_34001__$1 = state_34001;
if(inst_33958){
var statearr_34013_34062 = state_34001__$1;
(statearr_34013_34062[(1)] = (16));

} else {
var statearr_34014_34063 = state_34001__$1;
(statearr_34014_34063[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (22))){
var inst_33986 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
if(cljs.core.truth_(inst_33986)){
var statearr_34015_34064 = state_34001__$1;
(statearr_34015_34064[(1)] = (23));

} else {
var statearr_34016_34065 = state_34001__$1;
(statearr_34016_34065[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (6))){
var inst_33932 = (state_34001[(8)]);
var inst_33980 = (state_34001[(7)]);
var inst_33982 = (state_34001[(11)]);
var inst_33980__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33932) : topic_fn.call(null,inst_33932));
var inst_33981 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33982__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33981,inst_33980__$1);
var state_34001__$1 = (function (){var statearr_34017 = state_34001;
(statearr_34017[(7)] = inst_33980__$1);

(statearr_34017[(11)] = inst_33982__$1);

return statearr_34017;
})();
if(cljs.core.truth_(inst_33982__$1)){
var statearr_34018_34066 = state_34001__$1;
(statearr_34018_34066[(1)] = (19));

} else {
var statearr_34019_34067 = state_34001__$1;
(statearr_34019_34067[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (25))){
var inst_33991 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
var statearr_34020_34068 = state_34001__$1;
(statearr_34020_34068[(2)] = inst_33991);

(statearr_34020_34068[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (17))){
var inst_33956 = (state_34001[(10)]);
var inst_33965 = cljs.core.first(inst_33956);
var inst_33966 = cljs.core.async.muxch_STAR_(inst_33965);
var inst_33967 = cljs.core.async.close_BANG_(inst_33966);
var inst_33968 = cljs.core.next(inst_33956);
var inst_33942 = inst_33968;
var inst_33943 = null;
var inst_33944 = (0);
var inst_33945 = (0);
var state_34001__$1 = (function (){var statearr_34021 = state_34001;
(statearr_34021[(12)] = inst_33942);

(statearr_34021[(13)] = inst_33944);

(statearr_34021[(14)] = inst_33943);

(statearr_34021[(15)] = inst_33967);

(statearr_34021[(16)] = inst_33945);

return statearr_34021;
})();
var statearr_34022_34069 = state_34001__$1;
(statearr_34022_34069[(2)] = null);

(statearr_34022_34069[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (3))){
var inst_33999 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34001__$1,inst_33999);
} else {
if((state_val_34002 === (12))){
var inst_33976 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
var statearr_34023_34070 = state_34001__$1;
(statearr_34023_34070[(2)] = inst_33976);

(statearr_34023_34070[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (2))){
var state_34001__$1 = state_34001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34001__$1,(4),ch);
} else {
if((state_val_34002 === (23))){
var state_34001__$1 = state_34001;
var statearr_34024_34071 = state_34001__$1;
(statearr_34024_34071[(2)] = null);

(statearr_34024_34071[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (19))){
var inst_33932 = (state_34001[(8)]);
var inst_33982 = (state_34001[(11)]);
var inst_33984 = cljs.core.async.muxch_STAR_(inst_33982);
var state_34001__$1 = state_34001;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34001__$1,(22),inst_33984,inst_33932);
} else {
if((state_val_34002 === (11))){
var inst_33956 = (state_34001[(10)]);
var inst_33942 = (state_34001[(12)]);
var inst_33956__$1 = cljs.core.seq(inst_33942);
var state_34001__$1 = (function (){var statearr_34025 = state_34001;
(statearr_34025[(10)] = inst_33956__$1);

return statearr_34025;
})();
if(inst_33956__$1){
var statearr_34026_34072 = state_34001__$1;
(statearr_34026_34072[(1)] = (13));

} else {
var statearr_34027_34073 = state_34001__$1;
(statearr_34027_34073[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (9))){
var inst_33978 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
var statearr_34028_34074 = state_34001__$1;
(statearr_34028_34074[(2)] = inst_33978);

(statearr_34028_34074[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (5))){
var inst_33939 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33940 = cljs.core.vals(inst_33939);
var inst_33941 = cljs.core.seq(inst_33940);
var inst_33942 = inst_33941;
var inst_33943 = null;
var inst_33944 = (0);
var inst_33945 = (0);
var state_34001__$1 = (function (){var statearr_34029 = state_34001;
(statearr_34029[(12)] = inst_33942);

(statearr_34029[(13)] = inst_33944);

(statearr_34029[(14)] = inst_33943);

(statearr_34029[(16)] = inst_33945);

return statearr_34029;
})();
var statearr_34030_34075 = state_34001__$1;
(statearr_34030_34075[(2)] = null);

(statearr_34030_34075[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (14))){
var state_34001__$1 = state_34001;
var statearr_34034_34076 = state_34001__$1;
(statearr_34034_34076[(2)] = null);

(statearr_34034_34076[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (16))){
var inst_33956 = (state_34001[(10)]);
var inst_33960 = cljs.core.chunk_first(inst_33956);
var inst_33961 = cljs.core.chunk_rest(inst_33956);
var inst_33962 = cljs.core.count(inst_33960);
var inst_33942 = inst_33961;
var inst_33943 = inst_33960;
var inst_33944 = inst_33962;
var inst_33945 = (0);
var state_34001__$1 = (function (){var statearr_34035 = state_34001;
(statearr_34035[(12)] = inst_33942);

(statearr_34035[(13)] = inst_33944);

(statearr_34035[(14)] = inst_33943);

(statearr_34035[(16)] = inst_33945);

return statearr_34035;
})();
var statearr_34036_34077 = state_34001__$1;
(statearr_34036_34077[(2)] = null);

(statearr_34036_34077[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (10))){
var inst_33942 = (state_34001[(12)]);
var inst_33944 = (state_34001[(13)]);
var inst_33943 = (state_34001[(14)]);
var inst_33945 = (state_34001[(16)]);
var inst_33950 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33943,inst_33945);
var inst_33951 = cljs.core.async.muxch_STAR_(inst_33950);
var inst_33952 = cljs.core.async.close_BANG_(inst_33951);
var inst_33953 = (inst_33945 + (1));
var tmp34031 = inst_33942;
var tmp34032 = inst_33944;
var tmp34033 = inst_33943;
var inst_33942__$1 = tmp34031;
var inst_33943__$1 = tmp34033;
var inst_33944__$1 = tmp34032;
var inst_33945__$1 = inst_33953;
var state_34001__$1 = (function (){var statearr_34037 = state_34001;
(statearr_34037[(12)] = inst_33942__$1);

(statearr_34037[(13)] = inst_33944__$1);

(statearr_34037[(17)] = inst_33952);

(statearr_34037[(14)] = inst_33943__$1);

(statearr_34037[(16)] = inst_33945__$1);

return statearr_34037;
})();
var statearr_34038_34078 = state_34001__$1;
(statearr_34038_34078[(2)] = null);

(statearr_34038_34078[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (18))){
var inst_33971 = (state_34001[(2)]);
var state_34001__$1 = state_34001;
var statearr_34039_34079 = state_34001__$1;
(statearr_34039_34079[(2)] = inst_33971);

(statearr_34039_34079[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34002 === (8))){
var inst_33944 = (state_34001[(13)]);
var inst_33945 = (state_34001[(16)]);
var inst_33947 = (inst_33945 < inst_33944);
var inst_33948 = inst_33947;
var state_34001__$1 = state_34001;
if(cljs.core.truth_(inst_33948)){
var statearr_34040_34080 = state_34001__$1;
(statearr_34040_34080[(1)] = (10));

} else {
var statearr_34041_34081 = state_34001__$1;
(statearr_34041_34081[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34053,mults,ensure_mult,p))
;
return ((function (switch__19184__auto__,c__19296__auto___34053,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34045[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34045[(1)] = (1));

return statearr_34045;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34001){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34001);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34046){if((e34046 instanceof Object)){
var ex__19188__auto__ = e34046;
var statearr_34047_34082 = state_34001;
(statearr_34047_34082[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34001);

return cljs.core.cst$kw$recur;
} else {
throw e34046;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34083 = state_34001;
state_34001 = G__34083;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34001){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34053,mults,ensure_mult,p))
})();
var state__19298__auto__ = (function (){var statearr_34048 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34048[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34053);

return statearr_34048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34053,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args34084 = [];
var len__7651__auto___34087 = arguments.length;
var i__7652__auto___34088 = (0);
while(true){
if((i__7652__auto___34088 < len__7651__auto___34087)){
args34084.push((arguments[i__7652__auto___34088]));

var G__34089 = (i__7652__auto___34088 + (1));
i__7652__auto___34088 = G__34089;
continue;
} else {
}
break;
}

var G__34086 = args34084.length;
switch (G__34086) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34084.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args34091 = [];
var len__7651__auto___34094 = arguments.length;
var i__7652__auto___34095 = (0);
while(true){
if((i__7652__auto___34095 < len__7651__auto___34094)){
args34091.push((arguments[i__7652__auto___34095]));

var G__34096 = (i__7652__auto___34095 + (1));
i__7652__auto___34095 = G__34096;
continue;
} else {
}
break;
}

var G__34093 = args34091.length;
switch (G__34093) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34091.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args34098 = [];
var len__7651__auto___34169 = arguments.length;
var i__7652__auto___34170 = (0);
while(true){
if((i__7652__auto___34170 < len__7651__auto___34169)){
args34098.push((arguments[i__7652__auto___34170]));

var G__34171 = (i__7652__auto___34170 + (1));
i__7652__auto___34170 = G__34171;
continue;
} else {
}
break;
}

var G__34100 = args34098.length;
switch (G__34100) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34098.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__19296__auto___34173 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34173,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34173,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_34139){
var state_val_34140 = (state_34139[(1)]);
if((state_val_34140 === (7))){
var state_34139__$1 = state_34139;
var statearr_34141_34174 = state_34139__$1;
(statearr_34141_34174[(2)] = null);

(statearr_34141_34174[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (1))){
var state_34139__$1 = state_34139;
var statearr_34142_34175 = state_34139__$1;
(statearr_34142_34175[(2)] = null);

(statearr_34142_34175[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (4))){
var inst_34103 = (state_34139[(7)]);
var inst_34105 = (inst_34103 < cnt);
var state_34139__$1 = state_34139;
if(cljs.core.truth_(inst_34105)){
var statearr_34143_34176 = state_34139__$1;
(statearr_34143_34176[(1)] = (6));

} else {
var statearr_34144_34177 = state_34139__$1;
(statearr_34144_34177[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (15))){
var inst_34135 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
var statearr_34145_34178 = state_34139__$1;
(statearr_34145_34178[(2)] = inst_34135);

(statearr_34145_34178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (13))){
var inst_34128 = cljs.core.async.close_BANG_(out);
var state_34139__$1 = state_34139;
var statearr_34146_34179 = state_34139__$1;
(statearr_34146_34179[(2)] = inst_34128);

(statearr_34146_34179[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (6))){
var state_34139__$1 = state_34139;
var statearr_34147_34180 = state_34139__$1;
(statearr_34147_34180[(2)] = null);

(statearr_34147_34180[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (3))){
var inst_34137 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34139__$1,inst_34137);
} else {
if((state_val_34140 === (12))){
var inst_34125 = (state_34139[(8)]);
var inst_34125__$1 = (state_34139[(2)]);
var inst_34126 = cljs.core.some(cljs.core.nil_QMARK_,inst_34125__$1);
var state_34139__$1 = (function (){var statearr_34148 = state_34139;
(statearr_34148[(8)] = inst_34125__$1);

return statearr_34148;
})();
if(cljs.core.truth_(inst_34126)){
var statearr_34149_34181 = state_34139__$1;
(statearr_34149_34181[(1)] = (13));

} else {
var statearr_34150_34182 = state_34139__$1;
(statearr_34150_34182[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (2))){
var inst_34102 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_34103 = (0);
var state_34139__$1 = (function (){var statearr_34151 = state_34139;
(statearr_34151[(7)] = inst_34103);

(statearr_34151[(9)] = inst_34102);

return statearr_34151;
})();
var statearr_34152_34183 = state_34139__$1;
(statearr_34152_34183[(2)] = null);

(statearr_34152_34183[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (11))){
var inst_34103 = (state_34139[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_34139,(10),Object,null,(9));
var inst_34112 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_34103) : chs__$1.call(null,inst_34103));
var inst_34113 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_34103) : done.call(null,inst_34103));
var inst_34114 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34112,inst_34113);
var state_34139__$1 = state_34139;
var statearr_34153_34184 = state_34139__$1;
(statearr_34153_34184[(2)] = inst_34114);


cljs.core.async.impl.ioc_helpers.process_exception(state_34139__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (9))){
var inst_34103 = (state_34139[(7)]);
var inst_34116 = (state_34139[(2)]);
var inst_34117 = (inst_34103 + (1));
var inst_34103__$1 = inst_34117;
var state_34139__$1 = (function (){var statearr_34154 = state_34139;
(statearr_34154[(10)] = inst_34116);

(statearr_34154[(7)] = inst_34103__$1);

return statearr_34154;
})();
var statearr_34155_34185 = state_34139__$1;
(statearr_34155_34185[(2)] = null);

(statearr_34155_34185[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (5))){
var inst_34123 = (state_34139[(2)]);
var state_34139__$1 = (function (){var statearr_34156 = state_34139;
(statearr_34156[(11)] = inst_34123);

return statearr_34156;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34139__$1,(12),dchan);
} else {
if((state_val_34140 === (14))){
var inst_34125 = (state_34139[(8)]);
var inst_34130 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_34125);
var state_34139__$1 = state_34139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34139__$1,(16),out,inst_34130);
} else {
if((state_val_34140 === (16))){
var inst_34132 = (state_34139[(2)]);
var state_34139__$1 = (function (){var statearr_34157 = state_34139;
(statearr_34157[(12)] = inst_34132);

return statearr_34157;
})();
var statearr_34158_34186 = state_34139__$1;
(statearr_34158_34186[(2)] = null);

(statearr_34158_34186[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (10))){
var inst_34107 = (state_34139[(2)]);
var inst_34108 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_34139__$1 = (function (){var statearr_34159 = state_34139;
(statearr_34159[(13)] = inst_34107);

return statearr_34159;
})();
var statearr_34160_34187 = state_34139__$1;
(statearr_34160_34187[(2)] = inst_34108);


cljs.core.async.impl.ioc_helpers.process_exception(state_34139__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_34140 === (8))){
var inst_34121 = (state_34139[(2)]);
var state_34139__$1 = state_34139;
var statearr_34161_34188 = state_34139__$1;
(statearr_34161_34188[(2)] = inst_34121);

(statearr_34161_34188[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34173,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__19184__auto__,c__19296__auto___34173,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34165[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34165[(1)] = (1));

return statearr_34165;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34139){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34139);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34166){if((e34166 instanceof Object)){
var ex__19188__auto__ = e34166;
var statearr_34167_34189 = state_34139;
(statearr_34167_34189[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34139);

return cljs.core.cst$kw$recur;
} else {
throw e34166;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34190 = state_34139;
state_34139 = G__34190;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34173,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19298__auto__ = (function (){var statearr_34168 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34168[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34173);

return statearr_34168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34173,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args34192 = [];
var len__7651__auto___34250 = arguments.length;
var i__7652__auto___34251 = (0);
while(true){
if((i__7652__auto___34251 < len__7651__auto___34250)){
args34192.push((arguments[i__7652__auto___34251]));

var G__34252 = (i__7652__auto___34251 + (1));
i__7652__auto___34251 = G__34252;
continue;
} else {
}
break;
}

var G__34194 = args34192.length;
switch (G__34194) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34192.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19296__auto___34254 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34254,out){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34254,out){
return (function (state_34226){
var state_val_34227 = (state_34226[(1)]);
if((state_val_34227 === (7))){
var inst_34205 = (state_34226[(7)]);
var inst_34206 = (state_34226[(8)]);
var inst_34205__$1 = (state_34226[(2)]);
var inst_34206__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34205__$1,(0),null);
var inst_34207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34205__$1,(1),null);
var inst_34208 = (inst_34206__$1 == null);
var state_34226__$1 = (function (){var statearr_34228 = state_34226;
(statearr_34228[(7)] = inst_34205__$1);

(statearr_34228[(9)] = inst_34207);

(statearr_34228[(8)] = inst_34206__$1);

return statearr_34228;
})();
if(cljs.core.truth_(inst_34208)){
var statearr_34229_34255 = state_34226__$1;
(statearr_34229_34255[(1)] = (8));

} else {
var statearr_34230_34256 = state_34226__$1;
(statearr_34230_34256[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (1))){
var inst_34195 = cljs.core.vec(chs);
var inst_34196 = inst_34195;
var state_34226__$1 = (function (){var statearr_34231 = state_34226;
(statearr_34231[(10)] = inst_34196);

return statearr_34231;
})();
var statearr_34232_34257 = state_34226__$1;
(statearr_34232_34257[(2)] = null);

(statearr_34232_34257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (4))){
var inst_34196 = (state_34226[(10)]);
var state_34226__$1 = state_34226;
return cljs.core.async.ioc_alts_BANG_(state_34226__$1,(7),inst_34196);
} else {
if((state_val_34227 === (6))){
var inst_34222 = (state_34226[(2)]);
var state_34226__$1 = state_34226;
var statearr_34233_34258 = state_34226__$1;
(statearr_34233_34258[(2)] = inst_34222);

(statearr_34233_34258[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (3))){
var inst_34224 = (state_34226[(2)]);
var state_34226__$1 = state_34226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34226__$1,inst_34224);
} else {
if((state_val_34227 === (2))){
var inst_34196 = (state_34226[(10)]);
var inst_34198 = cljs.core.count(inst_34196);
var inst_34199 = (inst_34198 > (0));
var state_34226__$1 = state_34226;
if(cljs.core.truth_(inst_34199)){
var statearr_34235_34259 = state_34226__$1;
(statearr_34235_34259[(1)] = (4));

} else {
var statearr_34236_34260 = state_34226__$1;
(statearr_34236_34260[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (11))){
var inst_34196 = (state_34226[(10)]);
var inst_34215 = (state_34226[(2)]);
var tmp34234 = inst_34196;
var inst_34196__$1 = tmp34234;
var state_34226__$1 = (function (){var statearr_34237 = state_34226;
(statearr_34237[(10)] = inst_34196__$1);

(statearr_34237[(11)] = inst_34215);

return statearr_34237;
})();
var statearr_34238_34261 = state_34226__$1;
(statearr_34238_34261[(2)] = null);

(statearr_34238_34261[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (9))){
var inst_34206 = (state_34226[(8)]);
var state_34226__$1 = state_34226;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34226__$1,(11),out,inst_34206);
} else {
if((state_val_34227 === (5))){
var inst_34220 = cljs.core.async.close_BANG_(out);
var state_34226__$1 = state_34226;
var statearr_34239_34262 = state_34226__$1;
(statearr_34239_34262[(2)] = inst_34220);

(statearr_34239_34262[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (10))){
var inst_34218 = (state_34226[(2)]);
var state_34226__$1 = state_34226;
var statearr_34240_34263 = state_34226__$1;
(statearr_34240_34263[(2)] = inst_34218);

(statearr_34240_34263[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34227 === (8))){
var inst_34196 = (state_34226[(10)]);
var inst_34205 = (state_34226[(7)]);
var inst_34207 = (state_34226[(9)]);
var inst_34206 = (state_34226[(8)]);
var inst_34210 = (function (){var cs = inst_34196;
var vec__34201 = inst_34205;
var v = inst_34206;
var c = inst_34207;
return ((function (cs,vec__34201,v,c,inst_34196,inst_34205,inst_34207,inst_34206,state_val_34227,c__19296__auto___34254,out){
return (function (p1__34191_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__34191_SHARP_);
});
;})(cs,vec__34201,v,c,inst_34196,inst_34205,inst_34207,inst_34206,state_val_34227,c__19296__auto___34254,out))
})();
var inst_34211 = cljs.core.filterv(inst_34210,inst_34196);
var inst_34196__$1 = inst_34211;
var state_34226__$1 = (function (){var statearr_34241 = state_34226;
(statearr_34241[(10)] = inst_34196__$1);

return statearr_34241;
})();
var statearr_34242_34264 = state_34226__$1;
(statearr_34242_34264[(2)] = null);

(statearr_34242_34264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34254,out))
;
return ((function (switch__19184__auto__,c__19296__auto___34254,out){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34246 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34246[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34246[(1)] = (1));

return statearr_34246;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34226){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34226);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34247){if((e34247 instanceof Object)){
var ex__19188__auto__ = e34247;
var statearr_34248_34265 = state_34226;
(statearr_34248_34265[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34226);

return cljs.core.cst$kw$recur;
} else {
throw e34247;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34266 = state_34226;
state_34226 = G__34266;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34226){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34254,out))
})();
var state__19298__auto__ = (function (){var statearr_34249 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34254);

return statearr_34249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34254,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args34267 = [];
var len__7651__auto___34316 = arguments.length;
var i__7652__auto___34317 = (0);
while(true){
if((i__7652__auto___34317 < len__7651__auto___34316)){
args34267.push((arguments[i__7652__auto___34317]));

var G__34318 = (i__7652__auto___34317 + (1));
i__7652__auto___34317 = G__34318;
continue;
} else {
}
break;
}

var G__34269 = args34267.length;
switch (G__34269) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34267.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19296__auto___34320 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34320,out){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34320,out){
return (function (state_34293){
var state_val_34294 = (state_34293[(1)]);
if((state_val_34294 === (7))){
var inst_34275 = (state_34293[(7)]);
var inst_34275__$1 = (state_34293[(2)]);
var inst_34276 = (inst_34275__$1 == null);
var inst_34277 = cljs.core.not(inst_34276);
var state_34293__$1 = (function (){var statearr_34295 = state_34293;
(statearr_34295[(7)] = inst_34275__$1);

return statearr_34295;
})();
if(inst_34277){
var statearr_34296_34321 = state_34293__$1;
(statearr_34296_34321[(1)] = (8));

} else {
var statearr_34297_34322 = state_34293__$1;
(statearr_34297_34322[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (1))){
var inst_34270 = (0);
var state_34293__$1 = (function (){var statearr_34298 = state_34293;
(statearr_34298[(8)] = inst_34270);

return statearr_34298;
})();
var statearr_34299_34323 = state_34293__$1;
(statearr_34299_34323[(2)] = null);

(statearr_34299_34323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (4))){
var state_34293__$1 = state_34293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34293__$1,(7),ch);
} else {
if((state_val_34294 === (6))){
var inst_34288 = (state_34293[(2)]);
var state_34293__$1 = state_34293;
var statearr_34300_34324 = state_34293__$1;
(statearr_34300_34324[(2)] = inst_34288);

(statearr_34300_34324[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (3))){
var inst_34290 = (state_34293[(2)]);
var inst_34291 = cljs.core.async.close_BANG_(out);
var state_34293__$1 = (function (){var statearr_34301 = state_34293;
(statearr_34301[(9)] = inst_34290);

return statearr_34301;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34293__$1,inst_34291);
} else {
if((state_val_34294 === (2))){
var inst_34270 = (state_34293[(8)]);
var inst_34272 = (inst_34270 < n);
var state_34293__$1 = state_34293;
if(cljs.core.truth_(inst_34272)){
var statearr_34302_34325 = state_34293__$1;
(statearr_34302_34325[(1)] = (4));

} else {
var statearr_34303_34326 = state_34293__$1;
(statearr_34303_34326[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (11))){
var inst_34270 = (state_34293[(8)]);
var inst_34280 = (state_34293[(2)]);
var inst_34281 = (inst_34270 + (1));
var inst_34270__$1 = inst_34281;
var state_34293__$1 = (function (){var statearr_34304 = state_34293;
(statearr_34304[(10)] = inst_34280);

(statearr_34304[(8)] = inst_34270__$1);

return statearr_34304;
})();
var statearr_34305_34327 = state_34293__$1;
(statearr_34305_34327[(2)] = null);

(statearr_34305_34327[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (9))){
var state_34293__$1 = state_34293;
var statearr_34306_34328 = state_34293__$1;
(statearr_34306_34328[(2)] = null);

(statearr_34306_34328[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (5))){
var state_34293__$1 = state_34293;
var statearr_34307_34329 = state_34293__$1;
(statearr_34307_34329[(2)] = null);

(statearr_34307_34329[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (10))){
var inst_34285 = (state_34293[(2)]);
var state_34293__$1 = state_34293;
var statearr_34308_34330 = state_34293__$1;
(statearr_34308_34330[(2)] = inst_34285);

(statearr_34308_34330[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34294 === (8))){
var inst_34275 = (state_34293[(7)]);
var state_34293__$1 = state_34293;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34293__$1,(11),out,inst_34275);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34320,out))
;
return ((function (switch__19184__auto__,c__19296__auto___34320,out){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34312 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34312[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34312[(1)] = (1));

return statearr_34312;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34293){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34293);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34313){if((e34313 instanceof Object)){
var ex__19188__auto__ = e34313;
var statearr_34314_34331 = state_34293;
(statearr_34314_34331[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34293);

return cljs.core.cst$kw$recur;
} else {
throw e34313;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34332 = state_34293;
state_34293 = G__34332;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34293){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34320,out))
})();
var state__19298__auto__ = (function (){var statearr_34315 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34315[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34320);

return statearr_34315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34320,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34342 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34342 = (function (f,ch,meta34343){
this.f = f;
this.ch = ch;
this.meta34343 = meta34343;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34344,meta34343__$1){
var self__ = this;
var _34344__$1 = this;
return (new cljs.core.async.t_cljs$core$async34342(self__.f,self__.ch,meta34343__$1));
});

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34344){
var self__ = this;
var _34344__$1 = this;
return self__.meta34343;
});

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async34345 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34345 = (function (f,ch,meta34343,_,fn1,meta34346){
this.f = f;
this.ch = ch;
this.meta34343 = meta34343;
this._ = _;
this.fn1 = fn1;
this.meta34346 = meta34346;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34345.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_34347,meta34346__$1){
var self__ = this;
var _34347__$1 = this;
return (new cljs.core.async.t_cljs$core$async34345(self__.f,self__.ch,self__.meta34343,self__._,self__.fn1,meta34346__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async34345.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_34347){
var self__ = this;
var _34347__$1 = this;
return self__.meta34346;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34345.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34345.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34345.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34345.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__34333_SHARP_){
var G__34348 = (((p1__34333_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__34333_SHARP_) : self__.f.call(null,p1__34333_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__34348) : f1.call(null,G__34348));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async34345.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34343,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async34342], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta34346], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34345.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34345.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34345";

cljs.core.async.t_cljs$core$async34345.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34345");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async34345 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34345(f__$1,ch__$1,meta34343__$1,___$2,fn1__$1,meta34346){
return (new cljs.core.async.t_cljs$core$async34345(f__$1,ch__$1,meta34343__$1,___$2,fn1__$1,meta34346));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async34345(self__.f,self__.ch,self__.meta34343,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__34349 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__34349) : self__.f.call(null,G__34349));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34342.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async34342.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34343], null);
});

cljs.core.async.t_cljs$core$async34342.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34342.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34342";

cljs.core.async.t_cljs$core$async34342.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34342");
});

cljs.core.async.__GT_t_cljs$core$async34342 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34342(f__$1,ch__$1,meta34343){
return (new cljs.core.async.t_cljs$core$async34342(f__$1,ch__$1,meta34343));
});

}

return (new cljs.core.async.t_cljs$core$async34342(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34353 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34353 = (function (f,ch,meta34354){
this.f = f;
this.ch = ch;
this.meta34354 = meta34354;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34355,meta34354__$1){
var self__ = this;
var _34355__$1 = this;
return (new cljs.core.async.t_cljs$core$async34353(self__.f,self__.ch,meta34354__$1));
});

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34355){
var self__ = this;
var _34355__$1 = this;
return self__.meta34354;
});

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34353.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async34353.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34354], null);
});

cljs.core.async.t_cljs$core$async34353.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34353.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34353";

cljs.core.async.t_cljs$core$async34353.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34353");
});

cljs.core.async.__GT_t_cljs$core$async34353 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async34353(f__$1,ch__$1,meta34354){
return (new cljs.core.async.t_cljs$core$async34353(f__$1,ch__$1,meta34354));
});

}

return (new cljs.core.async.t_cljs$core$async34353(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async34359 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34359 = (function (p,ch,meta34360){
this.p = p;
this.ch = ch;
this.meta34360 = meta34360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34361,meta34360__$1){
var self__ = this;
var _34361__$1 = this;
return (new cljs.core.async.t_cljs$core$async34359(self__.p,self__.ch,meta34360__$1));
});

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34361){
var self__ = this;
var _34361__$1 = this;
return self__.meta34360;
});

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34359.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async34359.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34360], null);
});

cljs.core.async.t_cljs$core$async34359.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34359";

cljs.core.async.t_cljs$core$async34359.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34359");
});

cljs.core.async.__GT_t_cljs$core$async34359 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async34359(p__$1,ch__$1,meta34360){
return (new cljs.core.async.t_cljs$core$async34359(p__$1,ch__$1,meta34360));
});

}

return (new cljs.core.async.t_cljs$core$async34359(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args34362 = [];
var len__7651__auto___34406 = arguments.length;
var i__7652__auto___34407 = (0);
while(true){
if((i__7652__auto___34407 < len__7651__auto___34406)){
args34362.push((arguments[i__7652__auto___34407]));

var G__34408 = (i__7652__auto___34407 + (1));
i__7652__auto___34407 = G__34408;
continue;
} else {
}
break;
}

var G__34364 = args34362.length;
switch (G__34364) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34362.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19296__auto___34410 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34410,out){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34410,out){
return (function (state_34385){
var state_val_34386 = (state_34385[(1)]);
if((state_val_34386 === (7))){
var inst_34381 = (state_34385[(2)]);
var state_34385__$1 = state_34385;
var statearr_34387_34411 = state_34385__$1;
(statearr_34387_34411[(2)] = inst_34381);

(statearr_34387_34411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (1))){
var state_34385__$1 = state_34385;
var statearr_34388_34412 = state_34385__$1;
(statearr_34388_34412[(2)] = null);

(statearr_34388_34412[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (4))){
var inst_34367 = (state_34385[(7)]);
var inst_34367__$1 = (state_34385[(2)]);
var inst_34368 = (inst_34367__$1 == null);
var state_34385__$1 = (function (){var statearr_34389 = state_34385;
(statearr_34389[(7)] = inst_34367__$1);

return statearr_34389;
})();
if(cljs.core.truth_(inst_34368)){
var statearr_34390_34413 = state_34385__$1;
(statearr_34390_34413[(1)] = (5));

} else {
var statearr_34391_34414 = state_34385__$1;
(statearr_34391_34414[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (6))){
var inst_34367 = (state_34385[(7)]);
var inst_34372 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_34367) : p.call(null,inst_34367));
var state_34385__$1 = state_34385;
if(cljs.core.truth_(inst_34372)){
var statearr_34392_34415 = state_34385__$1;
(statearr_34392_34415[(1)] = (8));

} else {
var statearr_34393_34416 = state_34385__$1;
(statearr_34393_34416[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (3))){
var inst_34383 = (state_34385[(2)]);
var state_34385__$1 = state_34385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34385__$1,inst_34383);
} else {
if((state_val_34386 === (2))){
var state_34385__$1 = state_34385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34385__$1,(4),ch);
} else {
if((state_val_34386 === (11))){
var inst_34375 = (state_34385[(2)]);
var state_34385__$1 = state_34385;
var statearr_34394_34417 = state_34385__$1;
(statearr_34394_34417[(2)] = inst_34375);

(statearr_34394_34417[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (9))){
var state_34385__$1 = state_34385;
var statearr_34395_34418 = state_34385__$1;
(statearr_34395_34418[(2)] = null);

(statearr_34395_34418[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (5))){
var inst_34370 = cljs.core.async.close_BANG_(out);
var state_34385__$1 = state_34385;
var statearr_34396_34419 = state_34385__$1;
(statearr_34396_34419[(2)] = inst_34370);

(statearr_34396_34419[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (10))){
var inst_34378 = (state_34385[(2)]);
var state_34385__$1 = (function (){var statearr_34397 = state_34385;
(statearr_34397[(8)] = inst_34378);

return statearr_34397;
})();
var statearr_34398_34420 = state_34385__$1;
(statearr_34398_34420[(2)] = null);

(statearr_34398_34420[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34386 === (8))){
var inst_34367 = (state_34385[(7)]);
var state_34385__$1 = state_34385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34385__$1,(11),out,inst_34367);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34410,out))
;
return ((function (switch__19184__auto__,c__19296__auto___34410,out){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34402 = [null,null,null,null,null,null,null,null,null];
(statearr_34402[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34402[(1)] = (1));

return statearr_34402;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34385){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34385);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34403){if((e34403 instanceof Object)){
var ex__19188__auto__ = e34403;
var statearr_34404_34421 = state_34385;
(statearr_34404_34421[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34385);

return cljs.core.cst$kw$recur;
} else {
throw e34403;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34422 = state_34385;
state_34385 = G__34422;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34410,out))
})();
var state__19298__auto__ = (function (){var statearr_34405 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34405[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34410);

return statearr_34405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34410,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args34423 = [];
var len__7651__auto___34426 = arguments.length;
var i__7652__auto___34427 = (0);
while(true){
if((i__7652__auto___34427 < len__7651__auto___34426)){
args34423.push((arguments[i__7652__auto___34427]));

var G__34428 = (i__7652__auto___34427 + (1));
i__7652__auto___34427 = G__34428;
continue;
} else {
}
break;
}

var G__34425 = args34423.length;
switch (G__34425) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34423.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__){
return (function (state_34595){
var state_val_34596 = (state_34595[(1)]);
if((state_val_34596 === (7))){
var inst_34591 = (state_34595[(2)]);
var state_34595__$1 = state_34595;
var statearr_34597_34638 = state_34595__$1;
(statearr_34597_34638[(2)] = inst_34591);

(statearr_34597_34638[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (20))){
var inst_34561 = (state_34595[(7)]);
var inst_34572 = (state_34595[(2)]);
var inst_34573 = cljs.core.next(inst_34561);
var inst_34547 = inst_34573;
var inst_34548 = null;
var inst_34549 = (0);
var inst_34550 = (0);
var state_34595__$1 = (function (){var statearr_34598 = state_34595;
(statearr_34598[(8)] = inst_34550);

(statearr_34598[(9)] = inst_34572);

(statearr_34598[(10)] = inst_34549);

(statearr_34598[(11)] = inst_34547);

(statearr_34598[(12)] = inst_34548);

return statearr_34598;
})();
var statearr_34599_34639 = state_34595__$1;
(statearr_34599_34639[(2)] = null);

(statearr_34599_34639[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (1))){
var state_34595__$1 = state_34595;
var statearr_34600_34640 = state_34595__$1;
(statearr_34600_34640[(2)] = null);

(statearr_34600_34640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (4))){
var inst_34536 = (state_34595[(13)]);
var inst_34536__$1 = (state_34595[(2)]);
var inst_34537 = (inst_34536__$1 == null);
var state_34595__$1 = (function (){var statearr_34601 = state_34595;
(statearr_34601[(13)] = inst_34536__$1);

return statearr_34601;
})();
if(cljs.core.truth_(inst_34537)){
var statearr_34602_34641 = state_34595__$1;
(statearr_34602_34641[(1)] = (5));

} else {
var statearr_34603_34642 = state_34595__$1;
(statearr_34603_34642[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (15))){
var state_34595__$1 = state_34595;
var statearr_34607_34643 = state_34595__$1;
(statearr_34607_34643[(2)] = null);

(statearr_34607_34643[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (21))){
var state_34595__$1 = state_34595;
var statearr_34608_34644 = state_34595__$1;
(statearr_34608_34644[(2)] = null);

(statearr_34608_34644[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (13))){
var inst_34550 = (state_34595[(8)]);
var inst_34549 = (state_34595[(10)]);
var inst_34547 = (state_34595[(11)]);
var inst_34548 = (state_34595[(12)]);
var inst_34557 = (state_34595[(2)]);
var inst_34558 = (inst_34550 + (1));
var tmp34604 = inst_34549;
var tmp34605 = inst_34547;
var tmp34606 = inst_34548;
var inst_34547__$1 = tmp34605;
var inst_34548__$1 = tmp34606;
var inst_34549__$1 = tmp34604;
var inst_34550__$1 = inst_34558;
var state_34595__$1 = (function (){var statearr_34609 = state_34595;
(statearr_34609[(8)] = inst_34550__$1);

(statearr_34609[(14)] = inst_34557);

(statearr_34609[(10)] = inst_34549__$1);

(statearr_34609[(11)] = inst_34547__$1);

(statearr_34609[(12)] = inst_34548__$1);

return statearr_34609;
})();
var statearr_34610_34645 = state_34595__$1;
(statearr_34610_34645[(2)] = null);

(statearr_34610_34645[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (22))){
var state_34595__$1 = state_34595;
var statearr_34611_34646 = state_34595__$1;
(statearr_34611_34646[(2)] = null);

(statearr_34611_34646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (6))){
var inst_34536 = (state_34595[(13)]);
var inst_34545 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34536) : f.call(null,inst_34536));
var inst_34546 = cljs.core.seq(inst_34545);
var inst_34547 = inst_34546;
var inst_34548 = null;
var inst_34549 = (0);
var inst_34550 = (0);
var state_34595__$1 = (function (){var statearr_34612 = state_34595;
(statearr_34612[(8)] = inst_34550);

(statearr_34612[(10)] = inst_34549);

(statearr_34612[(11)] = inst_34547);

(statearr_34612[(12)] = inst_34548);

return statearr_34612;
})();
var statearr_34613_34647 = state_34595__$1;
(statearr_34613_34647[(2)] = null);

(statearr_34613_34647[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (17))){
var inst_34561 = (state_34595[(7)]);
var inst_34565 = cljs.core.chunk_first(inst_34561);
var inst_34566 = cljs.core.chunk_rest(inst_34561);
var inst_34567 = cljs.core.count(inst_34565);
var inst_34547 = inst_34566;
var inst_34548 = inst_34565;
var inst_34549 = inst_34567;
var inst_34550 = (0);
var state_34595__$1 = (function (){var statearr_34614 = state_34595;
(statearr_34614[(8)] = inst_34550);

(statearr_34614[(10)] = inst_34549);

(statearr_34614[(11)] = inst_34547);

(statearr_34614[(12)] = inst_34548);

return statearr_34614;
})();
var statearr_34615_34648 = state_34595__$1;
(statearr_34615_34648[(2)] = null);

(statearr_34615_34648[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (3))){
var inst_34593 = (state_34595[(2)]);
var state_34595__$1 = state_34595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34595__$1,inst_34593);
} else {
if((state_val_34596 === (12))){
var inst_34581 = (state_34595[(2)]);
var state_34595__$1 = state_34595;
var statearr_34616_34649 = state_34595__$1;
(statearr_34616_34649[(2)] = inst_34581);

(statearr_34616_34649[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (2))){
var state_34595__$1 = state_34595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34595__$1,(4),in$);
} else {
if((state_val_34596 === (23))){
var inst_34589 = (state_34595[(2)]);
var state_34595__$1 = state_34595;
var statearr_34617_34650 = state_34595__$1;
(statearr_34617_34650[(2)] = inst_34589);

(statearr_34617_34650[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (19))){
var inst_34576 = (state_34595[(2)]);
var state_34595__$1 = state_34595;
var statearr_34618_34651 = state_34595__$1;
(statearr_34618_34651[(2)] = inst_34576);

(statearr_34618_34651[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (11))){
var inst_34561 = (state_34595[(7)]);
var inst_34547 = (state_34595[(11)]);
var inst_34561__$1 = cljs.core.seq(inst_34547);
var state_34595__$1 = (function (){var statearr_34619 = state_34595;
(statearr_34619[(7)] = inst_34561__$1);

return statearr_34619;
})();
if(inst_34561__$1){
var statearr_34620_34652 = state_34595__$1;
(statearr_34620_34652[(1)] = (14));

} else {
var statearr_34621_34653 = state_34595__$1;
(statearr_34621_34653[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (9))){
var inst_34583 = (state_34595[(2)]);
var inst_34584 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_34595__$1 = (function (){var statearr_34622 = state_34595;
(statearr_34622[(15)] = inst_34583);

return statearr_34622;
})();
if(cljs.core.truth_(inst_34584)){
var statearr_34623_34654 = state_34595__$1;
(statearr_34623_34654[(1)] = (21));

} else {
var statearr_34624_34655 = state_34595__$1;
(statearr_34624_34655[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (5))){
var inst_34539 = cljs.core.async.close_BANG_(out);
var state_34595__$1 = state_34595;
var statearr_34625_34656 = state_34595__$1;
(statearr_34625_34656[(2)] = inst_34539);

(statearr_34625_34656[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (14))){
var inst_34561 = (state_34595[(7)]);
var inst_34563 = cljs.core.chunked_seq_QMARK_(inst_34561);
var state_34595__$1 = state_34595;
if(inst_34563){
var statearr_34626_34657 = state_34595__$1;
(statearr_34626_34657[(1)] = (17));

} else {
var statearr_34627_34658 = state_34595__$1;
(statearr_34627_34658[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (16))){
var inst_34579 = (state_34595[(2)]);
var state_34595__$1 = state_34595;
var statearr_34628_34659 = state_34595__$1;
(statearr_34628_34659[(2)] = inst_34579);

(statearr_34628_34659[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34596 === (10))){
var inst_34550 = (state_34595[(8)]);
var inst_34548 = (state_34595[(12)]);
var inst_34555 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34548,inst_34550);
var state_34595__$1 = state_34595;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34595__$1,(13),out,inst_34555);
} else {
if((state_val_34596 === (18))){
var inst_34561 = (state_34595[(7)]);
var inst_34570 = cljs.core.first(inst_34561);
var state_34595__$1 = state_34595;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34595__$1,(20),out,inst_34570);
} else {
if((state_val_34596 === (8))){
var inst_34550 = (state_34595[(8)]);
var inst_34549 = (state_34595[(10)]);
var inst_34552 = (inst_34550 < inst_34549);
var inst_34553 = inst_34552;
var state_34595__$1 = state_34595;
if(cljs.core.truth_(inst_34553)){
var statearr_34629_34660 = state_34595__$1;
(statearr_34629_34660[(1)] = (10));

} else {
var statearr_34630_34661 = state_34595__$1;
(statearr_34630_34661[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto__))
;
return ((function (switch__19184__auto__,c__19296__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__19185__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__19185__auto____0 = (function (){
var statearr_34634 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34634[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__19185__auto__);

(statearr_34634[(1)] = (1));

return statearr_34634;
});
var cljs$core$async$mapcat_STAR__$_state_machine__19185__auto____1 = (function (state_34595){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34595);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34635){if((e34635 instanceof Object)){
var ex__19188__auto__ = e34635;
var statearr_34636_34662 = state_34595;
(statearr_34636_34662[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34595);

return cljs.core.cst$kw$recur;
} else {
throw e34635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34663 = state_34595;
state_34595 = G__34663;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__19185__auto__ = function(state_34595){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__19185__auto____1.call(this,state_34595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__19185__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__19185__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__))
})();
var state__19298__auto__ = (function (){var statearr_34637 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_34637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__))
);

return c__19296__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args34664 = [];
var len__7651__auto___34667 = arguments.length;
var i__7652__auto___34668 = (0);
while(true){
if((i__7652__auto___34668 < len__7651__auto___34667)){
args34664.push((arguments[i__7652__auto___34668]));

var G__34669 = (i__7652__auto___34668 + (1));
i__7652__auto___34668 = G__34669;
continue;
} else {
}
break;
}

var G__34666 = args34664.length;
switch (G__34666) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34664.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args34671 = [];
var len__7651__auto___34674 = arguments.length;
var i__7652__auto___34675 = (0);
while(true){
if((i__7652__auto___34675 < len__7651__auto___34674)){
args34671.push((arguments[i__7652__auto___34675]));

var G__34676 = (i__7652__auto___34675 + (1));
i__7652__auto___34675 = G__34676;
continue;
} else {
}
break;
}

var G__34673 = args34671.length;
switch (G__34673) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34671.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args34678 = [];
var len__7651__auto___34729 = arguments.length;
var i__7652__auto___34730 = (0);
while(true){
if((i__7652__auto___34730 < len__7651__auto___34729)){
args34678.push((arguments[i__7652__auto___34730]));

var G__34731 = (i__7652__auto___34730 + (1));
i__7652__auto___34730 = G__34731;
continue;
} else {
}
break;
}

var G__34680 = args34678.length;
switch (G__34680) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34678.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19296__auto___34733 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34733,out){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34733,out){
return (function (state_34704){
var state_val_34705 = (state_34704[(1)]);
if((state_val_34705 === (7))){
var inst_34699 = (state_34704[(2)]);
var state_34704__$1 = state_34704;
var statearr_34706_34734 = state_34704__$1;
(statearr_34706_34734[(2)] = inst_34699);

(statearr_34706_34734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (1))){
var inst_34681 = null;
var state_34704__$1 = (function (){var statearr_34707 = state_34704;
(statearr_34707[(7)] = inst_34681);

return statearr_34707;
})();
var statearr_34708_34735 = state_34704__$1;
(statearr_34708_34735[(2)] = null);

(statearr_34708_34735[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (4))){
var inst_34684 = (state_34704[(8)]);
var inst_34684__$1 = (state_34704[(2)]);
var inst_34685 = (inst_34684__$1 == null);
var inst_34686 = cljs.core.not(inst_34685);
var state_34704__$1 = (function (){var statearr_34709 = state_34704;
(statearr_34709[(8)] = inst_34684__$1);

return statearr_34709;
})();
if(inst_34686){
var statearr_34710_34736 = state_34704__$1;
(statearr_34710_34736[(1)] = (5));

} else {
var statearr_34711_34737 = state_34704__$1;
(statearr_34711_34737[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (6))){
var state_34704__$1 = state_34704;
var statearr_34712_34738 = state_34704__$1;
(statearr_34712_34738[(2)] = null);

(statearr_34712_34738[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (3))){
var inst_34701 = (state_34704[(2)]);
var inst_34702 = cljs.core.async.close_BANG_(out);
var state_34704__$1 = (function (){var statearr_34713 = state_34704;
(statearr_34713[(9)] = inst_34701);

return statearr_34713;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34704__$1,inst_34702);
} else {
if((state_val_34705 === (2))){
var state_34704__$1 = state_34704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34704__$1,(4),ch);
} else {
if((state_val_34705 === (11))){
var inst_34684 = (state_34704[(8)]);
var inst_34693 = (state_34704[(2)]);
var inst_34681 = inst_34684;
var state_34704__$1 = (function (){var statearr_34714 = state_34704;
(statearr_34714[(7)] = inst_34681);

(statearr_34714[(10)] = inst_34693);

return statearr_34714;
})();
var statearr_34715_34739 = state_34704__$1;
(statearr_34715_34739[(2)] = null);

(statearr_34715_34739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (9))){
var inst_34684 = (state_34704[(8)]);
var state_34704__$1 = state_34704;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34704__$1,(11),out,inst_34684);
} else {
if((state_val_34705 === (5))){
var inst_34684 = (state_34704[(8)]);
var inst_34681 = (state_34704[(7)]);
var inst_34688 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34684,inst_34681);
var state_34704__$1 = state_34704;
if(inst_34688){
var statearr_34717_34740 = state_34704__$1;
(statearr_34717_34740[(1)] = (8));

} else {
var statearr_34718_34741 = state_34704__$1;
(statearr_34718_34741[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (10))){
var inst_34696 = (state_34704[(2)]);
var state_34704__$1 = state_34704;
var statearr_34719_34742 = state_34704__$1;
(statearr_34719_34742[(2)] = inst_34696);

(statearr_34719_34742[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34705 === (8))){
var inst_34681 = (state_34704[(7)]);
var tmp34716 = inst_34681;
var inst_34681__$1 = tmp34716;
var state_34704__$1 = (function (){var statearr_34720 = state_34704;
(statearr_34720[(7)] = inst_34681__$1);

return statearr_34720;
})();
var statearr_34721_34743 = state_34704__$1;
(statearr_34721_34743[(2)] = null);

(statearr_34721_34743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34733,out))
;
return ((function (switch__19184__auto__,c__19296__auto___34733,out){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34725 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34725[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34725[(1)] = (1));

return statearr_34725;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34704){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34704);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34726){if((e34726 instanceof Object)){
var ex__19188__auto__ = e34726;
var statearr_34727_34744 = state_34704;
(statearr_34727_34744[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34704);

return cljs.core.cst$kw$recur;
} else {
throw e34726;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34745 = state_34704;
state_34704 = G__34745;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34704){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34733,out))
})();
var state__19298__auto__ = (function (){var statearr_34728 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34728[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34733);

return statearr_34728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34733,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args34746 = [];
var len__7651__auto___34816 = arguments.length;
var i__7652__auto___34817 = (0);
while(true){
if((i__7652__auto___34817 < len__7651__auto___34816)){
args34746.push((arguments[i__7652__auto___34817]));

var G__34818 = (i__7652__auto___34817 + (1));
i__7652__auto___34817 = G__34818;
continue;
} else {
}
break;
}

var G__34748 = args34746.length;
switch (G__34748) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34746.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19296__auto___34820 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34820,out){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34820,out){
return (function (state_34786){
var state_val_34787 = (state_34786[(1)]);
if((state_val_34787 === (7))){
var inst_34782 = (state_34786[(2)]);
var state_34786__$1 = state_34786;
var statearr_34788_34821 = state_34786__$1;
(statearr_34788_34821[(2)] = inst_34782);

(statearr_34788_34821[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (1))){
var inst_34749 = (new Array(n));
var inst_34750 = inst_34749;
var inst_34751 = (0);
var state_34786__$1 = (function (){var statearr_34789 = state_34786;
(statearr_34789[(7)] = inst_34751);

(statearr_34789[(8)] = inst_34750);

return statearr_34789;
})();
var statearr_34790_34822 = state_34786__$1;
(statearr_34790_34822[(2)] = null);

(statearr_34790_34822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (4))){
var inst_34754 = (state_34786[(9)]);
var inst_34754__$1 = (state_34786[(2)]);
var inst_34755 = (inst_34754__$1 == null);
var inst_34756 = cljs.core.not(inst_34755);
var state_34786__$1 = (function (){var statearr_34791 = state_34786;
(statearr_34791[(9)] = inst_34754__$1);

return statearr_34791;
})();
if(inst_34756){
var statearr_34792_34823 = state_34786__$1;
(statearr_34792_34823[(1)] = (5));

} else {
var statearr_34793_34824 = state_34786__$1;
(statearr_34793_34824[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (15))){
var inst_34776 = (state_34786[(2)]);
var state_34786__$1 = state_34786;
var statearr_34794_34825 = state_34786__$1;
(statearr_34794_34825[(2)] = inst_34776);

(statearr_34794_34825[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (13))){
var state_34786__$1 = state_34786;
var statearr_34795_34826 = state_34786__$1;
(statearr_34795_34826[(2)] = null);

(statearr_34795_34826[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (6))){
var inst_34751 = (state_34786[(7)]);
var inst_34772 = (inst_34751 > (0));
var state_34786__$1 = state_34786;
if(cljs.core.truth_(inst_34772)){
var statearr_34796_34827 = state_34786__$1;
(statearr_34796_34827[(1)] = (12));

} else {
var statearr_34797_34828 = state_34786__$1;
(statearr_34797_34828[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (3))){
var inst_34784 = (state_34786[(2)]);
var state_34786__$1 = state_34786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34786__$1,inst_34784);
} else {
if((state_val_34787 === (12))){
var inst_34750 = (state_34786[(8)]);
var inst_34774 = cljs.core.vec(inst_34750);
var state_34786__$1 = state_34786;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34786__$1,(15),out,inst_34774);
} else {
if((state_val_34787 === (2))){
var state_34786__$1 = state_34786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34786__$1,(4),ch);
} else {
if((state_val_34787 === (11))){
var inst_34766 = (state_34786[(2)]);
var inst_34767 = (new Array(n));
var inst_34750 = inst_34767;
var inst_34751 = (0);
var state_34786__$1 = (function (){var statearr_34798 = state_34786;
(statearr_34798[(7)] = inst_34751);

(statearr_34798[(8)] = inst_34750);

(statearr_34798[(10)] = inst_34766);

return statearr_34798;
})();
var statearr_34799_34829 = state_34786__$1;
(statearr_34799_34829[(2)] = null);

(statearr_34799_34829[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (9))){
var inst_34750 = (state_34786[(8)]);
var inst_34764 = cljs.core.vec(inst_34750);
var state_34786__$1 = state_34786;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34786__$1,(11),out,inst_34764);
} else {
if((state_val_34787 === (5))){
var inst_34751 = (state_34786[(7)]);
var inst_34750 = (state_34786[(8)]);
var inst_34759 = (state_34786[(11)]);
var inst_34754 = (state_34786[(9)]);
var inst_34758 = (inst_34750[inst_34751] = inst_34754);
var inst_34759__$1 = (inst_34751 + (1));
var inst_34760 = (inst_34759__$1 < n);
var state_34786__$1 = (function (){var statearr_34800 = state_34786;
(statearr_34800[(12)] = inst_34758);

(statearr_34800[(11)] = inst_34759__$1);

return statearr_34800;
})();
if(cljs.core.truth_(inst_34760)){
var statearr_34801_34830 = state_34786__$1;
(statearr_34801_34830[(1)] = (8));

} else {
var statearr_34802_34831 = state_34786__$1;
(statearr_34802_34831[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (14))){
var inst_34779 = (state_34786[(2)]);
var inst_34780 = cljs.core.async.close_BANG_(out);
var state_34786__$1 = (function (){var statearr_34804 = state_34786;
(statearr_34804[(13)] = inst_34779);

return statearr_34804;
})();
var statearr_34805_34832 = state_34786__$1;
(statearr_34805_34832[(2)] = inst_34780);

(statearr_34805_34832[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (10))){
var inst_34770 = (state_34786[(2)]);
var state_34786__$1 = state_34786;
var statearr_34806_34833 = state_34786__$1;
(statearr_34806_34833[(2)] = inst_34770);

(statearr_34806_34833[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34787 === (8))){
var inst_34750 = (state_34786[(8)]);
var inst_34759 = (state_34786[(11)]);
var tmp34803 = inst_34750;
var inst_34750__$1 = tmp34803;
var inst_34751 = inst_34759;
var state_34786__$1 = (function (){var statearr_34807 = state_34786;
(statearr_34807[(7)] = inst_34751);

(statearr_34807[(8)] = inst_34750__$1);

return statearr_34807;
})();
var statearr_34808_34834 = state_34786__$1;
(statearr_34808_34834[(2)] = null);

(statearr_34808_34834[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34820,out))
;
return ((function (switch__19184__auto__,c__19296__auto___34820,out){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34812 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34812[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34812[(1)] = (1));

return statearr_34812;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34786){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34786);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34813){if((e34813 instanceof Object)){
var ex__19188__auto__ = e34813;
var statearr_34814_34835 = state_34786;
(statearr_34814_34835[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34786);

return cljs.core.cst$kw$recur;
} else {
throw e34813;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34836 = state_34786;
state_34786 = G__34836;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34786){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34820,out))
})();
var state__19298__auto__ = (function (){var statearr_34815 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34815[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34820);

return statearr_34815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34820,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34837 = [];
var len__7651__auto___34911 = arguments.length;
var i__7652__auto___34912 = (0);
while(true){
if((i__7652__auto___34912 < len__7651__auto___34911)){
args34837.push((arguments[i__7652__auto___34912]));

var G__34913 = (i__7652__auto___34912 + (1));
i__7652__auto___34912 = G__34913;
continue;
} else {
}
break;
}

var G__34839 = args34837.length;
switch (G__34839) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34837.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19296__auto___34915 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___34915,out){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___34915,out){
return (function (state_34881){
var state_val_34882 = (state_34881[(1)]);
if((state_val_34882 === (7))){
var inst_34877 = (state_34881[(2)]);
var state_34881__$1 = state_34881;
var statearr_34883_34916 = state_34881__$1;
(statearr_34883_34916[(2)] = inst_34877);

(statearr_34883_34916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (1))){
var inst_34840 = [];
var inst_34841 = inst_34840;
var inst_34842 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_34881__$1 = (function (){var statearr_34884 = state_34881;
(statearr_34884[(7)] = inst_34841);

(statearr_34884[(8)] = inst_34842);

return statearr_34884;
})();
var statearr_34885_34917 = state_34881__$1;
(statearr_34885_34917[(2)] = null);

(statearr_34885_34917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (4))){
var inst_34845 = (state_34881[(9)]);
var inst_34845__$1 = (state_34881[(2)]);
var inst_34846 = (inst_34845__$1 == null);
var inst_34847 = cljs.core.not(inst_34846);
var state_34881__$1 = (function (){var statearr_34886 = state_34881;
(statearr_34886[(9)] = inst_34845__$1);

return statearr_34886;
})();
if(inst_34847){
var statearr_34887_34918 = state_34881__$1;
(statearr_34887_34918[(1)] = (5));

} else {
var statearr_34888_34919 = state_34881__$1;
(statearr_34888_34919[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (15))){
var inst_34871 = (state_34881[(2)]);
var state_34881__$1 = state_34881;
var statearr_34889_34920 = state_34881__$1;
(statearr_34889_34920[(2)] = inst_34871);

(statearr_34889_34920[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (13))){
var state_34881__$1 = state_34881;
var statearr_34890_34921 = state_34881__$1;
(statearr_34890_34921[(2)] = null);

(statearr_34890_34921[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (6))){
var inst_34841 = (state_34881[(7)]);
var inst_34866 = inst_34841.length;
var inst_34867 = (inst_34866 > (0));
var state_34881__$1 = state_34881;
if(cljs.core.truth_(inst_34867)){
var statearr_34891_34922 = state_34881__$1;
(statearr_34891_34922[(1)] = (12));

} else {
var statearr_34892_34923 = state_34881__$1;
(statearr_34892_34923[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (3))){
var inst_34879 = (state_34881[(2)]);
var state_34881__$1 = state_34881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34881__$1,inst_34879);
} else {
if((state_val_34882 === (12))){
var inst_34841 = (state_34881[(7)]);
var inst_34869 = cljs.core.vec(inst_34841);
var state_34881__$1 = state_34881;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34881__$1,(15),out,inst_34869);
} else {
if((state_val_34882 === (2))){
var state_34881__$1 = state_34881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34881__$1,(4),ch);
} else {
if((state_val_34882 === (11))){
var inst_34845 = (state_34881[(9)]);
var inst_34849 = (state_34881[(10)]);
var inst_34859 = (state_34881[(2)]);
var inst_34860 = [];
var inst_34861 = inst_34860.push(inst_34845);
var inst_34841 = inst_34860;
var inst_34842 = inst_34849;
var state_34881__$1 = (function (){var statearr_34893 = state_34881;
(statearr_34893[(11)] = inst_34859);

(statearr_34893[(7)] = inst_34841);

(statearr_34893[(12)] = inst_34861);

(statearr_34893[(8)] = inst_34842);

return statearr_34893;
})();
var statearr_34894_34924 = state_34881__$1;
(statearr_34894_34924[(2)] = null);

(statearr_34894_34924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (9))){
var inst_34841 = (state_34881[(7)]);
var inst_34857 = cljs.core.vec(inst_34841);
var state_34881__$1 = state_34881;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34881__$1,(11),out,inst_34857);
} else {
if((state_val_34882 === (5))){
var inst_34845 = (state_34881[(9)]);
var inst_34849 = (state_34881[(10)]);
var inst_34842 = (state_34881[(8)]);
var inst_34849__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34845) : f.call(null,inst_34845));
var inst_34850 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34849__$1,inst_34842);
var inst_34851 = cljs.core.keyword_identical_QMARK_(inst_34842,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_34852 = (inst_34850) || (inst_34851);
var state_34881__$1 = (function (){var statearr_34895 = state_34881;
(statearr_34895[(10)] = inst_34849__$1);

return statearr_34895;
})();
if(cljs.core.truth_(inst_34852)){
var statearr_34896_34925 = state_34881__$1;
(statearr_34896_34925[(1)] = (8));

} else {
var statearr_34897_34926 = state_34881__$1;
(statearr_34897_34926[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (14))){
var inst_34874 = (state_34881[(2)]);
var inst_34875 = cljs.core.async.close_BANG_(out);
var state_34881__$1 = (function (){var statearr_34899 = state_34881;
(statearr_34899[(13)] = inst_34874);

return statearr_34899;
})();
var statearr_34900_34927 = state_34881__$1;
(statearr_34900_34927[(2)] = inst_34875);

(statearr_34900_34927[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (10))){
var inst_34864 = (state_34881[(2)]);
var state_34881__$1 = state_34881;
var statearr_34901_34928 = state_34881__$1;
(statearr_34901_34928[(2)] = inst_34864);

(statearr_34901_34928[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34882 === (8))){
var inst_34845 = (state_34881[(9)]);
var inst_34849 = (state_34881[(10)]);
var inst_34841 = (state_34881[(7)]);
var inst_34854 = inst_34841.push(inst_34845);
var tmp34898 = inst_34841;
var inst_34841__$1 = tmp34898;
var inst_34842 = inst_34849;
var state_34881__$1 = (function (){var statearr_34902 = state_34881;
(statearr_34902[(7)] = inst_34841__$1);

(statearr_34902[(14)] = inst_34854);

(statearr_34902[(8)] = inst_34842);

return statearr_34902;
})();
var statearr_34903_34929 = state_34881__$1;
(statearr_34903_34929[(2)] = null);

(statearr_34903_34929[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___34915,out))
;
return ((function (switch__19184__auto__,c__19296__auto___34915,out){
return (function() {
var cljs$core$async$state_machine__19185__auto__ = null;
var cljs$core$async$state_machine__19185__auto____0 = (function (){
var statearr_34907 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34907[(0)] = cljs$core$async$state_machine__19185__auto__);

(statearr_34907[(1)] = (1));

return statearr_34907;
});
var cljs$core$async$state_machine__19185__auto____1 = (function (state_34881){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34881);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e34908){if((e34908 instanceof Object)){
var ex__19188__auto__ = e34908;
var statearr_34909_34930 = state_34881;
(statearr_34909_34930[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34881);

return cljs.core.cst$kw$recur;
} else {
throw e34908;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__34931 = state_34881;
state_34881 = G__34931;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs$core$async$state_machine__19185__auto__ = function(state_34881){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19185__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19185__auto____1.call(this,state_34881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19185__auto____0;
cljs$core$async$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19185__auto____1;
return cljs$core$async$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___34915,out))
})();
var state__19298__auto__ = (function (){var statearr_34910 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_34910[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___34915);

return statearr_34910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___34915,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

