// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.notes');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Returns all notes. Returns notes for a specific submission if
 *   optional instance ID is proviced
 */
milia.api.notes.list = (function milia$api$notes$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38003 = arguments.length;
var i__7652__auto___38004 = (0);
while(true){
if((i__7652__auto___38004 < len__7651__auto___38003)){
args__7658__auto__.push((arguments[i__7652__auto___38004]));

var G__38005 = (i__7652__auto___38004 + (1));
i__7652__auto___38004 = G__38005;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__38000){
var map__38001 = p__38000;
var map__38001__$1 = ((((!((map__38001 == null)))?((((map__38001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38001.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38001):map__38001);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38001__$1,cljs.core.cst$kw$instance_DASH_id);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38001__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("notes"),cljs.core.str((cljs.core.truth_(instance_id)?[cljs.core.str("?instance="),cljs.core.str(instance_id)].join(''):null))].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.notes.list.cljs$lang$maxFixedArity = (0);

milia.api.notes.list.cljs$lang$applyTo = (function (seq37999){
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37999));
});

/**
 * Creates a note for a submission instance given the note and instance-id.
 * Takes an options instance-field argument if note added for specific field.
 */
milia.api.notes.create = (function milia$api$notes$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38013 = arguments.length;
var i__7652__auto___38014 = (0);
while(true){
if((i__7652__auto___38014 < len__7651__auto___38013)){
args__7658__auto__.push((arguments[i__7652__auto___38014]));

var G__38015 = (i__7652__auto___38014 + (1));
i__7652__auto___38014 = G__38015;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic = (function (note,instance_id,p__38009){
var vec__38010 = p__38009;
var instance_field = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38010,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes"], 0));
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$instance,instance_id], null);
var form_params = (cljs.core.truth_(instance_field)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(params,cljs.core.cst$kw$instance_field,instance_field):params);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.notes.create.cljs$lang$maxFixedArity = (2);

milia.api.notes.create.cljs$lang$applyTo = (function (seq38006){
var G__38007 = cljs.core.first(seq38006);
var seq38006__$1 = cljs.core.next(seq38006);
var G__38008 = cljs.core.first(seq38006__$1);
var seq38006__$2 = cljs.core.next(seq38006__$1);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic(G__38007,G__38008,seq38006__$2);
});

/**
 * Returns a note object given a note ID.
 */
milia.api.notes.get = (function milia$api$notes$get(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes",note_id], 0)));
});
/**
 * Deletes a note given a note ID.
 */
milia.api.notes.delete$ = (function milia$api$notes$delete(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes",note_id], 0)));
});
