// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__37577 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__37577,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__37578 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__37578) : cljs_hash.md5.md5.call(null,G__37578));
})());
} else {
return G__37577;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37583 = arguments.length;
var i__7652__auto___37584 = (0);
while(true){
if((i__7652__auto___37584 < len__7651__auto___37583)){
args__7658__auto__.push((arguments[i__7652__auto___37584]));

var G__37585 = (i__7652__auto___37584 + (1));
i__7652__auto___37584 = G__37585;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__37580){
var map__37581 = p__37580;
var map__37581__$1 = ((((!((map__37581 == null)))?((((map__37581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37581.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37581):map__37581);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37581__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37581__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37581__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37581__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq37579){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37579));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37595 = arguments.length;
var i__7652__auto___37596 = (0);
while(true){
if((i__7652__auto___37596 < len__7651__auto___37595)){
args__7658__auto__.push((arguments[i__7652__auto___37596]));

var G__37597 = (i__7652__auto___37596 + (1));
i__7652__auto___37596 = G__37597;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__37588){
var vec__37589 = p__37588;
var map__37592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37589,(0),null);
var map__37592__$1 = ((((!((map__37592 == null)))?((((map__37592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37592.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37592):map__37592);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37592__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e37594){if((e37594 instanceof Error)){
var _ = e37594;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e37594;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq37586){
var G__37587 = cljs.core.first(seq37586);
var seq37586__$1 = cljs.core.next(seq37586);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__37587,seq37586__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__37604_37610 = io_obj;
var G__37605_37611 = goog.net.EventType.SUCCESS;
var G__37606_37612 = ((function (G__37604_37610,G__37605_37611,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__37604_37610,G__37605_37611,io_obj))
;
goog.events.listen(G__37604_37610,G__37605_37611,G__37606_37612);

var G__37607_37613 = io_obj;
var G__37608_37614 = goog.net.EventType.ERROR;
var G__37609_37615 = ((function (G__37607_37613,G__37608_37614,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__37607_37613,G__37608_37614,io_obj))
;
goog.events.listen(G__37607_37613,G__37608_37614,G__37609_37615);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37632 = arguments.length;
var i__7652__auto___37633 = (0);
while(true){
if((i__7652__auto___37633 < len__7651__auto___37632)){
args__7658__auto__.push((arguments[i__7652__auto___37633]));

var G__37634 = (i__7652__auto___37633 + (1));
i__7652__auto___37633 = G__37634;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__37620){
var map__37621 = p__37620;
var map__37621__$1 = ((((!((map__37621 == null)))?((((map__37621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37621.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37621):map__37621);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37621__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37621__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37621__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__37623_37635 = io_obj;
var G__37624_37636 = goog.net.EventType.SUCCESS;
var G__37625_37637 = ((function (G__37623_37635,G__37624_37636,io_obj,data,url,map__37621,map__37621__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__37623_37635,G__37624_37636,io_obj,data,url,map__37621,map__37621__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37623_37635,G__37624_37636,G__37625_37637);

var G__37626_37638 = io_obj;
var G__37627_37639 = goog.net.EventType.ERROR;
var G__37628_37640 = ((function (G__37626_37638,G__37627_37639,io_obj,data,url,map__37621,map__37621__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__37626_37638,G__37627_37639,io_obj,data,url,map__37621,map__37621__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37626_37638,G__37627_37639,G__37628_37640);

var G__37629_37641 = io_obj;
var G__37630_37642 = goog.net.EventType.PROGRESS;
var G__37631_37643 = ((function (G__37629_37641,G__37630_37642,io_obj,data,url,map__37621,map__37621__$1,headers,id,require_json_QMARK_){
return (function (p1__37616_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__37616_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__37616_SHARP_.loaded,cljs.core.cst$kw$total,p1__37616_SHARP_.total], null)));
});})(G__37629_37641,G__37630_37642,io_obj,data,url,map__37621,map__37621__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__37629_37641,G__37630_37642,G__37631_37643);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq37617){
var G__37618 = cljs.core.first(seq37617);
var seq37617__$1 = cljs.core.next(seq37617);
var G__37619 = cljs.core.first(seq37617__$1);
var seq37617__$2 = cljs.core.next(seq37617__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__37618,G__37619,seq37617__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37708 = arguments.length;
var i__7652__auto___37709 = (0);
while(true){
if((i__7652__auto___37709 < len__7651__auto___37708)){
args__7658__auto__.push((arguments[i__7652__auto___37709]));

var G__37710 = (i__7652__auto___37709 + (1));
i__7652__auto___37709 = G__37710;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19296__auto___37711 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___37711,response_channel){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___37711,response_channel){
return (function (state_37681){
var state_val_37682 = (state_37681[(1)]);
if((state_val_37682 === (7))){
var state_37681__$1 = state_37681;
var statearr_37683_37712 = state_37681__$1;
(statearr_37683_37712[(2)] = false);

(statearr_37683_37712[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (1))){
var inst_37647 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_37681__$1 = state_37681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37681__$1,(2),inst_37647);
} else {
if((state_val_37682 === (4))){
var state_37681__$1 = state_37681;
var statearr_37684_37713 = state_37681__$1;
(statearr_37684_37713[(2)] = false);

(statearr_37684_37713[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (13))){
var inst_37670 = (state_37681[(7)]);
var inst_37677 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_37670);
var state_37681__$1 = state_37681;
var statearr_37685_37714 = state_37681__$1;
(statearr_37685_37714[(2)] = inst_37677);

(statearr_37685_37714[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (6))){
var state_37681__$1 = state_37681;
var statearr_37686_37715 = state_37681__$1;
(statearr_37686_37715[(2)] = true);

(statearr_37686_37715[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (3))){
var inst_37649 = (state_37681[(8)]);
var inst_37654 = inst_37649.cljs$lang$protocol_mask$partition0$;
var inst_37655 = (inst_37654 & (64));
var inst_37656 = inst_37649.cljs$core$ISeq$;
var inst_37657 = (cljs.core.PROTOCOL_SENTINEL === inst_37656);
var inst_37658 = (inst_37655) || (inst_37657);
var state_37681__$1 = state_37681;
if(cljs.core.truth_(inst_37658)){
var statearr_37687_37716 = state_37681__$1;
(statearr_37687_37716[(1)] = (6));

} else {
var statearr_37688_37717 = state_37681__$1;
(statearr_37688_37717[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (12))){
var inst_37674 = window.location.href();
var inst_37675 = window.location = inst_37674;
var state_37681__$1 = state_37681;
var statearr_37689_37718 = state_37681__$1;
(statearr_37689_37718[(2)] = inst_37675);

(statearr_37689_37718[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (2))){
var inst_37649 = (state_37681[(8)]);
var inst_37649__$1 = (state_37681[(2)]);
var inst_37651 = (inst_37649__$1 == null);
var inst_37652 = cljs.core.not(inst_37651);
var state_37681__$1 = (function (){var statearr_37690 = state_37681;
(statearr_37690[(8)] = inst_37649__$1);

return statearr_37690;
})();
if(inst_37652){
var statearr_37691_37719 = state_37681__$1;
(statearr_37691_37719[(1)] = (3));

} else {
var statearr_37692_37720 = state_37681__$1;
(statearr_37692_37720[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (11))){
var inst_37670 = (state_37681[(7)]);
var inst_37670__$1 = (state_37681[(2)]);
var inst_37671 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37670__$1,cljs.core.cst$kw$status);
var inst_37672 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37671,(401));
var state_37681__$1 = (function (){var statearr_37693 = state_37681;
(statearr_37693[(7)] = inst_37670__$1);

return statearr_37693;
})();
if(inst_37672){
var statearr_37694_37721 = state_37681__$1;
(statearr_37694_37721[(1)] = (12));

} else {
var statearr_37695_37722 = state_37681__$1;
(statearr_37695_37722[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (9))){
var inst_37649 = (state_37681[(8)]);
var inst_37667 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37649);
var state_37681__$1 = state_37681;
var statearr_37696_37723 = state_37681__$1;
(statearr_37696_37723[(2)] = inst_37667);

(statearr_37696_37723[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (5))){
var inst_37665 = (state_37681[(2)]);
var state_37681__$1 = state_37681;
if(cljs.core.truth_(inst_37665)){
var statearr_37697_37724 = state_37681__$1;
(statearr_37697_37724[(1)] = (9));

} else {
var statearr_37698_37725 = state_37681__$1;
(statearr_37698_37725[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (14))){
var inst_37679 = (state_37681[(2)]);
var state_37681__$1 = state_37681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37681__$1,inst_37679);
} else {
if((state_val_37682 === (10))){
var inst_37649 = (state_37681[(8)]);
var state_37681__$1 = state_37681;
var statearr_37699_37726 = state_37681__$1;
(statearr_37699_37726[(2)] = inst_37649);

(statearr_37699_37726[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37682 === (8))){
var inst_37662 = (state_37681[(2)]);
var state_37681__$1 = state_37681;
var statearr_37700_37727 = state_37681__$1;
(statearr_37700_37727[(2)] = inst_37662);

(statearr_37700_37727[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto___37711,response_channel))
;
return ((function (switch__19184__auto__,c__19296__auto___37711,response_channel){
return (function() {
var milia$api$io$state_machine__19185__auto__ = null;
var milia$api$io$state_machine__19185__auto____0 = (function (){
var statearr_37704 = [null,null,null,null,null,null,null,null,null];
(statearr_37704[(0)] = milia$api$io$state_machine__19185__auto__);

(statearr_37704[(1)] = (1));

return statearr_37704;
});
var milia$api$io$state_machine__19185__auto____1 = (function (state_37681){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_37681);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e37705){if((e37705 instanceof Object)){
var ex__19188__auto__ = e37705;
var statearr_37706_37728 = state_37681;
(statearr_37706_37728[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37681);

return cljs.core.cst$kw$recur;
} else {
throw e37705;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__37729 = state_37681;
state_37681 = G__37729;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
milia$api$io$state_machine__19185__auto__ = function(state_37681){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19185__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19185__auto____1.call(this,state_37681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19185__auto____0;
milia$api$io$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19185__auto____1;
return milia$api$io$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___37711,response_channel))
})();
var state__19298__auto__ = (function (){var statearr_37707 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_37707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___37711);

return statearr_37707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___37711,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq37644){
var G__37645 = cljs.core.first(seq37644);
var seq37644__$1 = cljs.core.next(seq37644);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__37645,seq37644__$1);
});

