// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__34934 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34934) : cljs.core.atom.call(null,G__34934));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__34939){
var vec__34940 = p__34939;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34940,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34940,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__34944 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__34944)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__34944)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__34944)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__34944)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__34944)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__34944)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__34945){
var map__34949 = p__34945;
var map__34949__$1 = ((((!((map__34949 == null)))?((((map__34949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34949.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34949):map__34949);
var request = map__34949__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34949__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34949__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34949__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6543__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__34951 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__34951,default_headers);

cljs_http.core.apply_response_type_BANG_(G__34951,response_type);

G__34951.setTimeoutInterval(timeout);

G__34951.setWithCredentials(send_credentials);

return G__34951;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__34952){
var map__34981 = p__34952;
var map__34981__$1 = ((((!((map__34981 == null)))?((((map__34981.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34981.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34981):map__34981);
var request = map__34981__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34981__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34981__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34981__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34981__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34981__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34981__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6543__auto__ = request_method;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__34983 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__34983) : cljs_http.core.error_kw.call(null,G__34983));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_35009 = ((function (channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__34984_35010 = xhr;
G__34984_35010.setProgressEventsEnabled(true);

G__34984_35010.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_35009,cljs.core.cst$kw$upload));

G__34984_35010.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_35009,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__19296__auto___35011 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___35011,channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___35011,channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_34995){
var state_val_34996 = (state_34995[(1)]);
if((state_val_34996 === (1))){
var state_34995__$1 = state_34995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34995__$1,(2),cancel);
} else {
if((state_val_34996 === (2))){
var inst_34986 = (state_34995[(2)]);
var inst_34987 = xhr.isComplete();
var inst_34988 = cljs.core.not(inst_34987);
var state_34995__$1 = (function (){var statearr_34997 = state_34995;
(statearr_34997[(7)] = inst_34986);

return statearr_34997;
})();
if(inst_34988){
var statearr_34998_35012 = state_34995__$1;
(statearr_34998_35012[(1)] = (3));

} else {
var statearr_34999_35013 = state_34995__$1;
(statearr_34999_35013[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34996 === (3))){
var inst_34990 = xhr.abort();
var state_34995__$1 = state_34995;
var statearr_35000_35014 = state_34995__$1;
(statearr_35000_35014[(2)] = inst_34990);

(statearr_35000_35014[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34996 === (4))){
var state_34995__$1 = state_34995;
var statearr_35001_35015 = state_34995__$1;
(statearr_35001_35015[(2)] = null);

(statearr_35001_35015[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34996 === (5))){
var inst_34993 = (state_34995[(2)]);
var state_34995__$1 = state_34995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34995__$1,inst_34993);
} else {
return null;
}
}
}
}
}
});})(c__19296__auto___35011,channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__19184__auto__,c__19296__auto___35011,channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__19185__auto__ = null;
var cljs_http$core$xhr_$_state_machine__19185__auto____0 = (function (){
var statearr_35005 = [null,null,null,null,null,null,null,null];
(statearr_35005[(0)] = cljs_http$core$xhr_$_state_machine__19185__auto__);

(statearr_35005[(1)] = (1));

return statearr_35005;
});
var cljs_http$core$xhr_$_state_machine__19185__auto____1 = (function (state_34995){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_34995);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e35006){if((e35006 instanceof Object)){
var ex__19188__auto__ = e35006;
var statearr_35007_35016 = state_34995;
(statearr_35007_35016[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34995);

return cljs.core.cst$kw$recur;
} else {
throw e35006;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__35017 = state_34995;
state_34995 = G__35017;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__19185__auto__ = function(state_34995){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__19185__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__19185__auto____1.call(this,state_34995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__19185__auto____0;
cljs_http$core$xhr_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__19185__auto____1;
return cljs_http$core$xhr_$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___35011,channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__19298__auto__ = (function (){var statearr_35008 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_35008[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___35011);

return statearr_35008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___35011,channel,request_url,method,headers__$1,xhr,map__34981,map__34981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__35018){
var map__35035 = p__35018;
var map__35035__$1 = ((((!((map__35035 == null)))?((((map__35035.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35035.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35035):map__35035);
var request = map__35035__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35035__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35035__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35035__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35035__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_35051 = jsonp.send(null,((function (channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_35051], null));

if(cljs.core.truth_(cancel)){
var c__19296__auto___35052 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto___35052,req_35051,channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto___35052,req_35051,channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_35041){
var state_val_35042 = (state_35041[(1)]);
if((state_val_35042 === (1))){
var state_35041__$1 = state_35041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35041__$1,(2),cancel);
} else {
if((state_val_35042 === (2))){
var inst_35038 = (state_35041[(2)]);
var inst_35039 = jsonp.cancel(req_35051);
var state_35041__$1 = (function (){var statearr_35043 = state_35041;
(statearr_35043[(7)] = inst_35038);

return statearr_35043;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35041__$1,inst_35039);
} else {
return null;
}
}
});})(c__19296__auto___35052,req_35051,channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__19184__auto__,c__19296__auto___35052,req_35051,channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__19185__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__19185__auto____0 = (function (){
var statearr_35047 = [null,null,null,null,null,null,null,null];
(statearr_35047[(0)] = cljs_http$core$jsonp_$_state_machine__19185__auto__);

(statearr_35047[(1)] = (1));

return statearr_35047;
});
var cljs_http$core$jsonp_$_state_machine__19185__auto____1 = (function (state_35041){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_35041);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e35048){if((e35048 instanceof Object)){
var ex__19188__auto__ = e35048;
var statearr_35049_35053 = state_35041;
(statearr_35049_35053[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35041);

return cljs.core.cst$kw$recur;
} else {
throw e35048;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__35054 = state_35041;
state_35041 = G__35054;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__19185__auto__ = function(state_35041){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__19185__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__19185__auto____1.call(this,state_35041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__19185__auto____0;
cljs_http$core$jsonp_$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__19185__auto____1;
return cljs_http$core$jsonp_$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto___35052,req_35051,channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__19298__auto__ = (function (){var statearr_35050 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_35050[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto___35052);

return statearr_35050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto___35052,req_35051,channel,jsonp,map__35035,map__35035__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__35055){
var map__35058 = p__35055;
var map__35058__$1 = ((((!((map__35058 == null)))?((((map__35058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35058.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35058):map__35058);
var request = map__35058__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35058__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
