// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31590 = arguments.length;
var i__7652__auto___31591 = (0);
while(true){
if((i__7652__auto___31591 < len__7651__auto___31590)){
args__7658__auto__.push((arguments[i__7652__auto___31591]));

var G__31592 = (i__7652__auto___31591 + (1));
i__7652__auto___31591 = G__31592;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__31586){
var vec__31587 = p__31586;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31587,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq31582){
var G__31583 = cljs.core.first(seq31582);
var seq31582__$1 = cljs.core.next(seq31582);
var G__31584 = cljs.core.first(seq31582__$1);
var seq31582__$2 = cljs.core.next(seq31582__$1);
var G__31585 = cljs.core.first(seq31582__$2);
var seq31582__$3 = cljs.core.next(seq31582__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__31583,G__31584,G__31585,seq31582__$3);
});

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31602 = arguments.length;
var i__7652__auto___31603 = (0);
while(true){
if((i__7652__auto___31603 < len__7651__auto___31602)){
args__7658__auto__.push((arguments[i__7652__auto___31603]));

var G__31604 = (i__7652__auto___31603 + (1));
i__7652__auto___31603 = G__31604;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((4) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7659__auto__);
});

milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__31598){
var vec__31599 = p__31598;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31599,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4);

milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq31593){
var G__31594 = cljs.core.first(seq31593);
var seq31593__$1 = cljs.core.next(seq31593);
var G__31595 = cljs.core.first(seq31593__$1);
var seq31593__$2 = cljs.core.next(seq31593__$1);
var G__31596 = cljs.core.first(seq31593__$2);
var seq31593__$3 = cljs.core.next(seq31593__$2);
var G__31597 = cljs.core.first(seq31593__$3);
var seq31593__$4 = cljs.core.next(seq31593__$3);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic(G__31594,G__31595,G__31596,G__31597,seq31593__$4);
});

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31610 = arguments.length;
var i__7652__auto___31611 = (0);
while(true){
if((i__7652__auto___31611 < len__7651__auto___31610)){
args__7658__auto__.push((arguments[i__7652__auto___31611]));

var G__31612 = (i__7652__auto___31611 + (1));
i__7652__auto___31611 = G__31612;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__31607){
var map__31608 = p__31607;
var map__31608__$1 = ((((!((map__31608 == null)))?((((map__31608.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31608.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31608):map__31608);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31608__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq31605){
var G__31606 = cljs.core.first(seq31605);
var seq31605__$1 = cljs.core.next(seq31605);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic(G__31606,seq31605__$1);
});

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31618 = arguments.length;
var i__7652__auto___31619 = (0);
while(true){
if((i__7652__auto___31619 < len__7651__auto___31618)){
args__7658__auto__.push((arguments[i__7652__auto___31619]));

var G__31620 = (i__7652__auto___31619 + (1));
i__7652__auto___31619 = G__31620;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__31615){
var map__31616 = p__31615;
var map__31616__$1 = ((((!((map__31616 == null)))?((((map__31616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31616.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31616):map__31616);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31616__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("restservices?xform="),cljs.core.str(formid)].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq31613){
var G__31614 = cljs.core.first(seq31613);
var seq31613__$1 = cljs.core.next(seq31613);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic(G__31614,seq31613__$1);
});

