// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__31149 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__31149,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__31150 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__31150) : cljs_hash.md5.md5.call(null,G__31150));
})());
} else {
return G__31149;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31155 = arguments.length;
var i__7652__auto___31156 = (0);
while(true){
if((i__7652__auto___31156 < len__7651__auto___31155)){
args__7658__auto__.push((arguments[i__7652__auto___31156]));

var G__31157 = (i__7652__auto___31156 + (1));
i__7652__auto___31156 = G__31157;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__31152){
var map__31153 = p__31152;
var map__31153__$1 = ((((!((map__31153 == null)))?((((map__31153.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31153.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31153):map__31153);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31153__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31153__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31153__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31153__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq31151){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31151));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31167 = arguments.length;
var i__7652__auto___31168 = (0);
while(true){
if((i__7652__auto___31168 < len__7651__auto___31167)){
args__7658__auto__.push((arguments[i__7652__auto___31168]));

var G__31169 = (i__7652__auto___31168 + (1));
i__7652__auto___31168 = G__31169;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__31160){
var vec__31161 = p__31160;
var map__31164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31161,(0),null);
var map__31164__$1 = ((((!((map__31164 == null)))?((((map__31164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31164.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31164):map__31164);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31164__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e31166){if((e31166 instanceof Error)){
var _ = e31166;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e31166;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq31158){
var G__31159 = cljs.core.first(seq31158);
var seq31158__$1 = cljs.core.next(seq31158);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__31159,seq31158__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__31176_31182 = io_obj;
var G__31177_31183 = goog.net.EventType.SUCCESS;
var G__31178_31184 = ((function (G__31176_31182,G__31177_31183,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__31176_31182,G__31177_31183,io_obj))
;
goog.events.listen(G__31176_31182,G__31177_31183,G__31178_31184);

var G__31179_31185 = io_obj;
var G__31180_31186 = goog.net.EventType.ERROR;
var G__31181_31187 = ((function (G__31179_31185,G__31180_31186,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__31179_31185,G__31180_31186,io_obj))
;
goog.events.listen(G__31179_31185,G__31180_31186,G__31181_31187);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31204 = arguments.length;
var i__7652__auto___31205 = (0);
while(true){
if((i__7652__auto___31205 < len__7651__auto___31204)){
args__7658__auto__.push((arguments[i__7652__auto___31205]));

var G__31206 = (i__7652__auto___31205 + (1));
i__7652__auto___31205 = G__31206;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__31192){
var map__31193 = p__31192;
var map__31193__$1 = ((((!((map__31193 == null)))?((((map__31193.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31193.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31193):map__31193);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31193__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31193__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31193__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__31195_31207 = io_obj;
var G__31196_31208 = goog.net.EventType.SUCCESS;
var G__31197_31209 = ((function (G__31195_31207,G__31196_31208,io_obj,data,url,map__31193,map__31193__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__31195_31207,G__31196_31208,io_obj,data,url,map__31193,map__31193__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31195_31207,G__31196_31208,G__31197_31209);

var G__31198_31210 = io_obj;
var G__31199_31211 = goog.net.EventType.ERROR;
var G__31200_31212 = ((function (G__31198_31210,G__31199_31211,io_obj,data,url,map__31193,map__31193__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__31198_31210,G__31199_31211,io_obj,data,url,map__31193,map__31193__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31198_31210,G__31199_31211,G__31200_31212);

var G__31201_31213 = io_obj;
var G__31202_31214 = goog.net.EventType.PROGRESS;
var G__31203_31215 = ((function (G__31201_31213,G__31202_31214,io_obj,data,url,map__31193,map__31193__$1,headers,id,require_json_QMARK_){
return (function (p1__31188_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__31188_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__31188_SHARP_.loaded,cljs.core.cst$kw$total,p1__31188_SHARP_.total], null)));
});})(G__31201_31213,G__31202_31214,io_obj,data,url,map__31193,map__31193__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31201_31213,G__31202_31214,G__31203_31215);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq31189){
var G__31190 = cljs.core.first(seq31189);
var seq31189__$1 = cljs.core.next(seq31189);
var G__31191 = cljs.core.first(seq31189__$1);
var seq31189__$2 = cljs.core.next(seq31189__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__31190,G__31191,seq31189__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31280 = arguments.length;
var i__7652__auto___31281 = (0);
while(true){
if((i__7652__auto___31281 < len__7651__auto___31280)){
args__7658__auto__.push((arguments[i__7652__auto___31281]));

var G__31282 = (i__7652__auto___31281 + (1));
i__7652__auto___31281 = G__31282;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19292__auto___31283 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___31283,response_channel){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___31283,response_channel){
return (function (state_31253){
var state_val_31254 = (state_31253[(1)]);
if((state_val_31254 === (7))){
var state_31253__$1 = state_31253;
var statearr_31255_31284 = state_31253__$1;
(statearr_31255_31284[(2)] = false);

(statearr_31255_31284[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (1))){
var inst_31219 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_31253__$1 = state_31253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31253__$1,(2),inst_31219);
} else {
if((state_val_31254 === (4))){
var state_31253__$1 = state_31253;
var statearr_31256_31285 = state_31253__$1;
(statearr_31256_31285[(2)] = false);

(statearr_31256_31285[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (13))){
var inst_31242 = (state_31253[(7)]);
var inst_31249 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_31242);
var state_31253__$1 = state_31253;
var statearr_31257_31286 = state_31253__$1;
(statearr_31257_31286[(2)] = inst_31249);

(statearr_31257_31286[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (6))){
var state_31253__$1 = state_31253;
var statearr_31258_31287 = state_31253__$1;
(statearr_31258_31287[(2)] = true);

(statearr_31258_31287[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (3))){
var inst_31221 = (state_31253[(8)]);
var inst_31226 = inst_31221.cljs$lang$protocol_mask$partition0$;
var inst_31227 = (inst_31226 & (64));
var inst_31228 = inst_31221.cljs$core$ISeq$;
var inst_31229 = (cljs.core.PROTOCOL_SENTINEL === inst_31228);
var inst_31230 = (inst_31227) || (inst_31229);
var state_31253__$1 = state_31253;
if(cljs.core.truth_(inst_31230)){
var statearr_31259_31288 = state_31253__$1;
(statearr_31259_31288[(1)] = (6));

} else {
var statearr_31260_31289 = state_31253__$1;
(statearr_31260_31289[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (12))){
var inst_31246 = window.location.href();
var inst_31247 = window.location = inst_31246;
var state_31253__$1 = state_31253;
var statearr_31261_31290 = state_31253__$1;
(statearr_31261_31290[(2)] = inst_31247);

(statearr_31261_31290[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (2))){
var inst_31221 = (state_31253[(8)]);
var inst_31221__$1 = (state_31253[(2)]);
var inst_31223 = (inst_31221__$1 == null);
var inst_31224 = cljs.core.not(inst_31223);
var state_31253__$1 = (function (){var statearr_31262 = state_31253;
(statearr_31262[(8)] = inst_31221__$1);

return statearr_31262;
})();
if(inst_31224){
var statearr_31263_31291 = state_31253__$1;
(statearr_31263_31291[(1)] = (3));

} else {
var statearr_31264_31292 = state_31253__$1;
(statearr_31264_31292[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (11))){
var inst_31242 = (state_31253[(7)]);
var inst_31242__$1 = (state_31253[(2)]);
var inst_31243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31242__$1,cljs.core.cst$kw$status);
var inst_31244 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31243,(401));
var state_31253__$1 = (function (){var statearr_31265 = state_31253;
(statearr_31265[(7)] = inst_31242__$1);

return statearr_31265;
})();
if(inst_31244){
var statearr_31266_31293 = state_31253__$1;
(statearr_31266_31293[(1)] = (12));

} else {
var statearr_31267_31294 = state_31253__$1;
(statearr_31267_31294[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (9))){
var inst_31221 = (state_31253[(8)]);
var inst_31239 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31221);
var state_31253__$1 = state_31253;
var statearr_31268_31295 = state_31253__$1;
(statearr_31268_31295[(2)] = inst_31239);

(statearr_31268_31295[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (5))){
var inst_31237 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
if(cljs.core.truth_(inst_31237)){
var statearr_31269_31296 = state_31253__$1;
(statearr_31269_31296[(1)] = (9));

} else {
var statearr_31270_31297 = state_31253__$1;
(statearr_31270_31297[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (14))){
var inst_31251 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31253__$1,inst_31251);
} else {
if((state_val_31254 === (10))){
var inst_31221 = (state_31253[(8)]);
var state_31253__$1 = state_31253;
var statearr_31271_31298 = state_31253__$1;
(statearr_31271_31298[(2)] = inst_31221);

(statearr_31271_31298[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (8))){
var inst_31234 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
var statearr_31272_31299 = state_31253__$1;
(statearr_31272_31299[(2)] = inst_31234);

(statearr_31272_31299[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___31283,response_channel))
;
return ((function (switch__19180__auto__,c__19292__auto___31283,response_channel){
return (function() {
var milia$api$io$state_machine__19181__auto__ = null;
var milia$api$io$state_machine__19181__auto____0 = (function (){
var statearr_31276 = [null,null,null,null,null,null,null,null,null];
(statearr_31276[(0)] = milia$api$io$state_machine__19181__auto__);

(statearr_31276[(1)] = (1));

return statearr_31276;
});
var milia$api$io$state_machine__19181__auto____1 = (function (state_31253){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_31253);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e31277){if((e31277 instanceof Object)){
var ex__19184__auto__ = e31277;
var statearr_31278_31300 = state_31253;
(statearr_31278_31300[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31253);

return cljs.core.cst$kw$recur;
} else {
throw e31277;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__31301 = state_31253;
state_31253 = G__31301;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$api$io$state_machine__19181__auto__ = function(state_31253){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19181__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19181__auto____1.call(this,state_31253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19181__auto____0;
milia$api$io$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19181__auto____1;
return milia$api$io$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___31283,response_channel))
})();
var state__19294__auto__ = (function (){var statearr_31279 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_31279[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___31283);

return statearr_31279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___31283,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq31216){
var G__31217 = cljs.core.first(seq31216);
var seq31216__$1 = cljs.core.next(seq31216);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__31217,seq31216__$1);
});

