// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
if(typeof milia.api.dataset.type__GT_endpoint !== 'undefined'){
} else {
milia.api.dataset.type__GT_endpoint = (function (){var method_table__7471__auto__ = (function (){var G__31659 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31659) : cljs.core.atom.call(null,G__31659));
})();
var prefer_table__7472__auto__ = (function (){var G__31660 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31660) : cljs.core.atom.call(null,G__31660));
})();
var method_cache__7473__auto__ = (function (){var G__31661 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31661) : cljs.core.atom.call(null,G__31661));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__31662 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31662) : cljs.core.atom.call(null,G__31662));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->endpoint"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__31663__delegate = function (datatype,_){
return datatype;
};
var G__31663 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__31664__i = 0, G__31664__a = new Array(arguments.length -  1);
while (G__31664__i < G__31664__a.length) {G__31664__a[G__31664__i] = arguments[G__31664__i + 1]; ++G__31664__i;}
  _ = new cljs.core.IndexedSeq(G__31664__a,0);
} 
return G__31663__delegate.call(this,datatype,_);};
G__31663.cljs$lang$maxFixedArity = 1;
G__31663.cljs$lang$applyTo = (function (arglist__31665){
var datatype = cljs.core.first(arglist__31665);
var _ = cljs.core.rest(arglist__31665);
return G__31663__delegate(datatype,_);
});
G__31663.cljs$core$IFn$_invoke$arity$variadic = G__31663__delegate;
return G__31663;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function() { 
var G__31669__delegate = function (_,p__31666){
var map__31667 = p__31666;
var map__31667__$1 = ((((!((map__31667 == null)))?((((map__31667.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31667.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31667):map__31667);
var async = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31667__$1,cljs.core.cst$kw$async,true);
if(cljs.core.truth_(async)){
return "forms";
} else {
return "data";
}
};
var G__31669 = function (_,var_args){
var p__31666 = null;
if (arguments.length > 1) {
var G__31670__i = 0, G__31670__a = new Array(arguments.length -  1);
while (G__31670__i < G__31670__a.length) {G__31670__a[G__31670__i] = arguments[G__31670__i + 1]; ++G__31670__i;}
  p__31666 = new cljs.core.IndexedSeq(G__31670__a,0);
} 
return G__31669__delegate.call(this,_,p__31666);};
G__31669.cljs$lang$maxFixedArity = 1;
G__31669.cljs$lang$applyTo = (function (arglist__31671){
var _ = cljs.core.first(arglist__31671);
var p__31666 = cljs.core.rest(arglist__31671);
return G__31669__delegate(_,p__31666);
});
G__31669.cljs$core$IFn$_invoke$arity$variadic = G__31669__delegate;
return G__31669;
})()
);
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function() { 
var G__31672__delegate = function (_,___$1){
return "dataviews";
};
var G__31672 = function (_,var_args){
var ___$1 = null;
if (arguments.length > 1) {
var G__31673__i = 0, G__31673__a = new Array(arguments.length -  1);
while (G__31673__i < G__31673__a.length) {G__31673__a[G__31673__i] = arguments[G__31673__i + 1]; ++G__31673__i;}
  ___$1 = new cljs.core.IndexedSeq(G__31673__a,0);
} 
return G__31672__delegate.call(this,_,___$1);};
G__31672.cljs$lang$maxFixedArity = 1;
G__31672.cljs$lang$applyTo = (function (arglist__31674){
var _ = cljs.core.first(arglist__31674);
var ___$1 = cljs.core.rest(arglist__31674);
return G__31672__delegate(_,___$1);
});
G__31672.cljs$core$IFn$_invoke$arity$variadic = G__31672__delegate;
return G__31672;
})()
);
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("forms?owner="),cljs.core.str(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",username], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31681 = arguments.length;
var i__7652__auto___31682 = (0);
while(true){
if((i__7652__auto___31682 < len__7651__auto___31681)){
args__7658__auto__.push((arguments[i__7652__auto___31682]));

var G__31683 = (i__7652__auto___31682 + (1));
i__7652__auto___31682 = G__31683;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__31678){
var map__31679 = p__31678;
var map__31679__$1 = ((((!((map__31679 == null)))?((((map__31679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31679.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31679):map__31679);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31679__$1,cljs.core.cst$kw$project_DASH_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"clone"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_params,cljs.core.cst$kw$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,data,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataset.clone.cljs$lang$maxFixedArity = (2);

milia.api.dataset.clone.cljs$lang$applyTo = (function (seq31675){
var G__31676 = cljs.core.first(seq31675);
var seq31675__$1 = cljs.core.next(seq31675);
var G__31677 = cljs.core.first(seq31675__$1);
var seq31675__$2 = cljs.core.next(seq31675__$1);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic(G__31676,G__31677,seq31675__$2);
});

/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(cljs.core.truth_(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$created_by,cljs.core.cst$kw$description,cljs.core.cst$kw$downloadable,cljs.core.cst$kw$owner,cljs.core.cst$kw$project,cljs.core.cst$kw$public,cljs.core.cst$kw$public_data,cljs.core.cst$kw$title,cljs.core.cst$kw$uuid], null)))){
} else {
throw (new Error("Assert failed: (has-keys? params [:created_by :description :downloadable :owner :project :public :public_data :title :uuid])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31689 = arguments.length;
var i__7652__auto___31690 = (0);
while(true){
if((i__7652__auto___31690 < len__7651__auto___31689)){
args__7658__auto__.push((arguments[i__7652__auto___31690]));

var G__31691 = (i__7652__auto___31690 + (1));
i__7652__auto___31690 = G__31691;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});
goog.exportSymbol('milia.api.dataset.data', milia.api.dataset.data);

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__31686){
var map__31687 = p__31686;
var map__31687__$1 = ((((!((map__31687 == null)))?((((map__31687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31687.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31687):map__31687);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$format);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$accept_DASH_header);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$query_DASH_params);
var data_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$data_DASH_id);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$auth_DASH_token);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str((cljs.core.truth_(data_id)?[cljs.core.str("/"),cljs.core.str(data_id)].join(''):null)),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_suffix], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (1);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq31684){
var G__31685 = cljs.core.first(seq31684);
var seq31684__$1 = cljs.core.next(seq31684);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__31685,seq31684__$1);
});

/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,record_id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx","zip"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
if(typeof milia.api.dataset.type__GT_download_path !== 'undefined'){
} else {
milia.api.dataset.type__GT_download_path = (function (){var method_table__7471__auto__ = (function (){var G__31692 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31692) : cljs.core.atom.call(null,G__31692));
})();
var prefer_table__7472__auto__ = (function (){var G__31693 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31693) : cljs.core.atom.call(null,G__31693));
})();
var method_cache__7473__auto__ = (function (){var G__31694 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31694) : cljs.core.atom.call(null,G__31694));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__31695 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31695) : cljs.core.atom.call(null,G__31695));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->download-path"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__31696__delegate = function (datatype,_){
return datatype;
};
var G__31696 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__31697__i = 0, G__31697__a = new Array(arguments.length -  1);
while (G__31697__i < G__31697__a.length) {G__31697__a[G__31697__i] = arguments[G__31697__i + 1]; ++G__31697__i;}
  _ = new cljs.core.IndexedSeq(G__31697__a,0);
} 
return G__31696__delegate.call(this,datatype,_);};
G__31696.cljs$lang$maxFixedArity = 1;
G__31696.cljs$lang$applyTo = (function (arglist__31698){
var datatype = cljs.core.first(arglist__31698);
var _ = cljs.core.rest(arglist__31698);
return G__31696__delegate(datatype,_);
});
G__31696.cljs$core$IFn$_invoke$arity$variadic = G__31696__delegate;
return G__31696;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format),cljs.core.str((cljs.core.truth_(export_options)?[cljs.core.str("?"),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",(function (){var iter__7326__auto__ = (function milia$api$dataset$iter__31699(s__31700){
return (new cljs.core.LazySeq(null,(function (){
var s__31700__$1 = s__31700;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31700__$1);
if(temp__4657__auto__){
var s__31700__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31700__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__31700__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__31702 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__31701 = (0);
while(true){
if((i__31701 < size__7325__auto__)){
var vec__31711 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__31701);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31711,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31711,(1),null);
cljs.core.chunk_append(b__31702,[cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''));

var G__31717 = (i__31701 + (1));
i__31701 = G__31717;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31702),milia$api$dataset$iter__31699(cljs.core.chunk_rest(s__31700__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31702),null);
}
} else {
var vec__31714 = cljs.core.first(s__31700__$2);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31714,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31714,(1),null);
return cljs.core.cons([cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''),milia$api$dataset$iter__31699(cljs.core.rest(s__31700__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(export_options);
})()))].join(''):null))].join('')], null);
}));
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], null);
}));
/**
 * Download form data in specified format. The synchronicity here refers to the
 * server side. This will still return a channel, not data, in CLJS.
 * The options map (last parameter) has the following keys:
 * :accept-header Defaults to application/json
 * :submission-id The id of the submission whose data the client requires. The
 *  function returns data for all submissions if this is not provided.
 * :dataview? Boolean flag indicating whether the data belongs to a filtered
 *  dataview
 */
milia.api.dataset.download_synchronously = (function milia$api$dataset$download_synchronously(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31724 = arguments.length;
var i__7652__auto___31725 = (0);
while(true){
if((i__7652__auto___31725 < len__7651__auto___31724)){
args__7658__auto__.push((arguments[i__7652__auto___31725]));

var G__31726 = (i__7652__auto___31725 + (1));
i__7652__auto___31725 = G__31726;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,format,p__31721){
var map__31722 = p__31721;
var map__31722__$1 = ((((!((map__31722 == null)))?((((map__31722.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31722.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31722):map__31722);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31722__$1,cljs.core.cst$kw$accept_DASH_header);
var submission_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31722__$1,cljs.core.cst$kw$submission_DASH_id);
var dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31722__$1,cljs.core.cst$kw$dataview_QMARK_);
var url = (cljs.core.truth_(dataview_QMARK_)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], 0)):(cljs.core.truth_(submission_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,[cljs.core.str(submission_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0))
));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$http_DASH_options,milia.api.dataset.options_for_format(format)], 0));
});

milia.api.dataset.download_synchronously.cljs$lang$maxFixedArity = (2);

milia.api.dataset.download_synchronously.cljs$lang$applyTo = (function (seq31718){
var G__31719 = cljs.core.first(seq31718);
var seq31718__$1 = cljs.core.next(seq31718);
var G__31720 = cljs.core.first(seq31718__$1);
var seq31718__$2 = cljs.core.next(seq31718__$1);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic(G__31719,G__31720,seq31718__$2);
});

/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(var_args){
var args31727 = [];
var len__7651__auto___31730 = arguments.length;
var i__7652__auto___31731 = (0);
while(true){
if((i__7652__auto___31731 < len__7651__auto___31730)){
args31727.push((arguments[i__7652__auto___31731]));

var G__31732 = (i__7652__auto___31731 + (1));
i__7652__auto___31731 = G__31732;
continue;
} else {
}
break;
}

var G__31729 = args31727.length;
switch (G__31729) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31727.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 2;

/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31739 = arguments.length;
var i__7652__auto___31740 = (0);
while(true){
if((i__7652__auto___31740 < len__7651__auto___31739)){
args__7658__auto__.push((arguments[i__7652__auto___31740]));

var G__31741 = (i__7652__auto___31740 + (1));
i__7652__auto___31740 = G__31741;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__31736){
var map__31737 = p__31736;
var map__31737__$1 = ((((!((map__31737 == null)))?((((map__31737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31737.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31737):map__31737);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31737__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.dataset.metadata.cljs$lang$maxFixedArity = (1);

milia.api.dataset.metadata.cljs$lang$applyTo = (function (seq31734){
var G__31735 = cljs.core.first(seq31734);
var seq31734__$1 = cljs.core.next(seq31734);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic(G__31735,seq31734__$1);
});

/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"enketo"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,[cljs.core.str("enketo?return_url="),cljs.core.str(return_url)].join('')], 0));
return cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.cst$kw$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"delete_async"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"forms"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formid,dataset_id], null)], null)], 0));
});
/**
 * Set a new form owner
 */
milia.api.dataset.new_form_owner = (function milia$api$dataset$new_form_owner(dataset_id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null)], null)], 0));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Link xform or dataview as media
 */
milia.api.dataset.link_xform_or_dataview_as_media = (function milia$api$dataset$link_xform_or_dataview_as_media(object_type,object_id,media_filename,xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"media",cljs.core.cst$kw$data_value,[cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_type,object_id,media_filename], null)))].join(''),cljs.core.cst$kw$xform,xform_id], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_type,"external_export",cljs.core.cst$kw$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(var_args){
var args31742 = [];
var len__7651__auto___31745 = arguments.length;
var i__7652__auto___31746 = (0);
while(true){
if((i__7652__auto___31746 < len__7651__auto___31745)){
args31742.push((arguments[i__7652__auto___31746]));

var G__31747 = (i__7652__auto___31746 + (1));
i__7652__auto___31746 = G__31747;
continue;
} else {
}
break;
}

var G__31744 = args31742.length;
switch (G__31744) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31742.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4;

/**
 * Returns a submission's edit history
 */
milia.api.dataset.edit_history = (function milia$api$dataset$edit_history(dataset_id,instance_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,"history"], 0)));
});
milia.api.dataset.files = (function milia$api$dataset$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31755 = arguments.length;
var i__7652__auto___31756 = (0);
while(true){
if((i__7652__auto___31756 < len__7651__auto___31755)){
args__7658__auto__.push((arguments[i__7652__auto___31756]));

var G__31757 = (i__7652__auto___31756 + (1));
i__7652__auto___31756 = G__31757;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic = (function (instance_id,project_id,p__31752){
var map__31753 = p__31752;
var map__31753__$1 = ((((!((map__31753 == null)))?((((map__31753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31753.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31753):map__31753);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31753__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31753__$1,cljs.core.cst$kw$dataset_DASH_id);
var extra_params = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$project,project_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$xform,dataset_id], null));
return milia.utils.metadata.metadata_files.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$instance,instance_id,no_cache_QMARK_,cljs.core.array_seq([cljs.core.cst$kw$extra_DASH_params,extra_params], 0));
});

milia.api.dataset.files.cljs$lang$maxFixedArity = (2);

milia.api.dataset.files.cljs$lang$applyTo = (function (seq31749){
var G__31750 = cljs.core.first(seq31749);
var seq31749__$1 = cljs.core.next(seq31749);
var G__31751 = cljs.core.first(seq31749__$1);
var seq31749__$2 = cljs.core.next(seq31749__$1);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic(G__31750,G__31751,seq31749__$2);
});

/**
 * Integer Integer String String -> Channel HttpResponse
 */
milia.api.dataset.update_xform_meta_permissions = (function milia$api$dataset$update_xform_meta_permissions(dataset_id,metadata_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata",metadata_id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Integer String String -> Channel HttpResponse
 */
milia.api.dataset.create_xform_meta_permissions = (function milia$api$dataset$create_xform_meta_permissions(dataset_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
