// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('milia.utils.url');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$temp_DASH_token,null,cljs.core.constant$keyword$token,null,cljs.core.constant$keyword$username,null,cljs.core.constant$keyword$password,null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__25317 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$client,"zebra.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$j2x,"j2x.ona.io",cljs.core.constant$keyword$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25317) : cljs.core.atom.call(null,G__25317));
})();
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var args__8986__auto__ = [];
var len__8979__auto___25319 = arguments.length;
var i__8980__auto___25320 = (0);
while(true){
if((i__8980__auto___25320 < len__8979__auto___25319)){
args__8986__auto__.push((arguments[i__8980__auto___25320]));

var G__25321 = (i__8980__auto___25320 + (1));
i__8980__auto___25320 = G__25321;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((0) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8987__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq25318){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25318));
});
/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(){
var args__8986__auto__ = [];
var len__8979__auto___25323 = arguments.length;
var i__8980__auto___25324 = (0);
while(true){
if((i__8980__auto___25324 < len__8979__auto___25323)){
args__8986__auto__.push((arguments[i__8980__auto___25324]));

var G__25325 = (i__8980__auto___25324 + (1));
i__8980__auto___25324 = G__25325;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((0) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8987__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq25322){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25322));
});
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(){
var args__8986__auto__ = [];
var len__8979__auto___25327 = arguments.length;
var i__8980__auto___25328 = (0);
while(true){
if((i__8980__auto___25328 < len__8979__auto___25327)){
args__8986__auto__.push((arguments[i__8980__auto___25328]));

var G__25329 = (i__8980__auto___25328 + (1));
i__8980__auto___25328 = G__25329;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((0) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8987__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq25326){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25326));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var args__8986__auto__ = [];
var len__8979__auto___25331 = arguments.length;
var i__8980__auto___25332 = (0);
while(true){
if((i__8980__auto___25332 < len__8979__auto___25331)){
args__8986__auto__.push((arguments[i__8980__auto___25332]));

var G__25333 = (i__8980__auto___25332 + (1));
i__8980__auto___25332 = G__25333;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((0) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8987__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq25330){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25330));
});
