// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.template');
goog.require('cljs.core');
goog.require('dommy.attrs');
goog.require('clojure.string');
dommy.template._PLUS_svg_ns_PLUS_ = "http://www.w3.org/2000/svg";
dommy.template._PLUS_svg_tags_PLUS_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["svg",null,"line",null], null), null);

dommy.template.PElement = (function (){var obj29863 = {};
return obj29863;
})();

/**
 * return the element representation of this
 */
dommy.template._elem = (function dommy$template$_elem(this$){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.dommy$template$PElement$_elem$arity$1;
} else {
return and__4264__auto__;
}
})()){
return this$.dommy$template$PElement$_elem$arity$1(this$);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (dommy.template._elem[(function (){var G__29867 = x__4912__auto__;
return goog.typeOf(G__29867);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (dommy.template._elem["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("PElement.-elem",this$);
}
}
})().call(null,this$);
}
});

/**
 * index of css character (#,.) in base-element. bottleneck
 */
dommy.template.next_css_index = (function dommy$template$next_css_index(s,start_idx){
var id_idx = s.indexOf("#",start_idx);
var class_idx = s.indexOf(".",start_idx);
var idx = Math.min(id_idx,class_idx);
if((idx < (0))){
return Math.max(id_idx,class_idx);
} else {
return idx;
}
});
/**
 * dom element from css-style keyword like :a.class1 or :span#my-span.class
 */
dommy.template.base_element = (function dommy$template$base_element(node_key){
var node_str = cljs.core.name(node_key);
var base_idx = dommy.template.next_css_index(node_str,(0));
var tag = (((base_idx > (0)))?node_str.substring((0),base_idx):(((base_idx === (0)))?"div":node_str
));
var node = (cljs.core.truth_((function (){var G__29870 = tag;
return (dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1 ? dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1(G__29870) : dommy.template._PLUS_svg_tags_PLUS_.call(null,G__29870));
})())?document.createElementNS(dommy.template._PLUS_svg_ns_PLUS_,tag):document.createElement(tag));
if((base_idx >= (0))){
var str_29872 = node_str.substring(base_idx);
while(true){
var next_idx_29873 = dommy.template.next_css_index(str_29872,(1));
var frag_29874 = (((next_idx_29873 >= (0)))?str_29872.substring((0),next_idx_29873):str_29872);
var G__29871_29875 = frag_29874.charAt((0));
switch (G__29871_29875) {
case ".":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(node,frag_29874.substring((1)));

break;
case "#":
node.setAttribute("id",frag_29874.substring((1)));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(frag_29874.charAt((0)))].join('')));

}

if((next_idx_29873 >= (0))){
var G__29877 = str_29872.substring(next_idx_29873);
str_29872 = G__29877;
continue;
} else {
}
break;
}
} else {
}

return node;
});
dommy.template.throw_unable_to_make_node = (function dommy$template$throw_unable_to_make_node(node_data){
throw [cljs.core.str("Don't know how to make node from: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([node_data], 0)))].join('');
});
/**
 * take data and return a document fragment
 */
dommy.template.__GT_document_fragment = (function dommy$template$__GT_document_fragment(){
var G__29879 = arguments.length;
switch (G__29879) {
case 1:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1 = (function (data){
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(document.createDocumentFragment(),data);
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2 = (function (result_frag,data){
if((function (){var G__29880 = data;
if(G__29880){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29880.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29880.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29880);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29880);
}
})()){
result_frag.appendChild(dommy.template._elem(data));

return result_frag;
} else {
if(cljs.core.seq_QMARK_(data)){
var seq__29881_29886 = cljs.core.seq(data);
var chunk__29882_29887 = null;
var count__29883_29888 = (0);
var i__29884_29889 = (0);
while(true){
if((i__29884_29889 < count__29883_29888)){
var child_29890 = chunk__29882_29887.cljs$core$IIndexed$_nth$arity$2(null,i__29884_29889);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_29890);

var G__29891 = seq__29881_29886;
var G__29892 = chunk__29882_29887;
var G__29893 = count__29883_29888;
var G__29894 = (i__29884_29889 + (1));
seq__29881_29886 = G__29891;
chunk__29882_29887 = G__29892;
count__29883_29888 = G__29893;
i__29884_29889 = G__29894;
continue;
} else {
var temp__4126__auto___29895 = cljs.core.seq(seq__29881_29886);
if(temp__4126__auto___29895){
var seq__29881_29896__$1 = temp__4126__auto___29895;
if(cljs.core.chunked_seq_QMARK_(seq__29881_29896__$1)){
var c__5061__auto___29897 = cljs.core.chunk_first(seq__29881_29896__$1);
var G__29898 = cljs.core.chunk_rest(seq__29881_29896__$1);
var G__29899 = c__5061__auto___29897;
var G__29900 = cljs.core.count(c__5061__auto___29897);
var G__29901 = (0);
seq__29881_29886 = G__29898;
chunk__29882_29887 = G__29899;
count__29883_29888 = G__29900;
i__29884_29889 = G__29901;
continue;
} else {
var child_29902 = cljs.core.first(seq__29881_29896__$1);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_29902);

var G__29903 = cljs.core.next(seq__29881_29896__$1);
var G__29904 = null;
var G__29905 = (0);
var G__29906 = (0);
seq__29881_29886 = G__29903;
chunk__29882_29887 = G__29904;
count__29883_29888 = G__29905;
i__29884_29889 = G__29906;
continue;
}
} else {
}
}
break;
}

return result_frag;
} else {
if((data == null)){
return result_frag;
} else {
return dommy.template.throw_unable_to_make_node(data);

}
}
}
});

dommy.template.__GT_document_fragment.cljs$lang$maxFixedArity = 2;
/**
 * take data and return DOM node if it satisfies PElement and tries to
 * make a document fragment otherwise
 */
dommy.template.__GT_node_like = (function dommy$template$__GT_node_like(data){
if((function (){var G__29908 = data;
if(G__29908){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29908.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29908.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29908);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29908);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1(data);
}
});
/**
 * element with either attrs or nested children [:div [:span "Hello"]]
 */
dommy.template.compound_element = (function dommy$template$compound_element(p__29909){
var vec__29929 = p__29909;
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29929,(0),null);
var maybe_attrs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29929,(1),null);
var children = cljs.core.nthnext(vec__29929,(2));
var n = dommy.template.base_element(tag_name);
var attrs = (((cljs.core.map_QMARK_(maybe_attrs)) && (!((function (){var G__29931 = maybe_attrs;
if(G__29931){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29931.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29931.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29931);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29931);
}
})())))?maybe_attrs:null);
var children__$1 = (cljs.core.truth_(attrs)?children:cljs.core.cons(maybe_attrs,children));
var seq__29932_29948 = cljs.core.seq(attrs);
var chunk__29933_29949 = null;
var count__29934_29950 = (0);
var i__29935_29951 = (0);
while(true){
if((i__29935_29951 < count__29934_29950)){
var vec__29936_29952 = chunk__29933_29949.cljs$core$IIndexed$_nth$arity$2(null,i__29935_29951);
var k_29953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29936_29952,(0),null);
var v_29954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29936_29952,(1),null);
var G__29937_29955 = (((k_29953 instanceof cljs.core.Keyword))?k_29953.fqn:null);
switch (G__29937_29955) {
case "classes":
var seq__29938_29957 = cljs.core.seq(v_29954);
var chunk__29939_29958 = null;
var count__29940_29959 = (0);
var i__29941_29960 = (0);
while(true){
if((i__29941_29960 < count__29940_29959)){
var c_29961 = chunk__29939_29958.cljs$core$IIndexed$_nth$arity$2(null,i__29941_29960);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29961);

var G__29962 = seq__29938_29957;
var G__29963 = chunk__29939_29958;
var G__29964 = count__29940_29959;
var G__29965 = (i__29941_29960 + (1));
seq__29938_29957 = G__29962;
chunk__29939_29958 = G__29963;
count__29940_29959 = G__29964;
i__29941_29960 = G__29965;
continue;
} else {
var temp__4126__auto___29966 = cljs.core.seq(seq__29938_29957);
if(temp__4126__auto___29966){
var seq__29938_29967__$1 = temp__4126__auto___29966;
if(cljs.core.chunked_seq_QMARK_(seq__29938_29967__$1)){
var c__5061__auto___29968 = cljs.core.chunk_first(seq__29938_29967__$1);
var G__29969 = cljs.core.chunk_rest(seq__29938_29967__$1);
var G__29970 = c__5061__auto___29968;
var G__29971 = cljs.core.count(c__5061__auto___29968);
var G__29972 = (0);
seq__29938_29957 = G__29969;
chunk__29939_29958 = G__29970;
count__29940_29959 = G__29971;
i__29941_29960 = G__29972;
continue;
} else {
var c_29973 = cljs.core.first(seq__29938_29967__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29973);

var G__29974 = cljs.core.next(seq__29938_29967__$1);
var G__29975 = null;
var G__29976 = (0);
var G__29977 = (0);
seq__29938_29957 = G__29974;
chunk__29939_29958 = G__29975;
count__29940_29959 = G__29976;
i__29941_29960 = G__29977;
continue;
}
} else {
}
}
break;
}

break;
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_29954);

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_29953,v_29954);

}

var G__29978 = seq__29932_29948;
var G__29979 = chunk__29933_29949;
var G__29980 = count__29934_29950;
var G__29981 = (i__29935_29951 + (1));
seq__29932_29948 = G__29978;
chunk__29933_29949 = G__29979;
count__29934_29950 = G__29980;
i__29935_29951 = G__29981;
continue;
} else {
var temp__4126__auto___29982 = cljs.core.seq(seq__29932_29948);
if(temp__4126__auto___29982){
var seq__29932_29983__$1 = temp__4126__auto___29982;
if(cljs.core.chunked_seq_QMARK_(seq__29932_29983__$1)){
var c__5061__auto___29984 = cljs.core.chunk_first(seq__29932_29983__$1);
var G__29985 = cljs.core.chunk_rest(seq__29932_29983__$1);
var G__29986 = c__5061__auto___29984;
var G__29987 = cljs.core.count(c__5061__auto___29984);
var G__29988 = (0);
seq__29932_29948 = G__29985;
chunk__29933_29949 = G__29986;
count__29934_29950 = G__29987;
i__29935_29951 = G__29988;
continue;
} else {
var vec__29942_29989 = cljs.core.first(seq__29932_29983__$1);
var k_29990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29942_29989,(0),null);
var v_29991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29942_29989,(1),null);
var G__29943_29992 = (((k_29990 instanceof cljs.core.Keyword))?k_29990.fqn:null);
switch (G__29943_29992) {
case "classes":
var seq__29944_29994 = cljs.core.seq(v_29991);
var chunk__29945_29995 = null;
var count__29946_29996 = (0);
var i__29947_29997 = (0);
while(true){
if((i__29947_29997 < count__29946_29996)){
var c_29998 = chunk__29945_29995.cljs$core$IIndexed$_nth$arity$2(null,i__29947_29997);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29998);

var G__29999 = seq__29944_29994;
var G__30000 = chunk__29945_29995;
var G__30001 = count__29946_29996;
var G__30002 = (i__29947_29997 + (1));
seq__29944_29994 = G__29999;
chunk__29945_29995 = G__30000;
count__29946_29996 = G__30001;
i__29947_29997 = G__30002;
continue;
} else {
var temp__4126__auto___30003__$1 = cljs.core.seq(seq__29944_29994);
if(temp__4126__auto___30003__$1){
var seq__29944_30004__$1 = temp__4126__auto___30003__$1;
if(cljs.core.chunked_seq_QMARK_(seq__29944_30004__$1)){
var c__5061__auto___30005 = cljs.core.chunk_first(seq__29944_30004__$1);
var G__30006 = cljs.core.chunk_rest(seq__29944_30004__$1);
var G__30007 = c__5061__auto___30005;
var G__30008 = cljs.core.count(c__5061__auto___30005);
var G__30009 = (0);
seq__29944_29994 = G__30006;
chunk__29945_29995 = G__30007;
count__29946_29996 = G__30008;
i__29947_29997 = G__30009;
continue;
} else {
var c_30010 = cljs.core.first(seq__29944_30004__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_30010);

var G__30011 = cljs.core.next(seq__29944_30004__$1);
var G__30012 = null;
var G__30013 = (0);
var G__30014 = (0);
seq__29944_29994 = G__30011;
chunk__29945_29995 = G__30012;
count__29946_29996 = G__30013;
i__29947_29997 = G__30014;
continue;
}
} else {
}
}
break;
}

break;
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_29991);

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_29990,v_29991);

}

var G__30015 = cljs.core.next(seq__29932_29983__$1);
var G__30016 = null;
var G__30017 = (0);
var G__30018 = (0);
seq__29932_29948 = G__30015;
chunk__29933_29949 = G__30016;
count__29934_29950 = G__30017;
i__29935_29951 = G__30018;
continue;
}
} else {
}
}
break;
}

n.appendChild(dommy.template.__GT_node_like(children__$1));

return n;
});
(dommy.template.PElement["string"] = true);

(dommy.template._elem["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return dommy.template.base_element(this$);
} else {
return document.createTextNode([cljs.core.str(this$)].join(''));
}
}));

(dommy.template.PElement["number"] = true);

(dommy.template._elem["number"] = (function (this$){
return document.createTextNode([cljs.core.str(this$)].join(''));
}));

cljs.core.PersistentVector.prototype.dommy$template$PElement$ = true;

cljs.core.PersistentVector.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return dommy.template.compound_element(this$__$1);
});

SVGElement.prototype.dommy$template$PElement$ = true;

SVGElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Document.prototype.dommy$template$PElement$ = true;

Document.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Text.prototype.dommy$template$PElement$ = true;

Text.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

DocumentFragment.prototype.dommy$template$PElement$ = true;

DocumentFragment.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

HTMLElement.prototype.dommy$template$PElement$ = true;

HTMLElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
try{Window.prototype.dommy$template$PElement$ = true;

Window.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
}catch (e30019){if((e30019 instanceof ReferenceError)){
var __30020 = e30019;
console.log("PElement: js/Window not defined by browser, skipping it... (running on phantomjs?)");
} else {
throw e30019;

}
}dommy.template.node = (function dommy$template$node(data){
if((function (){var G__30022 = data;
if(G__30022){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__30022.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__30022.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__30022);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__30022);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.throw_unable_to_make_node(data);
}
});
dommy.template.html__GT_nodes = (function dommy$template$html__GT_nodes(html){
var parent = document.createElement("div");
parent.insertAdjacentHTML("beforeend",html);

return cljs.core.seq(Array.prototype.slice.call(parent.childNodes));
});
