// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__28656 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28656) : cljs.core.atom.call(null,G__28656));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4425__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4425__auto__)){
var req = temp__4425__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.constant$keyword$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.constant$keyword$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var seq__28669 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)));
var chunk__28674 = null;
var count__28675 = (0);
var i__28676 = (0);
while(true){
if((i__28676 < count__28675)){
var h_name = chunk__28674.cljs$core$IIndexed$_nth$arity$2(null,i__28676);
var seq__28677_28681 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28678_28682 = null;
var count__28679_28683 = (0);
var i__28680_28684 = (0);
while(true){
if((i__28680_28684 < count__28679_28683)){
var h_val_28685 = chunk__28678_28682.cljs$core$IIndexed$_nth$arity$2(null,i__28680_28684);
xhr.headers.set(h_name,h_val_28685);

var G__28686 = seq__28677_28681;
var G__28687 = chunk__28678_28682;
var G__28688 = count__28679_28683;
var G__28689 = (i__28680_28684 + (1));
seq__28677_28681 = G__28686;
chunk__28678_28682 = G__28687;
count__28679_28683 = G__28688;
i__28680_28684 = G__28689;
continue;
} else {
var temp__4425__auto___28690 = cljs.core.seq(seq__28677_28681);
if(temp__4425__auto___28690){
var seq__28677_28691__$1 = temp__4425__auto___28690;
if(cljs.core.chunked_seq_QMARK_(seq__28677_28691__$1)){
var c__8721__auto___28692 = cljs.core.chunk_first(seq__28677_28691__$1);
var G__28693 = cljs.core.chunk_rest(seq__28677_28691__$1);
var G__28694 = c__8721__auto___28692;
var G__28695 = cljs.core.count(c__8721__auto___28692);
var G__28696 = (0);
seq__28677_28681 = G__28693;
chunk__28678_28682 = G__28694;
count__28679_28683 = G__28695;
i__28680_28684 = G__28696;
continue;
} else {
var h_val_28697 = cljs.core.first(seq__28677_28691__$1);
xhr.headers.set(h_name,h_val_28697);

var G__28698 = cljs.core.next(seq__28677_28691__$1);
var G__28699 = null;
var G__28700 = (0);
var G__28701 = (0);
seq__28677_28681 = G__28698;
chunk__28678_28682 = G__28699;
count__28679_28683 = G__28700;
i__28680_28684 = G__28701;
continue;
}
} else {
}
}
break;
}

var G__28702 = seq__28669;
var G__28703 = chunk__28674;
var G__28704 = count__28675;
var G__28705 = (i__28676 + (1));
seq__28669 = G__28702;
chunk__28674 = G__28703;
count__28675 = G__28704;
i__28676 = G__28705;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__28669);
if(temp__4425__auto__){
var seq__28669__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28669__$1)){
var c__8721__auto__ = cljs.core.chunk_first(seq__28669__$1);
var G__28706 = cljs.core.chunk_rest(seq__28669__$1);
var G__28707 = c__8721__auto__;
var G__28708 = cljs.core.count(c__8721__auto__);
var G__28709 = (0);
seq__28669 = G__28706;
chunk__28674 = G__28707;
count__28675 = G__28708;
i__28676 = G__28709;
continue;
} else {
var h_name = cljs.core.first(seq__28669__$1);
var seq__28670_28710 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28671_28711 = null;
var count__28672_28712 = (0);
var i__28673_28713 = (0);
while(true){
if((i__28673_28713 < count__28672_28712)){
var h_val_28714 = chunk__28671_28711.cljs$core$IIndexed$_nth$arity$2(null,i__28673_28713);
xhr.headers.set(h_name,h_val_28714);

var G__28715 = seq__28670_28710;
var G__28716 = chunk__28671_28711;
var G__28717 = count__28672_28712;
var G__28718 = (i__28673_28713 + (1));
seq__28670_28710 = G__28715;
chunk__28671_28711 = G__28716;
count__28672_28712 = G__28717;
i__28673_28713 = G__28718;
continue;
} else {
var temp__4425__auto___28719__$1 = cljs.core.seq(seq__28670_28710);
if(temp__4425__auto___28719__$1){
var seq__28670_28720__$1 = temp__4425__auto___28719__$1;
if(cljs.core.chunked_seq_QMARK_(seq__28670_28720__$1)){
var c__8721__auto___28721 = cljs.core.chunk_first(seq__28670_28720__$1);
var G__28722 = cljs.core.chunk_rest(seq__28670_28720__$1);
var G__28723 = c__8721__auto___28721;
var G__28724 = cljs.core.count(c__8721__auto___28721);
var G__28725 = (0);
seq__28670_28710 = G__28722;
chunk__28671_28711 = G__28723;
count__28672_28712 = G__28724;
i__28673_28713 = G__28725;
continue;
} else {
var h_val_28726 = cljs.core.first(seq__28670_28720__$1);
xhr.headers.set(h_name,h_val_28726);

var G__28727 = cljs.core.next(seq__28670_28720__$1);
var G__28728 = null;
var G__28729 = (0);
var G__28730 = (0);
seq__28670_28710 = G__28727;
chunk__28671_28711 = G__28728;
count__28672_28712 = G__28729;
i__28673_28713 = G__28730;
continue;
}
} else {
}
}
break;
}

var G__28731 = cljs.core.next(seq__28669__$1);
var G__28732 = null;
var G__28733 = (0);
var G__28734 = (0);
seq__28669 = G__28731;
chunk__28674 = G__28732;
count__28675 = G__28733;
i__28676 = G__28734;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__28736 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$array_DASH_buffer,G__28736)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$blob,G__28736)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$document,G__28736)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$text,G__28736)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$default,G__28736)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__28736)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__28737){
var map__28741 = p__28737;
var map__28741__$1 = ((((!((map__28741 == null)))?((((map__28741.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28741.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28741):map__28741);
var request = map__28741__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28741__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28741__$1,cljs.core.constant$keyword$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28741__$1,cljs.core.constant$keyword$response_DASH_type);
var timeout = (function (){var or__7937__auto__ = cljs.core.constant$keyword$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__28743 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__28743,default_headers);

cljs_http.core.apply_response_type_BANG_(G__28743,response_type);

G__28743.setTimeoutInterval(timeout);

G__28743.setWithCredentials(send_credentials);

return G__28743;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.constant$keyword$no_DASH_error,cljs.core.constant$keyword$abort,cljs.core.constant$keyword$access_DASH_denied,cljs.core.constant$keyword$custom_DASH_error,cljs.core.constant$keyword$http_DASH_error,cljs.core.constant$keyword$ff_DASH_silent_DASH_error,cljs.core.constant$keyword$file_DASH_not_DASH_found,cljs.core.constant$keyword$offline,cljs.core.constant$keyword$exception,cljs.core.constant$keyword$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__28744){
var map__28772 = p__28744;
var map__28772__$1 = ((((!((map__28772 == null)))?((((map__28772.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28772.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28772):map__28772);
var request = map__28772__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28772__$1,cljs.core.constant$keyword$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28772__$1,cljs.core.constant$keyword$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28772__$1,cljs.core.constant$keyword$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28772__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28772__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__7937__auto__ = request_method;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return cljs.core.constant$keyword$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$status,target.getStatus(),cljs.core.constant$keyword$success,target.isSuccess(),cljs.core.constant$keyword$body,target.getResponse(),cljs.core.constant$keyword$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.constant$keyword$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.constant$keyword$error_DASH_code,(function (){var G__28774 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__28774) : cljs_http.core.error_kw.call(null,G__28774));
})(),cljs.core.constant$keyword$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__11556__auto___28799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___28799,channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___28799,channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_28785){
var state_val_28786 = (state_28785[(1)]);
if((state_val_28786 === (1))){
var state_28785__$1 = state_28785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28785__$1,(2),cancel);
} else {
if((state_val_28786 === (2))){
var inst_28776 = (state_28785[(2)]);
var inst_28777 = xhr__$1.isComplete();
var inst_28778 = cljs.core.not(inst_28777);
var state_28785__$1 = (function (){var statearr_28787 = state_28785;
(statearr_28787[(7)] = inst_28776);

return statearr_28787;
})();
if(inst_28778){
var statearr_28788_28800 = state_28785__$1;
(statearr_28788_28800[(1)] = (3));

} else {
var statearr_28789_28801 = state_28785__$1;
(statearr_28789_28801[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28786 === (3))){
var inst_28780 = xhr__$1.abort();
var state_28785__$1 = state_28785;
var statearr_28790_28802 = state_28785__$1;
(statearr_28790_28802[(2)] = inst_28780);

(statearr_28790_28802[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28786 === (4))){
var state_28785__$1 = state_28785;
var statearr_28791_28803 = state_28785__$1;
(statearr_28791_28803[(2)] = null);

(statearr_28791_28803[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28786 === (5))){
var inst_28783 = (state_28785[(2)]);
var state_28785__$1 = state_28785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28785__$1,inst_28783);
} else {
return null;
}
}
}
}
}
});})(c__11556__auto___28799,channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__11491__auto__,c__11556__auto___28799,channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__11492__auto__ = null;
var cljs_http$core$xhr_$_state_machine__11492__auto____0 = (function (){
var statearr_28795 = [null,null,null,null,null,null,null,null];
(statearr_28795[(0)] = cljs_http$core$xhr_$_state_machine__11492__auto__);

(statearr_28795[(1)] = (1));

return statearr_28795;
});
var cljs_http$core$xhr_$_state_machine__11492__auto____1 = (function (state_28785){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_28785);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e28796){if((e28796 instanceof Object)){
var ex__11495__auto__ = e28796;
var statearr_28797_28804 = state_28785;
(statearr_28797_28804[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28785);

return cljs.core.constant$keyword$recur;
} else {
throw e28796;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__28805 = state_28785;
state_28785 = G__28805;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__11492__auto__ = function(state_28785){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__11492__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__11492__auto____1.call(this,state_28785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__11492__auto____0;
cljs_http$core$xhr_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__11492__auto____1;
return cljs_http$core$xhr_$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___28799,channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__11558__auto__ = (function (){var statearr_28798 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_28798[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___28799);

return statearr_28798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___28799,channel,request_url,method,headers__$1,xhr__$1,map__28772,map__28772__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__28806){
var map__28823 = p__28806;
var map__28823__$1 = ((((!((map__28823 == null)))?((((map__28823.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28823.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28823):map__28823);
var request = map__28823__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28823__$1,cljs.core.constant$keyword$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28823__$1,cljs.core.constant$keyword$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28823__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_28839 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$status,(200),cljs.core.constant$keyword$success,true,cljs.core.constant$keyword$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel))
,((function (channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$jsonp,jsonp__$1,cljs.core.constant$keyword$request,req_28839], null));

if(cljs.core.truth_(cancel)){
var c__11556__auto___28840 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___28840,req_28839,channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___28840,req_28839,channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel){
return (function (state_28829){
var state_val_28830 = (state_28829[(1)]);
if((state_val_28830 === (1))){
var state_28829__$1 = state_28829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28829__$1,(2),cancel);
} else {
if((state_val_28830 === (2))){
var inst_28826 = (state_28829[(2)]);
var inst_28827 = jsonp__$1.cancel(req_28839);
var state_28829__$1 = (function (){var statearr_28831 = state_28829;
(statearr_28831[(7)] = inst_28826);

return statearr_28831;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28829__$1,inst_28827);
} else {
return null;
}
}
});})(c__11556__auto___28840,req_28839,channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel))
;
return ((function (switch__11491__auto__,c__11556__auto___28840,req_28839,channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel){
return (function() {
var cljs_http$core$jsonp_$_state_machine__11492__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__11492__auto____0 = (function (){
var statearr_28835 = [null,null,null,null,null,null,null,null];
(statearr_28835[(0)] = cljs_http$core$jsonp_$_state_machine__11492__auto__);

(statearr_28835[(1)] = (1));

return statearr_28835;
});
var cljs_http$core$jsonp_$_state_machine__11492__auto____1 = (function (state_28829){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_28829);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e28836){if((e28836 instanceof Object)){
var ex__11495__auto__ = e28836;
var statearr_28837_28841 = state_28829;
(statearr_28837_28841[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28829);

return cljs.core.constant$keyword$recur;
} else {
throw e28836;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__28842 = state_28829;
state_28829 = G__28842;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__11492__auto__ = function(state_28829){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__11492__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__11492__auto____1.call(this,state_28829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__11492__auto____0;
cljs_http$core$jsonp_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__11492__auto____1;
return cljs_http$core$jsonp_$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___28840,req_28839,channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel))
})();
var state__11558__auto__ = (function (){var statearr_28838 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_28838[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___28840);

return statearr_28838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___28840,req_28839,channel,jsonp__$1,map__28823,map__28823__$1,request,timeout,callback_name,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__28843){
var map__28846 = p__28843;
var map__28846__$1 = ((((!((map__28846 == null)))?((((map__28846.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28846.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28846):map__28846);
var request__$1 = map__28846__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28846__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.constant$keyword$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
