// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__7928__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__7928__auto__)){
return stateful_method_QMARK_;
} else {
return and__7928__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__7928__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__7928__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__7928__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__28103 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28103) : cljs_hash.md5.md5.call(null,G__28103));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__8986__auto__ = [];
var len__8979__auto___28108 = arguments.length;
var i__8980__auto___28109 = (0);
while(true){
if((i__8980__auto___28109 < len__8979__auto___28108)){
args__8986__auto__.push((arguments[i__8980__auto___28109]));

var G__28110 = (i__8980__auto___28109 + (1));
i__8980__auto___28109 = G__28110;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((0) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__8987__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__28105){
var map__28106 = p__28105;
var map__28106__$1 = ((((!((map__28106 == null)))?((((map__28106.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28106.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28106):map__28106);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28106__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28106__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28106__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__7928__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__7928__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__7928__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__7928__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__7928__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__7928__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__7940__auto__ = accept_header;
if(cljs.core.truth_(or__7940__auto__)){
return or__7940__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq28104){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28104));
});
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(io_obj){
try{return io_obj.getResponseJson();
}catch (e28112){if((e28112 instanceof Error)){
var _ = e28112;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$error,io_obj.getResponseText()], null);
} else {
throw e28112;

}
}});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 * a core.async channel where result message will be put
 * and (optionally) an id to include in the result message. Returns the
 * XhrIo object that can be used to abort request. More XhrIo API
 * docs at:
 * https://closure-library.googlecode.com/git-history/docs/class_goog_net_XhrIo.html
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(){
var args__8986__auto__ = [];
var len__8979__auto___28128 = arguments.length;
var i__8980__auto___28129 = (0);
while(true){
if((i__8980__auto___28129 < len__8979__auto___28128)){
args__8986__auto__.push((arguments[i__8980__auto___28129]));

var G__28130 = (i__8980__auto___28129 + (1));
i__8980__auto___28129 = G__28130;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((2) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((2)),(0))):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8987__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__28117){
var vec__28118 = p__28117;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28118,(0),null);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$id,id], null):null);
var url = form.action;
var G__28119_28131 = io_obj;
var G__28120_28132 = goog.net.EventType.SUCCESS;
var G__28121_28133 = ((function (G__28119_28131,G__28120_28132,io_obj,data,url,vec__28118,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.constant$keyword$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.constant$keyword$success_QMARK_,true], 0)));
});})(G__28119_28131,G__28120_28132,io_obj,data,url,vec__28118,id))
;
goog.events.listen(G__28119_28131,G__28120_28132,G__28121_28133);

var G__28122_28134 = io_obj;
var G__28123_28135 = goog.net.EventType.ERROR;
var G__28124_28136 = ((function (G__28122_28134,G__28123_28135,io_obj,data,url,vec__28118,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.constant$keyword$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.constant$keyword$success_QMARK_,false], 0)));
});})(G__28122_28134,G__28123_28135,io_obj,data,url,vec__28118,id))
;
goog.events.listen(G__28122_28134,G__28123_28135,G__28124_28136);

var G__28125_28137 = io_obj;
var G__28126_28138 = goog.net.EventType.PROGRESS;
var G__28127_28139 = ((function (G__28125_28137,G__28126_28138,io_obj,data,url,vec__28118,id){
return (function (p1__28113_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.constant$keyword$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$length_DASH_computable,p1__28113_SHARP_.lengthComputable,cljs.core.constant$keyword$loaded,p1__28113_SHARP_.loaded,cljs.core.constant$keyword$total,p1__28113_SHARP_.total], null)));
});})(G__28125_28137,G__28126_28138,io_obj,data,url,vec__28118,id))
;
goog.events.listen(G__28125_28137,G__28126_28138,G__28127_28139);

io_obj.send(url,"POST",form);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq28114){
var G__28115 = cljs.core.first(seq28114);
var seq28114__$1 = cljs.core.next(seq28114);
var G__28116 = cljs.core.first(seq28114__$1);
var seq28114__$2 = cljs.core.next(seq28114__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__28115,G__28116,seq28114__$2);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__8986__auto__ = [];
var len__8979__auto___28202 = arguments.length;
var i__8980__auto___28203 = (0);
while(true){
if((i__8980__auto___28203 < len__8979__auto___28202)){
args__8986__auto__.push((arguments[i__8980__auto___28203]));

var G__28204 = (i__8980__auto___28203 + (1));
i__8980__auto___28203 = G__28204;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((1) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8987__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11629__auto___28205 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11629__auto___28205,response_channel){
return (function (){
var f__11630__auto__ = (function (){var switch__11564__auto__ = ((function (c__11629__auto___28205,response_channel){
return (function (state_28175){
var state_val_28176 = (state_28175[(1)]);
if((state_val_28176 === (7))){
var state_28175__$1 = state_28175;
var statearr_28177_28206 = state_28175__$1;
(statearr_28177_28206[(2)] = false);

(statearr_28177_28206[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (1))){
var inst_28143 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_28175__$1 = state_28175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28175__$1,(2),inst_28143);
} else {
if((state_val_28176 === (4))){
var state_28175__$1 = state_28175;
var statearr_28178_28207 = state_28175__$1;
(statearr_28178_28207[(2)] = false);

(statearr_28178_28207[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (13))){
var inst_28165 = (state_28175[(7)]);
var inst_28171 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_28165);
var state_28175__$1 = state_28175;
var statearr_28179_28208 = state_28175__$1;
(statearr_28179_28208[(2)] = inst_28171);

(statearr_28179_28208[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (6))){
var state_28175__$1 = state_28175;
var statearr_28180_28209 = state_28175__$1;
(statearr_28180_28209[(2)] = true);

(statearr_28180_28209[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (3))){
var inst_28145 = (state_28175[(8)]);
var inst_28150 = inst_28145.cljs$lang$protocol_mask$partition0$;
var inst_28151 = (inst_28150 & (64));
var inst_28152 = inst_28145.cljs$core$ISeq$;
var inst_28153 = (inst_28151) || (inst_28152);
var state_28175__$1 = state_28175;
if(cljs.core.truth_(inst_28153)){
var statearr_28181_28210 = state_28175__$1;
(statearr_28181_28210[(1)] = (6));

} else {
var statearr_28182_28211 = state_28175__$1;
(statearr_28182_28211[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (12))){
var inst_28169 = window.location = window.location;
var state_28175__$1 = state_28175;
var statearr_28183_28212 = state_28175__$1;
(statearr_28183_28212[(2)] = inst_28169);

(statearr_28183_28212[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (2))){
var inst_28145 = (state_28175[(8)]);
var inst_28145__$1 = (state_28175[(2)]);
var inst_28147 = (inst_28145__$1 == null);
var inst_28148 = cljs.core.not(inst_28147);
var state_28175__$1 = (function (){var statearr_28184 = state_28175;
(statearr_28184[(8)] = inst_28145__$1);

return statearr_28184;
})();
if(inst_28148){
var statearr_28185_28213 = state_28175__$1;
(statearr_28185_28213[(1)] = (3));

} else {
var statearr_28186_28214 = state_28175__$1;
(statearr_28186_28214[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (11))){
var inst_28165 = (state_28175[(7)]);
var inst_28165__$1 = (state_28175[(2)]);
var inst_28166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28165__$1,cljs.core.constant$keyword$status);
var inst_28167 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28166,(401));
var state_28175__$1 = (function (){var statearr_28187 = state_28175;
(statearr_28187[(7)] = inst_28165__$1);

return statearr_28187;
})();
if(inst_28167){
var statearr_28188_28215 = state_28175__$1;
(statearr_28188_28215[(1)] = (12));

} else {
var statearr_28189_28216 = state_28175__$1;
(statearr_28189_28216[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (9))){
var inst_28145 = (state_28175[(8)]);
var inst_28162 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28145);
var state_28175__$1 = state_28175;
var statearr_28190_28217 = state_28175__$1;
(statearr_28190_28217[(2)] = inst_28162);

(statearr_28190_28217[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (5))){
var inst_28160 = (state_28175[(2)]);
var state_28175__$1 = state_28175;
if(cljs.core.truth_(inst_28160)){
var statearr_28191_28218 = state_28175__$1;
(statearr_28191_28218[(1)] = (9));

} else {
var statearr_28192_28219 = state_28175__$1;
(statearr_28192_28219[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (14))){
var inst_28173 = (state_28175[(2)]);
var state_28175__$1 = state_28175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28175__$1,inst_28173);
} else {
if((state_val_28176 === (10))){
var inst_28145 = (state_28175[(8)]);
var state_28175__$1 = state_28175;
var statearr_28193_28220 = state_28175__$1;
(statearr_28193_28220[(2)] = inst_28145);

(statearr_28193_28220[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28176 === (8))){
var inst_28157 = (state_28175[(2)]);
var state_28175__$1 = state_28175;
var statearr_28194_28221 = state_28175__$1;
(statearr_28194_28221[(2)] = inst_28157);

(statearr_28194_28221[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11629__auto___28205,response_channel))
;
return ((function (switch__11564__auto__,c__11629__auto___28205,response_channel){
return (function() {
var milia$api$io$state_machine__11565__auto__ = null;
var milia$api$io$state_machine__11565__auto____0 = (function (){
var statearr_28198 = [null,null,null,null,null,null,null,null,null];
(statearr_28198[(0)] = milia$api$io$state_machine__11565__auto__);

(statearr_28198[(1)] = (1));

return statearr_28198;
});
var milia$api$io$state_machine__11565__auto____1 = (function (state_28175){
while(true){
var ret_value__11566__auto__ = (function (){try{while(true){
var result__11567__auto__ = switch__11564__auto__(state_28175);
if(cljs.core.keyword_identical_QMARK_(result__11567__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11567__auto__;
}
break;
}
}catch (e28199){if((e28199 instanceof Object)){
var ex__11568__auto__ = e28199;
var statearr_28200_28222 = state_28175;
(statearr_28200_28222[(5)] = ex__11568__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28175);

return cljs.core.constant$keyword$recur;
} else {
throw e28199;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11566__auto__,cljs.core.constant$keyword$recur)){
var G__28223 = state_28175;
state_28175 = G__28223;
continue;
} else {
return ret_value__11566__auto__;
}
break;
}
});
milia$api$io$state_machine__11565__auto__ = function(state_28175){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11565__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11565__auto____1.call(this,state_28175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11565__auto____0;
milia$api$io$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11565__auto____1;
return milia$api$io$state_machine__11565__auto__;
})()
;})(switch__11564__auto__,c__11629__auto___28205,response_channel))
})();
var state__11631__auto__ = (function (){var statearr_28201 = (f__11630__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11630__auto__.cljs$core$IFn$_invoke$arity$0() : f__11630__auto__.call(null));
(statearr_28201[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11629__auto___28205);

return statearr_28201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11631__auto__);
});})(c__11629__auto___28205,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq28140){
var G__28141 = cljs.core.first(seq28140);
var seq28140__$1 = cljs.core.next(seq28140);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__28141,seq28140__$1);
});
