// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31488 = arguments.length;
var i__7652__auto___31489 = (0);
while(true){
if((i__7652__auto___31489 < len__7651__auto___31488)){
args__7658__auto__.push((arguments[i__7652__auto___31489]));

var G__31490 = (i__7652__auto___31489 + (1));
i__7652__auto___31489 = G__31490;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__31401){
var map__31402 = p__31401;
var map__31402__$1 = ((((!((map__31402 == null)))?((((map__31402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31402.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31402):map__31402);
var options = map__31402__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31402__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31402__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__,map__31402,map__31402__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__,map__31402,map__31402__$1,options,max_retries,retry_for_statuses){
return (function (state_31453){
var state_val_31454 = (state_31453[(1)]);
if((state_val_31454 === (7))){
var inst_31427 = (state_31453[(2)]);
var state_31453__$1 = state_31453;
if(cljs.core.truth_(inst_31427)){
var statearr_31455_31491 = state_31453__$1;
(statearr_31455_31491[(1)] = (11));

} else {
var statearr_31456_31492 = state_31453__$1;
(statearr_31456_31492[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (20))){
var inst_31404 = (state_31453[(7)]);
var inst_31405 = (state_31453[(8)]);
var inst_31443 = (state_31453[(2)]);
var inst_31444 = (inst_31404 * (2));
var inst_31445 = (inst_31405 + (1));
var inst_31404__$1 = inst_31444;
var inst_31405__$1 = inst_31445;
var state_31453__$1 = (function (){var statearr_31457 = state_31453;
(statearr_31457[(7)] = inst_31404__$1);

(statearr_31457[(8)] = inst_31405__$1);

(statearr_31457[(9)] = inst_31443);

return statearr_31457;
})();
var statearr_31458_31493 = state_31453__$1;
(statearr_31458_31493[(2)] = null);

(statearr_31458_31493[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (1))){
var inst_31404 = milia.utils.retry.initial_polling_interval;
var inst_31405 = (0);
var state_31453__$1 = (function (){var statearr_31459 = state_31453;
(statearr_31459[(7)] = inst_31404);

(statearr_31459[(8)] = inst_31405);

return statearr_31459;
})();
var statearr_31460_31494 = state_31453__$1;
(statearr_31460_31494[(2)] = null);

(statearr_31460_31494[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (4))){
var inst_31411 = (state_31453[(10)]);
var inst_31411__$1 = (state_31453[(2)]);
var inst_31413 = (inst_31411__$1 == null);
var inst_31414 = cljs.core.not(inst_31413);
var state_31453__$1 = (function (){var statearr_31461 = state_31453;
(statearr_31461[(10)] = inst_31411__$1);

return statearr_31461;
})();
if(inst_31414){
var statearr_31462_31495 = state_31453__$1;
(statearr_31462_31495[(1)] = (5));

} else {
var statearr_31463_31496 = state_31453__$1;
(statearr_31463_31496[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (15))){
var inst_31434 = (state_31453[(11)]);
var state_31453__$1 = state_31453;
var statearr_31464_31497 = state_31453__$1;
(statearr_31464_31497[(2)] = inst_31434);

(statearr_31464_31497[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (13))){
var inst_31434 = (state_31453[(11)]);
var inst_31432 = (state_31453[(12)]);
var inst_31432__$1 = (state_31453[(2)]);
var inst_31433 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31432__$1,cljs.core.cst$kw$status);
var inst_31434__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_31433);
var state_31453__$1 = (function (){var statearr_31465 = state_31453;
(statearr_31465[(11)] = inst_31434__$1);

(statearr_31465[(12)] = inst_31432__$1);

return statearr_31465;
})();
if(cljs.core.truth_(inst_31434__$1)){
var statearr_31466_31498 = state_31453__$1;
(statearr_31466_31498[(1)] = (14));

} else {
var statearr_31467_31499 = state_31453__$1;
(statearr_31467_31499[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (6))){
var state_31453__$1 = state_31453;
var statearr_31468_31500 = state_31453__$1;
(statearr_31468_31500[(2)] = false);

(statearr_31468_31500[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (17))){
var inst_31404 = (state_31453[(7)]);
var inst_31441 = cljs.core.async.timeout(inst_31404);
var state_31453__$1 = state_31453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31453__$1,(20),inst_31441);
} else {
if((state_val_31454 === (3))){
var inst_31451 = (state_31453[(2)]);
var state_31453__$1 = state_31453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31453__$1,inst_31451);
} else {
if((state_val_31454 === (12))){
var inst_31411 = (state_31453[(10)]);
var state_31453__$1 = state_31453;
var statearr_31469_31501 = state_31453__$1;
(statearr_31469_31501[(2)] = inst_31411);

(statearr_31469_31501[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (2))){
var inst_31408 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_31409 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_31408], 0));
var state_31453__$1 = state_31453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31453__$1,(4),inst_31409);
} else {
if((state_val_31454 === (19))){
var inst_31449 = (state_31453[(2)]);
var state_31453__$1 = state_31453;
var statearr_31470_31502 = state_31453__$1;
(statearr_31470_31502[(2)] = inst_31449);

(statearr_31470_31502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (11))){
var inst_31411 = (state_31453[(10)]);
var inst_31429 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31411);
var state_31453__$1 = state_31453;
var statearr_31471_31503 = state_31453__$1;
(statearr_31471_31503[(2)] = inst_31429);

(statearr_31471_31503[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (9))){
var state_31453__$1 = state_31453;
var statearr_31472_31504 = state_31453__$1;
(statearr_31472_31504[(2)] = false);

(statearr_31472_31504[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (5))){
var inst_31411 = (state_31453[(10)]);
var inst_31416 = inst_31411.cljs$lang$protocol_mask$partition0$;
var inst_31417 = (inst_31416 & (64));
var inst_31418 = inst_31411.cljs$core$ISeq$;
var inst_31419 = (cljs.core.PROTOCOL_SENTINEL === inst_31418);
var inst_31420 = (inst_31417) || (inst_31419);
var state_31453__$1 = state_31453;
if(cljs.core.truth_(inst_31420)){
var statearr_31473_31505 = state_31453__$1;
(statearr_31473_31505[(1)] = (8));

} else {
var statearr_31474_31506 = state_31453__$1;
(statearr_31474_31506[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (14))){
var inst_31405 = (state_31453[(8)]);
var inst_31436 = (inst_31405 < max_retries);
var state_31453__$1 = state_31453;
var statearr_31475_31507 = state_31453__$1;
(statearr_31475_31507[(2)] = inst_31436);

(statearr_31475_31507[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (16))){
var inst_31439 = (state_31453[(2)]);
var state_31453__$1 = state_31453;
if(cljs.core.truth_(inst_31439)){
var statearr_31476_31508 = state_31453__$1;
(statearr_31476_31508[(1)] = (17));

} else {
var statearr_31477_31509 = state_31453__$1;
(statearr_31477_31509[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (10))){
var inst_31424 = (state_31453[(2)]);
var state_31453__$1 = state_31453;
var statearr_31478_31510 = state_31453__$1;
(statearr_31478_31510[(2)] = inst_31424);

(statearr_31478_31510[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (18))){
var inst_31432 = (state_31453[(12)]);
var state_31453__$1 = state_31453;
var statearr_31479_31511 = state_31453__$1;
(statearr_31479_31511[(2)] = inst_31432);

(statearr_31479_31511[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31454 === (8))){
var state_31453__$1 = state_31453;
var statearr_31480_31512 = state_31453__$1;
(statearr_31480_31512[(2)] = true);

(statearr_31480_31512[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__,map__31402,map__31402__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19180__auto__,c__19292__auto__,map__31402,map__31402__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19181__auto__ = null;
var milia$utils$retry$state_machine__19181__auto____0 = (function (){
var statearr_31484 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31484[(0)] = milia$utils$retry$state_machine__19181__auto__);

(statearr_31484[(1)] = (1));

return statearr_31484;
});
var milia$utils$retry$state_machine__19181__auto____1 = (function (state_31453){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_31453);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e31485){if((e31485 instanceof Object)){
var ex__19184__auto__ = e31485;
var statearr_31486_31513 = state_31453;
(statearr_31486_31513[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31453);

return cljs.core.cst$kw$recur;
} else {
throw e31485;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__31514 = state_31453;
state_31453 = G__31514;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19181__auto__ = function(state_31453){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19181__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19181__auto____1.call(this,state_31453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19181__auto____0;
milia$utils$retry$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19181__auto____1;
return milia$utils$retry$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__,map__31402,map__31402__$1,options,max_retries,retry_for_statuses))
})();
var state__19294__auto__ = (function (){var statearr_31487 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_31487[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_31487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__,map__31402,map__31402__$1,options,max_retries,retry_for_statuses))
);

return c__19292__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq31398){
var G__31399 = cljs.core.first(seq31398);
var seq31398__$1 = cljs.core.next(seq31398);
var G__31400 = cljs.core.first(seq31398__$1);
var seq31398__$2 = cljs.core.next(seq31398__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__31399,G__31400,seq31398__$2);
});

