// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35905 = arguments.length;
var i__7652__auto___35906 = (0);
while(true){
if((i__7652__auto___35906 < len__7651__auto___35905)){
args__7658__auto__.push((arguments[i__7652__auto___35906]));

var G__35907 = (i__7652__auto___35906 + (1));
i__7652__auto___35906 = G__35907;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq35904){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35904));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__35908,p__35909){
var map__35918 = p__35908;
var map__35918__$1 = ((((!((map__35918 == null)))?((((map__35918.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35918.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35918):map__35918);
var response = map__35918__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35918__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35918__$1,cljs.core.cst$kw$body);
var map__35919 = p__35909;
var map__35919__$1 = ((((!((map__35919 == null)))?((((map__35919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35919.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35919):map__35919);
var callbacks = map__35919__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35919__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35919__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35919__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35919__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__35922 = body;
var map__35922__$1 = ((((!((map__35922 == null)))?((((map__35922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35922.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35922):map__35922);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35922__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35922__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35922__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__35922,map__35922__$1,export_url,job_status,job_id,map__35918,map__35918__$1,response,status,body,map__35919,map__35919__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__35922,map__35922__$1,export_url,job_status,job_id,map__35918,map__35918__$1,response,status,body,map__35919,map__35919__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__35924_35926 = error_detail;
var G__35925_35927 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__35924_35926,G__35925_35927) : on_error.call(null,G__35924_35926,G__35925_35927));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35978 = arguments.length;
var i__7652__auto___35979 = (0);
while(true){
if((i__7652__auto___35979 < len__7651__auto___35978)){
args__7658__auto__.push((arguments[i__7652__auto___35979]));

var G__35980 = (i__7652__auto___35979 + (1));
i__7652__auto___35979 = G__35980;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__35931){
var map__35932 = p__35931;
var map__35932__$1 = ((((!((map__35932 == null)))?((((map__35932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35932.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35932):map__35932);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35932__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35932__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35932__$1,cljs.core.cst$kw$data_DASH_type);
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type){
return (function (state_35960){
var state_val_35961 = (state_35960[(1)]);
if((state_val_35961 === (1))){
var inst_35934 = milia.api.async_export.initial_polling_interval;
var state_35960__$1 = (function (){var statearr_35962 = state_35960;
(statearr_35962[(7)] = inst_35934);

return statearr_35962;
})();
var statearr_35963_35981 = state_35960__$1;
(statearr_35963_35981[(2)] = null);

(statearr_35963_35981[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35961 === (2))){
var inst_35938 = (state_35960[(8)]);
var inst_35936 = (state_35960[(9)]);
var inst_35936__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_35937 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_35938__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_35937,dataset_id,inst_35936__$1], 0));
var inst_35939 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_35938__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_35960__$1 = (function (){var statearr_35964 = state_35960;
(statearr_35964[(8)] = inst_35938__$1);

(statearr_35964[(9)] = inst_35936__$1);

return statearr_35964;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35960__$1,(4),inst_35939);
} else {
if((state_val_35961 === (3))){
var inst_35958 = (state_35960[(2)]);
var state_35960__$1 = state_35960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35960__$1,inst_35958);
} else {
if((state_val_35961 === (4))){
var inst_35938 = (state_35960[(8)]);
var inst_35934 = (state_35960[(7)]);
var inst_35936 = (state_35960[(9)]);
var inst_35941 = (state_35960[(2)]);
var inst_35942 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_35943 = (function (){var polling_interval = inst_35934;
var job_suffix = inst_35936;
var job_url = inst_35938;
var response = inst_35941;
return ((function (polling_interval,job_suffix,job_url,response,inst_35938,inst_35934,inst_35936,inst_35941,inst_35942,state_val_35961,c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_35938,inst_35934,inst_35936,inst_35941,inst_35942,state_val_35961,c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type))
})();
var inst_35944 = [inst_35943,on_error,on_export_url];
var inst_35945 = cljs.core.PersistentHashMap.fromArrays(inst_35942,inst_35944);
var inst_35946 = milia.api.async_export.handle_response(inst_35941,inst_35945);
var inst_35947 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_35946,cljs.core.cst$kw$stop);
var state_35960__$1 = state_35960;
if(inst_35947){
var statearr_35965_35982 = state_35960__$1;
(statearr_35965_35982[(1)] = (5));

} else {
var statearr_35966_35983 = state_35960__$1;
(statearr_35966_35983[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35961 === (5))){
var inst_35934 = (state_35960[(7)]);
var inst_35949 = cljs.core.async.timeout(inst_35934);
var state_35960__$1 = state_35960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35960__$1,(8),inst_35949);
} else {
if((state_val_35961 === (6))){
var state_35960__$1 = state_35960;
var statearr_35967_35984 = state_35960__$1;
(statearr_35967_35984[(2)] = null);

(statearr_35967_35984[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35961 === (7))){
var inst_35956 = (state_35960[(2)]);
var state_35960__$1 = state_35960;
var statearr_35968_35985 = state_35960__$1;
(statearr_35968_35985[(2)] = inst_35956);

(statearr_35968_35985[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35961 === (8))){
var inst_35934 = (state_35960[(7)]);
var inst_35951 = (state_35960[(2)]);
var inst_35952 = (inst_35934 * (2));
var inst_35934__$1 = inst_35952;
var state_35960__$1 = (function (){var statearr_35969 = state_35960;
(statearr_35969[(7)] = inst_35934__$1);

(statearr_35969[(10)] = inst_35951);

return statearr_35969;
})();
var statearr_35970_35986 = state_35960__$1;
(statearr_35970_35986[(2)] = null);

(statearr_35970_35986[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19063__auto__,c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19064__auto__ = null;
var milia$api$async_export$state_machine__19064__auto____0 = (function (){
var statearr_35974 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35974[(0)] = milia$api$async_export$state_machine__19064__auto__);

(statearr_35974[(1)] = (1));

return statearr_35974;
});
var milia$api$async_export$state_machine__19064__auto____1 = (function (state_35960){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_35960);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e35975){if((e35975 instanceof Object)){
var ex__19067__auto__ = e35975;
var statearr_35976_35987 = state_35960;
(statearr_35976_35987[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35960);

return cljs.core.cst$kw$recur;
} else {
throw e35975;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__35988 = state_35960;
state_35960 = G__35988;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19064__auto__ = function(state_35960){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19064__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19064__auto____1.call(this,state_35960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19064__auto____0;
milia$api$async_export$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19064__auto____1;
return milia$api$async_export$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type))
})();
var state__19177__auto__ = (function (){var statearr_35977 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_35977[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_35977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__,map__35932,map__35932__$1,on_error,on_export_url,data_type))
);

return c__19175__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq35928){
var G__35929 = cljs.core.first(seq35928);
var seq35928__$1 = cljs.core.next(seq35928);
var G__35930 = cljs.core.first(seq35928__$1);
var seq35928__$2 = cljs.core.next(seq35928__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35929,G__35930,seq35928__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__){
return (function (state_36118){
var state_val_36119 = (state_36118[(1)]);
if((state_val_36119 === (7))){
var inst_36093 = (state_36118[(2)]);
var state_36118__$1 = state_36118;
if(cljs.core.truth_(inst_36093)){
var statearr_36120_36150 = state_36118__$1;
(statearr_36120_36150[(1)] = (11));

} else {
var statearr_36121_36151 = state_36118__$1;
(statearr_36121_36151[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (1))){
var inst_36070 = milia.api.async_export.initial_polling_interval;
var state_36118__$1 = (function (){var statearr_36122 = state_36118;
(statearr_36122[(7)] = inst_36070);

return statearr_36122;
})();
var statearr_36123_36152 = state_36118__$1;
(statearr_36123_36152[(2)] = null);

(statearr_36123_36152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (4))){
var inst_36077 = (state_36118[(8)]);
var inst_36077__$1 = (state_36118[(2)]);
var inst_36079 = (inst_36077__$1 == null);
var inst_36080 = cljs.core.not(inst_36079);
var state_36118__$1 = (function (){var statearr_36124 = state_36118;
(statearr_36124[(8)] = inst_36077__$1);

return statearr_36124;
})();
if(inst_36080){
var statearr_36125_36153 = state_36118__$1;
(statearr_36125_36153[(1)] = (5));

} else {
var statearr_36126_36154 = state_36118__$1;
(statearr_36126_36154[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (15))){
var inst_36070 = (state_36118[(7)]);
var inst_36108 = cljs.core.async.timeout(inst_36070);
var state_36118__$1 = state_36118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36118__$1,(17),inst_36108);
} else {
if((state_val_36119 === (13))){
var inst_36070 = (state_36118[(7)]);
var inst_36100 = (state_36118[(9)]);
var inst_36074 = (state_36118[(10)]);
var inst_36098 = (state_36118[(2)]);
var inst_36099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36098,cljs.core.cst$kw$status);
var inst_36100__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36098,cljs.core.cst$kw$body);
var inst_36101 = (function (){var polling_interval = inst_36070;
var export_url = inst_36074;
var map__36072 = inst_36098;
var status = inst_36099;
var body = inst_36100__$1;
return ((function (polling_interval,export_url,map__36072,status,body,inst_36070,inst_36100,inst_36074,inst_36098,inst_36099,inst_36100__$1,state_val_36119,c__19175__auto__){
return (function (p1__35989_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__35989_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__36072,status,body,inst_36070,inst_36100,inst_36074,inst_36098,inst_36099,inst_36100__$1,state_val_36119,c__19175__auto__))
})();
var inst_36102 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_36101,inst_36100__$1);
var inst_36103 = cljs.core.vec(inst_36102);
var inst_36104 = cljs.core.empty_QMARK_(inst_36103);
var state_36118__$1 = (function (){var statearr_36127 = state_36118;
(statearr_36127[(9)] = inst_36100__$1);

return statearr_36127;
})();
if(inst_36104){
var statearr_36128_36155 = state_36118__$1;
(statearr_36128_36155[(1)] = (14));

} else {
var statearr_36129_36156 = state_36118__$1;
(statearr_36129_36156[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (6))){
var state_36118__$1 = state_36118;
var statearr_36130_36157 = state_36118__$1;
(statearr_36130_36157[(2)] = false);

(statearr_36130_36157[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (17))){
var inst_36070 = (state_36118[(7)]);
var inst_36110 = (state_36118[(2)]);
var inst_36111 = (inst_36070 * (2));
var inst_36070__$1 = inst_36111;
var state_36118__$1 = (function (){var statearr_36131 = state_36118;
(statearr_36131[(7)] = inst_36070__$1);

(statearr_36131[(11)] = inst_36110);

return statearr_36131;
})();
var statearr_36132_36158 = state_36118__$1;
(statearr_36132_36158[(2)] = null);

(statearr_36132_36158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (3))){
var inst_36116 = (state_36118[(2)]);
var state_36118__$1 = state_36118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36118__$1,inst_36116);
} else {
if((state_val_36119 === (12))){
var inst_36077 = (state_36118[(8)]);
var state_36118__$1 = state_36118;
var statearr_36133_36159 = state_36118__$1;
(statearr_36133_36159[(2)] = inst_36077);

(statearr_36133_36159[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (2))){
var inst_36074 = (state_36118[(10)]);
var inst_36073 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0));
var inst_36074__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_36073], 0));
var inst_36075 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_36074__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_36118__$1 = (function (){var statearr_36134 = state_36118;
(statearr_36134[(10)] = inst_36074__$1);

return statearr_36134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36118__$1,(4),inst_36075);
} else {
if((state_val_36119 === (11))){
var inst_36077 = (state_36118[(8)]);
var inst_36095 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36077);
var state_36118__$1 = state_36118;
var statearr_36135_36160 = state_36118__$1;
(statearr_36135_36160[(2)] = inst_36095);

(statearr_36135_36160[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (9))){
var state_36118__$1 = state_36118;
var statearr_36136_36161 = state_36118__$1;
(statearr_36136_36161[(2)] = false);

(statearr_36136_36161[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (5))){
var inst_36077 = (state_36118[(8)]);
var inst_36082 = inst_36077.cljs$lang$protocol_mask$partition0$;
var inst_36083 = (inst_36082 & (64));
var inst_36084 = inst_36077.cljs$core$ISeq$;
var inst_36085 = (cljs.core.PROTOCOL_SENTINEL === inst_36084);
var inst_36086 = (inst_36083) || (inst_36085);
var state_36118__$1 = state_36118;
if(cljs.core.truth_(inst_36086)){
var statearr_36137_36162 = state_36118__$1;
(statearr_36137_36162[(1)] = (8));

} else {
var statearr_36138_36163 = state_36118__$1;
(statearr_36138_36163[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (14))){
var inst_36100 = (state_36118[(9)]);
var inst_36106 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_36100) : callback.call(null,inst_36100));
var state_36118__$1 = state_36118;
var statearr_36139_36164 = state_36118__$1;
(statearr_36139_36164[(2)] = inst_36106);

(statearr_36139_36164[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (16))){
var inst_36114 = (state_36118[(2)]);
var state_36118__$1 = state_36118;
var statearr_36140_36165 = state_36118__$1;
(statearr_36140_36165[(2)] = inst_36114);

(statearr_36140_36165[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (10))){
var inst_36090 = (state_36118[(2)]);
var state_36118__$1 = state_36118;
var statearr_36141_36166 = state_36118__$1;
(statearr_36141_36166[(2)] = inst_36090);

(statearr_36141_36166[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36119 === (8))){
var state_36118__$1 = state_36118;
var statearr_36142_36167 = state_36118__$1;
(statearr_36142_36167[(2)] = true);

(statearr_36142_36167[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto__))
;
return ((function (switch__19063__auto__,c__19175__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto____0 = (function (){
var statearr_36146 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36146[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto__);

(statearr_36146[(1)] = (1));

return statearr_36146;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto____1 = (function (state_36118){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_36118);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e36147){if((e36147 instanceof Object)){
var ex__19067__auto__ = e36147;
var statearr_36148_36168 = state_36118;
(statearr_36148_36168[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36118);

return cljs.core.cst$kw$recur;
} else {
throw e36147;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__36169 = state_36118;
state_36118 = G__36169;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto__ = function(state_36118){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto____1.call(this,state_36118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__))
})();
var state__19177__auto__ = (function (){var statearr_36149 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_36149[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_36149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__))
);

return c__19175__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36177 = arguments.length;
var i__7652__auto___36178 = (0);
while(true){
if((i__7652__auto___36178 < len__7651__auto___36177)){
args__7658__auto__.push((arguments[i__7652__auto___36178]));

var G__36179 = (i__7652__auto___36178 + (1));
i__7652__auto___36178 = G__36179;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__36173){
var vec__36174 = p__36173;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36174,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq36170){
var G__36171 = cljs.core.first(seq36170);
var seq36170__$1 = cljs.core.next(seq36170);
var G__36172 = cljs.core.first(seq36170__$1);
var seq36170__$2 = cljs.core.next(seq36170__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__36171,G__36172,seq36170__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36229 = arguments.length;
var i__7652__auto___36230 = (0);
while(true){
if((i__7652__auto___36230 < len__7651__auto___36229)){
args__7658__auto__.push((arguments[i__7652__auto___36230]));

var G__36231 = (i__7652__auto___36230 + (1));
i__7652__auto___36230 = G__36231;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__36182){
var vec__36183 = p__36182;
var map__36186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36183,(0),null);
var map__36186__$1 = ((((!((map__36186 == null)))?((((map__36186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36186.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36186):map__36186);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36186__$1,cljs.core.cst$kw$on_DASH_done);
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_36209){
var state_val_36210 = (state_36209[(1)]);
if((state_val_36210 === (1))){
var inst_36188 = (state_36209[(7)]);
var inst_36190 = (state_36209[(8)]);
var inst_36188__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_36189 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_36190__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_36189,dataset_id,inst_36188__$1], 0));
var inst_36191 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_36190__$1);
var state_36209__$1 = (function (){var statearr_36211 = state_36209;
(statearr_36211[(7)] = inst_36188__$1);

(statearr_36211[(8)] = inst_36190__$1);

return statearr_36211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36209__$1,(2),inst_36191);
} else {
if((state_val_36210 === (2))){
var inst_36188 = (state_36209[(7)]);
var inst_36190 = (state_36209[(8)]);
var inst_36193 = (state_36209[(9)]);
var inst_36193__$1 = (state_36209[(2)]);
var inst_36194 = (function (){var export_suffix = inst_36188;
var export_url = inst_36190;
var response = inst_36193__$1;
return ((function (export_suffix,export_url,response,inst_36188,inst_36190,inst_36193,inst_36193__$1,state_val_36210,c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_36188,inst_36190,inst_36193,inst_36193__$1,state_val_36210,c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_36209__$1 = (function (){var statearr_36212 = state_36209;
(statearr_36212[(10)] = inst_36194);

(statearr_36212[(9)] = inst_36193__$1);

return statearr_36212;
})();
if(cljs.core.truth_(on_done)){
var statearr_36213_36232 = state_36209__$1;
(statearr_36213_36232[(1)] = (3));

} else {
var statearr_36214_36233 = state_36209__$1;
(statearr_36214_36233[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36210 === (3))){
var inst_36193 = (state_36209[(9)]);
var inst_36196 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_36193) : on_done.call(null,inst_36193));
var state_36209__$1 = state_36209;
var statearr_36215_36234 = state_36209__$1;
(statearr_36215_36234[(2)] = inst_36196);

(statearr_36215_36234[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36210 === (4))){
var state_36209__$1 = state_36209;
var statearr_36216_36235 = state_36209__$1;
(statearr_36216_36235[(2)] = null);

(statearr_36216_36235[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36210 === (5))){
var inst_36199 = (state_36209[(2)]);
var inst_36200 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_36209__$1 = (function (){var statearr_36217 = state_36209;
(statearr_36217[(11)] = inst_36199);

(statearr_36217[(12)] = inst_36200);

return statearr_36217;
})();
if(cljs.core.truth_(on_done)){
var statearr_36218_36236 = state_36209__$1;
(statearr_36218_36236[(1)] = (6));

} else {
var statearr_36219_36237 = state_36209__$1;
(statearr_36219_36237[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36210 === (6))){
var state_36209__$1 = state_36209;
var statearr_36220_36238 = state_36209__$1;
(statearr_36220_36238[(2)] = on_job_id);

(statearr_36220_36238[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36210 === (7))){
var inst_36194 = (state_36209[(10)]);
var state_36209__$1 = state_36209;
var statearr_36221_36239 = state_36209__$1;
(statearr_36221_36239[(2)] = inst_36194);

(statearr_36221_36239[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36210 === (8))){
var inst_36200 = (state_36209[(12)]);
var inst_36193 = (state_36209[(9)]);
var inst_36204 = (state_36209[(2)]);
var inst_36205 = [on_error,inst_36204,on_export_url];
var inst_36206 = cljs.core.PersistentHashMap.fromArrays(inst_36200,inst_36205);
var inst_36207 = milia.api.async_export.handle_response(inst_36193,inst_36206);
var state_36209__$1 = state_36209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36209__$1,inst_36207);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19063__auto__,c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19064__auto__ = null;
var milia$api$async_export$state_machine__19064__auto____0 = (function (){
var statearr_36225 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36225[(0)] = milia$api$async_export$state_machine__19064__auto__);

(statearr_36225[(1)] = (1));

return statearr_36225;
});
var milia$api$async_export$state_machine__19064__auto____1 = (function (state_36209){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_36209);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e36226){if((e36226 instanceof Object)){
var ex__19067__auto__ = e36226;
var statearr_36227_36240 = state_36209;
(statearr_36227_36240[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36209);

return cljs.core.cst$kw$recur;
} else {
throw e36226;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__36241 = state_36209;
state_36209 = G__36241;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19064__auto__ = function(state_36209){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19064__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19064__auto____1.call(this,state_36209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19064__auto____0;
milia$api$async_export$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19064__auto____1;
return milia$api$async_export$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19177__auto__ = (function (){var statearr_36228 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_36228[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_36228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__,vec__36183,map__36186,map__36186__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19175__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq36180){
var G__36181 = cljs.core.first(seq36180);
var seq36180__$1 = cljs.core.next(seq36180);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36181,seq36180__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__36242_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__36242_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36267 = arguments.length;
var i__7652__auto___36268 = (0);
while(true){
if((i__7652__auto___36268 < len__7651__auto___36267)){
args__7658__auto__.push((arguments[i__7652__auto___36268]));

var G__36269 = (i__7652__auto___36268 + (1));
i__7652__auto___36268 = G__36269;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__){
return (function (state_36258){
var state_val_36259 = (state_36258[(1)]);
if((state_val_36259 === (1))){
var inst_36247 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_36258__$1 = state_36258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36258__$1,(2),inst_36247);
} else {
if((state_val_36259 === (2))){
var inst_36249 = (state_36258[(2)]);
var inst_36250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36251 = [http_method,inst_36249];
var inst_36252 = (new cljs.core.PersistentVector(null,2,(5),inst_36250,inst_36251,null));
var inst_36253 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36252,args);
var inst_36254 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_36253);
var state_36258__$1 = state_36258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36258__$1,(3),inst_36254);
} else {
if((state_val_36259 === (3))){
var inst_36256 = (state_36258[(2)]);
var state_36258__$1 = state_36258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36258__$1,inst_36256);
} else {
return null;
}
}
}
});})(c__19175__auto__))
;
return ((function (switch__19063__auto__,c__19175__auto__){
return (function() {
var milia$api$async_export$state_machine__19064__auto__ = null;
var milia$api$async_export$state_machine__19064__auto____0 = (function (){
var statearr_36263 = [null,null,null,null,null,null,null];
(statearr_36263[(0)] = milia$api$async_export$state_machine__19064__auto__);

(statearr_36263[(1)] = (1));

return statearr_36263;
});
var milia$api$async_export$state_machine__19064__auto____1 = (function (state_36258){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_36258);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e36264){if((e36264 instanceof Object)){
var ex__19067__auto__ = e36264;
var statearr_36265_36270 = state_36258;
(statearr_36265_36270[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36258);

return cljs.core.cst$kw$recur;
} else {
throw e36264;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__36271 = state_36258;
state_36258 = G__36271;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19064__auto__ = function(state_36258){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19064__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19064__auto____1.call(this,state_36258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19064__auto____0;
milia$api$async_export$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19064__auto____1;
return milia$api$async_export$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__))
})();
var state__19177__auto__ = (function (){var statearr_36266 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_36266[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_36266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__))
);

return c__19175__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq36243){
var G__36244 = cljs.core.first(seq36243);
var seq36243__$1 = cljs.core.next(seq36243);
var G__36245 = cljs.core.first(seq36243__$1);
var seq36243__$2 = cljs.core.next(seq36243__$1);
var G__36246 = cljs.core.first(seq36243__$2);
var seq36243__$3 = cljs.core.next(seq36243__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__36244,G__36245,G__36246,seq36243__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
