// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__31160 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__31160,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__31161 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__31161) : cljs_hash.md5.md5.call(null,G__31161));
})());
} else {
return G__31160;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31166 = arguments.length;
var i__7652__auto___31167 = (0);
while(true){
if((i__7652__auto___31167 < len__7651__auto___31166)){
args__7658__auto__.push((arguments[i__7652__auto___31167]));

var G__31168 = (i__7652__auto___31167 + (1));
i__7652__auto___31167 = G__31168;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__31163){
var map__31164 = p__31163;
var map__31164__$1 = ((((!((map__31164 == null)))?((((map__31164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31164.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31164):map__31164);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31164__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31164__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31164__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31164__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq31162){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31162));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31178 = arguments.length;
var i__7652__auto___31179 = (0);
while(true){
if((i__7652__auto___31179 < len__7651__auto___31178)){
args__7658__auto__.push((arguments[i__7652__auto___31179]));

var G__31180 = (i__7652__auto___31179 + (1));
i__7652__auto___31179 = G__31180;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__31171){
var vec__31172 = p__31171;
var map__31175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31172,(0),null);
var map__31175__$1 = ((((!((map__31175 == null)))?((((map__31175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31175):map__31175);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31175__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e31177){if((e31177 instanceof Error)){
var _ = e31177;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e31177;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq31169){
var G__31170 = cljs.core.first(seq31169);
var seq31169__$1 = cljs.core.next(seq31169);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__31170,seq31169__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__31187_31193 = io_obj;
var G__31188_31194 = goog.net.EventType.SUCCESS;
var G__31189_31195 = ((function (G__31187_31193,G__31188_31194,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__31187_31193,G__31188_31194,io_obj))
;
goog.events.listen(G__31187_31193,G__31188_31194,G__31189_31195);

var G__31190_31196 = io_obj;
var G__31191_31197 = goog.net.EventType.ERROR;
var G__31192_31198 = ((function (G__31190_31196,G__31191_31197,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__31190_31196,G__31191_31197,io_obj))
;
goog.events.listen(G__31190_31196,G__31191_31197,G__31192_31198);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31215 = arguments.length;
var i__7652__auto___31216 = (0);
while(true){
if((i__7652__auto___31216 < len__7651__auto___31215)){
args__7658__auto__.push((arguments[i__7652__auto___31216]));

var G__31217 = (i__7652__auto___31216 + (1));
i__7652__auto___31216 = G__31217;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__31203){
var map__31204 = p__31203;
var map__31204__$1 = ((((!((map__31204 == null)))?((((map__31204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31204.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31204):map__31204);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31204__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31204__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31204__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__31206_31218 = io_obj;
var G__31207_31219 = goog.net.EventType.SUCCESS;
var G__31208_31220 = ((function (G__31206_31218,G__31207_31219,io_obj,data,url,map__31204,map__31204__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__31206_31218,G__31207_31219,io_obj,data,url,map__31204,map__31204__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31206_31218,G__31207_31219,G__31208_31220);

var G__31209_31221 = io_obj;
var G__31210_31222 = goog.net.EventType.ERROR;
var G__31211_31223 = ((function (G__31209_31221,G__31210_31222,io_obj,data,url,map__31204,map__31204__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__31209_31221,G__31210_31222,io_obj,data,url,map__31204,map__31204__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31209_31221,G__31210_31222,G__31211_31223);

var G__31212_31224 = io_obj;
var G__31213_31225 = goog.net.EventType.PROGRESS;
var G__31214_31226 = ((function (G__31212_31224,G__31213_31225,io_obj,data,url,map__31204,map__31204__$1,headers,id,require_json_QMARK_){
return (function (p1__31199_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__31199_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__31199_SHARP_.loaded,cljs.core.cst$kw$total,p1__31199_SHARP_.total], null)));
});})(G__31212_31224,G__31213_31225,io_obj,data,url,map__31204,map__31204__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31212_31224,G__31213_31225,G__31214_31226);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq31200){
var G__31201 = cljs.core.first(seq31200);
var seq31200__$1 = cljs.core.next(seq31200);
var G__31202 = cljs.core.first(seq31200__$1);
var seq31200__$2 = cljs.core.next(seq31200__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__31201,G__31202,seq31200__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31291 = arguments.length;
var i__7652__auto___31292 = (0);
while(true){
if((i__7652__auto___31292 < len__7651__auto___31291)){
args__7658__auto__.push((arguments[i__7652__auto___31292]));

var G__31293 = (i__7652__auto___31292 + (1));
i__7652__auto___31292 = G__31293;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19294__auto___31294 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto___31294,response_channel){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto___31294,response_channel){
return (function (state_31264){
var state_val_31265 = (state_31264[(1)]);
if((state_val_31265 === (7))){
var state_31264__$1 = state_31264;
var statearr_31266_31295 = state_31264__$1;
(statearr_31266_31295[(2)] = false);

(statearr_31266_31295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (1))){
var inst_31230 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_31264__$1 = state_31264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31264__$1,(2),inst_31230);
} else {
if((state_val_31265 === (4))){
var state_31264__$1 = state_31264;
var statearr_31267_31296 = state_31264__$1;
(statearr_31267_31296[(2)] = false);

(statearr_31267_31296[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (13))){
var inst_31253 = (state_31264[(7)]);
var inst_31260 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_31253);
var state_31264__$1 = state_31264;
var statearr_31268_31297 = state_31264__$1;
(statearr_31268_31297[(2)] = inst_31260);

(statearr_31268_31297[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (6))){
var state_31264__$1 = state_31264;
var statearr_31269_31298 = state_31264__$1;
(statearr_31269_31298[(2)] = true);

(statearr_31269_31298[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (3))){
var inst_31232 = (state_31264[(8)]);
var inst_31237 = inst_31232.cljs$lang$protocol_mask$partition0$;
var inst_31238 = (inst_31237 & (64));
var inst_31239 = inst_31232.cljs$core$ISeq$;
var inst_31240 = (cljs.core.PROTOCOL_SENTINEL === inst_31239);
var inst_31241 = (inst_31238) || (inst_31240);
var state_31264__$1 = state_31264;
if(cljs.core.truth_(inst_31241)){
var statearr_31270_31299 = state_31264__$1;
(statearr_31270_31299[(1)] = (6));

} else {
var statearr_31271_31300 = state_31264__$1;
(statearr_31271_31300[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (12))){
var inst_31257 = window.location.href();
var inst_31258 = window.location = inst_31257;
var state_31264__$1 = state_31264;
var statearr_31272_31301 = state_31264__$1;
(statearr_31272_31301[(2)] = inst_31258);

(statearr_31272_31301[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (2))){
var inst_31232 = (state_31264[(8)]);
var inst_31232__$1 = (state_31264[(2)]);
var inst_31234 = (inst_31232__$1 == null);
var inst_31235 = cljs.core.not(inst_31234);
var state_31264__$1 = (function (){var statearr_31273 = state_31264;
(statearr_31273[(8)] = inst_31232__$1);

return statearr_31273;
})();
if(inst_31235){
var statearr_31274_31302 = state_31264__$1;
(statearr_31274_31302[(1)] = (3));

} else {
var statearr_31275_31303 = state_31264__$1;
(statearr_31275_31303[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (11))){
var inst_31253 = (state_31264[(7)]);
var inst_31253__$1 = (state_31264[(2)]);
var inst_31254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31253__$1,cljs.core.cst$kw$status);
var inst_31255 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31254,(401));
var state_31264__$1 = (function (){var statearr_31276 = state_31264;
(statearr_31276[(7)] = inst_31253__$1);

return statearr_31276;
})();
if(inst_31255){
var statearr_31277_31304 = state_31264__$1;
(statearr_31277_31304[(1)] = (12));

} else {
var statearr_31278_31305 = state_31264__$1;
(statearr_31278_31305[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (9))){
var inst_31232 = (state_31264[(8)]);
var inst_31250 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31232);
var state_31264__$1 = state_31264;
var statearr_31279_31306 = state_31264__$1;
(statearr_31279_31306[(2)] = inst_31250);

(statearr_31279_31306[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (5))){
var inst_31248 = (state_31264[(2)]);
var state_31264__$1 = state_31264;
if(cljs.core.truth_(inst_31248)){
var statearr_31280_31307 = state_31264__$1;
(statearr_31280_31307[(1)] = (9));

} else {
var statearr_31281_31308 = state_31264__$1;
(statearr_31281_31308[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (14))){
var inst_31262 = (state_31264[(2)]);
var state_31264__$1 = state_31264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31264__$1,inst_31262);
} else {
if((state_val_31265 === (10))){
var inst_31232 = (state_31264[(8)]);
var state_31264__$1 = state_31264;
var statearr_31282_31309 = state_31264__$1;
(statearr_31282_31309[(2)] = inst_31232);

(statearr_31282_31309[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31265 === (8))){
var inst_31245 = (state_31264[(2)]);
var state_31264__$1 = state_31264;
var statearr_31283_31310 = state_31264__$1;
(statearr_31283_31310[(2)] = inst_31245);

(statearr_31283_31310[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19294__auto___31294,response_channel))
;
return ((function (switch__19182__auto__,c__19294__auto___31294,response_channel){
return (function() {
var milia$api$io$state_machine__19183__auto__ = null;
var milia$api$io$state_machine__19183__auto____0 = (function (){
var statearr_31287 = [null,null,null,null,null,null,null,null,null];
(statearr_31287[(0)] = milia$api$io$state_machine__19183__auto__);

(statearr_31287[(1)] = (1));

return statearr_31287;
});
var milia$api$io$state_machine__19183__auto____1 = (function (state_31264){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_31264);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e31288){if((e31288 instanceof Object)){
var ex__19186__auto__ = e31288;
var statearr_31289_31311 = state_31264;
(statearr_31289_31311[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31264);

return cljs.core.cst$kw$recur;
} else {
throw e31288;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__31312 = state_31264;
state_31264 = G__31312;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$api$io$state_machine__19183__auto__ = function(state_31264){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19183__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19183__auto____1.call(this,state_31264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19183__auto____0;
milia$api$io$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19183__auto____1;
return milia$api$io$state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto___31294,response_channel))
})();
var state__19296__auto__ = (function (){var statearr_31290 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_31290[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto___31294);

return statearr_31290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto___31294,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq31227){
var G__31228 = cljs.core.first(seq31227);
var seq31227__$1 = cljs.core.next(seq31227);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__31228,seq31227__$1);
});

