// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 * When a request fails for one of the following reasons, an exception is thrown
 * with a map containing a `:reason` key, and an optional `:detail` key
 *  1. No response: {:reason :no-http-response}
 *  2. 4xx response: {:reason :http-client-error
 *                    :detail {:status-code <status-code>
 *                             :response <parsed-json-from-server>}
 *  3. 5xx response: {:reason :http-server-error
 *                    :detail {:response <raw-response>
 *                             :status-code <status-code>}
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31335 = arguments.length;
var i__7652__auto___31336 = (0);
while(true){
if((i__7652__auto___31336 < len__7651__auto___31335)){
args__7658__auto__.push((arguments[i__7652__auto___31336]));

var G__31337 = (i__7652__auto___31336 + (1));
i__7652__auto___31336 = G__31337;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__31319){
var map__31320 = p__31319;
var map__31320__$1 = ((((!((map__31320 == null)))?((((map__31320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31320.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31320):map__31320);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$http_DASH_options);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$callback);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$as_DASH_map_QMARK_);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$auth_DASH_token);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$filename);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31320__$1,cljs.core.cst$kw$raw_DASH_response_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$get_DASH_crsftoken_QMARK_,cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.cst$kw$get),cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$method,method,cljs.core.cst$kw$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__19294__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto__,request_fn,headers,ch,map__31320,map__31320__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto__,request_fn,headers,ch,map__31320,map__31320__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_){
return (function (state_31326){
var state_val_31327 = (state_31326[(1)]);
if((state_val_31327 === (1))){
var state_31326__$1 = state_31326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31326__$1,(2),ch);
} else {
if((state_val_31327 === (2))){
var inst_31323 = (state_31326[(2)]);
var inst_31324 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_31323) : callback.call(null,inst_31323));
var state_31326__$1 = state_31326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31326__$1,inst_31324);
} else {
return null;
}
}
});})(c__19294__auto__,request_fn,headers,ch,map__31320,map__31320__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_))
;
return ((function (switch__19182__auto__,c__19294__auto__,request_fn,headers,ch,map__31320,map__31320__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_){
return (function() {
var milia$api$http$state_machine__19183__auto__ = null;
var milia$api$http$state_machine__19183__auto____0 = (function (){
var statearr_31331 = [null,null,null,null,null,null,null];
(statearr_31331[(0)] = milia$api$http$state_machine__19183__auto__);

(statearr_31331[(1)] = (1));

return statearr_31331;
});
var milia$api$http$state_machine__19183__auto____1 = (function (state_31326){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_31326);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e31332){if((e31332 instanceof Object)){
var ex__19186__auto__ = e31332;
var statearr_31333_31338 = state_31326;
(statearr_31333_31338[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31326);

return cljs.core.cst$kw$recur;
} else {
throw e31332;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__31339 = state_31326;
state_31326 = G__31339;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$api$http$state_machine__19183__auto__ = function(state_31326){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__19183__auto____0.call(this);
case 1:
return milia$api$http$state_machine__19183__auto____1.call(this,state_31326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__19183__auto____0;
milia$api$http$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__19183__auto____1;
return milia$api$http$state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto__,request_fn,headers,ch,map__31320,map__31320__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_))
})();
var state__19296__auto__ = (function (){var statearr_31334 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_31334[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto__);

return statearr_31334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto__,request_fn,headers,ch,map__31320,map__31320__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_))
);

return c__19294__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq31316){
var G__31317 = cljs.core.first(seq31316);
var seq31316__$1 = cljs.core.next(seq31316);
var G__31318 = cljs.core.first(seq31316__$1);
var seq31316__$2 = cljs.core.next(seq31316__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__31317,G__31318,seq31316__$2);
});

