// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('chimera.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__31832,p__31833){
var map__31842 = p__31832;
var map__31842__$1 = ((((!((map__31842 == null)))?((((map__31842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31842.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31842):map__31842);
var response = map__31842__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31842__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31842__$1,cljs.core.cst$kw$body);
var map__31843 = p__31833;
var map__31843__$1 = ((((!((map__31843 == null)))?((((map__31843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31843.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31843):map__31843);
var callbacks = map__31843__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31843__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31843__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31843__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31843__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__31846 = body;
var map__31846__$1 = ((((!((map__31846 == null)))?((((map__31846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31846.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31846):map__31846);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31846__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31846__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31846__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__31846,map__31846__$1,export_url,job_status,job_id,map__31842,map__31842__$1,response,status,body,map__31843,map__31843__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__31846,map__31846__$1,export_url,job_status,job_id,map__31842,map__31842__$1,response,status,body,map__31843,map__31843__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__31848_31850 = error_detail;
var G__31849_31851 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__31848_31850,G__31849_31851) : on_error.call(null,G__31848_31850,G__31849_31851));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31902 = arguments.length;
var i__7652__auto___31903 = (0);
while(true){
if((i__7652__auto___31903 < len__7651__auto___31902)){
args__7658__auto__.push((arguments[i__7652__auto___31903]));

var G__31904 = (i__7652__auto___31903 + (1));
i__7652__auto___31903 = G__31904;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__31855){
var map__31856 = p__31855;
var map__31856__$1 = ((((!((map__31856 == null)))?((((map__31856.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31856.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31856):map__31856);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31856__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31856__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31856__$1,cljs.core.cst$kw$data_DASH_type);
var c__19294__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type){
return (function (state_31884){
var state_val_31885 = (state_31884[(1)]);
if((state_val_31885 === (1))){
var inst_31858 = milia.api.async_export.initial_polling_interval;
var state_31884__$1 = (function (){var statearr_31886 = state_31884;
(statearr_31886[(7)] = inst_31858);

return statearr_31886;
})();
var statearr_31887_31905 = state_31884__$1;
(statearr_31887_31905[(2)] = null);

(statearr_31887_31905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31885 === (2))){
var inst_31862 = (state_31884[(8)]);
var inst_31860 = (state_31884[(9)]);
var inst_31860__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_31861 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_31862__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_31861,dataset_id,inst_31860__$1], 0));
var inst_31863 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_31862__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_31884__$1 = (function (){var statearr_31888 = state_31884;
(statearr_31888[(8)] = inst_31862__$1);

(statearr_31888[(9)] = inst_31860__$1);

return statearr_31888;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31884__$1,(4),inst_31863);
} else {
if((state_val_31885 === (3))){
var inst_31882 = (state_31884[(2)]);
var state_31884__$1 = state_31884;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31884__$1,inst_31882);
} else {
if((state_val_31885 === (4))){
var inst_31862 = (state_31884[(8)]);
var inst_31860 = (state_31884[(9)]);
var inst_31858 = (state_31884[(7)]);
var inst_31865 = (state_31884[(2)]);
var inst_31866 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_31867 = (function (){var polling_interval = inst_31858;
var job_suffix = inst_31860;
var job_url = inst_31862;
var response = inst_31865;
return ((function (polling_interval,job_suffix,job_url,response,inst_31862,inst_31860,inst_31858,inst_31865,inst_31866,state_val_31885,c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_31862,inst_31860,inst_31858,inst_31865,inst_31866,state_val_31885,c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type))
})();
var inst_31868 = [inst_31867,on_error,on_export_url];
var inst_31869 = cljs.core.PersistentHashMap.fromArrays(inst_31866,inst_31868);
var inst_31870 = milia.api.async_export.handle_response(inst_31865,inst_31869);
var inst_31871 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_31870,cljs.core.cst$kw$stop);
var state_31884__$1 = state_31884;
if(inst_31871){
var statearr_31889_31906 = state_31884__$1;
(statearr_31889_31906[(1)] = (5));

} else {
var statearr_31890_31907 = state_31884__$1;
(statearr_31890_31907[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31885 === (5))){
var inst_31858 = (state_31884[(7)]);
var inst_31873 = cljs.core.async.timeout(inst_31858);
var state_31884__$1 = state_31884;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31884__$1,(8),inst_31873);
} else {
if((state_val_31885 === (6))){
var state_31884__$1 = state_31884;
var statearr_31891_31908 = state_31884__$1;
(statearr_31891_31908[(2)] = null);

(statearr_31891_31908[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31885 === (7))){
var inst_31880 = (state_31884[(2)]);
var state_31884__$1 = state_31884;
var statearr_31892_31909 = state_31884__$1;
(statearr_31892_31909[(2)] = inst_31880);

(statearr_31892_31909[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31885 === (8))){
var inst_31858 = (state_31884[(7)]);
var inst_31875 = (state_31884[(2)]);
var inst_31876 = (inst_31858 * (2));
var inst_31858__$1 = inst_31876;
var state_31884__$1 = (function (){var statearr_31893 = state_31884;
(statearr_31893[(10)] = inst_31875);

(statearr_31893[(7)] = inst_31858__$1);

return statearr_31893;
})();
var statearr_31894_31910 = state_31884__$1;
(statearr_31894_31910[(2)] = null);

(statearr_31894_31910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19182__auto__,c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19183__auto__ = null;
var milia$api$async_export$state_machine__19183__auto____0 = (function (){
var statearr_31898 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31898[(0)] = milia$api$async_export$state_machine__19183__auto__);

(statearr_31898[(1)] = (1));

return statearr_31898;
});
var milia$api$async_export$state_machine__19183__auto____1 = (function (state_31884){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_31884);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e31899){if((e31899 instanceof Object)){
var ex__19186__auto__ = e31899;
var statearr_31900_31911 = state_31884;
(statearr_31900_31911[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31884);

return cljs.core.cst$kw$recur;
} else {
throw e31899;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__31912 = state_31884;
state_31884 = G__31912;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19183__auto__ = function(state_31884){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19183__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19183__auto____1.call(this,state_31884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19183__auto____0;
milia$api$async_export$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19183__auto____1;
return milia$api$async_export$state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type))
})();
var state__19296__auto__ = (function (){var statearr_31901 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_31901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto__);

return statearr_31901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto__,map__31856,map__31856__$1,on_error,on_export_url,data_type))
);

return c__19294__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq31852){
var G__31853 = cljs.core.first(seq31852);
var seq31852__$1 = cljs.core.next(seq31852);
var G__31854 = cljs.core.first(seq31852__$1);
var seq31852__$2 = cljs.core.next(seq31852__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31853,G__31854,seq31852__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *  export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19294__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto__){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto__){
return (function (state_32044){
var state_val_32045 = (state_32044[(1)]);
if((state_val_32045 === (7))){
var inst_32019 = (state_32044[(2)]);
var state_32044__$1 = state_32044;
if(cljs.core.truth_(inst_32019)){
var statearr_32046_32076 = state_32044__$1;
(statearr_32046_32076[(1)] = (11));

} else {
var statearr_32047_32077 = state_32044__$1;
(statearr_32047_32077[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (1))){
var inst_31995 = milia.api.async_export.initial_polling_interval;
var state_32044__$1 = (function (){var statearr_32048 = state_32044;
(statearr_32048[(7)] = inst_31995);

return statearr_32048;
})();
var statearr_32049_32078 = state_32044__$1;
(statearr_32049_32078[(2)] = null);

(statearr_32049_32078[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (4))){
var inst_32003 = (state_32044[(8)]);
var inst_32003__$1 = (state_32044[(2)]);
var inst_32005 = (inst_32003__$1 == null);
var inst_32006 = cljs.core.not(inst_32005);
var state_32044__$1 = (function (){var statearr_32050 = state_32044;
(statearr_32050[(8)] = inst_32003__$1);

return statearr_32050;
})();
if(inst_32006){
var statearr_32051_32079 = state_32044__$1;
(statearr_32051_32079[(1)] = (5));

} else {
var statearr_32052_32080 = state_32044__$1;
(statearr_32052_32080[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (15))){
var inst_31995 = (state_32044[(7)]);
var inst_32034 = cljs.core.async.timeout(inst_31995);
var state_32044__$1 = state_32044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32044__$1,(17),inst_32034);
} else {
if((state_val_32045 === (13))){
var inst_32000 = (state_32044[(9)]);
var inst_31995 = (state_32044[(7)]);
var inst_32026 = (state_32044[(10)]);
var inst_31998 = (state_32044[(11)]);
var inst_32024 = (state_32044[(2)]);
var inst_32025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32024,cljs.core.cst$kw$status);
var inst_32026__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32024,cljs.core.cst$kw$body);
var inst_32027 = (function (){var polling_interval = inst_31995;
var temp_token = inst_31998;
var export_url = inst_32000;
var map__31997 = inst_32024;
var status = inst_32025;
var body = inst_32026__$1;
return ((function (polling_interval,temp_token,export_url,map__31997,status,body,inst_32000,inst_31995,inst_32026,inst_31998,inst_32024,inst_32025,inst_32026__$1,state_val_32045,c__19294__auto__){
return (function (p1__31913_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__31913_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,temp_token,export_url,map__31997,status,body,inst_32000,inst_31995,inst_32026,inst_31998,inst_32024,inst_32025,inst_32026__$1,state_val_32045,c__19294__auto__))
})();
var inst_32028 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_32027,inst_32026__$1);
var inst_32029 = cljs.core.vec(inst_32028);
var inst_32030 = cljs.core.empty_QMARK_(inst_32029);
var state_32044__$1 = (function (){var statearr_32053 = state_32044;
(statearr_32053[(10)] = inst_32026__$1);

return statearr_32053;
})();
if(inst_32030){
var statearr_32054_32081 = state_32044__$1;
(statearr_32054_32081[(1)] = (14));

} else {
var statearr_32055_32082 = state_32044__$1;
(statearr_32055_32082[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (6))){
var state_32044__$1 = state_32044;
var statearr_32056_32083 = state_32044__$1;
(statearr_32056_32083[(2)] = false);

(statearr_32056_32083[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (17))){
var inst_31995 = (state_32044[(7)]);
var inst_32036 = (state_32044[(2)]);
var inst_32037 = (inst_31995 * (2));
var inst_31995__$1 = inst_32037;
var state_32044__$1 = (function (){var statearr_32057 = state_32044;
(statearr_32057[(12)] = inst_32036);

(statearr_32057[(7)] = inst_31995__$1);

return statearr_32057;
})();
var statearr_32058_32084 = state_32044__$1;
(statearr_32058_32084[(2)] = null);

(statearr_32058_32084[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (3))){
var inst_32042 = (state_32044[(2)]);
var state_32044__$1 = state_32044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32044__$1,inst_32042);
} else {
if((state_val_32045 === (12))){
var inst_32003 = (state_32044[(8)]);
var state_32044__$1 = state_32044;
var statearr_32059_32085 = state_32044__$1;
(statearr_32059_32085[(2)] = inst_32003);

(statearr_32059_32085[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (2))){
var inst_32000 = (state_32044[(9)]);
var inst_31998 = (state_32044[(11)]);
var inst_31998__$1 = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
var inst_31999 = [cljs.core.str("export?xform="),cljs.core.str(dataset_id),cljs.core.str("&temp_token="),cljs.core.str(inst_31998__$1)].join('');
var inst_32000__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_31999], 0));
var inst_32001 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_32000__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_32044__$1 = (function (){var statearr_32060 = state_32044;
(statearr_32060[(9)] = inst_32000__$1);

(statearr_32060[(11)] = inst_31998__$1);

return statearr_32060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32044__$1,(4),inst_32001);
} else {
if((state_val_32045 === (11))){
var inst_32003 = (state_32044[(8)]);
var inst_32021 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32003);
var state_32044__$1 = state_32044;
var statearr_32061_32086 = state_32044__$1;
(statearr_32061_32086[(2)] = inst_32021);

(statearr_32061_32086[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (9))){
var state_32044__$1 = state_32044;
var statearr_32062_32087 = state_32044__$1;
(statearr_32062_32087[(2)] = false);

(statearr_32062_32087[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (5))){
var inst_32003 = (state_32044[(8)]);
var inst_32008 = inst_32003.cljs$lang$protocol_mask$partition0$;
var inst_32009 = (inst_32008 & (64));
var inst_32010 = inst_32003.cljs$core$ISeq$;
var inst_32011 = (cljs.core.PROTOCOL_SENTINEL === inst_32010);
var inst_32012 = (inst_32009) || (inst_32011);
var state_32044__$1 = state_32044;
if(cljs.core.truth_(inst_32012)){
var statearr_32063_32088 = state_32044__$1;
(statearr_32063_32088[(1)] = (8));

} else {
var statearr_32064_32089 = state_32044__$1;
(statearr_32064_32089[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (14))){
var inst_32026 = (state_32044[(10)]);
var inst_32032 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_32026) : callback.call(null,inst_32026));
var state_32044__$1 = state_32044;
var statearr_32065_32090 = state_32044__$1;
(statearr_32065_32090[(2)] = inst_32032);

(statearr_32065_32090[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (16))){
var inst_32040 = (state_32044[(2)]);
var state_32044__$1 = state_32044;
var statearr_32066_32091 = state_32044__$1;
(statearr_32066_32091[(2)] = inst_32040);

(statearr_32066_32091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (10))){
var inst_32016 = (state_32044[(2)]);
var state_32044__$1 = state_32044;
var statearr_32067_32092 = state_32044__$1;
(statearr_32067_32092[(2)] = inst_32016);

(statearr_32067_32092[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32045 === (8))){
var state_32044__$1 = state_32044;
var statearr_32068_32093 = state_32044__$1;
(statearr_32068_32093[(2)] = true);

(statearr_32068_32093[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19294__auto__))
;
return ((function (switch__19182__auto__,c__19294__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto____0 = (function (){
var statearr_32072 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32072[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto__);

(statearr_32072[(1)] = (1));

return statearr_32072;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto____1 = (function (state_32044){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_32044);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e32073){if((e32073 instanceof Object)){
var ex__19186__auto__ = e32073;
var statearr_32074_32094 = state_32044;
(statearr_32074_32094[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32044);

return cljs.core.cst$kw$recur;
} else {
throw e32073;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__32095 = state_32044;
state_32044 = G__32095;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto__ = function(state_32044){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto____1.call(this,state_32044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto__))
})();
var state__19296__auto__ = (function (){var statearr_32075 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_32075[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto__);

return statearr_32075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto__))
);

return c__19294__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32103 = arguments.length;
var i__7652__auto___32104 = (0);
while(true){
if((i__7652__auto___32104 < len__7651__auto___32103)){
args__7658__auto__.push((arguments[i__7652__auto___32104]));

var G__32105 = (i__7652__auto___32104 + (1));
i__7652__auto___32104 = G__32105;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__32099){
var vec__32100 = p__32099;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32100,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq32096){
var G__32097 = cljs.core.first(seq32096);
var seq32096__$1 = cljs.core.next(seq32096);
var G__32098 = cljs.core.first(seq32096__$1);
var seq32096__$2 = cljs.core.next(seq32096__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__32097,G__32098,seq32096__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32155 = arguments.length;
var i__7652__auto___32156 = (0);
while(true){
if((i__7652__auto___32156 < len__7651__auto___32155)){
args__7658__auto__.push((arguments[i__7652__auto___32156]));

var G__32157 = (i__7652__auto___32156 + (1));
i__7652__auto___32156 = G__32157;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__32108){
var vec__32109 = p__32108;
var map__32112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32109,(0),null);
var map__32112__$1 = ((((!((map__32112 == null)))?((((map__32112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32112.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32112):map__32112);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32112__$1,cljs.core.cst$kw$on_DASH_done);
var c__19294__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_32135){
var state_val_32136 = (state_32135[(1)]);
if((state_val_32136 === (1))){
var inst_32114 = (state_32135[(7)]);
var inst_32116 = (state_32135[(8)]);
var inst_32114__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_32115 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_32116__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_32115,dataset_id,inst_32114__$1], 0));
var inst_32117 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_32116__$1);
var state_32135__$1 = (function (){var statearr_32137 = state_32135;
(statearr_32137[(7)] = inst_32114__$1);

(statearr_32137[(8)] = inst_32116__$1);

return statearr_32137;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32135__$1,(2),inst_32117);
} else {
if((state_val_32136 === (2))){
var inst_32114 = (state_32135[(7)]);
var inst_32119 = (state_32135[(9)]);
var inst_32116 = (state_32135[(8)]);
var inst_32119__$1 = (state_32135[(2)]);
var inst_32120 = (function (){var export_suffix = inst_32114;
var export_url = inst_32116;
var response = inst_32119__$1;
return ((function (export_suffix,export_url,response,inst_32114,inst_32119,inst_32116,inst_32119__$1,state_val_32136,c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_32114,inst_32119,inst_32116,inst_32119__$1,state_val_32136,c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_32135__$1 = (function (){var statearr_32138 = state_32135;
(statearr_32138[(9)] = inst_32119__$1);

(statearr_32138[(10)] = inst_32120);

return statearr_32138;
})();
if(cljs.core.truth_(on_done)){
var statearr_32139_32158 = state_32135__$1;
(statearr_32139_32158[(1)] = (3));

} else {
var statearr_32140_32159 = state_32135__$1;
(statearr_32140_32159[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32136 === (3))){
var inst_32119 = (state_32135[(9)]);
var inst_32122 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_32119) : on_done.call(null,inst_32119));
var state_32135__$1 = state_32135;
var statearr_32141_32160 = state_32135__$1;
(statearr_32141_32160[(2)] = inst_32122);

(statearr_32141_32160[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32136 === (4))){
var state_32135__$1 = state_32135;
var statearr_32142_32161 = state_32135__$1;
(statearr_32142_32161[(2)] = null);

(statearr_32142_32161[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32136 === (5))){
var inst_32125 = (state_32135[(2)]);
var inst_32126 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_32135__$1 = (function (){var statearr_32143 = state_32135;
(statearr_32143[(11)] = inst_32126);

(statearr_32143[(12)] = inst_32125);

return statearr_32143;
})();
if(cljs.core.truth_(on_done)){
var statearr_32144_32162 = state_32135__$1;
(statearr_32144_32162[(1)] = (6));

} else {
var statearr_32145_32163 = state_32135__$1;
(statearr_32145_32163[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32136 === (6))){
var state_32135__$1 = state_32135;
var statearr_32146_32164 = state_32135__$1;
(statearr_32146_32164[(2)] = on_job_id);

(statearr_32146_32164[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32136 === (7))){
var inst_32120 = (state_32135[(10)]);
var state_32135__$1 = state_32135;
var statearr_32147_32165 = state_32135__$1;
(statearr_32147_32165[(2)] = inst_32120);

(statearr_32147_32165[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32136 === (8))){
var inst_32126 = (state_32135[(11)]);
var inst_32119 = (state_32135[(9)]);
var inst_32130 = (state_32135[(2)]);
var inst_32131 = [on_error,inst_32130,on_export_url];
var inst_32132 = cljs.core.PersistentHashMap.fromArrays(inst_32126,inst_32131);
var inst_32133 = milia.api.async_export.handle_response(inst_32119,inst_32132);
var state_32135__$1 = state_32135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32135__$1,inst_32133);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19182__auto__,c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19183__auto__ = null;
var milia$api$async_export$state_machine__19183__auto____0 = (function (){
var statearr_32151 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32151[(0)] = milia$api$async_export$state_machine__19183__auto__);

(statearr_32151[(1)] = (1));

return statearr_32151;
});
var milia$api$async_export$state_machine__19183__auto____1 = (function (state_32135){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_32135);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e32152){if((e32152 instanceof Object)){
var ex__19186__auto__ = e32152;
var statearr_32153_32166 = state_32135;
(statearr_32153_32166[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32135);

return cljs.core.cst$kw$recur;
} else {
throw e32152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__32167 = state_32135;
state_32135 = G__32167;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19183__auto__ = function(state_32135){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19183__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19183__auto____1.call(this,state_32135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19183__auto____0;
milia$api$async_export$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19183__auto____1;
return milia$api$async_export$state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19296__auto__ = (function (){var statearr_32154 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_32154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto__);

return statearr_32154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto__,vec__32109,map__32112,map__32112__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19294__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq32106){
var G__32107 = cljs.core.first(seq32106);
var seq32106__$1 = cljs.core.next(seq32106);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32107,seq32106__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__32168_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__32168_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32193 = arguments.length;
var i__7652__auto___32194 = (0);
while(true){
if((i__7652__auto___32194 < len__7651__auto___32193)){
args__7658__auto__.push((arguments[i__7652__auto___32194]));

var G__32195 = (i__7652__auto___32194 + (1));
i__7652__auto___32194 = G__32195;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19294__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto__){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto__){
return (function (state_32184){
var state_val_32185 = (state_32184[(1)]);
if((state_val_32185 === (1))){
var inst_32173 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_32184__$1 = state_32184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32184__$1,(2),inst_32173);
} else {
if((state_val_32185 === (2))){
var inst_32175 = (state_32184[(2)]);
var inst_32176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32177 = [http_method,inst_32175];
var inst_32178 = (new cljs.core.PersistentVector(null,2,(5),inst_32176,inst_32177,null));
var inst_32179 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_32178,args);
var inst_32180 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_32179);
var state_32184__$1 = state_32184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32184__$1,(3),inst_32180);
} else {
if((state_val_32185 === (3))){
var inst_32182 = (state_32184[(2)]);
var state_32184__$1 = state_32184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32184__$1,inst_32182);
} else {
return null;
}
}
}
});})(c__19294__auto__))
;
return ((function (switch__19182__auto__,c__19294__auto__){
return (function() {
var milia$api$async_export$state_machine__19183__auto__ = null;
var milia$api$async_export$state_machine__19183__auto____0 = (function (){
var statearr_32189 = [null,null,null,null,null,null,null];
(statearr_32189[(0)] = milia$api$async_export$state_machine__19183__auto__);

(statearr_32189[(1)] = (1));

return statearr_32189;
});
var milia$api$async_export$state_machine__19183__auto____1 = (function (state_32184){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_32184);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e32190){if((e32190 instanceof Object)){
var ex__19186__auto__ = e32190;
var statearr_32191_32196 = state_32184;
(statearr_32191_32196[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32184);

return cljs.core.cst$kw$recur;
} else {
throw e32190;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__32197 = state_32184;
state_32184 = G__32197;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19183__auto__ = function(state_32184){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19183__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19183__auto____1.call(this,state_32184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19183__auto____0;
milia$api$async_export$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19183__auto____1;
return milia$api$async_export$state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto__))
})();
var state__19296__auto__ = (function (){var statearr_32192 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_32192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto__);

return statearr_32192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto__))
);

return c__19294__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq32169){
var G__32170 = cljs.core.first(seq32169);
var seq32169__$1 = cljs.core.next(seq32169);
var G__32171 = cljs.core.first(seq32169__$1);
var seq32169__$2 = cljs.core.next(seq32169__$1);
var G__32172 = cljs.core.first(seq32169__$2);
var seq32169__$3 = cljs.core.next(seq32169__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__32170,G__32171,G__32172,seq32169__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32204 = arguments.length;
var i__7652__auto___32205 = (0);
while(true){
if((i__7652__auto___32205 < len__7651__auto___32204)){
args__7658__auto__.push((arguments[i__7652__auto___32205]));

var G__32206 = (i__7652__auto___32205 + (1));
i__7652__auto___32205 = G__32206;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.get_exports_per_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.get_exports_per_form.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__32200){
var map__32201 = p__32200;
var map__32201__$1 = ((((!((map__32201 == null)))?((((map__32201.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32201.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32201):map__32201);
var temp_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32201__$1,cljs.core.cst$kw$temp_DASH_token);
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("export?xform="),cljs.core.str(dataset_id),cljs.core.str((function (){var G__32203 = temp_token;
if((G__32203 == null)){
return null;
} else {
return [cljs.core.str("&temp_token="),cljs.core.str(G__32203)].join('');
}
})())].join('')], 0)));
});

milia.api.async_export.get_exports_per_form.cljs$lang$maxFixedArity = (1);

milia.api.async_export.get_exports_per_form.cljs$lang$applyTo = (function (seq32198){
var G__32199 = cljs.core.first(seq32198);
var seq32198__$1 = cljs.core.next(seq32198);
return milia.api.async_export.get_exports_per_form.cljs$core$IFn$_invoke$arity$variadic(G__32199,seq32198__$1);
});

/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id,temp_token){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",[cljs.core.str(export_id),cljs.core.str("?temp_token="),cljs.core.str(temp_token)].join('')], 0)));
});
