// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__35037 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35037) : cljs.core.atom.call(null,G__35037));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__35042){
var vec__35043 = p__35042;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35043,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35043,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__35047 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__35047)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__35047)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__35047)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__35047)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__35047)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__35047)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__35048){
var map__35052 = p__35048;
var map__35052__$1 = ((((!((map__35052 == null)))?((((map__35052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35052.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35052):map__35052);
var request = map__35052__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35052__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35052__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35052__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6543__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__35054 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__35054,default_headers);

cljs_http.core.apply_response_type_BANG_(G__35054,response_type);

G__35054.setTimeoutInterval(timeout);

G__35054.setWithCredentials(send_credentials);

return G__35054;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__35055){
var map__35084 = p__35055;
var map__35084__$1 = ((((!((map__35084 == null)))?((((map__35084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35084.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35084):map__35084);
var request = map__35084__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6543__auto__ = request_method;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__35086 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__35086) : cljs_http.core.error_kw.call(null,G__35086));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_35112 = ((function (channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__35087_35113 = xhr;
G__35087_35113.setProgressEventsEnabled(true);

G__35087_35113.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_35112,cljs.core.cst$kw$upload));

G__35087_35113.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_35112,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__18808__auto___35114 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___35114,channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___35114,channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_35098){
var state_val_35099 = (state_35098[(1)]);
if((state_val_35099 === (1))){
var state_35098__$1 = state_35098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35098__$1,(2),cancel);
} else {
if((state_val_35099 === (2))){
var inst_35089 = (state_35098[(2)]);
var inst_35090 = xhr.isComplete();
var inst_35091 = cljs.core.not(inst_35090);
var state_35098__$1 = (function (){var statearr_35100 = state_35098;
(statearr_35100[(7)] = inst_35089);

return statearr_35100;
})();
if(inst_35091){
var statearr_35101_35115 = state_35098__$1;
(statearr_35101_35115[(1)] = (3));

} else {
var statearr_35102_35116 = state_35098__$1;
(statearr_35102_35116[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35099 === (3))){
var inst_35093 = xhr.abort();
var state_35098__$1 = state_35098;
var statearr_35103_35117 = state_35098__$1;
(statearr_35103_35117[(2)] = inst_35093);

(statearr_35103_35117[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35099 === (4))){
var state_35098__$1 = state_35098;
var statearr_35104_35118 = state_35098__$1;
(statearr_35104_35118[(2)] = null);

(statearr_35104_35118[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35099 === (5))){
var inst_35096 = (state_35098[(2)]);
var state_35098__$1 = state_35098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35098__$1,inst_35096);
} else {
return null;
}
}
}
}
}
});})(c__18808__auto___35114,channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__18696__auto__,c__18808__auto___35114,channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__18697__auto__ = null;
var cljs_http$core$xhr_$_state_machine__18697__auto____0 = (function (){
var statearr_35108 = [null,null,null,null,null,null,null,null];
(statearr_35108[(0)] = cljs_http$core$xhr_$_state_machine__18697__auto__);

(statearr_35108[(1)] = (1));

return statearr_35108;
});
var cljs_http$core$xhr_$_state_machine__18697__auto____1 = (function (state_35098){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_35098);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e35109){if((e35109 instanceof Object)){
var ex__18700__auto__ = e35109;
var statearr_35110_35119 = state_35098;
(statearr_35110_35119[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35098);

return cljs.core.cst$kw$recur;
} else {
throw e35109;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__35120 = state_35098;
state_35098 = G__35120;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__18697__auto__ = function(state_35098){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__18697__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__18697__auto____1.call(this,state_35098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__18697__auto____0;
cljs_http$core$xhr_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__18697__auto____1;
return cljs_http$core$xhr_$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___35114,channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__18810__auto__ = (function (){var statearr_35111 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_35111[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___35114);

return statearr_35111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___35114,channel,request_url,method,headers__$1,xhr,map__35084,map__35084__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__35121){
var map__35138 = p__35121;
var map__35138__$1 = ((((!((map__35138 == null)))?((((map__35138.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35138.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35138):map__35138);
var request = map__35138__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35138__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35138__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35138__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35138__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_35154 = jsonp.send(null,((function (channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_35154], null));

if(cljs.core.truth_(cancel)){
var c__18808__auto___35155 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___35155,req_35154,channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___35155,req_35154,channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_35144){
var state_val_35145 = (state_35144[(1)]);
if((state_val_35145 === (1))){
var state_35144__$1 = state_35144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35144__$1,(2),cancel);
} else {
if((state_val_35145 === (2))){
var inst_35141 = (state_35144[(2)]);
var inst_35142 = jsonp.cancel(req_35154);
var state_35144__$1 = (function (){var statearr_35146 = state_35144;
(statearr_35146[(7)] = inst_35141);

return statearr_35146;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35144__$1,inst_35142);
} else {
return null;
}
}
});})(c__18808__auto___35155,req_35154,channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__18696__auto__,c__18808__auto___35155,req_35154,channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__18697__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__18697__auto____0 = (function (){
var statearr_35150 = [null,null,null,null,null,null,null,null];
(statearr_35150[(0)] = cljs_http$core$jsonp_$_state_machine__18697__auto__);

(statearr_35150[(1)] = (1));

return statearr_35150;
});
var cljs_http$core$jsonp_$_state_machine__18697__auto____1 = (function (state_35144){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_35144);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e35151){if((e35151 instanceof Object)){
var ex__18700__auto__ = e35151;
var statearr_35152_35156 = state_35144;
(statearr_35152_35156[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35144);

return cljs.core.cst$kw$recur;
} else {
throw e35151;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__35157 = state_35144;
state_35144 = G__35157;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__18697__auto__ = function(state_35144){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__18697__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__18697__auto____1.call(this,state_35144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__18697__auto____0;
cljs_http$core$jsonp_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__18697__auto____1;
return cljs_http$core$jsonp_$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___35155,req_35154,channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__18810__auto__ = (function (){var statearr_35153 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_35153[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___35155);

return statearr_35153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___35155,req_35154,channel,jsonp,map__35138,map__35138__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__35158){
var map__35161 = p__35158;
var map__35161__$1 = ((((!((map__35161 == null)))?((((map__35161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35161):map__35161);
var request = map__35161__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35161__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
