// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26675 = arguments.length;
var i__7652__auto___26676 = (0);
while(true){
if((i__7652__auto___26676 < len__7651__auto___26675)){
args__7658__auto__.push((arguments[i__7652__auto___26676]));

var G__26677 = (i__7652__auto___26676 + (1));
i__7652__auto___26676 = G__26677;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__26588){
var map__26589 = p__26588;
var map__26589__$1 = ((((!((map__26589 == null)))?((((map__26589.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26589.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26589):map__26589);
var options = map__26589__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26589__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26589__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__15677__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto__,map__26589,map__26589__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto__,map__26589,map__26589__$1,options,max_retries,retry_for_statuses){
return (function (state_26640){
var state_val_26641 = (state_26640[(1)]);
if((state_val_26641 === (7))){
var inst_26614 = (state_26640[(2)]);
var state_26640__$1 = state_26640;
if(cljs.core.truth_(inst_26614)){
var statearr_26642_26678 = state_26640__$1;
(statearr_26642_26678[(1)] = (11));

} else {
var statearr_26643_26679 = state_26640__$1;
(statearr_26643_26679[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (20))){
var inst_26592 = (state_26640[(7)]);
var inst_26591 = (state_26640[(8)]);
var inst_26630 = (state_26640[(2)]);
var inst_26631 = (inst_26591 * (2));
var inst_26632 = (inst_26592 + (1));
var inst_26591__$1 = inst_26631;
var inst_26592__$1 = inst_26632;
var state_26640__$1 = (function (){var statearr_26644 = state_26640;
(statearr_26644[(7)] = inst_26592__$1);

(statearr_26644[(9)] = inst_26630);

(statearr_26644[(8)] = inst_26591__$1);

return statearr_26644;
})();
var statearr_26645_26680 = state_26640__$1;
(statearr_26645_26680[(2)] = null);

(statearr_26645_26680[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (1))){
var inst_26591 = milia.utils.retry.initial_polling_interval;
var inst_26592 = (0);
var state_26640__$1 = (function (){var statearr_26646 = state_26640;
(statearr_26646[(7)] = inst_26592);

(statearr_26646[(8)] = inst_26591);

return statearr_26646;
})();
var statearr_26647_26681 = state_26640__$1;
(statearr_26647_26681[(2)] = null);

(statearr_26647_26681[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (4))){
var inst_26598 = (state_26640[(10)]);
var inst_26598__$1 = (state_26640[(2)]);
var inst_26600 = (inst_26598__$1 == null);
var inst_26601 = cljs.core.not(inst_26600);
var state_26640__$1 = (function (){var statearr_26648 = state_26640;
(statearr_26648[(10)] = inst_26598__$1);

return statearr_26648;
})();
if(inst_26601){
var statearr_26649_26682 = state_26640__$1;
(statearr_26649_26682[(1)] = (5));

} else {
var statearr_26650_26683 = state_26640__$1;
(statearr_26650_26683[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (15))){
var inst_26621 = (state_26640[(11)]);
var state_26640__$1 = state_26640;
var statearr_26651_26684 = state_26640__$1;
(statearr_26651_26684[(2)] = inst_26621);

(statearr_26651_26684[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (13))){
var inst_26619 = (state_26640[(12)]);
var inst_26621 = (state_26640[(11)]);
var inst_26619__$1 = (state_26640[(2)]);
var inst_26620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26619__$1,cljs.core.cst$kw$status);
var inst_26621__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_26620);
var state_26640__$1 = (function (){var statearr_26652 = state_26640;
(statearr_26652[(12)] = inst_26619__$1);

(statearr_26652[(11)] = inst_26621__$1);

return statearr_26652;
})();
if(cljs.core.truth_(inst_26621__$1)){
var statearr_26653_26685 = state_26640__$1;
(statearr_26653_26685[(1)] = (14));

} else {
var statearr_26654_26686 = state_26640__$1;
(statearr_26654_26686[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (6))){
var state_26640__$1 = state_26640;
var statearr_26655_26687 = state_26640__$1;
(statearr_26655_26687[(2)] = false);

(statearr_26655_26687[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (17))){
var inst_26591 = (state_26640[(8)]);
var inst_26628 = cljs.core.async.timeout(inst_26591);
var state_26640__$1 = state_26640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26640__$1,(20),inst_26628);
} else {
if((state_val_26641 === (3))){
var inst_26638 = (state_26640[(2)]);
var state_26640__$1 = state_26640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26640__$1,inst_26638);
} else {
if((state_val_26641 === (12))){
var inst_26598 = (state_26640[(10)]);
var state_26640__$1 = state_26640;
var statearr_26656_26688 = state_26640__$1;
(statearr_26656_26688[(2)] = inst_26598);

(statearr_26656_26688[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (2))){
var inst_26595 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_26596 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_26595], 0));
var state_26640__$1 = state_26640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26640__$1,(4),inst_26596);
} else {
if((state_val_26641 === (19))){
var inst_26636 = (state_26640[(2)]);
var state_26640__$1 = state_26640;
var statearr_26657_26689 = state_26640__$1;
(statearr_26657_26689[(2)] = inst_26636);

(statearr_26657_26689[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (11))){
var inst_26598 = (state_26640[(10)]);
var inst_26616 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26598);
var state_26640__$1 = state_26640;
var statearr_26658_26690 = state_26640__$1;
(statearr_26658_26690[(2)] = inst_26616);

(statearr_26658_26690[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (9))){
var state_26640__$1 = state_26640;
var statearr_26659_26691 = state_26640__$1;
(statearr_26659_26691[(2)] = false);

(statearr_26659_26691[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (5))){
var inst_26598 = (state_26640[(10)]);
var inst_26603 = inst_26598.cljs$lang$protocol_mask$partition0$;
var inst_26604 = (inst_26603 & (64));
var inst_26605 = inst_26598.cljs$core$ISeq$;
var inst_26606 = (cljs.core.PROTOCOL_SENTINEL === inst_26605);
var inst_26607 = (inst_26604) || (inst_26606);
var state_26640__$1 = state_26640;
if(cljs.core.truth_(inst_26607)){
var statearr_26660_26692 = state_26640__$1;
(statearr_26660_26692[(1)] = (8));

} else {
var statearr_26661_26693 = state_26640__$1;
(statearr_26661_26693[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (14))){
var inst_26592 = (state_26640[(7)]);
var inst_26623 = (inst_26592 < max_retries);
var state_26640__$1 = state_26640;
var statearr_26662_26694 = state_26640__$1;
(statearr_26662_26694[(2)] = inst_26623);

(statearr_26662_26694[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (16))){
var inst_26626 = (state_26640[(2)]);
var state_26640__$1 = state_26640;
if(cljs.core.truth_(inst_26626)){
var statearr_26663_26695 = state_26640__$1;
(statearr_26663_26695[(1)] = (17));

} else {
var statearr_26664_26696 = state_26640__$1;
(statearr_26664_26696[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (10))){
var inst_26611 = (state_26640[(2)]);
var state_26640__$1 = state_26640;
var statearr_26665_26697 = state_26640__$1;
(statearr_26665_26697[(2)] = inst_26611);

(statearr_26665_26697[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (18))){
var inst_26619 = (state_26640[(12)]);
var state_26640__$1 = state_26640;
var statearr_26666_26698 = state_26640__$1;
(statearr_26666_26698[(2)] = inst_26619);

(statearr_26666_26698[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26641 === (8))){
var state_26640__$1 = state_26640;
var statearr_26667_26699 = state_26640__$1;
(statearr_26667_26699[(2)] = true);

(statearr_26667_26699[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15677__auto__,map__26589,map__26589__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__15612__auto__,c__15677__auto__,map__26589,map__26589__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__15613__auto__ = null;
var milia$utils$retry$state_machine__15613__auto____0 = (function (){
var statearr_26671 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26671[(0)] = milia$utils$retry$state_machine__15613__auto__);

(statearr_26671[(1)] = (1));

return statearr_26671;
});
var milia$utils$retry$state_machine__15613__auto____1 = (function (state_26640){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_26640);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e26672){if((e26672 instanceof Object)){
var ex__15616__auto__ = e26672;
var statearr_26673_26700 = state_26640;
(statearr_26673_26700[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26640);

return cljs.core.cst$kw$recur;
} else {
throw e26672;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__26701 = state_26640;
state_26640 = G__26701;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$utils$retry$state_machine__15613__auto__ = function(state_26640){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__15613__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__15613__auto____1.call(this,state_26640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__15613__auto____0;
milia$utils$retry$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__15613__auto____1;
return milia$utils$retry$state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto__,map__26589,map__26589__$1,options,max_retries,retry_for_statuses))
})();
var state__15679__auto__ = (function (){var statearr_26674 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_26674[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto__);

return statearr_26674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto__,map__26589,map__26589__$1,options,max_retries,retry_for_statuses))
);

return c__15677__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq26585){
var G__26586 = cljs.core.first(seq26585);
var seq26585__$1 = cljs.core.next(seq26585);
var G__26587 = cljs.core.first(seq26585__$1);
var seq26585__$2 = cljs.core.next(seq26585__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__26586,G__26587,seq26585__$2);
});

