// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__26336 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__26336,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__26337 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__26337) : cljs_hash.md5.md5.call(null,G__26337));
})());
} else {
return G__26336;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26342 = arguments.length;
var i__7652__auto___26343 = (0);
while(true){
if((i__7652__auto___26343 < len__7651__auto___26342)){
args__7658__auto__.push((arguments[i__7652__auto___26343]));

var G__26344 = (i__7652__auto___26343 + (1));
i__7652__auto___26343 = G__26344;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__26339){
var map__26340 = p__26339;
var map__26340__$1 = ((((!((map__26340 == null)))?((((map__26340.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26340.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26340):map__26340);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26340__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26340__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26340__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26340__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq26338){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26338));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26354 = arguments.length;
var i__7652__auto___26355 = (0);
while(true){
if((i__7652__auto___26355 < len__7651__auto___26354)){
args__7658__auto__.push((arguments[i__7652__auto___26355]));

var G__26356 = (i__7652__auto___26355 + (1));
i__7652__auto___26355 = G__26356;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__26347){
var vec__26348 = p__26347;
var map__26351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26348,(0),null);
var map__26351__$1 = ((((!((map__26351 == null)))?((((map__26351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26351.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26351):map__26351);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26351__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e26353){if((e26353 instanceof Error)){
var _ = e26353;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e26353;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq26345){
var G__26346 = cljs.core.first(seq26345);
var seq26345__$1 = cljs.core.next(seq26345);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__26346,seq26345__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__26363_26369 = io_obj;
var G__26364_26370 = goog.net.EventType.SUCCESS;
var G__26365_26371 = ((function (G__26363_26369,G__26364_26370,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__26363_26369,G__26364_26370,io_obj))
;
goog.events.listen(G__26363_26369,G__26364_26370,G__26365_26371);

var G__26366_26372 = io_obj;
var G__26367_26373 = goog.net.EventType.ERROR;
var G__26368_26374 = ((function (G__26366_26372,G__26367_26373,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__26366_26372,G__26367_26373,io_obj))
;
goog.events.listen(G__26366_26372,G__26367_26373,G__26368_26374);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26391 = arguments.length;
var i__7652__auto___26392 = (0);
while(true){
if((i__7652__auto___26392 < len__7651__auto___26391)){
args__7658__auto__.push((arguments[i__7652__auto___26392]));

var G__26393 = (i__7652__auto___26392 + (1));
i__7652__auto___26392 = G__26393;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__26379){
var map__26380 = p__26379;
var map__26380__$1 = ((((!((map__26380 == null)))?((((map__26380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26380.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26380):map__26380);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26380__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26380__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26380__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__26382_26394 = io_obj;
var G__26383_26395 = goog.net.EventType.SUCCESS;
var G__26384_26396 = ((function (G__26382_26394,G__26383_26395,io_obj,data,url,map__26380,map__26380__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__26382_26394,G__26383_26395,io_obj,data,url,map__26380,map__26380__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__26382_26394,G__26383_26395,G__26384_26396);

var G__26385_26397 = io_obj;
var G__26386_26398 = goog.net.EventType.ERROR;
var G__26387_26399 = ((function (G__26385_26397,G__26386_26398,io_obj,data,url,map__26380,map__26380__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__26385_26397,G__26386_26398,io_obj,data,url,map__26380,map__26380__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__26385_26397,G__26386_26398,G__26387_26399);

var G__26388_26400 = io_obj;
var G__26389_26401 = goog.net.EventType.PROGRESS;
var G__26390_26402 = ((function (G__26388_26400,G__26389_26401,io_obj,data,url,map__26380,map__26380__$1,headers,id,require_json_QMARK_){
return (function (p1__26375_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__26375_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__26375_SHARP_.loaded,cljs.core.cst$kw$total,p1__26375_SHARP_.total], null)));
});})(G__26388_26400,G__26389_26401,io_obj,data,url,map__26380,map__26380__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__26388_26400,G__26389_26401,G__26390_26402);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq26376){
var G__26377 = cljs.core.first(seq26376);
var seq26376__$1 = cljs.core.next(seq26376);
var G__26378 = cljs.core.first(seq26376__$1);
var seq26376__$2 = cljs.core.next(seq26376__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__26377,G__26378,seq26376__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26467 = arguments.length;
var i__7652__auto___26468 = (0);
while(true){
if((i__7652__auto___26468 < len__7651__auto___26467)){
args__7658__auto__.push((arguments[i__7652__auto___26468]));

var G__26469 = (i__7652__auto___26468 + (1));
i__7652__auto___26468 = G__26469;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__15677__auto___26470 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto___26470,response_channel){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto___26470,response_channel){
return (function (state_26440){
var state_val_26441 = (state_26440[(1)]);
if((state_val_26441 === (7))){
var state_26440__$1 = state_26440;
var statearr_26442_26471 = state_26440__$1;
(statearr_26442_26471[(2)] = false);

(statearr_26442_26471[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (1))){
var inst_26406 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_26440__$1 = state_26440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26440__$1,(2),inst_26406);
} else {
if((state_val_26441 === (4))){
var state_26440__$1 = state_26440;
var statearr_26443_26472 = state_26440__$1;
(statearr_26443_26472[(2)] = false);

(statearr_26443_26472[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (13))){
var inst_26429 = (state_26440[(7)]);
var inst_26436 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_26429);
var state_26440__$1 = state_26440;
var statearr_26444_26473 = state_26440__$1;
(statearr_26444_26473[(2)] = inst_26436);

(statearr_26444_26473[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (6))){
var state_26440__$1 = state_26440;
var statearr_26445_26474 = state_26440__$1;
(statearr_26445_26474[(2)] = true);

(statearr_26445_26474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (3))){
var inst_26408 = (state_26440[(8)]);
var inst_26413 = inst_26408.cljs$lang$protocol_mask$partition0$;
var inst_26414 = (inst_26413 & (64));
var inst_26415 = inst_26408.cljs$core$ISeq$;
var inst_26416 = (cljs.core.PROTOCOL_SENTINEL === inst_26415);
var inst_26417 = (inst_26414) || (inst_26416);
var state_26440__$1 = state_26440;
if(cljs.core.truth_(inst_26417)){
var statearr_26446_26475 = state_26440__$1;
(statearr_26446_26475[(1)] = (6));

} else {
var statearr_26447_26476 = state_26440__$1;
(statearr_26447_26476[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (12))){
var inst_26433 = window.location.href();
var inst_26434 = window.location = inst_26433;
var state_26440__$1 = state_26440;
var statearr_26448_26477 = state_26440__$1;
(statearr_26448_26477[(2)] = inst_26434);

(statearr_26448_26477[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (2))){
var inst_26408 = (state_26440[(8)]);
var inst_26408__$1 = (state_26440[(2)]);
var inst_26410 = (inst_26408__$1 == null);
var inst_26411 = cljs.core.not(inst_26410);
var state_26440__$1 = (function (){var statearr_26449 = state_26440;
(statearr_26449[(8)] = inst_26408__$1);

return statearr_26449;
})();
if(inst_26411){
var statearr_26450_26478 = state_26440__$1;
(statearr_26450_26478[(1)] = (3));

} else {
var statearr_26451_26479 = state_26440__$1;
(statearr_26451_26479[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (11))){
var inst_26429 = (state_26440[(7)]);
var inst_26429__$1 = (state_26440[(2)]);
var inst_26430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26429__$1,cljs.core.cst$kw$status);
var inst_26431 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26430,(401));
var state_26440__$1 = (function (){var statearr_26452 = state_26440;
(statearr_26452[(7)] = inst_26429__$1);

return statearr_26452;
})();
if(inst_26431){
var statearr_26453_26480 = state_26440__$1;
(statearr_26453_26480[(1)] = (12));

} else {
var statearr_26454_26481 = state_26440__$1;
(statearr_26454_26481[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (9))){
var inst_26408 = (state_26440[(8)]);
var inst_26426 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26408);
var state_26440__$1 = state_26440;
var statearr_26455_26482 = state_26440__$1;
(statearr_26455_26482[(2)] = inst_26426);

(statearr_26455_26482[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (5))){
var inst_26424 = (state_26440[(2)]);
var state_26440__$1 = state_26440;
if(cljs.core.truth_(inst_26424)){
var statearr_26456_26483 = state_26440__$1;
(statearr_26456_26483[(1)] = (9));

} else {
var statearr_26457_26484 = state_26440__$1;
(statearr_26457_26484[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (14))){
var inst_26438 = (state_26440[(2)]);
var state_26440__$1 = state_26440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26440__$1,inst_26438);
} else {
if((state_val_26441 === (10))){
var inst_26408 = (state_26440[(8)]);
var state_26440__$1 = state_26440;
var statearr_26458_26485 = state_26440__$1;
(statearr_26458_26485[(2)] = inst_26408);

(statearr_26458_26485[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26441 === (8))){
var inst_26421 = (state_26440[(2)]);
var state_26440__$1 = state_26440;
var statearr_26459_26486 = state_26440__$1;
(statearr_26459_26486[(2)] = inst_26421);

(statearr_26459_26486[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15677__auto___26470,response_channel))
;
return ((function (switch__15612__auto__,c__15677__auto___26470,response_channel){
return (function() {
var milia$api$io$state_machine__15613__auto__ = null;
var milia$api$io$state_machine__15613__auto____0 = (function (){
var statearr_26463 = [null,null,null,null,null,null,null,null,null];
(statearr_26463[(0)] = milia$api$io$state_machine__15613__auto__);

(statearr_26463[(1)] = (1));

return statearr_26463;
});
var milia$api$io$state_machine__15613__auto____1 = (function (state_26440){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_26440);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e26464){if((e26464 instanceof Object)){
var ex__15616__auto__ = e26464;
var statearr_26465_26487 = state_26440;
(statearr_26465_26487[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26440);

return cljs.core.cst$kw$recur;
} else {
throw e26464;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__26488 = state_26440;
state_26440 = G__26488;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$api$io$state_machine__15613__auto__ = function(state_26440){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__15613__auto____0.call(this);
case 1:
return milia$api$io$state_machine__15613__auto____1.call(this,state_26440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__15613__auto____0;
milia$api$io$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__15613__auto____1;
return milia$api$io$state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto___26470,response_channel))
})();
var state__15679__auto__ = (function (){var statearr_26466 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_26466[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto___26470);

return statearr_26466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto___26470,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq26403){
var G__26404 = cljs.core.first(seq26403);
var seq26403__$1 = cljs.core.next(seq26403);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__26404,seq26403__$1);
});

