// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35252 = arguments.length;
var i__7652__auto___35253 = (0);
while(true){
if((i__7652__auto___35253 < len__7651__auto___35252)){
args__7658__auto__.push((arguments[i__7652__auto___35253]));

var G__35254 = (i__7652__auto___35253 + (1));
i__7652__auto___35253 = G__35254;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__35248){
var vec__35249 = p__35248;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35249,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq35244){
var G__35245 = cljs.core.first(seq35244);
var seq35244__$1 = cljs.core.next(seq35244);
var G__35246 = cljs.core.first(seq35244__$1);
var seq35244__$2 = cljs.core.next(seq35244__$1);
var G__35247 = cljs.core.first(seq35244__$2);
var seq35244__$3 = cljs.core.next(seq35244__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__35245,G__35246,G__35247,seq35244__$3);
});

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35264 = arguments.length;
var i__7652__auto___35265 = (0);
while(true){
if((i__7652__auto___35265 < len__7651__auto___35264)){
args__7658__auto__.push((arguments[i__7652__auto___35265]));

var G__35266 = (i__7652__auto___35265 + (1));
i__7652__auto___35265 = G__35266;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((4) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7659__auto__);
});

milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__35260){
var vec__35261 = p__35260;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35261,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4);

milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq35255){
var G__35256 = cljs.core.first(seq35255);
var seq35255__$1 = cljs.core.next(seq35255);
var G__35257 = cljs.core.first(seq35255__$1);
var seq35255__$2 = cljs.core.next(seq35255__$1);
var G__35258 = cljs.core.first(seq35255__$2);
var seq35255__$3 = cljs.core.next(seq35255__$2);
var G__35259 = cljs.core.first(seq35255__$3);
var seq35255__$4 = cljs.core.next(seq35255__$3);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic(G__35256,G__35257,G__35258,G__35259,seq35255__$4);
});

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35272 = arguments.length;
var i__7652__auto___35273 = (0);
while(true){
if((i__7652__auto___35273 < len__7651__auto___35272)){
args__7658__auto__.push((arguments[i__7652__auto___35273]));

var G__35274 = (i__7652__auto___35273 + (1));
i__7652__auto___35273 = G__35274;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35269){
var map__35270 = p__35269;
var map__35270__$1 = ((((!((map__35270 == null)))?((((map__35270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35270.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35270):map__35270);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35270__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq35267){
var G__35268 = cljs.core.first(seq35267);
var seq35267__$1 = cljs.core.next(seq35267);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic(G__35268,seq35267__$1);
});

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35280 = arguments.length;
var i__7652__auto___35281 = (0);
while(true){
if((i__7652__auto___35281 < len__7651__auto___35280)){
args__7658__auto__.push((arguments[i__7652__auto___35281]));

var G__35282 = (i__7652__auto___35281 + (1));
i__7652__auto___35281 = G__35282;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__35277){
var map__35278 = p__35277;
var map__35278__$1 = ((((!((map__35278 == null)))?((((map__35278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35278.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35278):map__35278);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35278__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("restservices?xform="),cljs.core.str(formid)].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq35275){
var G__35276 = cljs.core.first(seq35275);
var seq35275__$1 = cljs.core.next(seq35275);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic(G__35276,seq35275__$1);
});

