// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35079 = arguments.length;
var i__7652__auto___35080 = (0);
while(true){
if((i__7652__auto___35080 < len__7651__auto___35079)){
args__7658__auto__.push((arguments[i__7652__auto___35080]));

var G__35081 = (i__7652__auto___35080 + (1));
i__7652__auto___35080 = G__35081;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__34992){
var map__34993 = p__34992;
var map__34993__$1 = ((((!((map__34993 == null)))?((((map__34993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34993.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34993):map__34993);
var options = map__34993__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34993__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34993__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__,map__34993,map__34993__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__,map__34993,map__34993__$1,options,max_retries,retry_for_statuses){
return (function (state_35044){
var state_val_35045 = (state_35044[(1)]);
if((state_val_35045 === (7))){
var inst_35018 = (state_35044[(2)]);
var state_35044__$1 = state_35044;
if(cljs.core.truth_(inst_35018)){
var statearr_35046_35082 = state_35044__$1;
(statearr_35046_35082[(1)] = (11));

} else {
var statearr_35047_35083 = state_35044__$1;
(statearr_35047_35083[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (20))){
var inst_34995 = (state_35044[(7)]);
var inst_34996 = (state_35044[(8)]);
var inst_35034 = (state_35044[(2)]);
var inst_35035 = (inst_34995 * (2));
var inst_35036 = (inst_34996 + (1));
var inst_34995__$1 = inst_35035;
var inst_34996__$1 = inst_35036;
var state_35044__$1 = (function (){var statearr_35048 = state_35044;
(statearr_35048[(7)] = inst_34995__$1);

(statearr_35048[(9)] = inst_35034);

(statearr_35048[(8)] = inst_34996__$1);

return statearr_35048;
})();
var statearr_35049_35084 = state_35044__$1;
(statearr_35049_35084[(2)] = null);

(statearr_35049_35084[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (1))){
var inst_34995 = milia.utils.retry.initial_polling_interval;
var inst_34996 = (0);
var state_35044__$1 = (function (){var statearr_35050 = state_35044;
(statearr_35050[(7)] = inst_34995);

(statearr_35050[(8)] = inst_34996);

return statearr_35050;
})();
var statearr_35051_35085 = state_35044__$1;
(statearr_35051_35085[(2)] = null);

(statearr_35051_35085[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (4))){
var inst_35002 = (state_35044[(10)]);
var inst_35002__$1 = (state_35044[(2)]);
var inst_35004 = (inst_35002__$1 == null);
var inst_35005 = cljs.core.not(inst_35004);
var state_35044__$1 = (function (){var statearr_35052 = state_35044;
(statearr_35052[(10)] = inst_35002__$1);

return statearr_35052;
})();
if(inst_35005){
var statearr_35053_35086 = state_35044__$1;
(statearr_35053_35086[(1)] = (5));

} else {
var statearr_35054_35087 = state_35044__$1;
(statearr_35054_35087[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (15))){
var inst_35025 = (state_35044[(11)]);
var state_35044__$1 = state_35044;
var statearr_35055_35088 = state_35044__$1;
(statearr_35055_35088[(2)] = inst_35025);

(statearr_35055_35088[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (13))){
var inst_35023 = (state_35044[(12)]);
var inst_35025 = (state_35044[(11)]);
var inst_35023__$1 = (state_35044[(2)]);
var inst_35024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35023__$1,cljs.core.cst$kw$status);
var inst_35025__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_35024);
var state_35044__$1 = (function (){var statearr_35056 = state_35044;
(statearr_35056[(12)] = inst_35023__$1);

(statearr_35056[(11)] = inst_35025__$1);

return statearr_35056;
})();
if(cljs.core.truth_(inst_35025__$1)){
var statearr_35057_35089 = state_35044__$1;
(statearr_35057_35089[(1)] = (14));

} else {
var statearr_35058_35090 = state_35044__$1;
(statearr_35058_35090[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (6))){
var state_35044__$1 = state_35044;
var statearr_35059_35091 = state_35044__$1;
(statearr_35059_35091[(2)] = false);

(statearr_35059_35091[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (17))){
var inst_34995 = (state_35044[(7)]);
var inst_35032 = cljs.core.async.timeout(inst_34995);
var state_35044__$1 = state_35044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35044__$1,(20),inst_35032);
} else {
if((state_val_35045 === (3))){
var inst_35042 = (state_35044[(2)]);
var state_35044__$1 = state_35044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35044__$1,inst_35042);
} else {
if((state_val_35045 === (12))){
var inst_35002 = (state_35044[(10)]);
var state_35044__$1 = state_35044;
var statearr_35060_35092 = state_35044__$1;
(statearr_35060_35092[(2)] = inst_35002);

(statearr_35060_35092[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (2))){
var inst_34999 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_35000 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_34999], 0));
var state_35044__$1 = state_35044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35044__$1,(4),inst_35000);
} else {
if((state_val_35045 === (19))){
var inst_35040 = (state_35044[(2)]);
var state_35044__$1 = state_35044;
var statearr_35061_35093 = state_35044__$1;
(statearr_35061_35093[(2)] = inst_35040);

(statearr_35061_35093[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (11))){
var inst_35002 = (state_35044[(10)]);
var inst_35020 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35002);
var state_35044__$1 = state_35044;
var statearr_35062_35094 = state_35044__$1;
(statearr_35062_35094[(2)] = inst_35020);

(statearr_35062_35094[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (9))){
var state_35044__$1 = state_35044;
var statearr_35063_35095 = state_35044__$1;
(statearr_35063_35095[(2)] = false);

(statearr_35063_35095[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (5))){
var inst_35002 = (state_35044[(10)]);
var inst_35007 = inst_35002.cljs$lang$protocol_mask$partition0$;
var inst_35008 = (inst_35007 & (64));
var inst_35009 = inst_35002.cljs$core$ISeq$;
var inst_35010 = (cljs.core.PROTOCOL_SENTINEL === inst_35009);
var inst_35011 = (inst_35008) || (inst_35010);
var state_35044__$1 = state_35044;
if(cljs.core.truth_(inst_35011)){
var statearr_35064_35096 = state_35044__$1;
(statearr_35064_35096[(1)] = (8));

} else {
var statearr_35065_35097 = state_35044__$1;
(statearr_35065_35097[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (14))){
var inst_34996 = (state_35044[(8)]);
var inst_35027 = (inst_34996 < max_retries);
var state_35044__$1 = state_35044;
var statearr_35066_35098 = state_35044__$1;
(statearr_35066_35098[(2)] = inst_35027);

(statearr_35066_35098[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (16))){
var inst_35030 = (state_35044[(2)]);
var state_35044__$1 = state_35044;
if(cljs.core.truth_(inst_35030)){
var statearr_35067_35099 = state_35044__$1;
(statearr_35067_35099[(1)] = (17));

} else {
var statearr_35068_35100 = state_35044__$1;
(statearr_35068_35100[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (10))){
var inst_35015 = (state_35044[(2)]);
var state_35044__$1 = state_35044;
var statearr_35069_35101 = state_35044__$1;
(statearr_35069_35101[(2)] = inst_35015);

(statearr_35069_35101[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (18))){
var inst_35023 = (state_35044[(12)]);
var state_35044__$1 = state_35044;
var statearr_35070_35102 = state_35044__$1;
(statearr_35070_35102[(2)] = inst_35023);

(statearr_35070_35102[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35045 === (8))){
var state_35044__$1 = state_35044;
var statearr_35071_35103 = state_35044__$1;
(statearr_35071_35103[(2)] = true);

(statearr_35071_35103[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto__,map__34993,map__34993__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__18977__auto__,c__19089__auto__,map__34993,map__34993__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__18978__auto__ = null;
var milia$utils$retry$state_machine__18978__auto____0 = (function (){
var statearr_35075 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35075[(0)] = milia$utils$retry$state_machine__18978__auto__);

(statearr_35075[(1)] = (1));

return statearr_35075;
});
var milia$utils$retry$state_machine__18978__auto____1 = (function (state_35044){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_35044);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e35076){if((e35076 instanceof Object)){
var ex__18981__auto__ = e35076;
var statearr_35077_35104 = state_35044;
(statearr_35077_35104[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35044);

return cljs.core.cst$kw$recur;
} else {
throw e35076;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__35105 = state_35044;
state_35044 = G__35105;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
milia$utils$retry$state_machine__18978__auto__ = function(state_35044){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__18978__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__18978__auto____1.call(this,state_35044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__18978__auto____0;
milia$utils$retry$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__18978__auto____1;
return milia$utils$retry$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__,map__34993,map__34993__$1,options,max_retries,retry_for_statuses))
})();
var state__19091__auto__ = (function (){var statearr_35078 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_35078[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_35078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__,map__34993,map__34993__$1,options,max_retries,retry_for_statuses))
);

return c__19089__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq34989){
var G__34990 = cljs.core.first(seq34989);
var seq34989__$1 = cljs.core.next(seq34989);
var G__34991 = cljs.core.first(seq34989__$1);
var seq34989__$2 = cljs.core.next(seq34989__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__34990,G__34991,seq34989__$2);
});

