// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21370 = arguments.length;
var i__7281__auto___21371 = (0);
while(true){
if((i__7281__auto___21371 < len__7280__auto___21370)){
args__7287__auto__.push((arguments[i__7281__auto___21371]));

var G__21372 = (i__7281__auto___21371 + (1));
i__7281__auto___21371 = G__21372;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__21368){
var vec__21369 = p__21368;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21369,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq21364){
var G__21365 = cljs.core.first(seq21364);
var seq21364__$1 = cljs.core.next(seq21364);
var G__21366 = cljs.core.first(seq21364__$1);
var seq21364__$2 = cljs.core.next(seq21364__$1);
var G__21367 = cljs.core.first(seq21364__$2);
var seq21364__$3 = cljs.core.next(seq21364__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__21365,G__21366,G__21367,seq21364__$3);
});
/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21380 = arguments.length;
var i__7281__auto___21381 = (0);
while(true){
if((i__7281__auto___21381 < len__7280__auto___21380)){
args__7287__auto__.push((arguments[i__7281__auto___21381]));

var G__21382 = (i__7281__auto___21381 + (1));
i__7281__auto___21381 = G__21382;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((4) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7288__auto__);
});

milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__21378){
var vec__21379 = p__21378;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21379,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4);

milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq21373){
var G__21374 = cljs.core.first(seq21373);
var seq21373__$1 = cljs.core.next(seq21373);
var G__21375 = cljs.core.first(seq21373__$1);
var seq21373__$2 = cljs.core.next(seq21373__$1);
var G__21376 = cljs.core.first(seq21373__$2);
var seq21373__$3 = cljs.core.next(seq21373__$2);
var G__21377 = cljs.core.first(seq21373__$3);
var seq21373__$4 = cljs.core.next(seq21373__$3);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic(G__21374,G__21375,G__21376,G__21377,seq21373__$4);
});
/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21388 = arguments.length;
var i__7281__auto___21389 = (0);
while(true){
if((i__7281__auto___21389 < len__7280__auto___21388)){
args__7287__auto__.push((arguments[i__7281__auto___21389]));

var G__21390 = (i__7281__auto___21389 + (1));
i__7281__auto___21389 = G__21390;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__21385){
var map__21386 = p__21385;
var map__21386__$1 = ((((!((map__21386 == null)))?((((map__21386.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21386.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21386):map__21386);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21386__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq21383){
var G__21384 = cljs.core.first(seq21383);
var seq21383__$1 = cljs.core.next(seq21383);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic(G__21384,seq21383__$1);
});
/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21396 = arguments.length;
var i__7281__auto___21397 = (0);
while(true){
if((i__7281__auto___21397 < len__7280__auto___21396)){
args__7287__auto__.push((arguments[i__7281__auto___21397]));

var G__21398 = (i__7281__auto___21397 + (1));
i__7281__auto___21397 = G__21398;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__21393){
var map__21394 = p__21393;
var map__21394__$1 = ((((!((map__21394 == null)))?((((map__21394.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21394.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21394):map__21394);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21394__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("restservices?xform="),cljs.core.str(formid)].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq21391){
var G__21392 = cljs.core.first(seq21391);
var seq21391__$1 = cljs.core.next(seq21391);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic(G__21392,seq21391__$1);
});
