// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(){
var args__5541__auto__ = [];
var len__5534__auto___16845 = arguments.length;
var i__5535__auto___16846 = (0);
while(true){
if((i__5535__auto___16846 < len__5534__auto___16845)){
args__5541__auto__.push((arguments[i__5535__auto___16846]));

var G__16847 = (i__5535__auto___16846 + (1));
i__5535__auto___16846 = G__16847;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((2) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((2)),(0))):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5542__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__16829){
var map__16830 = p__16829;
var map__16830__$1 = ((((!((map__16830 == null)))?((((map__16830.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16830.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16830):map__16830);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$callback);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$filename);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$http_DASH_options);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16830__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.constant$keyword$delete),cljs.core.constant$keyword$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.constant$keyword$accept_DASH_header,accept_header], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__8116__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8116__auto__,request_fn,headers,ch,map__16830,map__16830__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (){
var f__8117__auto__ = (function (){var switch__8051__auto__ = ((function (c__8116__auto__,request_fn,headers,ch,map__16830,map__16830__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (state_16836){
var state_val_16837 = (state_16836[(1)]);
if((state_val_16837 === (1))){
var state_16836__$1 = state_16836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16836__$1,(2),ch);
} else {
if((state_val_16837 === (2))){
var inst_16833 = (state_16836[(2)]);
var inst_16834 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_16833) : callback.call(null,inst_16833));
var state_16836__$1 = state_16836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16836__$1,inst_16834);
} else {
return null;
}
}
});})(c__8116__auto__,request_fn,headers,ch,map__16830,map__16830__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
;
return ((function (switch__8051__auto__,c__8116__auto__,request_fn,headers,ch,map__16830,map__16830__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function() {
var milia$api$http$state_machine__8052__auto__ = null;
var milia$api$http$state_machine__8052__auto____0 = (function (){
var statearr_16841 = [null,null,null,null,null,null,null];
(statearr_16841[(0)] = milia$api$http$state_machine__8052__auto__);

(statearr_16841[(1)] = (1));

return statearr_16841;
});
var milia$api$http$state_machine__8052__auto____1 = (function (state_16836){
while(true){
var ret_value__8053__auto__ = (function (){try{while(true){
var result__8054__auto__ = switch__8051__auto__(state_16836);
if(cljs.core.keyword_identical_QMARK_(result__8054__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__8054__auto__;
}
break;
}
}catch (e16842){if((e16842 instanceof Object)){
var ex__8055__auto__ = e16842;
var statearr_16843_16848 = state_16836;
(statearr_16843_16848[(5)] = ex__8055__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16836);

return cljs.core.constant$keyword$recur;
} else {
throw e16842;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8053__auto__,cljs.core.constant$keyword$recur)){
var G__16849 = state_16836;
state_16836 = G__16849;
continue;
} else {
return ret_value__8053__auto__;
}
break;
}
});
milia$api$http$state_machine__8052__auto__ = function(state_16836){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__8052__auto____0.call(this);
case 1:
return milia$api$http$state_machine__8052__auto____1.call(this,state_16836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__8052__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__8052__auto____0;
milia$api$http$state_machine__8052__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__8052__auto____1;
return milia$api$http$state_machine__8052__auto__;
})()
;})(switch__8051__auto__,c__8116__auto__,request_fn,headers,ch,map__16830,map__16830__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
})();
var state__8118__auto__ = (function (){var statearr_16844 = (f__8117__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8117__auto__.cljs$core$IFn$_invoke$arity$0() : f__8117__auto__.call(null));
(statearr_16844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8116__auto__);

return statearr_16844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8118__auto__);
});})(c__8116__auto__,request_fn,headers,ch,map__16830,map__16830__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
);

return c__8116__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq16826){
var G__16827 = cljs.core.first(seq16826);
var seq16826__$1 = cljs.core.next(seq16826);
var G__16828 = cljs.core.first(seq16826__$1);
var seq16826__$2 = cljs.core.next(seq16826__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__16827,G__16828,seq16826__$2);
});
