// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__7907__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__7907__auto__)){
return stateful_method_QMARK_;
} else {
return and__7907__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__7907__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__7907__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__7907__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__14728 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__14728) : cljs_hash.md5.md5.call(null,G__14728));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__8965__auto__ = [];
var len__8958__auto___14733 = arguments.length;
var i__8959__auto___14734 = (0);
while(true){
if((i__8959__auto___14734 < len__8958__auto___14733)){
args__8965__auto__.push((arguments[i__8959__auto___14734]));

var G__14735 = (i__8959__auto___14734 + (1));
i__8959__auto___14734 = G__14735;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((0) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__8966__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__14730){
var map__14731 = p__14730;
var map__14731__$1 = ((((!((map__14731 == null)))?((((map__14731.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14731.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14731):map__14731);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14731__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14731__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14731__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__7907__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__7907__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__7907__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__7907__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__7907__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__7907__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__7919__auto__ = accept_header;
if(cljs.core.truth_(or__7919__auto__)){
return or__7919__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq14729){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14729));
});
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(io_obj){
try{return io_obj.getResponseJson();
}catch (e14737){if((e14737 instanceof Error)){
var _ = e14737;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$error,io_obj.getResponseText()], null);
} else {
throw e14737;

}
}});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 * a core.async channel where result message will be put
 * and (optionally) an id to include in the result message. Returns the
 * XhrIo object that can be used to abort request. More XhrIo API
 * docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(){
var args__8965__auto__ = [];
var len__8958__auto___14753 = arguments.length;
var i__8959__auto___14754 = (0);
while(true){
if((i__8959__auto___14754 < len__8958__auto___14753)){
args__8965__auto__.push((arguments[i__8959__auto___14754]));

var G__14755 = (i__8959__auto___14754 + (1));
i__8959__auto___14754 = G__14755;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((2) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((2)),(0))):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8966__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__14742){
var vec__14743 = p__14742;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14743,(0),null);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$id,id], null):null);
var url = form.action;
var G__14744_14756 = io_obj;
var G__14745_14757 = goog.net.EventType.SUCCESS;
var G__14746_14758 = ((function (G__14744_14756,G__14745_14757,io_obj,data,url,vec__14743,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.constant$keyword$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.constant$keyword$success_QMARK_,true], 0)));
});})(G__14744_14756,G__14745_14757,io_obj,data,url,vec__14743,id))
;
goog.events.listen(G__14744_14756,G__14745_14757,G__14746_14758);

var G__14747_14759 = io_obj;
var G__14748_14760 = goog.net.EventType.ERROR;
var G__14749_14761 = ((function (G__14747_14759,G__14748_14760,io_obj,data,url,vec__14743,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.constant$keyword$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.constant$keyword$success_QMARK_,false], 0)));
});})(G__14747_14759,G__14748_14760,io_obj,data,url,vec__14743,id))
;
goog.events.listen(G__14747_14759,G__14748_14760,G__14749_14761);

var G__14750_14762 = io_obj;
var G__14751_14763 = goog.net.EventType.PROGRESS;
var G__14752_14764 = ((function (G__14750_14762,G__14751_14763,io_obj,data,url,vec__14743,id){
return (function (p1__14738_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.constant$keyword$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$length_DASH_computable,p1__14738_SHARP_.lengthComputable,cljs.core.constant$keyword$loaded,p1__14738_SHARP_.loaded,cljs.core.constant$keyword$total,p1__14738_SHARP_.total], null)));
});})(G__14750_14762,G__14751_14763,io_obj,data,url,vec__14743,id))
;
goog.events.listen(G__14750_14762,G__14751_14763,G__14752_14764);

io_obj.send(url,"POST",form);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq14739){
var G__14740 = cljs.core.first(seq14739);
var seq14739__$1 = cljs.core.next(seq14739);
var G__14741 = cljs.core.first(seq14739__$1);
var seq14739__$2 = cljs.core.next(seq14739__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__14740,G__14741,seq14739__$2);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__8965__auto__ = [];
var len__8958__auto___14827 = arguments.length;
var i__8959__auto___14828 = (0);
while(true){
if((i__8959__auto___14828 < len__8958__auto___14827)){
args__8965__auto__.push((arguments[i__8959__auto___14828]));

var G__14829 = (i__8959__auto___14828 + (1));
i__8959__auto___14828 = G__14829;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((1) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8966__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__12179__auto___14830 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12179__auto___14830,response_channel){
return (function (){
var f__12180__auto__ = (function (){var switch__12112__auto__ = ((function (c__12179__auto___14830,response_channel){
return (function (state_14800){
var state_val_14801 = (state_14800[(1)]);
if((state_val_14801 === (7))){
var state_14800__$1 = state_14800;
var statearr_14802_14831 = state_14800__$1;
(statearr_14802_14831[(2)] = false);

(statearr_14802_14831[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (1))){
var inst_14768 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_14800__$1 = state_14800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14800__$1,(2),inst_14768);
} else {
if((state_val_14801 === (4))){
var state_14800__$1 = state_14800;
var statearr_14803_14832 = state_14800__$1;
(statearr_14803_14832[(2)] = false);

(statearr_14803_14832[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (13))){
var inst_14790 = (state_14800[(7)]);
var inst_14796 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_14790);
var state_14800__$1 = state_14800;
var statearr_14804_14833 = state_14800__$1;
(statearr_14804_14833[(2)] = inst_14796);

(statearr_14804_14833[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (6))){
var state_14800__$1 = state_14800;
var statearr_14805_14834 = state_14800__$1;
(statearr_14805_14834[(2)] = true);

(statearr_14805_14834[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (3))){
var inst_14770 = (state_14800[(8)]);
var inst_14775 = inst_14770.cljs$lang$protocol_mask$partition0$;
var inst_14776 = (inst_14775 & (64));
var inst_14777 = inst_14770.cljs$core$ISeq$;
var inst_14778 = (inst_14776) || (inst_14777);
var state_14800__$1 = state_14800;
if(cljs.core.truth_(inst_14778)){
var statearr_14806_14835 = state_14800__$1;
(statearr_14806_14835[(1)] = (6));

} else {
var statearr_14807_14836 = state_14800__$1;
(statearr_14807_14836[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (12))){
var inst_14794 = window.location = window.location;
var state_14800__$1 = state_14800;
var statearr_14808_14837 = state_14800__$1;
(statearr_14808_14837[(2)] = inst_14794);

(statearr_14808_14837[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (2))){
var inst_14770 = (state_14800[(8)]);
var inst_14770__$1 = (state_14800[(2)]);
var inst_14772 = (inst_14770__$1 == null);
var inst_14773 = cljs.core.not(inst_14772);
var state_14800__$1 = (function (){var statearr_14809 = state_14800;
(statearr_14809[(8)] = inst_14770__$1);

return statearr_14809;
})();
if(inst_14773){
var statearr_14810_14838 = state_14800__$1;
(statearr_14810_14838[(1)] = (3));

} else {
var statearr_14811_14839 = state_14800__$1;
(statearr_14811_14839[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (11))){
var inst_14790 = (state_14800[(7)]);
var inst_14790__$1 = (state_14800[(2)]);
var inst_14791 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14790__$1,cljs.core.constant$keyword$status);
var inst_14792 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14791,(401));
var state_14800__$1 = (function (){var statearr_14812 = state_14800;
(statearr_14812[(7)] = inst_14790__$1);

return statearr_14812;
})();
if(inst_14792){
var statearr_14813_14840 = state_14800__$1;
(statearr_14813_14840[(1)] = (12));

} else {
var statearr_14814_14841 = state_14800__$1;
(statearr_14814_14841[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (9))){
var inst_14770 = (state_14800[(8)]);
var inst_14787 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14770);
var state_14800__$1 = state_14800;
var statearr_14815_14842 = state_14800__$1;
(statearr_14815_14842[(2)] = inst_14787);

(statearr_14815_14842[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (5))){
var inst_14785 = (state_14800[(2)]);
var state_14800__$1 = state_14800;
if(cljs.core.truth_(inst_14785)){
var statearr_14816_14843 = state_14800__$1;
(statearr_14816_14843[(1)] = (9));

} else {
var statearr_14817_14844 = state_14800__$1;
(statearr_14817_14844[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (14))){
var inst_14798 = (state_14800[(2)]);
var state_14800__$1 = state_14800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14800__$1,inst_14798);
} else {
if((state_val_14801 === (10))){
var inst_14770 = (state_14800[(8)]);
var state_14800__$1 = state_14800;
var statearr_14818_14845 = state_14800__$1;
(statearr_14818_14845[(2)] = inst_14770);

(statearr_14818_14845[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_14801 === (8))){
var inst_14782 = (state_14800[(2)]);
var state_14800__$1 = state_14800;
var statearr_14819_14846 = state_14800__$1;
(statearr_14819_14846[(2)] = inst_14782);

(statearr_14819_14846[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12179__auto___14830,response_channel))
;
return ((function (switch__12112__auto__,c__12179__auto___14830,response_channel){
return (function() {
var milia$api$io$state_machine__12113__auto__ = null;
var milia$api$io$state_machine__12113__auto____0 = (function (){
var statearr_14823 = [null,null,null,null,null,null,null,null,null];
(statearr_14823[(0)] = milia$api$io$state_machine__12113__auto__);

(statearr_14823[(1)] = (1));

return statearr_14823;
});
var milia$api$io$state_machine__12113__auto____1 = (function (state_14800){
while(true){
var ret_value__12114__auto__ = (function (){try{while(true){
var result__12115__auto__ = switch__12112__auto__(state_14800);
if(cljs.core.keyword_identical_QMARK_(result__12115__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__12115__auto__;
}
break;
}
}catch (e14824){if((e14824 instanceof Object)){
var ex__12116__auto__ = e14824;
var statearr_14825_14847 = state_14800;
(statearr_14825_14847[(5)] = ex__12116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14800);

return cljs.core.constant$keyword$recur;
} else {
throw e14824;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12114__auto__,cljs.core.constant$keyword$recur)){
var G__14848 = state_14800;
state_14800 = G__14848;
continue;
} else {
return ret_value__12114__auto__;
}
break;
}
});
milia$api$io$state_machine__12113__auto__ = function(state_14800){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__12113__auto____0.call(this);
case 1:
return milia$api$io$state_machine__12113__auto____1.call(this,state_14800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__12113__auto____0;
milia$api$io$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__12113__auto____1;
return milia$api$io$state_machine__12113__auto__;
})()
;})(switch__12112__auto__,c__12179__auto___14830,response_channel))
})();
var state__12181__auto__ = (function (){var statearr_14826 = (f__12180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12180__auto__.cljs$core$IFn$_invoke$arity$0() : f__12180__auto__.call(null));
(statearr_14826[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12179__auto___14830);

return statearr_14826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12181__auto__);
});})(c__12179__auto___14830,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq14765){
var G__14766 = cljs.core.first(seq14765);
var seq14765__$1 = cljs.core.next(seq14765);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__14766,seq14765__$1);
});
