// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.async_export.export_async_url = "export_async.json?format=";
/**
 * Handles API server's response and acts according to given
 * callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__14991,p__14992){
var map__14999 = p__14991;
var map__14999__$1 = ((((!((map__14999 == null)))?((((map__14999.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14999.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14999):map__14999);
var response = map__14999__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14999__$1,cljs.core.constant$keyword$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14999__$1,cljs.core.constant$keyword$body);
var map__15000 = p__14992;
var map__15000__$1 = ((((!((map__15000 == null)))?((((map__15000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15000):map__15000);
var callbacks = map__15000__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15000__$1,cljs.core.constant$keyword$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15000__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15000__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15000__$1,cljs.core.constant$keyword$on_DASH_stop,cljs.core.constantly(null));
var map__15003 = body;
var map__15003__$1 = ((((!((map__15003 == null)))?((((map__15003.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15003.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15003):map__15003);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15003__$1,cljs.core.constant$keyword$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15003__$1,cljs.core.constant$keyword$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15003__$1,cljs.core.constant$keyword$job_uuid);
var error_detail = (function (){var or__7919__auto__ = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__7919__auto__)){
return or__7919__auto__;
} else {
return cljs.core.constant$keyword$error.cljs$core$IFn$_invoke$arity$1(body);
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if((status >= (400))){
if(cljs.core.fn_QMARK_(on_error)){
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 * `millis` is the number of milliseconds after which to poll again.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(){
var args__8965__auto__ = [];
var len__8958__auto___15063 = arguments.length;
var i__8959__auto___15064 = (0);
while(true){
if((i__8959__auto___15064 < len__8958__auto___15063)){
args__8965__auto__.push((arguments[i__8959__auto___15064]));

var G__15065 = (i__8959__auto___15064 + (1));
i__8959__auto___15064 = G__15065;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((2) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((2)),(0))):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8966__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__15008){
var vec__15009 = p__15008;
var map__15010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15009,(0),null);
var map__15010__$1 = ((((!((map__15010 == null)))?((((map__15010.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15010.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15010):map__15010);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15010__$1,cljs.core.constant$keyword$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15010__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15010__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15010__$1,cljs.core.constant$keyword$millis);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__12179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
var f__12180__auto__ = (function (){var switch__12112__auto__ = ((function (c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (state_15040){
var state_val_15041 = (state_15040[(1)]);
if((state_val_15041 === (7))){
var state_15040__$1 = state_15040;
var statearr_15042_15066 = state_15040__$1;
(statearr_15042_15066[(2)] = "dataviews");

(statearr_15042_15066[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (1))){
var state_15040__$1 = state_15040;
var statearr_15043_15067 = state_15040__$1;
(statearr_15043_15067[(2)] = null);

(statearr_15043_15067[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (4))){
var inst_15016 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_15040__$1 = (function (){var statearr_15044 = state_15040;
(statearr_15044[(7)] = inst_15016);

return statearr_15044;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_15045_15068 = state_15040__$1;
(statearr_15045_15068[(1)] = (7));

} else {
var statearr_15046_15069 = state_15040__$1;
(statearr_15046_15069[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (6))){
var inst_15036 = (state_15040[(2)]);
var state_15040__$1 = state_15040;
var statearr_15047_15070 = state_15040__$1;
(statearr_15047_15070[(2)] = inst_15036);

(statearr_15047_15070[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (3))){
var inst_15038 = (state_15040[(2)]);
var state_15040__$1 = state_15040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15040__$1,inst_15038);
} else {
if((state_val_15041 === (2))){
var inst_15013 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_15014 = cljs.core.not(inst_15013);
var state_15040__$1 = state_15040;
if(inst_15014){
var statearr_15048_15071 = state_15040__$1;
(statearr_15048_15071[(1)] = (4));

} else {
var statearr_15049_15072 = state_15040__$1;
(statearr_15049_15072[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (11))){
var inst_15032 = (state_15040[(2)]);
var state_15040__$1 = (function (){var statearr_15050 = state_15040;
(statearr_15050[(8)] = inst_15032);

return statearr_15050;
})();
var statearr_15051_15073 = state_15040__$1;
(statearr_15051_15073[(2)] = null);

(statearr_15051_15073[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (9))){
var inst_15016 = (state_15040[(7)]);
var inst_15021 = (state_15040[(9)]);
var inst_15020 = (state_15040[(2)]);
var inst_15021__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_15020,dataset_id,inst_15016], 0));
var inst_15022 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_15021__$1);
var state_15040__$1 = (function (){var statearr_15052 = state_15040;
(statearr_15052[(9)] = inst_15021__$1);

return statearr_15052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15040__$1,(10),inst_15022);
} else {
if((state_val_15041 === (5))){
var state_15040__$1 = state_15040;
var statearr_15053_15074 = state_15040__$1;
(statearr_15053_15074[(2)] = null);

(statearr_15053_15074[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15041 === (10))){
var inst_15016 = (state_15040[(7)]);
var inst_15021 = (state_15040[(9)]);
var inst_15024 = (state_15040[(2)]);
var inst_15025 = [cljs.core.constant$keyword$on_DASH_stop,cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_15026 = (function (){var job_suffix = inst_15016;
var job_url = inst_15021;
var response = inst_15024;
return ((function (job_suffix,job_url,response,inst_15016,inst_15021,inst_15024,inst_15025,state_val_15041,c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_15016,inst_15021,inst_15024,inst_15025,state_val_15041,c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var inst_15027 = [inst_15026,on_error,on_export_url];
var inst_15028 = cljs.core.PersistentHashMap.fromArrays(inst_15025,inst_15027);
var inst_15029 = milia.api.async_export.handle_response(inst_15024,inst_15028);
var inst_15030 = cljs.core.async.timeout(millis);
var state_15040__$1 = (function (){var statearr_15054 = state_15040;
(statearr_15054[(10)] = inst_15029);

return statearr_15054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15040__$1,(11),inst_15030);
} else {
if((state_val_15041 === (8))){
var state_15040__$1 = state_15040;
var statearr_15055_15075 = state_15040__$1;
(statearr_15055_15075[(2)] = "forms");

(statearr_15055_15075[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
;
return ((function (switch__12112__auto__,c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function() {
var milia$api$async_export$state_machine__12113__auto__ = null;
var milia$api$async_export$state_machine__12113__auto____0 = (function (){
var statearr_15059 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15059[(0)] = milia$api$async_export$state_machine__12113__auto__);

(statearr_15059[(1)] = (1));

return statearr_15059;
});
var milia$api$async_export$state_machine__12113__auto____1 = (function (state_15040){
while(true){
var ret_value__12114__auto__ = (function (){try{while(true){
var result__12115__auto__ = switch__12112__auto__(state_15040);
if(cljs.core.keyword_identical_QMARK_(result__12115__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__12115__auto__;
}
break;
}
}catch (e15060){if((e15060 instanceof Object)){
var ex__12116__auto__ = e15060;
var statearr_15061_15076 = state_15040;
(statearr_15061_15076[(5)] = ex__12116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15040);

return cljs.core.constant$keyword$recur;
} else {
throw e15060;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12114__auto__,cljs.core.constant$keyword$recur)){
var G__15077 = state_15040;
state_15040 = G__15077;
continue;
} else {
return ret_value__12114__auto__;
}
break;
}
});
milia$api$async_export$state_machine__12113__auto__ = function(state_15040){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__12113__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__12113__auto____1.call(this,state_15040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__12113__auto____0;
milia$api$async_export$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__12113__auto____1;
return milia$api$async_export$state_machine__12113__auto__;
})()
;})(switch__12112__auto__,c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var state__12181__auto__ = (function (){var statearr_15062 = (f__12180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12180__auto__.cljs$core$IFn$_invoke$arity$0() : f__12180__auto__.call(null));
(statearr_15062[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12179__auto__);

return statearr_15062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12181__auto__);
});})(c__12179__auto__,done_polling_QMARK_,vec__15009,map__15010,map__15010__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
);

return c__12179__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq15005){
var G__15006 = cljs.core.first(seq15005);
var seq15005__$1 = cljs.core.next(seq15005);
var G__15007 = cljs.core.first(seq15005__$1);
var seq15005__$2 = cljs.core.next(seq15005__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15006,G__15007,seq15005__$2);
});
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","remove_group_name","_version"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$meta_DASH_id,cljs.core.constant$keyword$data_DASH_id,cljs.core.constant$keyword$group_DASH_delimiter,cljs.core.constant$keyword$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.constant$keyword$remove_DASH_group_DASH_name_QMARK_,cljs.core.constant$keyword$version], null);
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_(value)){
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(){
var args__8965__auto__ = [];
var len__8958__auto___15083 = arguments.length;
var i__8959__auto___15084 = (0);
while(true){
if((i__8959__auto___15084 < len__8958__auto___15083)){
args__8965__auto__.push((arguments[i__8959__auto___15084]));

var G__15085 = (i__8959__auto___15084 + (1));
i__8959__auto___15084 = G__15085;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((2) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((2)),(0))):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8966__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__15081){
var vec__15082 = p__15081;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15082,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq15078){
var G__15079 = cljs.core.first(seq15078);
var seq15078__$1 = cljs.core.next(seq15078);
var G__15080 = cljs.core.first(seq15078__$1);
var seq15078__$2 = cljs.core.next(seq15078__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__15079,G__15080,seq15078__$2);
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(){
var args__8965__auto__ = [];
var len__8958__auto___15122 = arguments.length;
var i__8959__auto___15123 = (0);
while(true){
if((i__8959__auto___15123 < len__8958__auto___15122)){
args__8965__auto__.push((arguments[i__8959__auto___15123]));

var G__15124 = (i__8959__auto___15123 + (1));
i__8959__auto___15123 = G__15124;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((1) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((1)),(0))):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8966__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__15088){
var vec__15089 = p__15088;
var map__15090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15089,(0),null);
var map__15090__$1 = ((((!((map__15090 == null)))?((((map__15090.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15090.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15090):map__15090);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.constant$keyword$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.constant$keyword$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15090__$1,cljs.core.constant$keyword$on_DASH_error);
var c__12179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__12180__auto__ = (function (){var switch__12112__auto__ = ((function (c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_15107){
var state_val_15108 = (state_15107[(1)]);
if((state_val_15108 === (1))){
var inst_15092 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_15107__$1 = (function (){var statearr_15109 = state_15107;
(statearr_15109[(7)] = inst_15092);

return statearr_15109;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_15110_15125 = state_15107__$1;
(statearr_15110_15125[(1)] = (2));

} else {
var statearr_15111_15126 = state_15107__$1;
(statearr_15111_15126[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_15108 === (2))){
var state_15107__$1 = state_15107;
var statearr_15112_15127 = state_15107__$1;
(statearr_15112_15127[(2)] = "dataviews");

(statearr_15112_15127[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15108 === (3))){
var state_15107__$1 = state_15107;
var statearr_15113_15128 = state_15107__$1;
(statearr_15113_15128[(2)] = "forms");

(statearr_15113_15128[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_15108 === (4))){
var inst_15096 = (state_15107[(8)]);
var inst_15097 = (state_15107[(9)]);
var inst_15092 = (state_15107[(7)]);
var inst_15096__$1 = (state_15107[(2)]);
var inst_15097__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_15096__$1,dataset_id,inst_15092], 0));
var inst_15098 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_15097__$1);
var state_15107__$1 = (function (){var statearr_15114 = state_15107;
(statearr_15114[(8)] = inst_15096__$1);

(statearr_15114[(9)] = inst_15097__$1);

return statearr_15114;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15107__$1,(5),inst_15098);
} else {
if((state_val_15108 === (5))){
var inst_15096 = (state_15107[(8)]);
var inst_15097 = (state_15107[(9)]);
var inst_15092 = (state_15107[(7)]);
var inst_15100 = (state_15107[(2)]);
var inst_15101 = (function (){var export_suffix = inst_15092;
var export_endpoint = inst_15096;
var export_url = inst_15097;
var response = inst_15100;
return ((function (export_suffix,export_endpoint,export_url,response,inst_15096,inst_15097,inst_15092,inst_15100,state_val_15108,c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$on_DASH_export_DASH_url,on_export_url,cljs.core.constant$keyword$on_DASH_error,on_error,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], null)], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_15096,inst_15097,inst_15092,inst_15100,state_val_15108,c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_15102 = [cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_15103 = [on_error,inst_15101,on_export_url];
var inst_15104 = cljs.core.PersistentHashMap.fromArrays(inst_15102,inst_15103);
var inst_15105 = milia.api.async_export.handle_response(inst_15100,inst_15104);
var state_15107__$1 = state_15107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15107__$1,inst_15105);
} else {
return null;
}
}
}
}
}
});})(c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__12112__auto__,c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__12113__auto__ = null;
var milia$api$async_export$state_machine__12113__auto____0 = (function (){
var statearr_15118 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15118[(0)] = milia$api$async_export$state_machine__12113__auto__);

(statearr_15118[(1)] = (1));

return statearr_15118;
});
var milia$api$async_export$state_machine__12113__auto____1 = (function (state_15107){
while(true){
var ret_value__12114__auto__ = (function (){try{while(true){
var result__12115__auto__ = switch__12112__auto__(state_15107);
if(cljs.core.keyword_identical_QMARK_(result__12115__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__12115__auto__;
}
break;
}
}catch (e15119){if((e15119 instanceof Object)){
var ex__12116__auto__ = e15119;
var statearr_15120_15129 = state_15107;
(statearr_15120_15129[(5)] = ex__12116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15107);

return cljs.core.constant$keyword$recur;
} else {
throw e15119;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12114__auto__,cljs.core.constant$keyword$recur)){
var G__15130 = state_15107;
state_15107 = G__15130;
continue;
} else {
return ret_value__12114__auto__;
}
break;
}
});
milia$api$async_export$state_machine__12113__auto__ = function(state_15107){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__12113__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__12113__auto____1.call(this,state_15107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__12113__auto____0;
milia$api$async_export$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__12113__auto____1;
return milia$api$async_export$state_machine__12113__auto__;
})()
;})(switch__12112__auto__,c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__12181__auto__ = (function (){var statearr_15121 = (f__12180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12180__auto__.cljs$core$IFn$_invoke$arity$0() : f__12180__auto__.call(null));
(statearr_15121[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12179__auto__);

return statearr_15121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12181__auto__);
});})(c__12179__auto__,vec__15089,map__15090,map__15090__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__12179__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq15086){
var G__15087 = cljs.core.first(seq15086);
var seq15086__$1 = cljs.core.next(seq15086);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15087,seq15086__$1);
});
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){

var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$data_DASH_format,data_format,cljs.core.constant$keyword$on_DASH_export_DASH_url,((function (ch){
return (function (p1__15131_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__15131_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(){
var args__8965__auto__ = [];
var len__8958__auto___15156 = arguments.length;
var i__8959__auto___15157 = (0);
while(true){
if((i__8959__auto___15157 < len__8958__auto___15156)){
args__8965__auto__.push((arguments[i__8959__auto___15157]));

var G__15158 = (i__8959__auto___15157 + (1));
i__8959__auto___15157 = G__15158;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((3) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((3)),(0))):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8966__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){

var c__12179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12179__auto__){
return (function (){
var f__12180__auto__ = (function (){var switch__12112__auto__ = ((function (c__12179__auto__){
return (function (state_15147){
var state_val_15148 = (state_15147[(1)]);
if((state_val_15148 === (1))){
var inst_15136 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_15147__$1 = state_15147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15147__$1,(2),inst_15136);
} else {
if((state_val_15148 === (2))){
var inst_15138 = (state_15147[(2)]);
var inst_15139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15140 = [http_method,inst_15138];
var inst_15141 = (new cljs.core.PersistentVector(null,2,(5),inst_15139,inst_15140,null));
var inst_15142 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_15141,args);
var inst_15143 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_15142);
var state_15147__$1 = state_15147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15147__$1,(3),inst_15143);
} else {
if((state_val_15148 === (3))){
var inst_15145 = (state_15147[(2)]);
var state_15147__$1 = state_15147;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15147__$1,inst_15145);
} else {
return null;
}
}
}
});})(c__12179__auto__))
;
return ((function (switch__12112__auto__,c__12179__auto__){
return (function() {
var milia$api$async_export$state_machine__12113__auto__ = null;
var milia$api$async_export$state_machine__12113__auto____0 = (function (){
var statearr_15152 = [null,null,null,null,null,null,null];
(statearr_15152[(0)] = milia$api$async_export$state_machine__12113__auto__);

(statearr_15152[(1)] = (1));

return statearr_15152;
});
var milia$api$async_export$state_machine__12113__auto____1 = (function (state_15147){
while(true){
var ret_value__12114__auto__ = (function (){try{while(true){
var result__12115__auto__ = switch__12112__auto__(state_15147);
if(cljs.core.keyword_identical_QMARK_(result__12115__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__12115__auto__;
}
break;
}
}catch (e15153){if((e15153 instanceof Object)){
var ex__12116__auto__ = e15153;
var statearr_15154_15159 = state_15147;
(statearr_15154_15159[(5)] = ex__12116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15147);

return cljs.core.constant$keyword$recur;
} else {
throw e15153;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12114__auto__,cljs.core.constant$keyword$recur)){
var G__15160 = state_15147;
state_15147 = G__15160;
continue;
} else {
return ret_value__12114__auto__;
}
break;
}
});
milia$api$async_export$state_machine__12113__auto__ = function(state_15147){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__12113__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__12113__auto____1.call(this,state_15147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__12113__auto____0;
milia$api$async_export$state_machine__12113__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__12113__auto____1;
return milia$api$async_export$state_machine__12113__auto__;
})()
;})(switch__12112__auto__,c__12179__auto__))
})();
var state__12181__auto__ = (function (){var statearr_15155 = (f__12180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12180__auto__.cljs$core$IFn$_invoke$arity$0() : f__12180__auto__.call(null));
(statearr_15155[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12179__auto__);

return statearr_15155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12181__auto__);
});})(c__12179__auto__))
);

return c__12179__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq15132){
var G__15133 = cljs.core.first(seq15132);
var seq15132__$1 = cljs.core.next(seq15132);
var G__15134 = cljs.core.first(seq15132__$1);
var seq15132__$2 = cljs.core.next(seq15132__$1);
var G__15135 = cljs.core.first(seq15132__$2);
var seq15132__$3 = cljs.core.next(seq15132__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__15133,G__15134,G__15135,seq15132__$3);
});
