// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('dommy.template');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.attrs');
dommy.template._PLUS_svg_ns_PLUS_ = "http://www.w3.org/2000/svg";
dommy.template._PLUS_svg_tags_PLUS_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["svg",null,"line",null], null), null);

dommy.template.PElement = (function (){var obj34210 = {};
return obj34210;
})();

/**
 * return the element representation of this
 */
dommy.template._elem = (function dommy$template$_elem(this$){
if((function (){var and__8170__auto__ = this$;
if(and__8170__auto__){
return this$.dommy$template$PElement$_elem$arity$1;
} else {
return and__8170__auto__;
}
})()){
return this$.dommy$template$PElement$_elem$arity$1(this$);
} else {
var x__8818__auto__ = (((this$ == null))?null:this$);
return (function (){var or__8182__auto__ = (dommy.template._elem[(function (){var G__34214 = x__8818__auto__;
return goog.typeOf(G__34214);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (dommy.template._elem["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("PElement.-elem",this$);
}
}
})().call(null,this$);
}
});

/**
 * index of css character (#,.) in base-element. bottleneck
 */
dommy.template.next_css_index = (function dommy$template$next_css_index(s,start_idx){
var id_idx = s.indexOf("#",start_idx);
var class_idx = s.indexOf(".",start_idx);
var idx = Math.min(id_idx,class_idx);
if((idx < (0))){
return Math.max(id_idx,class_idx);
} else {
return idx;
}
});
/**
 * dom element from css-style keyword like :a.class1 or :span#my-span.class
 */
dommy.template.base_element = (function dommy$template$base_element(node_key){
var node_str = cljs.core.name(node_key);
var base_idx = dommy.template.next_css_index(node_str,(0));
var tag = (((base_idx > (0)))?node_str.substring((0),base_idx):(((base_idx === (0)))?"div":node_str
));
var node = (cljs.core.truth_((function (){var G__34217 = tag;
return (dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1 ? dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1(G__34217) : dommy.template._PLUS_svg_tags_PLUS_.call(null,G__34217));
})())?document.createElementNS(dommy.template._PLUS_svg_ns_PLUS_,tag):document.createElement(tag));
if((base_idx >= (0))){
var str_34219 = node_str.substring(base_idx);
while(true){
var next_idx_34220 = dommy.template.next_css_index(str_34219,(1));
var frag_34221 = (((next_idx_34220 >= (0)))?str_34219.substring((0),next_idx_34220):str_34219);
var G__34218_34222 = frag_34221.charAt((0));
switch (G__34218_34222) {
case ".":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(node,frag_34221.substring((1)));

break;
case "#":
node.setAttribute("id",frag_34221.substring((1)));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(frag_34221.charAt((0)))].join('')));

}

if((next_idx_34220 >= (0))){
var G__34224 = str_34219.substring(next_idx_34220);
str_34219 = G__34224;
continue;
} else {
}
break;
}
} else {
}

return node;
});
dommy.template.throw_unable_to_make_node = (function dommy$template$throw_unable_to_make_node(node_data){
throw [cljs.core.str("Don't know how to make node from: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([node_data], 0)))].join('');
});
/**
 * take data and return a document fragment
 */
dommy.template.__GT_document_fragment = (function dommy$template$__GT_document_fragment(){
var G__34226 = arguments.length;
switch (G__34226) {
case 1:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1 = (function (data){
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(document.createDocumentFragment(),data);
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2 = (function (result_frag,data){
if((function (){var G__34227 = data;
if(G__34227){
var bit__8856__auto__ = null;
if(cljs.core.truth_((function (){var or__8182__auto__ = bit__8856__auto__;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return G__34227.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__34227.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34227);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34227);
}
})()){
result_frag.appendChild(dommy.template._elem(data));

return result_frag;
} else {
if(cljs.core.seq_QMARK_(data)){
var seq__34228_34233 = cljs.core.seq(data);
var chunk__34229_34234 = null;
var count__34230_34235 = (0);
var i__34231_34236 = (0);
while(true){
if((i__34231_34236 < count__34230_34235)){
var child_34237 = chunk__34229_34234.cljs$core$IIndexed$_nth$arity$2(null,i__34231_34236);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_34237);

var G__34238 = seq__34228_34233;
var G__34239 = chunk__34229_34234;
var G__34240 = count__34230_34235;
var G__34241 = (i__34231_34236 + (1));
seq__34228_34233 = G__34238;
chunk__34229_34234 = G__34239;
count__34230_34235 = G__34240;
i__34231_34236 = G__34241;
continue;
} else {
var temp__4425__auto___34242 = cljs.core.seq(seq__34228_34233);
if(temp__4425__auto___34242){
var seq__34228_34243__$1 = temp__4425__auto___34242;
if(cljs.core.chunked_seq_QMARK_(seq__34228_34243__$1)){
var c__8967__auto___34244 = cljs.core.chunk_first(seq__34228_34243__$1);
var G__34245 = cljs.core.chunk_rest(seq__34228_34243__$1);
var G__34246 = c__8967__auto___34244;
var G__34247 = cljs.core.count(c__8967__auto___34244);
var G__34248 = (0);
seq__34228_34233 = G__34245;
chunk__34229_34234 = G__34246;
count__34230_34235 = G__34247;
i__34231_34236 = G__34248;
continue;
} else {
var child_34249 = cljs.core.first(seq__34228_34243__$1);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_34249);

var G__34250 = cljs.core.next(seq__34228_34243__$1);
var G__34251 = null;
var G__34252 = (0);
var G__34253 = (0);
seq__34228_34233 = G__34250;
chunk__34229_34234 = G__34251;
count__34230_34235 = G__34252;
i__34231_34236 = G__34253;
continue;
}
} else {
}
}
break;
}

return result_frag;
} else {
if((data == null)){
return result_frag;
} else {
return dommy.template.throw_unable_to_make_node(data);

}
}
}
});

dommy.template.__GT_document_fragment.cljs$lang$maxFixedArity = 2;
/**
 * take data and return DOM node if it satisfies PElement and tries to
 * make a document fragment otherwise
 */
dommy.template.__GT_node_like = (function dommy$template$__GT_node_like(data){
if((function (){var G__34255 = data;
if(G__34255){
var bit__8856__auto__ = null;
if(cljs.core.truth_((function (){var or__8182__auto__ = bit__8856__auto__;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return G__34255.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__34255.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34255);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34255);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1(data);
}
});
/**
 * element with either attrs or nested children [:div [:span "Hello"]]
 */
dommy.template.compound_element = (function dommy$template$compound_element(p__34256){
var vec__34276 = p__34256;
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34276,(0),null);
var maybe_attrs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34276,(1),null);
var children = cljs.core.nthnext(vec__34276,(2));
var n = dommy.template.base_element(tag_name);
var attrs = (((cljs.core.map_QMARK_(maybe_attrs)) && (!((function (){var G__34278 = maybe_attrs;
if(G__34278){
var bit__8856__auto__ = null;
if(cljs.core.truth_((function (){var or__8182__auto__ = bit__8856__auto__;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return G__34278.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__34278.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34278);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34278);
}
})())))?maybe_attrs:null);
var children__$1 = (cljs.core.truth_(attrs)?children:cljs.core.cons(maybe_attrs,children));
var seq__34279_34295 = cljs.core.seq(attrs);
var chunk__34280_34296 = null;
var count__34281_34297 = (0);
var i__34282_34298 = (0);
while(true){
if((i__34282_34298 < count__34281_34297)){
var vec__34283_34299 = chunk__34280_34296.cljs$core$IIndexed$_nth$arity$2(null,i__34282_34298);
var k_34300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34283_34299,(0),null);
var v_34301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34283_34299,(1),null);
var G__34284_34302 = (((k_34300 instanceof cljs.core.Keyword))?k_34300.fqn:null);
switch (G__34284_34302) {
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_34301);

break;
case "classes":
var seq__34285_34304 = cljs.core.seq(v_34301);
var chunk__34286_34305 = null;
var count__34287_34306 = (0);
var i__34288_34307 = (0);
while(true){
if((i__34288_34307 < count__34287_34306)){
var c_34308 = chunk__34286_34305.cljs$core$IIndexed$_nth$arity$2(null,i__34288_34307);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_34308);

var G__34309 = seq__34285_34304;
var G__34310 = chunk__34286_34305;
var G__34311 = count__34287_34306;
var G__34312 = (i__34288_34307 + (1));
seq__34285_34304 = G__34309;
chunk__34286_34305 = G__34310;
count__34287_34306 = G__34311;
i__34288_34307 = G__34312;
continue;
} else {
var temp__4425__auto___34313 = cljs.core.seq(seq__34285_34304);
if(temp__4425__auto___34313){
var seq__34285_34314__$1 = temp__4425__auto___34313;
if(cljs.core.chunked_seq_QMARK_(seq__34285_34314__$1)){
var c__8967__auto___34315 = cljs.core.chunk_first(seq__34285_34314__$1);
var G__34316 = cljs.core.chunk_rest(seq__34285_34314__$1);
var G__34317 = c__8967__auto___34315;
var G__34318 = cljs.core.count(c__8967__auto___34315);
var G__34319 = (0);
seq__34285_34304 = G__34316;
chunk__34286_34305 = G__34317;
count__34287_34306 = G__34318;
i__34288_34307 = G__34319;
continue;
} else {
var c_34320 = cljs.core.first(seq__34285_34314__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_34320);

var G__34321 = cljs.core.next(seq__34285_34314__$1);
var G__34322 = null;
var G__34323 = (0);
var G__34324 = (0);
seq__34285_34304 = G__34321;
chunk__34286_34305 = G__34322;
count__34287_34306 = G__34323;
i__34288_34307 = G__34324;
continue;
}
} else {
}
}
break;
}

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_34300,v_34301);

}

var G__34325 = seq__34279_34295;
var G__34326 = chunk__34280_34296;
var G__34327 = count__34281_34297;
var G__34328 = (i__34282_34298 + (1));
seq__34279_34295 = G__34325;
chunk__34280_34296 = G__34326;
count__34281_34297 = G__34327;
i__34282_34298 = G__34328;
continue;
} else {
var temp__4425__auto___34329 = cljs.core.seq(seq__34279_34295);
if(temp__4425__auto___34329){
var seq__34279_34330__$1 = temp__4425__auto___34329;
if(cljs.core.chunked_seq_QMARK_(seq__34279_34330__$1)){
var c__8967__auto___34331 = cljs.core.chunk_first(seq__34279_34330__$1);
var G__34332 = cljs.core.chunk_rest(seq__34279_34330__$1);
var G__34333 = c__8967__auto___34331;
var G__34334 = cljs.core.count(c__8967__auto___34331);
var G__34335 = (0);
seq__34279_34295 = G__34332;
chunk__34280_34296 = G__34333;
count__34281_34297 = G__34334;
i__34282_34298 = G__34335;
continue;
} else {
var vec__34289_34336 = cljs.core.first(seq__34279_34330__$1);
var k_34337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34289_34336,(0),null);
var v_34338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34289_34336,(1),null);
var G__34290_34339 = (((k_34337 instanceof cljs.core.Keyword))?k_34337.fqn:null);
switch (G__34290_34339) {
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_34338);

break;
case "classes":
var seq__34291_34341 = cljs.core.seq(v_34338);
var chunk__34292_34342 = null;
var count__34293_34343 = (0);
var i__34294_34344 = (0);
while(true){
if((i__34294_34344 < count__34293_34343)){
var c_34345 = chunk__34292_34342.cljs$core$IIndexed$_nth$arity$2(null,i__34294_34344);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_34345);

var G__34346 = seq__34291_34341;
var G__34347 = chunk__34292_34342;
var G__34348 = count__34293_34343;
var G__34349 = (i__34294_34344 + (1));
seq__34291_34341 = G__34346;
chunk__34292_34342 = G__34347;
count__34293_34343 = G__34348;
i__34294_34344 = G__34349;
continue;
} else {
var temp__4425__auto___34350__$1 = cljs.core.seq(seq__34291_34341);
if(temp__4425__auto___34350__$1){
var seq__34291_34351__$1 = temp__4425__auto___34350__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34291_34351__$1)){
var c__8967__auto___34352 = cljs.core.chunk_first(seq__34291_34351__$1);
var G__34353 = cljs.core.chunk_rest(seq__34291_34351__$1);
var G__34354 = c__8967__auto___34352;
var G__34355 = cljs.core.count(c__8967__auto___34352);
var G__34356 = (0);
seq__34291_34341 = G__34353;
chunk__34292_34342 = G__34354;
count__34293_34343 = G__34355;
i__34294_34344 = G__34356;
continue;
} else {
var c_34357 = cljs.core.first(seq__34291_34351__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_34357);

var G__34358 = cljs.core.next(seq__34291_34351__$1);
var G__34359 = null;
var G__34360 = (0);
var G__34361 = (0);
seq__34291_34341 = G__34358;
chunk__34292_34342 = G__34359;
count__34293_34343 = G__34360;
i__34294_34344 = G__34361;
continue;
}
} else {
}
}
break;
}

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_34337,v_34338);

}

var G__34362 = cljs.core.next(seq__34279_34330__$1);
var G__34363 = null;
var G__34364 = (0);
var G__34365 = (0);
seq__34279_34295 = G__34362;
chunk__34280_34296 = G__34363;
count__34281_34297 = G__34364;
i__34282_34298 = G__34365;
continue;
}
} else {
}
}
break;
}

n.appendChild(dommy.template.__GT_node_like(children__$1));

return n;
});
HTMLElement.prototype.dommy$template$PElement$ = true;

HTMLElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

DocumentFragment.prototype.dommy$template$PElement$ = true;

DocumentFragment.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Text.prototype.dommy$template$PElement$ = true;

Text.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Document.prototype.dommy$template$PElement$ = true;

Document.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

SVGElement.prototype.dommy$template$PElement$ = true;

SVGElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentVector.prototype.dommy$template$PElement$ = true;

cljs.core.PersistentVector.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return dommy.template.compound_element(this$__$1);
});

(dommy.template.PElement["number"] = true);

(dommy.template._elem["number"] = (function (this$){
return document.createTextNode([cljs.core.str(this$)].join(''));
}));

(dommy.template.PElement["string"] = true);

(dommy.template._elem["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return dommy.template.base_element(this$);
} else {
return document.createTextNode([cljs.core.str(this$)].join(''));
}
}));
try{Window.prototype.dommy$template$PElement$ = true;

Window.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
}catch (e34366){if((e34366 instanceof ReferenceError)){
var __34367 = e34366;
console.log("PElement: js/Window not defined by browser, skipping it... (running on phantomjs?)");
} else {
throw e34366;

}
}dommy.template.node = (function dommy$template$node(data){
if((function (){var G__34369 = data;
if(G__34369){
var bit__8856__auto__ = null;
if(cljs.core.truth_((function (){var or__8182__auto__ = bit__8856__auto__;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return G__34369.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__34369.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34369);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__34369);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.throw_unable_to_make_node(data);
}
});
dommy.template.html__GT_nodes = (function dommy$template$html__GT_nodes(html){
var parent = document.createElement("div");
parent.insertAdjacentHTML("beforeend",html);

return cljs.core.seq(Array.prototype.slice.call(parent.childNodes));
});
