// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('milia.utils.url');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = (function (){var G__25413 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$temp_DASH_token,null,cljs.core.constant$keyword$token,null,cljs.core.constant$keyword$username,null,cljs.core.constant$keyword$password,null], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25413) : cljs.core.atom.call(null,G__25413));
})();
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__25414 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$client,"zebra.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$j2x,"j2x.ona.io",cljs.core.constant$keyword$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25414) : cljs.core.atom.call(null,G__25414));
})();
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var args__9088__auto__ = [];
var len__9081__auto___25416 = arguments.length;
var i__9082__auto___25417 = (0);
while(true){
if((i__9082__auto___25417 < len__9081__auto___25416)){
args__9088__auto__.push((arguments[i__9082__auto___25417]));

var G__25418 = (i__9082__auto___25417 + (1));
i__9082__auto___25417 = G__25418;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((0) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9089__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq25415){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25415));
});
/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(){
var args__9088__auto__ = [];
var len__9081__auto___25420 = arguments.length;
var i__9082__auto___25421 = (0);
while(true){
if((i__9082__auto___25421 < len__9081__auto___25420)){
args__9088__auto__.push((arguments[i__9082__auto___25421]));

var G__25422 = (i__9082__auto___25421 + (1));
i__9082__auto___25421 = G__25422;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((0) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9089__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq25419){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25419));
});
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(){
var args__9088__auto__ = [];
var len__9081__auto___25424 = arguments.length;
var i__9082__auto___25425 = (0);
while(true){
if((i__9082__auto___25425 < len__9081__auto___25424)){
args__9088__auto__.push((arguments[i__9082__auto___25425]));

var G__25426 = (i__9082__auto___25425 + (1));
i__9082__auto___25425 = G__25426;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((0) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9089__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq25423){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25423));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var args__9088__auto__ = [];
var len__9081__auto___25428 = arguments.length;
var i__9082__auto___25429 = (0);
while(true){
if((i__9082__auto___25429 < len__9081__auto___25428)){
args__9088__auto__.push((arguments[i__9082__auto___25429]));

var G__25430 = (i__9082__auto___25429 + (1));
i__9082__auto___25429 = G__25430;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((0) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9089__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq25427){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25427));
});
