// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__8030__auto__ = v;
if(cljs.core.truth_(and__8030__auto__)){
return (v > (0));
} else {
return and__8030__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__29357_SHARP_,p2__29356_SHARP_){
var vec__29359 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__29356_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29359,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29359,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29357_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29360_SHARP_){
return cljs_http.client.encode_val(k,p1__29360_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__29361){
var vec__29363 = p__29361;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29363,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29363,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__29364_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__29364_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__8030__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__8030__auto__){
var and__8030__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__8030__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__8030__auto____$1;
}
} else {
return and__8030__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__29366 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29366) : client.call(null,G__29366));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__29367_SHARP_){
return cljs_http.client.decode_body(p1__29367_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(){
var args__9088__auto__ = [];
var len__9081__auto___29373 = arguments.length;
var i__9082__auto___29374 = (0);
while(true){
if((i__9082__auto___29374 < len__9081__auto___29373)){
args__9088__auto__.push((arguments[i__9082__auto___29374]));

var G__29375 = (i__9082__auto___29374 + (1));
i__9082__auto___29374 = G__29375;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29370){
var vec__29371 = p__29370;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29371,(0),null);
return ((function (vec__29371,default_headers){
return (function (request){
var temp__4423__auto__ = (function (){var or__8042__auto__ = cljs.core.constant$keyword$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var default_headers__$1 = temp__4423__auto__;
var G__29372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.constant$keyword$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29372) : client.call(null,G__29372));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29371,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq29368){
var G__29369 = cljs.core.first(seq29368);
var seq29368__$1 = cljs.core.next(seq29368);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__29369,seq29368__$1);
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var args__9088__auto__ = [];
var len__9081__auto___29381 = arguments.length;
var i__9082__auto___29382 = (0);
while(true){
if((i__9082__auto___29382 < len__9081__auto___29381)){
args__9088__auto__.push((arguments[i__9082__auto___29382]));

var G__29383 = (i__9082__auto___29382 + (1));
i__9082__auto___29382 = G__29383;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29378){
var vec__29379 = p__29378;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29379,(0),null);
return ((function (vec__29379,accept){
return (function (request){
var temp__4423__auto__ = (function (){var or__8042__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var accept__$1 = temp__4423__auto__;
var G__29380 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29380) : client.call(null,G__29380));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29379,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq29376){
var G__29377 = cljs.core.first(seq29376);
var seq29376__$1 = cljs.core.next(seq29376);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__29377,seq29376__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var args__9088__auto__ = [];
var len__9081__auto___29389 = arguments.length;
var i__9082__auto___29390 = (0);
while(true){
if((i__9082__auto___29390 < len__9081__auto___29389)){
args__9088__auto__.push((arguments[i__9082__auto___29390]));

var G__29391 = (i__9082__auto___29390 + (1));
i__9082__auto___29390 = G__29391;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29386){
var vec__29387 = p__29386;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29387,(0),null);
return ((function (vec__29387,content_type){
return (function (request){
var temp__4423__auto__ = (function (){var or__8042__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var content_type__$1 = temp__4423__auto__;
var G__29388 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29388) : client.call(null,G__29388));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29387,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq29384){
var G__29385 = cljs.core.first(seq29384);
var seq29384__$1 = cljs.core.next(seq29384);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__29385,seq29384__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var map__29395 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__29395__$1 = ((((!((map__29395 == null)))?((((map__29395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29395):map__29395);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29395__$1,cljs.core.constant$keyword$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29395__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var G__29397 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29397) : client.call(null,G__29397));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__29402 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__29402__$1 = ((((!((map__29402 == null)))?((((map__29402.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29402.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29402):map__29402);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29402__$1,cljs.core.constant$keyword$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29402__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var transit_decode = ((function (map__29402,map__29402__$1,decoding,decoding_opts){
return (function (p1__29398_SHARP_){
return cljs_http.util.transit_decode(p1__29398_SHARP_,decoding,decoding_opts);
});})(map__29402,map__29402__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__29402,map__29402__$1,decoding,decoding_opts,transit_decode){
return (function (p1__29399_SHARP_){
return cljs_http.client.decode_body(p1__29399_SHARP_,transit_decode,"application/transit+json",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
});})(map__29402,map__29402__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__29405 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29405) : client.call(null,G__29405));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__29406_SHARP_){
return cljs_http.client.decode_body(p1__29406_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__29411){
var map__29412 = p__29411;
var map__29412__$1 = ((((!((map__29412 == null)))?((((map__29412.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29412.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29412):map__29412);
var req = map__29412__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29412__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__29414 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29414) : client.call(null,G__29414));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__29419){
var map__29420 = p__29419;
var map__29420__$1 = ((((!((map__29420 == null)))?((((map__29420.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29420.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29420):map__29420);
var request = map__29420__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29420__$1,cljs.core.constant$keyword$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29420__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__8030__auto__ = form_params;
if(cljs.core.truth_(and__8030__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__8030__auto__;
}
})())){
var G__29422 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29422) : client.call(null,G__29422));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__29429_29435 = cljs.core.seq(params);
var chunk__29430_29436 = null;
var count__29431_29437 = (0);
var i__29432_29438 = (0);
while(true){
if((i__29432_29438 < count__29431_29437)){
var vec__29433_29439 = chunk__29430_29436.cljs$core$IIndexed$_nth$arity$2(null,i__29432_29438);
var k_29440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29433_29439,(0),null);
var v_29441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29433_29439,(1),null);
form_data.append(cljs.core.name(k_29440),v_29441);

var G__29442 = seq__29429_29435;
var G__29443 = chunk__29430_29436;
var G__29444 = count__29431_29437;
var G__29445 = (i__29432_29438 + (1));
seq__29429_29435 = G__29442;
chunk__29430_29436 = G__29443;
count__29431_29437 = G__29444;
i__29432_29438 = G__29445;
continue;
} else {
var temp__4425__auto___29446 = cljs.core.seq(seq__29429_29435);
if(temp__4425__auto___29446){
var seq__29429_29447__$1 = temp__4425__auto___29446;
if(cljs.core.chunked_seq_QMARK_(seq__29429_29447__$1)){
var c__8826__auto___29448 = cljs.core.chunk_first(seq__29429_29447__$1);
var G__29449 = cljs.core.chunk_rest(seq__29429_29447__$1);
var G__29450 = c__8826__auto___29448;
var G__29451 = cljs.core.count(c__8826__auto___29448);
var G__29452 = (0);
seq__29429_29435 = G__29449;
chunk__29430_29436 = G__29450;
count__29431_29437 = G__29451;
i__29432_29438 = G__29452;
continue;
} else {
var vec__29434_29453 = cljs.core.first(seq__29429_29447__$1);
var k_29454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29434_29453,(0),null);
var v_29455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29434_29453,(1),null);
form_data.append(cljs.core.name(k_29454),v_29455);

var G__29456 = cljs.core.next(seq__29429_29447__$1);
var G__29457 = null;
var G__29458 = (0);
var G__29459 = (0);
seq__29429_29435 = G__29456;
chunk__29430_29436 = G__29457;
count__29431_29437 = G__29458;
i__29432_29438 = G__29459;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__29464){
var map__29465 = p__29464;
var map__29465__$1 = ((((!((map__29465 == null)))?((((map__29465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29465):map__29465);
var request = map__29465__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29465__$1,cljs.core.constant$keyword$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29465__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__8030__auto__ = multipart_params;
if(cljs.core.truth_(and__8030__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__8030__auto__;
}
})())){
var G__29467 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$multipart_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29467) : client.call(null,G__29467));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var m = temp__4423__auto__;
var G__29469 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29469) : client.call(null,G__29469));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__29470_SHARP_){
var G__29472 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29470_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29472) : client.call(null,G__29472));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__29478){
var map__29479 = p__29478;
var map__29479__$1 = ((((!((map__29479 == null)))?((((map__29479.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29479.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29479):map__29479);
var req = map__29479__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29479__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4423__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4423__auto__)){
var spec = temp__4423__auto__;
var G__29481 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4423__auto__,map__29479,map__29479__$1,req,query_params){
return (function (p1__29473_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29473_SHARP_,query_params], 0));
});})(spec,temp__4423__auto__,map__29479,map__29479__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29481) : client.call(null,G__29481));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var args__9088__auto__ = [];
var len__9081__auto___29487 = arguments.length;
var i__9082__auto___29488 = (0);
while(true){
if((i__9082__auto___29488 < len__9081__auto___29487)){
args__9088__auto__.push((arguments[i__9082__auto___29488]));

var G__29489 = (i__9082__auto___29488 + (1));
i__9082__auto___29488 = G__29489;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29484){
var vec__29485 = p__29484;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29485,(0),null);
return ((function (vec__29485,credentials){
return (function (req){
var credentials__$1 = (function (){var or__8042__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__29486 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29486) : client.call(null,G__29486));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__29485,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq29482){
var G__29483 = cljs.core.first(seq29482);
var seq29482__$1 = cljs.core.next(seq29482);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__29483,seq29482__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var oauth_token = temp__4423__auto__;
var G__29491 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29491) : client.call(null,G__29491));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var custom_channel = temp__4423__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var args__9088__auto__ = [];
var len__9081__auto___29497 = arguments.length;
var i__9082__auto___29498 = (0);
while(true){
if((i__9082__auto___29498 < len__9081__auto___29497)){
args__9088__auto__.push((arguments[i__9082__auto___29498]));

var G__29499 = (i__9082__auto___29498 + (1));
i__9082__auto___29498 = G__29499;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29494){
var vec__29495 = p__29494;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29495,(0),null);
var G__29496 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29496) : cljs_http.client.request.call(null,G__29496));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq29492){
var G__29493 = cljs.core.first(seq29492);
var seq29492__$1 = cljs.core.next(seq29492);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__29493,seq29492__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var args__9088__auto__ = [];
var len__9081__auto___29505 = arguments.length;
var i__9082__auto___29506 = (0);
while(true){
if((i__9082__auto___29506 < len__9081__auto___29505)){
args__9088__auto__.push((arguments[i__9082__auto___29506]));

var G__29507 = (i__9082__auto___29506 + (1));
i__9082__auto___29506 = G__29507;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29502){
var vec__29503 = p__29502;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29503,(0),null);
var G__29504 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29504) : cljs_http.client.request.call(null,G__29504));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq29500){
var G__29501 = cljs.core.first(seq29500);
var seq29500__$1 = cljs.core.next(seq29500);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__29501,seq29500__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var args__9088__auto__ = [];
var len__9081__auto___29513 = arguments.length;
var i__9082__auto___29514 = (0);
while(true){
if((i__9082__auto___29514 < len__9081__auto___29513)){
args__9088__auto__.push((arguments[i__9082__auto___29514]));

var G__29515 = (i__9082__auto___29514 + (1));
i__9082__auto___29514 = G__29515;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29510){
var vec__29511 = p__29510;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29511,(0),null);
var G__29512 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29512) : cljs_http.client.request.call(null,G__29512));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq29508){
var G__29509 = cljs.core.first(seq29508);
var seq29508__$1 = cljs.core.next(seq29508);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__29509,seq29508__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(){
var args__9088__auto__ = [];
var len__9081__auto___29521 = arguments.length;
var i__9082__auto___29522 = (0);
while(true){
if((i__9082__auto___29522 < len__9081__auto___29521)){
args__9088__auto__.push((arguments[i__9082__auto___29522]));

var G__29523 = (i__9082__auto___29522 + (1));
i__9082__auto___29522 = G__29523;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29518){
var vec__29519 = p__29518;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29519,(0),null);
var G__29520 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$jsonp,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29520) : cljs_http.client.request.call(null,G__29520));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq29516){
var G__29517 = cljs.core.first(seq29516);
var seq29516__$1 = cljs.core.next(seq29516);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__29517,seq29516__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var args__9088__auto__ = [];
var len__9081__auto___29529 = arguments.length;
var i__9082__auto___29530 = (0);
while(true){
if((i__9082__auto___29530 < len__9081__auto___29529)){
args__9088__auto__.push((arguments[i__9082__auto___29530]));

var G__29531 = (i__9082__auto___29530 + (1));
i__9082__auto___29530 = G__29531;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29526){
var vec__29527 = p__29526;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29527,(0),null);
var G__29528 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29528) : cljs_http.client.request.call(null,G__29528));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq29524){
var G__29525 = cljs.core.first(seq29524);
var seq29524__$1 = cljs.core.next(seq29524);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__29525,seq29524__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var args__9088__auto__ = [];
var len__9081__auto___29537 = arguments.length;
var i__9082__auto___29538 = (0);
while(true){
if((i__9082__auto___29538 < len__9081__auto___29537)){
args__9088__auto__.push((arguments[i__9082__auto___29538]));

var G__29539 = (i__9082__auto___29538 + (1));
i__9082__auto___29538 = G__29539;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29534){
var vec__29535 = p__29534;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29535,(0),null);
var G__29536 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29536) : cljs_http.client.request.call(null,G__29536));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq29532){
var G__29533 = cljs.core.first(seq29532);
var seq29532__$1 = cljs.core.next(seq29532);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__29533,seq29532__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var args__9088__auto__ = [];
var len__9081__auto___29545 = arguments.length;
var i__9082__auto___29546 = (0);
while(true){
if((i__9082__auto___29546 < len__9081__auto___29545)){
args__9088__auto__.push((arguments[i__9082__auto___29546]));

var G__29547 = (i__9082__auto___29546 + (1));
i__9082__auto___29546 = G__29547;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29542){
var vec__29543 = p__29542;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29543,(0),null);
var G__29544 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29544) : cljs_http.client.request.call(null,G__29544));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq29540){
var G__29541 = cljs.core.first(seq29540);
var seq29540__$1 = cljs.core.next(seq29540);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__29541,seq29540__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var args__9088__auto__ = [];
var len__9081__auto___29553 = arguments.length;
var i__9082__auto___29554 = (0);
while(true){
if((i__9082__auto___29554 < len__9081__auto___29553)){
args__9088__auto__.push((arguments[i__9082__auto___29554]));

var G__29555 = (i__9082__auto___29554 + (1));
i__9082__auto___29554 = G__29555;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29550){
var vec__29551 = p__29550;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29551,(0),null);
var G__29552 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29552) : cljs_http.client.request.call(null,G__29552));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq29548){
var G__29549 = cljs.core.first(seq29548);
var seq29548__$1 = cljs.core.next(seq29548);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__29549,seq29548__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var args__9088__auto__ = [];
var len__9081__auto___29561 = arguments.length;
var i__9082__auto___29562 = (0);
while(true){
if((i__9082__auto___29562 < len__9081__auto___29561)){
args__9088__auto__.push((arguments[i__9082__auto___29562]));

var G__29563 = (i__9082__auto___29562 + (1));
i__9082__auto___29562 = G__29563;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29558){
var vec__29559 = p__29558;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29559,(0),null);
var G__29560 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29560) : cljs_http.client.request.call(null,G__29560));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq29556){
var G__29557 = cljs.core.first(seq29556);
var seq29556__$1 = cljs.core.next(seq29556);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__29557,seq29556__$1);
});
